/*
 * Decompiled with CFR 0.152.
 */
package org.walkmod.javalang.ast;

import java.util.LinkedList;
import java.util.List;
import org.walkmod.javalang.ast.Node;
import org.walkmod.javalang.ast.expr.AnnotationExpr;
import org.walkmod.javalang.ast.expr.NameExpr;
import org.walkmod.javalang.visitors.GenericVisitor;
import org.walkmod.javalang.visitors.VoidVisitor;

public final class PackageDeclaration
extends Node {
    private List<AnnotationExpr> annotations;
    private NameExpr name;

    public PackageDeclaration() {
    }

    public PackageDeclaration(NameExpr name) {
        this.setName(name);
    }

    public PackageDeclaration(List<AnnotationExpr> annotations, NameExpr name) {
        this.setAnnotations(annotations);
        this.setName(name);
    }

    public PackageDeclaration(int beginLine, int beginColumn, int endLine, int endColumn, List<AnnotationExpr> annotations, NameExpr name) {
        super(beginLine, beginColumn, endLine, endColumn);
        this.setAnnotations(annotations);
        this.setName(name);
    }

    @Override
    public boolean removeChild(Node child) {
        boolean result = false;
        if (child != null) {
            if (child instanceof AnnotationExpr) {
                LinkedList<AnnotationExpr> annotationAux = new LinkedList<AnnotationExpr>(this.annotations);
                result = annotationAux.remove(child);
                this.annotations = annotationAux;
            } else if (child == this.name && this.name != null) {
                this.name = (NameExpr)child;
                result = true;
            }
        }
        if (result) {
            this.updateReferences(child);
        }
        return result;
    }

    @Override
    public List<Node> getChildren() {
        LinkedList<Node> children = new LinkedList<Node>();
        if (this.annotations != null) {
            children.addAll(this.annotations);
        }
        if (this.name != null) {
            children.add(this.name);
        }
        return children;
    }

    @Override
    public <R, A> R accept(GenericVisitor<R, A> v, A arg) {
        if (!this.check()) {
            return null;
        }
        return v.visit(this, arg);
    }

    @Override
    public <A> void accept(VoidVisitor<A> v, A arg) {
        if (this.check()) {
            v.visit(this, arg);
        }
    }

    public List<AnnotationExpr> getAnnotations() {
        return this.annotations;
    }

    public NameExpr getName() {
        return this.name;
    }

    public void setAnnotations(List<AnnotationExpr> annotations) {
        this.annotations = annotations;
        this.setAsParentNodeOf(annotations);
    }

    public void setName(NameExpr name) {
        if (this.name != null) {
            this.updateReferences(this.name);
        }
        this.name = name;
        this.setAsParentNodeOf(name);
    }

    @Override
    public boolean replaceChildNode(Node oldChild, Node newChild) {
        if (this.name == oldChild) {
            this.setName((NameExpr)newChild);
            return true;
        }
        return false;
    }

    @Override
    public PackageDeclaration clone() throws CloneNotSupportedException {
        return new PackageDeclaration(this.clone(this.annotations), this.clone(this.name));
    }
}

