/*
 * Decompiled with CFR 0.152.
 */
package org.walkmod.javalang.ast;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.walkmod.javalang.ast.Node;
import org.walkmod.javalang.ast.ScopeAware;
import org.walkmod.javalang.ast.SymbolDefinition;
import org.walkmod.javalang.ast.SymbolReference;
import org.walkmod.javalang.ast.expr.AnnotationExpr;
import org.walkmod.javalang.ast.type.ClassOrInterfaceType;
import org.walkmod.javalang.visitors.GenericVisitor;
import org.walkmod.javalang.visitors.VoidVisitor;

public final class TypeParameter
extends Node
implements SymbolDefinition {
    private String name;
    private List<AnnotationExpr> annotations;
    private List<ClassOrInterfaceType> typeBound;
    private List<SymbolReference> usages;
    private int scopeLevel = 0;

    public TypeParameter() {
    }

    public TypeParameter(String name, List<ClassOrInterfaceType> typeBound) {
        this.name = name;
        this.setTypeBound(typeBound);
    }

    public TypeParameter(String name, List<ClassOrInterfaceType> typeBound, List<AnnotationExpr> annotations) {
        this.name = name;
        this.setTypeBound(typeBound);
        this.setAnnotations(annotations);
    }

    public TypeParameter(int beginLine, int beginColumn, int endLine, int endColumn, String name, List<ClassOrInterfaceType> typeBound) {
        super(beginLine, beginColumn, endLine, endColumn);
        this.name = name;
        this.setTypeBound(typeBound);
    }

    public TypeParameter(int beginLine, int beginColumn, int endLine, int endColumn, String name, List<ClassOrInterfaceType> typeBound, List<AnnotationExpr> annotations) {
        super(beginLine, beginColumn, endLine, endColumn);
        this.name = name;
        this.setTypeBound(typeBound);
        this.setAnnotations(annotations);
    }

    @Override
    public List<Node> getChildren() {
        LinkedList<Node> children = new LinkedList<Node>();
        if (this.annotations != null) {
            children.addAll(this.annotations);
        }
        if (this.typeBound != null) {
            children.addAll(this.typeBound);
        }
        return children;
    }

    @Override
    public <R, A> R accept(GenericVisitor<R, A> v, A arg) {
        if (!this.check()) {
            return null;
        }
        return v.visit(this, arg);
    }

    @Override
    public <A> void accept(VoidVisitor<A> v, A arg) {
        if (this.check()) {
            v.visit(this, arg);
        }
    }

    public String getName() {
        return this.name;
    }

    public List<ClassOrInterfaceType> getTypeBound() {
        return this.typeBound;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setTypeBound(List<ClassOrInterfaceType> typeBound) {
        this.typeBound = typeBound;
        this.setAsParentNodeOf(typeBound);
    }

    public List<AnnotationExpr> getAnnotations() {
        return this.annotations;
    }

    public void setAnnotations(List<AnnotationExpr> annotations) {
        this.annotations = annotations;
        this.setAsParentNodeOf(annotations);
    }

    @Override
    public List<SymbolReference> getUsages() {
        return this.usages;
    }

    @Override
    public void setUsages(List<SymbolReference> usages) {
        this.usages = usages;
    }

    @Override
    public boolean addUsage(SymbolReference usage) {
        if (usage != null) {
            usage.setSymbolDefinition(this);
            if (this.usages == null) {
                this.usages = new LinkedList<SymbolReference>();
            }
            return this.usages.add(usage);
        }
        return false;
    }

    @Override
    public List<SymbolReference> getBodyReferences() {
        return null;
    }

    @Override
    public void setBodyReferences(List<SymbolReference> bodyReferences) {
    }

    @Override
    public boolean addBodyReference(SymbolReference bodyReference) {
        return false;
    }

    @Override
    public int getScopeLevel() {
        return this.scopeLevel;
    }

    @Override
    public void setScopeLevel(int scopeLevel) {
        this.scopeLevel = scopeLevel;
    }

    @Override
    public boolean replaceChildNode(Node oldChild, Node newChild) {
        LinkedList<AnnotationExpr> auxAnnotations;
        boolean update = false;
        if (this.annotations != null && (update = this.replaceChildNodeInList(oldChild, newChild, auxAnnotations = new LinkedList<AnnotationExpr>(this.annotations)))) {
            this.annotations = auxAnnotations;
        }
        if (!update && this.typeBound != null) {
            LinkedList<ClassOrInterfaceType> auxTypeBound = new LinkedList<ClassOrInterfaceType>(this.typeBound);
            update = this.replaceChildNodeInList(oldChild, newChild, auxTypeBound);
        }
        return update;
    }

    @Override
    public boolean removeChild(Node child) {
        boolean result = false;
        if (child != null) {
            if (child instanceof ClassOrInterfaceType) {
                if (this.typeBound != null) {
                    LinkedList<ClassOrInterfaceType> auxTypeBound = new LinkedList<ClassOrInterfaceType>(this.typeBound);
                    result = auxTypeBound.remove(child);
                    this.typeBound = auxTypeBound;
                }
            } else if (child instanceof AnnotationExpr && this.annotations != null) {
                LinkedList<AnnotationExpr> annotationsAux = new LinkedList<AnnotationExpr>(this.annotations);
                result = annotationsAux.remove(child);
                this.annotations = annotationsAux;
            }
        }
        if (result) {
            this.updateReferences(child);
        }
        return result;
    }

    @Override
    public TypeParameter clone() throws CloneNotSupportedException {
        return new TypeParameter(this.name, this.clone(this.typeBound), this.clone(this.annotations));
    }

    @Override
    public Map<String, SymbolDefinition> getVariableDefinitions() {
        Node parent;
        for (parent = this.getParentNode(); parent != null && parent instanceof ScopeAware; parent = parent.getParentNode()) {
        }
        if (parent != null) {
            return ((ScopeAware)((Object)parent)).getVariableDefinitions();
        }
        return new HashMap<String, SymbolDefinition>();
    }

    @Override
    public Map<String, List<SymbolDefinition>> getMethodDefinitions() {
        Node parent;
        for (parent = this.getParentNode(); parent != null && parent instanceof ScopeAware; parent = parent.getParentNode()) {
        }
        if (parent != null) {
            return ((ScopeAware)((Object)parent)).getMethodDefinitions();
        }
        return new HashMap<String, List<SymbolDefinition>>();
    }

    @Override
    public Map<String, SymbolDefinition> getTypeDefinitions() {
        Node parent;
        for (parent = this.getParentNode(); parent != null && parent instanceof ScopeAware; parent = parent.getParentNode()) {
        }
        if (parent != null) {
            return ((ScopeAware)((Object)parent)).getTypeDefinitions();
        }
        return new HashMap<String, SymbolDefinition>();
    }

    @Override
    public String getSymbolName() {
        return this.name;
    }
}

