/*
 * Decompiled with CFR 0.152.
 */
package org.walkmod.javalang.ast.body;

import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import org.walkmod.javalang.ast.Node;
import org.walkmod.javalang.ast.SymbolDefinition;
import org.walkmod.javalang.ast.SymbolReference;
import org.walkmod.javalang.ast.body.AnnotationDeclaration;
import org.walkmod.javalang.ast.body.BodyDeclaration;
import org.walkmod.javalang.ast.body.JavadocComment;
import org.walkmod.javalang.ast.expr.AnnotationExpr;
import org.walkmod.javalang.ast.expr.Expression;
import org.walkmod.javalang.ast.type.Type;
import org.walkmod.javalang.comparators.AnnotationMemberDeclarationComparator;
import org.walkmod.javalang.visitors.GenericVisitor;
import org.walkmod.javalang.visitors.VoidVisitor;
import org.walkmod.merger.MergeEngine;
import org.walkmod.merger.Mergeable;

public final class AnnotationMemberDeclaration
extends BodyDeclaration
implements Mergeable<AnnotationMemberDeclaration>,
SymbolDefinition {
    private int modifiers;
    private Type type;
    private String name;
    private Expression defaultValue;
    private List<SymbolReference> usages;
    private List<SymbolReference> bodyReferences;
    private int scopeLevel = 0;

    public AnnotationMemberDeclaration() {
    }

    public AnnotationMemberDeclaration(int modifiers, Type type, String name, Expression defaultValue) {
        this.modifiers = modifiers;
        this.setType(type);
        this.name = name;
        this.setDefaultValue(defaultValue);
    }

    public AnnotationMemberDeclaration(JavadocComment javaDoc, int modifiers, List<AnnotationExpr> annotations, Type type, String name, Expression defaultValue) {
        this.setJavaDoc(javaDoc);
        this.modifiers = modifiers;
        this.setType(type);
        this.name = name;
        this.setDefaultValue(defaultValue);
    }

    public AnnotationMemberDeclaration(int beginLine, int beginColumn, int endLine, int endColumn, JavadocComment javaDoc, int modifiers, List<AnnotationExpr> annotations, Type type, String name, Expression defaultValue) {
        super(beginLine, beginColumn, endLine, endColumn, annotations, javaDoc);
        this.modifiers = modifiers;
        this.setType(type);
        this.name = name;
        this.setDefaultValue(defaultValue);
    }

    @Override
    public boolean removeChild(Node child) {
        boolean result = false;
        if (child != null && !(result = super.removeChild(child))) {
            if (this.type == child && this.type != null) {
                this.type = null;
                result = true;
            } else if (this.defaultValue == child && this.defaultValue != null) {
                this.defaultValue = null;
                result = true;
            }
        }
        if (result) {
            this.updateReferences(child);
        }
        return result;
    }

    @Override
    public List<Node> getChildren() {
        LinkedList<Node> children = new LinkedList<Node>();
        if (this.type != null) {
            children.add(this.type);
        }
        if (this.defaultValue != null) {
            children.add(this.defaultValue);
        }
        return children;
    }

    @Override
    public <R, A> R accept(GenericVisitor<R, A> v, A arg) {
        if (!this.check()) {
            return null;
        }
        return v.visit(this, arg);
    }

    @Override
    public <A> void accept(VoidVisitor<A> v, A arg) {
        if (this.check()) {
            v.visit(this, arg);
        }
    }

    public Expression getDefaultValue() {
        return this.defaultValue;
    }

    public int getModifiers() {
        return this.modifiers;
    }

    public String getName() {
        return this.name;
    }

    public Type getType() {
        return this.type;
    }

    public void setDefaultValue(Expression defaultValue) {
        this.defaultValue = defaultValue;
        this.setAsParentNodeOf(defaultValue);
    }

    public void setModifiers(int modifiers) {
        this.modifiers = modifiers;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setType(Type type) {
        this.type = type;
        this.setAsParentNodeOf(type);
    }

    public Comparator<?> getIdentityComparator() {
        return new AnnotationMemberDeclarationComparator();
    }

    public void merge(AnnotationMemberDeclaration remote, MergeEngine configuration) {
        super.merge(remote, configuration);
        this.setType((Type)configuration.apply((Object)this.getType(), (Object)remote.getType(), Type.class));
        this.setDefaultValue((Expression)configuration.apply((Object)this.getDefaultValue(), (Object)remote.getDefaultValue(), Expression.class));
    }

    @Override
    public AnnotationDeclaration getParentNode() {
        return (AnnotationDeclaration)super.getParentNode();
    }

    @Override
    public List<SymbolReference> getUsages() {
        return this.usages;
    }

    @Override
    public void setUsages(List<SymbolReference> usages) {
        this.usages = usages;
    }

    @Override
    public boolean addUsage(SymbolReference usage) {
        if (usage != null) {
            usage.setSymbolDefinition(this);
            if (this.usages == null) {
                this.usages = new LinkedList<SymbolReference>();
            }
            return this.usages.add(usage);
        }
        return false;
    }

    @Override
    public List<SymbolReference> getBodyReferences() {
        return this.bodyReferences;
    }

    @Override
    public void setBodyReferences(List<SymbolReference> bodyReferences) {
        this.bodyReferences = bodyReferences;
    }

    @Override
    public boolean addBodyReference(SymbolReference bodyReference) {
        int scope;
        SymbolDefinition definition;
        if (bodyReference != null && (definition = bodyReference.getSymbolDefinition()) != null && (scope = definition.getScopeLevel()) <= this.scopeLevel) {
            if (this.bodyReferences == null) {
                this.bodyReferences = new LinkedList<SymbolReference>();
            }
            return this.bodyReferences.add(bodyReference);
        }
        return false;
    }

    @Override
    public int getScopeLevel() {
        return this.scopeLevel;
    }

    @Override
    public void setScopeLevel(int scopeLevel) {
        this.scopeLevel = scopeLevel;
    }

    @Override
    public AnnotationMemberDeclaration clone() throws CloneNotSupportedException {
        return new AnnotationMemberDeclaration(this.getModifiers(), this.clone(this.getType()), this.getName(), this.clone(this.getDefaultValue()));
    }

    @Override
    public String getSymbolName() {
        return this.name;
    }
}

