/*
 * Decompiled with CFR 0.152.
 */
package org.walkmod.javalang.ast.body;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.walkmod.javalang.ast.Node;
import org.walkmod.javalang.ast.ScopeAware;
import org.walkmod.javalang.ast.SymbolDefinition;
import org.walkmod.javalang.ast.body.JavadocComment;
import org.walkmod.javalang.ast.expr.AnnotationExpr;
import org.walkmod.merger.MergeEngine;

public abstract class BodyDeclaration
extends Node
implements ScopeAware {
    private JavadocComment javaDoc;
    private List<AnnotationExpr> annotations;

    public BodyDeclaration() {
    }

    public BodyDeclaration(List<AnnotationExpr> annotations, JavadocComment javaDoc) {
        this.setJavaDoc(javaDoc);
        this.setAnnotations(annotations);
    }

    public BodyDeclaration(int beginLine, int beginColumn, int endLine, int endColumn, List<AnnotationExpr> annotations, JavadocComment javaDoc) {
        super(beginLine, beginColumn, endLine, endColumn);
        this.setJavaDoc(javaDoc);
        this.setAnnotations(annotations);
    }

    @Override
    public List<Node> getChildren() {
        LinkedList<Node> children = new LinkedList<Node>();
        if (this.javaDoc != null) {
            children.add(this.javaDoc);
        }
        if (this.annotations != null) {
            children.addAll(this.annotations);
        }
        return children;
    }

    @Override
    public boolean removeChild(Node child) {
        boolean result = false;
        if (child != null) {
            if (child instanceof AnnotationExpr) {
                if (this.annotations != null) {
                    LinkedList<AnnotationExpr> aux = new LinkedList<AnnotationExpr>(this.annotations);
                    result = aux.remove(child);
                    this.annotations = aux;
                }
            } else if (child instanceof JavadocComment && this.javaDoc != null && this.javaDoc.equals(child)) {
                this.javaDoc = null;
                result = true;
            }
        }
        if (result) {
            this.updateReferences(child);
        }
        return result;
    }

    public final JavadocComment getJavaDoc() {
        return this.javaDoc;
    }

    public final List<AnnotationExpr> getAnnotations() {
        return this.annotations;
    }

    public final void setJavaDoc(JavadocComment javaDoc) {
        this.javaDoc = javaDoc;
        this.setAsParentNodeOf(javaDoc);
    }

    public final void setAnnotations(List<AnnotationExpr> annotations) {
        this.annotations = annotations;
        this.setAsParentNodeOf(annotations);
    }

    public void merge(BodyDeclaration remoteBodyDeclaration, MergeEngine configuration) {
        LinkedList<AnnotationExpr> resultAnnotations = new LinkedList<AnnotationExpr>();
        configuration.apply(this.getAnnotations(), remoteBodyDeclaration.getAnnotations(), resultAnnotations, AnnotationExpr.class);
        this.setAnnotations(resultAnnotations);
        this.setJavaDoc((JavadocComment)configuration.apply((Object)this.getJavaDoc(), (Object)remoteBodyDeclaration.getJavaDoc(), JavadocComment.class));
    }

    @Override
    public boolean replaceChildNode(Node oldChild, Node newChild) {
        LinkedList<AnnotationExpr> auxAnn;
        if (newChild instanceof JavadocComment) {
            this.setJavaDoc((JavadocComment)newChild);
            return true;
        }
        boolean update = false;
        if (this.annotations != null && (update = this.replaceChildNodeInList(oldChild, newChild, auxAnn = new LinkedList<AnnotationExpr>(this.annotations)))) {
            this.annotations = auxAnn;
        }
        return update;
    }

    @Override
    public Map<String, SymbolDefinition> getVariableDefinitions() {
        Node parent;
        for (parent = this.getParentNode(); parent != null && parent instanceof ScopeAware; parent = parent.getParentNode()) {
        }
        if (parent != null && parent instanceof ScopeAware) {
            return ((ScopeAware)((Object)parent)).getVariableDefinitions();
        }
        return new HashMap<String, SymbolDefinition>();
    }

    @Override
    public Map<String, List<SymbolDefinition>> getMethodDefinitions() {
        Node parent;
        for (parent = this.getParentNode(); parent != null && parent instanceof ScopeAware; parent = parent.getParentNode()) {
        }
        if (parent != null && parent instanceof ScopeAware) {
            return ((ScopeAware)((Object)parent)).getMethodDefinitions();
        }
        return new HashMap<String, List<SymbolDefinition>>();
    }

    @Override
    public Map<String, SymbolDefinition> getTypeDefinitions() {
        Node parent;
        for (parent = this.getParentNode(); parent != null && parent instanceof ScopeAware; parent = parent.getParentNode()) {
        }
        if (parent != null && parent instanceof ScopeAware) {
            return ((ScopeAware)((Object)parent)).getTypeDefinitions();
        }
        return new HashMap<String, SymbolDefinition>();
    }
}

