/*
 * Decompiled with CFR 0.152.
 */
package org.walkmod.javalang.ast.body;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import org.walkmod.javalang.ast.FieldSymbolData;
import org.walkmod.javalang.ast.Node;
import org.walkmod.javalang.ast.SymbolDefinition;
import org.walkmod.javalang.ast.SymbolReference;
import org.walkmod.javalang.ast.body.BodyDeclaration;
import org.walkmod.javalang.ast.body.JavadocComment;
import org.walkmod.javalang.ast.body.VariableDeclarator;
import org.walkmod.javalang.ast.expr.AnnotationExpr;
import org.walkmod.javalang.ast.type.Type;
import org.walkmod.javalang.comparators.FieldDeclarationComparator;
import org.walkmod.javalang.visitors.GenericVisitor;
import org.walkmod.javalang.visitors.VoidVisitor;
import org.walkmod.merger.MergeEngine;
import org.walkmod.merger.Mergeable;

public final class FieldDeclaration
extends BodyDeclaration
implements Mergeable<FieldDeclaration>,
SymbolDefinition {
    private int modifiers;
    private Type type;
    private List<VariableDeclarator> variables;
    private List<FieldSymbolData> symbolData;
    private int scopeLevel = 0;

    public FieldDeclaration() {
    }

    public FieldDeclaration(int modifiers, Type type, VariableDeclarator variable) {
        this.modifiers = modifiers;
        this.setType(type);
        this.variables = new ArrayList<VariableDeclarator>();
        this.setAsParentNodeOf(variable);
        this.variables.add(variable);
    }

    public FieldDeclaration(int modifiers, Type type, List<VariableDeclarator> variables) {
        this.modifiers = modifiers;
        this.setType(type);
        this.setVariables(variables);
    }

    public FieldDeclaration(JavadocComment javaDoc, int modifiers, List<AnnotationExpr> annotations, Type type, List<VariableDeclarator> variables) {
        super(annotations, javaDoc);
        this.modifiers = modifiers;
        this.setType(type);
        this.setVariables(variables);
    }

    public FieldDeclaration(int beginLine, int beginColumn, int endLine, int endColumn, JavadocComment javaDoc, int modifiers, List<AnnotationExpr> annotations, Type type, List<VariableDeclarator> variables) {
        super(beginLine, beginColumn, endLine, endColumn, annotations, javaDoc);
        this.modifiers = modifiers;
        this.setType(type);
        this.setVariables(variables);
    }

    @Override
    public boolean removeChild(Node child) {
        boolean result = false;
        if (child != null && !(result = super.removeChild(child))) {
            if (child == this.type && this.type != null) {
                this.type = null;
                result = true;
            }
            if (this.variables != null) {
                LinkedList<VariableDeclarator> auxVars = new LinkedList<VariableDeclarator>(this.variables);
                auxVars.remove(child);
                this.variables = auxVars;
            }
        }
        if (result) {
            this.updateReferences(child);
        }
        return result;
    }

    @Override
    public List<Node> getChildren() {
        List<Node> children = super.getChildren();
        if (this.type != null) {
            children.add(this.type);
        }
        if (this.variables != null) {
            children.addAll(this.variables);
        }
        return children;
    }

    @Override
    public <R, A> R accept(GenericVisitor<R, A> v, A arg) {
        if (!this.check()) {
            return null;
        }
        return v.visit(this, arg);
    }

    @Override
    public <A> void accept(VoidVisitor<A> v, A arg) {
        if (this.check()) {
            v.visit(this, arg);
        }
    }

    public int getModifiers() {
        return this.modifiers;
    }

    public Type getType() {
        return this.type;
    }

    public List<VariableDeclarator> getVariables() {
        return this.variables;
    }

    public void setModifiers(int modifiers) {
        this.modifiers = modifiers;
    }

    public void setType(Type type) {
        if (this.type != null) {
            this.updateReferences(this.type);
        }
        this.type = type;
        this.setAsParentNodeOf(type);
    }

    public void setVariables(List<VariableDeclarator> variables) {
        this.variables = variables;
        this.setAsParentNodeOf(variables);
    }

    public Comparator<?> getIdentityComparator() {
        return new FieldDeclarationComparator();
    }

    public void merge(FieldDeclaration remote, MergeEngine configuration) {
        super.merge(remote, configuration);
        this.setType((Type)configuration.apply((Object)this.getType(), (Object)remote.getType(), Type.class));
        LinkedList<VariableDeclarator> resultList = new LinkedList<VariableDeclarator>();
        configuration.apply(this.getVariables(), remote.getVariables(), resultList, VariableDeclarator.class);
        this.setVariables(resultList);
    }

    public List<FieldSymbolData> getFieldsSymbolData() {
        return this.symbolData;
    }

    public void setFieldsSymbolData(List<FieldSymbolData> symbolData) {
        this.symbolData = symbolData;
    }

    @Override
    public List<SymbolReference> getUsages() {
        LinkedList<SymbolReference> result = null;
        if (this.variables != null) {
            result = new LinkedList<SymbolReference>();
            for (VariableDeclarator vd : this.variables) {
                List<SymbolReference> usages = vd.getUsages();
                if (usages == null) continue;
                result.addAll(usages);
            }
            if (result.isEmpty()) {
                result = null;
            }
        }
        return result;
    }

    @Override
    public void setUsages(List<SymbolReference> usages) {
    }

    @Override
    public List<SymbolReference> getBodyReferences() {
        LinkedList<SymbolReference> result = null;
        if (this.variables != null) {
            result = new LinkedList<SymbolReference>();
            for (VariableDeclarator vd : this.variables) {
                List<SymbolReference> bodyReferences = vd.getBodyReferences();
                if (bodyReferences == null) continue;
                result.addAll(bodyReferences);
            }
            if (result.isEmpty()) {
                result = null;
            }
        }
        return result;
    }

    @Override
    public void setBodyReferences(List<SymbolReference> bodyReferences) {
    }

    @Override
    public int getScopeLevel() {
        return this.scopeLevel;
    }

    @Override
    public void setScopeLevel(int scopeLevel) {
        this.scopeLevel = scopeLevel;
    }

    @Override
    public boolean addBodyReference(SymbolReference bodyReference) {
        return false;
    }

    @Override
    public boolean addUsage(SymbolReference usage) {
        return false;
    }

    @Override
    public boolean replaceChildNode(Node oldChild, Node newChild) {
        boolean update = super.replaceChildNode(oldChild, newChild);
        if (!update) {
            LinkedList<VariableDeclarator> auxVars;
            if (oldChild == this.type) {
                this.setType((Type)newChild);
                update = true;
            } else if (this.variables != null && (update = this.replaceChildNodeInList(oldChild, newChild, auxVars = new LinkedList<VariableDeclarator>(this.variables)))) {
                this.variables = auxVars;
            }
        }
        return update;
    }

    @Override
    public FieldDeclaration clone() throws CloneNotSupportedException {
        return new FieldDeclaration(this.clone(this.getJavaDoc()), this.getModifiers(), this.clone(this.getAnnotations()), this.clone(this.getType()), this.clone(this.getVariables()));
    }

    @Override
    public String getSymbolName() {
        if (this.variables != null && this.variables.size() == 1) {
            return this.variables.get(0).getId().getName();
        }
        return null;
    }
}

