/*
 * Decompiled with CFR 0.152.
 */
package org.walkmod.javalang.ast.body;

import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.walkmod.javalang.ast.MethodSymbolData;
import org.walkmod.javalang.ast.Node;
import org.walkmod.javalang.ast.SymbolDataAware;
import org.walkmod.javalang.ast.SymbolDefinition;
import org.walkmod.javalang.ast.SymbolReference;
import org.walkmod.javalang.ast.TypeParameter;
import org.walkmod.javalang.ast.body.BodyDeclaration;
import org.walkmod.javalang.ast.body.JavadocComment;
import org.walkmod.javalang.ast.body.Parameter;
import org.walkmod.javalang.ast.expr.AnnotationExpr;
import org.walkmod.javalang.ast.stmt.BlockStmt;
import org.walkmod.javalang.ast.type.ClassOrInterfaceType;
import org.walkmod.javalang.ast.type.Type;
import org.walkmod.javalang.comparators.MethodDeclarationComparator;
import org.walkmod.javalang.visitors.GenericVisitor;
import org.walkmod.javalang.visitors.VoidVisitor;
import org.walkmod.merger.MergeEngine;
import org.walkmod.merger.Mergeable;

public final class MethodDeclaration
extends BodyDeclaration
implements Mergeable<MethodDeclaration>,
SymbolDataAware<MethodSymbolData>,
SymbolDefinition {
    private int modifiers;
    private List<TypeParameter> typeParameters;
    private Type type;
    private String name;
    private List<Parameter> parameters;
    private int arrayCount;
    private List<ClassOrInterfaceType> throws_;
    private BlockStmt body;
    private boolean isDefault = false;
    private MethodSymbolData symbolData;
    private List<SymbolReference> usages;
    private List<SymbolReference> bodyReferences;
    private int scopeLevel = 0;

    public MethodDeclaration() {
    }

    public MethodDeclaration(int modifiers, Type type, String name) {
        this.modifiers = modifiers;
        this.setType(type);
        this.name = name;
    }

    public MethodDeclaration(int modifiers, Type type, String name, List<Parameter> parameters) {
        this.modifiers = modifiers;
        this.setType(type);
        this.name = name;
        this.setParameters(parameters);
    }

    public MethodDeclaration(JavadocComment javaDoc, int modifiers, List<AnnotationExpr> annotations, List<TypeParameter> typeParameters, Type type, String name, List<Parameter> parameters, int arrayCount, List<ClassOrInterfaceType> throws_, BlockStmt block) {
        super(annotations, javaDoc);
        this.modifiers = modifiers;
        this.setTypeParameters(typeParameters);
        this.setType(type);
        this.name = name;
        this.setParameters(parameters);
        this.arrayCount = arrayCount;
        this.setThrows(throws_);
        this.setBody(block);
    }

    public MethodDeclaration(JavadocComment javaDoc, int modifiers, List<AnnotationExpr> annotations, List<TypeParameter> typeParameters, Type type, String name, List<Parameter> parameters, int arrayCount, List<ClassOrInterfaceType> throws_, BlockStmt block, boolean isDefault) {
        this(javaDoc, modifiers, annotations, typeParameters, type, name, parameters, arrayCount, throws_, block);
        this.isDefault = isDefault;
    }

    public MethodDeclaration(int beginLine, int beginColumn, int endLine, int endColumn, JavadocComment javaDoc, int modifiers, List<AnnotationExpr> annotations, List<TypeParameter> typeParameters, Type type, String name, List<Parameter> parameters, int arrayCount, List<ClassOrInterfaceType> throws_, BlockStmt block) {
        super(beginLine, beginColumn, endLine, endColumn, annotations, javaDoc);
        this.modifiers = modifiers;
        this.setTypeParameters(typeParameters);
        this.setType(type);
        this.name = name;
        this.setParameters(parameters);
        this.arrayCount = arrayCount;
        this.setThrows(throws_);
        this.setBody(block);
    }

    public MethodDeclaration(int beginLine, int beginColumn, int endLine, int endColumn, JavadocComment javaDoc, int modifiers, List<AnnotationExpr> annotations, List<TypeParameter> typeParameters, Type type, String name, List<Parameter> parameters, int arrayCount, List<ClassOrInterfaceType> throws_, BlockStmt block, boolean isDefault) {
        this(beginLine, beginColumn, endLine, endColumn, javaDoc, modifiers, annotations, typeParameters, type, name, parameters, arrayCount, throws_, block);
        this.isDefault = isDefault;
    }

    @Override
    public boolean removeChild(Node child) {
        boolean result = false;
        if (child != null && !(result = super.removeChild(child))) {
            if (child == this.type && this.type != null) {
                this.type = null;
                result = true;
            }
            if (child instanceof TypeParameter) {
                if (this.typeParameters != null) {
                    LinkedList<TypeParameter> typeParametersAux = new LinkedList<TypeParameter>(this.typeParameters);
                    result = typeParametersAux.remove(child);
                    this.typeParameters = typeParametersAux;
                }
            } else if (child instanceof Parameter) {
                if (this.parameters != null) {
                    LinkedList<Parameter> parametersAux = new LinkedList<Parameter>(this.parameters);
                    result = parametersAux.remove(child);
                    this.parameters = parametersAux;
                }
            } else if (child instanceof ClassOrInterfaceType) {
                if (this.throws_ != null) {
                    LinkedList<ClassOrInterfaceType> throwsAux = new LinkedList<ClassOrInterfaceType>();
                    result = throwsAux.remove(child);
                    this.throws_ = throwsAux;
                }
            } else if (child instanceof BlockStmt && this.body != null && this.body == child) {
                this.body = null;
                result = true;
            }
        }
        if (result) {
            this.updateReferences(child);
        }
        return result;
    }

    @Override
    public List<Node> getChildren() {
        List<Node> children = super.getChildren();
        if (this.typeParameters != null) {
            children.addAll(this.typeParameters);
        }
        if (this.type != null) {
            children.add(this.type);
        }
        if (this.parameters != null) {
            children.addAll(this.parameters);
        }
        if (this.throws_ != null) {
            children.addAll(this.throws_);
        }
        if (this.body != null) {
            children.add(this.body);
        }
        return children;
    }

    @Override
    public <R, A> R accept(GenericVisitor<R, A> v, A arg) {
        if (!this.check()) {
            return null;
        }
        return v.visit(this, arg);
    }

    @Override
    public <A> void accept(VoidVisitor<A> v, A arg) {
        if (this.check()) {
            v.visit(this, arg);
        }
    }

    public int getArrayCount() {
        return this.arrayCount;
    }

    public BlockStmt getBody() {
        return this.body;
    }

    public int getModifiers() {
        return this.modifiers;
    }

    public String getName() {
        return this.name;
    }

    public List<Parameter> getParameters() {
        return this.parameters;
    }

    public List<ClassOrInterfaceType> getThrows() {
        return this.throws_;
    }

    public Type getType() {
        return this.type;
    }

    public List<TypeParameter> getTypeParameters() {
        return this.typeParameters;
    }

    public void setArrayCount(int arrayCount) {
        this.arrayCount = arrayCount;
    }

    public void setBody(BlockStmt body) {
        if (this.body != null) {
            this.updateReferences(this.body);
        }
        this.body = body;
        this.setAsParentNodeOf(body);
    }

    public void setModifiers(int modifiers) {
        this.modifiers = modifiers;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setParameters(List<Parameter> parameters) {
        this.parameters = parameters;
        this.setAsParentNodeOf(parameters);
    }

    public void setThrows(List<ClassOrInterfaceType> throws_) {
        this.throws_ = throws_;
        this.setAsParentNodeOf(throws_);
    }

    public void setType(Type type) {
        if (this.type != null) {
            this.updateReferences(this.type);
        }
        this.type = type;
        this.setAsParentNodeOf(type);
    }

    public void setTypeParameters(List<TypeParameter> typeParameters) {
        this.typeParameters = typeParameters;
        this.setAsParentNodeOf(typeParameters);
    }

    public Comparator<?> getIdentityComparator() {
        return new MethodDeclarationComparator();
    }

    public void merge(MethodDeclaration remote, MergeEngine configuration) {
        super.merge(remote, configuration);
        this.setBody((BlockStmt)configuration.apply((Object)this.getBody(), (Object)remote.getBody(), BlockStmt.class));
        LinkedList<Parameter> resultParams = new LinkedList<Parameter>();
        configuration.apply(this.getParameters(), remote.getParameters(), resultParams, Parameter.class);
        if (!resultParams.isEmpty()) {
            this.setParameters(resultParams);
        } else {
            this.setParameters(null);
        }
        LinkedList<TypeParameter> resultTypeParams = new LinkedList<TypeParameter>();
        configuration.apply(this.getTypeParameters(), remote.getTypeParameters(), resultTypeParams, TypeParameter.class);
        if (!resultTypeParams.isEmpty()) {
            this.setTypeParameters(resultTypeParams);
        } else {
            this.setTypeParameters(null);
        }
        LinkedList<ClassOrInterfaceType> resultThrows = new LinkedList<ClassOrInterfaceType>();
        configuration.apply(this.getThrows(), remote.getThrows(), resultThrows, ClassOrInterfaceType.class);
        if (!resultThrows.isEmpty()) {
            this.setThrows(resultThrows);
        } else {
            this.setThrows(null);
        }
    }

    public boolean isDefault() {
        return this.isDefault;
    }

    public void setDefault(boolean isDefault) {
        this.isDefault = isDefault;
    }

    @Override
    public MethodSymbolData getSymbolData() {
        return this.symbolData;
    }

    @Override
    public void setSymbolData(MethodSymbolData symbolData) {
        this.symbolData = symbolData;
    }

    @Override
    public List<SymbolReference> getUsages() {
        return this.usages;
    }

    @Override
    public void setUsages(List<SymbolReference> usages) {
        this.usages = usages;
    }

    @Override
    public List<SymbolReference> getBodyReferences() {
        return this.bodyReferences;
    }

    @Override
    public void setBodyReferences(List<SymbolReference> bodyReferences) {
        this.bodyReferences = bodyReferences;
    }

    @Override
    public int getScopeLevel() {
        return this.scopeLevel;
    }

    @Override
    public void setScopeLevel(int scopeLevel) {
        this.scopeLevel = scopeLevel;
    }

    @Override
    public boolean addBodyReference(SymbolReference bodyReference) {
        int scope;
        SymbolDefinition definition;
        if (bodyReference != null && (definition = bodyReference.getSymbolDefinition()) != null && (scope = definition.getScopeLevel()) <= this.scopeLevel) {
            if (this.bodyReferences == null) {
                this.bodyReferences = new LinkedList<SymbolReference>();
            }
            return this.bodyReferences.add(bodyReference);
        }
        return false;
    }

    @Override
    public boolean addUsage(SymbolReference usage) {
        if (usage != null) {
            usage.setSymbolDefinition(this);
            if (this.usages == null) {
                this.usages = new LinkedList<SymbolReference>();
            }
            return this.usages.add(usage);
        }
        return false;
    }

    @Override
    public boolean replaceChildNode(Node oldChild, Node newChild) {
        boolean update = super.replaceChildNode(oldChild, newChild);
        if (!update) {
            LinkedList<TypeParameter> auxTParameter;
            LinkedList<ClassOrInterfaceType> auxThrows;
            LinkedList<Parameter> auxParams;
            if (this.type == oldChild) {
                this.setType((Type)newChild);
                update = true;
            }
            if (!update && this.body == oldChild) {
                this.setBody((BlockStmt)newChild);
                update = true;
            }
            if (!update && this.parameters != null && (update = this.replaceChildNodeInList(oldChild, newChild, auxParams = new LinkedList<Parameter>(this.parameters)))) {
                this.parameters = auxParams;
            }
            if (!update && this.throws_ != null && (update = this.replaceChildNodeInList(oldChild, newChild, auxThrows = new LinkedList<ClassOrInterfaceType>(this.throws_)))) {
                this.throws_ = auxThrows;
            }
            if (!update && this.typeParameters != null && (update = this.replaceChildNodeInList(oldChild, newChild, auxTParameter = new LinkedList<TypeParameter>(this.typeParameters)))) {
                this.typeParameters = auxTParameter;
            }
        }
        return update;
    }

    @Override
    public MethodDeclaration clone() throws CloneNotSupportedException {
        return new MethodDeclaration(this.clone(this.getJavaDoc()), this.getModifiers(), this.clone(this.getAnnotations()), this.clone(this.getTypeParameters()), this.clone(this.getType()), this.getName(), this.clone(this.getParameters()), this.getArrayCount(), this.clone(this.getThrows()), this.clone(this.getBody()));
    }

    @Override
    public Map<String, SymbolDefinition> getVariableDefinitions() {
        Map<String, SymbolDefinition> result = super.getVariableDefinitions();
        if (this.parameters != null) {
            for (Parameter param : this.parameters) {
                result.put(param.getSymbolName(), param);
            }
        }
        return result;
    }

    @Override
    public Map<String, SymbolDefinition> getTypeDefinitions() {
        Map<String, SymbolDefinition> result = super.getVariableDefinitions();
        if (this.typeParameters != null) {
            for (TypeParameter tp : this.typeParameters) {
                result.put(tp.getSymbolName(), tp);
            }
        }
        return result;
    }

    @Override
    public String getSymbolName() {
        return this.name;
    }
}

