/*
 * Decompiled with CFR 0.152.
 */
package org.walkmod.javalang.ast.body;

import java.util.LinkedList;
import java.util.List;
import org.walkmod.javalang.ast.Node;
import org.walkmod.javalang.ast.body.BaseParameter;
import org.walkmod.javalang.ast.body.VariableDeclaratorId;
import org.walkmod.javalang.ast.expr.AnnotationExpr;
import org.walkmod.javalang.ast.type.Type;
import org.walkmod.javalang.visitors.GenericVisitor;
import org.walkmod.javalang.visitors.VoidVisitor;

public class MultiTypeParameter
extends BaseParameter {
    private List<Type> types;

    public MultiTypeParameter() {
    }

    public MultiTypeParameter(int modifiers, List<AnnotationExpr> annotations, List<Type> types, VariableDeclaratorId id) {
        super(modifiers, annotations, id);
        this.setTypes(types);
    }

    public MultiTypeParameter(int beginLine, int beginColumn, int endLine, int endColumn, int modifiers, List<AnnotationExpr> annotations, List<Type> types, VariableDeclaratorId id) {
        super(beginLine, beginColumn, endLine, endColumn, modifiers, annotations, id);
        this.setTypes(types);
    }

    @Override
    public List<Node> getChildren() {
        List<Node> children = super.getChildren();
        if (this.types != null) {
            children.addAll(this.types);
        }
        return children;
    }

    @Override
    public boolean removeChild(Node child) {
        boolean result = false;
        if (child != null && !(result = super.removeChild(child)) && child instanceof Type && this.types != null) {
            LinkedList<Type> typesAux = new LinkedList<Type>(this.types);
            result = typesAux.remove(child);
            this.types = typesAux;
        }
        if (result) {
            this.updateReferences(child);
        }
        return result;
    }

    @Override
    public <R, A> R accept(GenericVisitor<R, A> v, A arg) {
        if (!this.check()) {
            return null;
        }
        return v.visit(this, arg);
    }

    @Override
    public <A> void accept(VoidVisitor<A> v, A arg) {
        if (this.check()) {
            v.visit(this, arg);
        }
    }

    public List<Type> getTypes() {
        return this.types;
    }

    public void setTypes(List<Type> types) {
        this.types = types;
        this.setAsParentNodeOf(types);
    }

    @Override
    public MultiTypeParameter clone() throws CloneNotSupportedException {
        return new MultiTypeParameter(this.getModifiers(), this.clone(this.getAnnotations()), this.clone(this.getTypes()), this.clone(this.getId()));
    }
}

