/*
 * Decompiled with CFR 0.152.
 */
package org.walkmod.javalang.ast.body;

import java.util.List;
import org.walkmod.javalang.ast.Node;
import org.walkmod.javalang.ast.Refactorizable;
import org.walkmod.javalang.ast.Refactorization;
import org.walkmod.javalang.ast.body.BaseParameter;
import org.walkmod.javalang.ast.body.VariableDeclaratorId;
import org.walkmod.javalang.ast.expr.AnnotationExpr;
import org.walkmod.javalang.ast.type.Type;
import org.walkmod.javalang.visitors.GenericVisitor;
import org.walkmod.javalang.visitors.VoidVisitor;

public final class Parameter
extends BaseParameter
implements Refactorizable {
    private Type type;
    private boolean isVarArgs;

    public Parameter() {
    }

    public Parameter(Type type, VariableDeclaratorId id) {
        super(id);
        this.setType(type);
    }

    public Parameter(int modifiers, Type type, VariableDeclaratorId id) {
        super(modifiers, id);
        this.setType(type);
    }

    public Parameter(int beginLine, int beginColumn, int endLine, int endColumn, int modifiers, List<AnnotationExpr> annotations, Type type, boolean isVarArgs, VariableDeclaratorId id) {
        super(beginLine, beginColumn, endLine, endColumn, modifiers, annotations, id);
        this.setType(type);
        this.setVarArgs(isVarArgs);
    }

    @Override
    public boolean removeChild(Node child) {
        boolean result = false;
        if (child != null && !(result = super.removeChild(child)) && this.type != null && this.type == child) {
            this.type = null;
            result = true;
        }
        if (result) {
            this.updateReferences(child);
        }
        return result;
    }

    @Override
    public List<Node> getChildren() {
        List<Node> children = super.getChildren();
        if (this.type != null) {
            children.add(this.type);
        }
        return children;
    }

    @Override
    public <R, A> R accept(GenericVisitor<R, A> v, A arg) {
        if (!this.check()) {
            return null;
        }
        return v.visit(this, arg);
    }

    @Override
    public <A> void accept(VoidVisitor<A> v, A arg) {
        if (this.check()) {
            v.visit(this, arg);
        }
    }

    public Type getType() {
        return this.type;
    }

    public boolean isVarArgs() {
        return this.isVarArgs;
    }

    public void setType(Type type) {
        this.type = type;
        this.setAsParentNodeOf(type);
    }

    public void setVarArgs(boolean isVarArgs) {
        this.isVarArgs = isVarArgs;
    }

    @Override
    public boolean rename(String newName) {
        Refactorization refactorization = new Refactorization();
        if (refactorization.refactorVariable(this, newName)) {
            this.replaceChildNode(this.getId(), new VariableDeclaratorId(newName));
            return true;
        }
        return false;
    }

    @Override
    public Parameter clone() throws CloneNotSupportedException {
        return new Parameter(this.getModifiers(), this.clone(this.getType()), this.clone(this.getId()));
    }
}

