/*
 * Decompiled with CFR 0.152.
 */
package org.walkmod.javalang.ast.body;

import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.walkmod.javalang.ast.Node;
import org.walkmod.javalang.ast.ScopeAware;
import org.walkmod.javalang.ast.SymbolData;
import org.walkmod.javalang.ast.SymbolDataAware;
import org.walkmod.javalang.ast.SymbolDefinition;
import org.walkmod.javalang.ast.SymbolReference;
import org.walkmod.javalang.ast.body.AnnotationMemberDeclaration;
import org.walkmod.javalang.ast.body.BodyDeclaration;
import org.walkmod.javalang.ast.body.EnumConstantDeclaration;
import org.walkmod.javalang.ast.body.FieldDeclaration;
import org.walkmod.javalang.ast.body.JavadocComment;
import org.walkmod.javalang.ast.body.MethodDeclaration;
import org.walkmod.javalang.ast.body.VariableDeclarator;
import org.walkmod.javalang.ast.expr.AnnotationExpr;
import org.walkmod.javalang.comparators.TypeDeclarationComparator;
import org.walkmod.merger.MergeEngine;
import org.walkmod.merger.Mergeable;

public abstract class TypeDeclaration
extends BodyDeclaration
implements Mergeable<TypeDeclaration>,
SymbolDataAware<SymbolData>,
SymbolDefinition {
    private String name;
    private int modifiers;
    private List<BodyDeclaration> members;
    private SymbolData symbolData;
    private List<SymbolReference> usages;
    private List<SymbolReference> bodyReferences;
    private int scopeLevel = 0;

    public TypeDeclaration() {
    }

    public TypeDeclaration(int modifiers, String name) {
        this.name = name;
        this.modifiers = modifiers;
    }

    public TypeDeclaration(List<AnnotationExpr> annotations, JavadocComment javaDoc, int modifiers, String name, List<BodyDeclaration> members) {
        this.name = name;
        this.modifiers = modifiers;
        this.setMembers(members);
        this.setJavaDoc(javaDoc);
        this.setAnnotations(annotations);
    }

    public TypeDeclaration(int beginLine, int beginColumn, int endLine, int endColumn, List<AnnotationExpr> annotations, JavadocComment javaDoc, int modifiers, String name, List<BodyDeclaration> members) {
        super(beginLine, beginColumn, endLine, endColumn, annotations, javaDoc);
        this.name = name;
        this.modifiers = modifiers;
        this.setMembers(members);
    }

    @Override
    public boolean removeChild(Node child) {
        boolean result = false;
        if (child != null && !(result = super.removeChild(child)) && child instanceof BodyDeclaration && this.members != null) {
            LinkedList<BodyDeclaration> auxMembers = new LinkedList<BodyDeclaration>(this.members);
            result = auxMembers.remove(child);
            this.members = auxMembers;
        }
        if (result) {
            this.updateReferences(child);
        }
        return result;
    }

    @Override
    public List<Node> getChildren() {
        List<Node> children = super.getChildren();
        if (this.members != null) {
            children.addAll(this.members);
        }
        return children;
    }

    public final List<BodyDeclaration> getMembers() {
        return this.members;
    }

    public final int getModifiers() {
        return this.modifiers;
    }

    public final String getName() {
        return this.name;
    }

    public void setMembers(List<BodyDeclaration> members) {
        this.members = members;
        this.setAsParentNodeOf(members);
    }

    public final void setModifiers(int modifiers) {
        this.modifiers = modifiers;
    }

    public final void setName(String name) {
        this.name = name;
    }

    public void merge(TypeDeclaration remoteTypeDeclaration, MergeEngine configuration) {
        super.merge(remoteTypeDeclaration, configuration);
        LinkedList<BodyDeclaration> resultList = new LinkedList<BodyDeclaration>();
        configuration.apply(this.getMembers(), remoteTypeDeclaration.getMembers(), resultList, BodyDeclaration.class);
        if (!resultList.isEmpty()) {
            this.setMembers(resultList);
        } else {
            this.setMembers(null);
        }
    }

    public Comparator<?> getIdentityComparator() {
        return new TypeDeclarationComparator();
    }

    @Override
    public SymbolData getSymbolData() {
        return this.symbolData;
    }

    @Override
    public void setSymbolData(SymbolData symbolData) {
        this.symbolData = symbolData;
    }

    @Override
    public List<SymbolReference> getUsages() {
        return this.usages;
    }

    @Override
    public List<SymbolReference> getBodyReferences() {
        return this.bodyReferences;
    }

    @Override
    public void setUsages(List<SymbolReference> usages) {
        this.usages = usages;
    }

    @Override
    public void setBodyReferences(List<SymbolReference> bodyReferences) {
        this.bodyReferences = bodyReferences;
    }

    @Override
    public boolean addBodyReference(SymbolReference bodyReference) {
        int scope;
        SymbolDefinition definition;
        if (bodyReference != null && (definition = bodyReference.getSymbolDefinition()) != null && (scope = definition.getScopeLevel()) <= this.scopeLevel) {
            if (this.bodyReferences == null) {
                this.bodyReferences = new LinkedList<SymbolReference>();
            }
            return this.bodyReferences.add(bodyReference);
        }
        return false;
    }

    @Override
    public boolean addUsage(SymbolReference usage) {
        if (usage != null) {
            usage.setSymbolDefinition(this);
            if (this.usages == null) {
                this.usages = new LinkedList<SymbolReference>();
            }
            return this.usages.add(usage);
        }
        return false;
    }

    @Override
    public int getScopeLevel() {
        return this.scopeLevel;
    }

    @Override
    public void setScopeLevel(int scopeLevel) {
        this.scopeLevel = scopeLevel;
    }

    @Override
    public boolean replaceChildNode(Node oldChild, Node newChild) {
        LinkedList<BodyDeclaration> auxMembers;
        boolean update = super.replaceChildNode(oldChild, newChild);
        if (!update && this.members != null && (update = this.replaceChildNodeInList(oldChild, newChild, auxMembers = new LinkedList<BodyDeclaration>(this.members)))) {
            this.members = auxMembers;
        }
        return update;
    }

    @Override
    public Map<String, List<SymbolDefinition>> getMethodDefinitions() {
        Node parent;
        for (parent = this.getParentNode(); parent != null && parent instanceof ScopeAware; parent = parent.getParentNode()) {
        }
        if (parent != null) {
            Map<String, List<SymbolDefinition>> aux = ((ScopeAware)((Object)parent)).getMethodDefinitions();
            List<BodyDeclaration> children = this.getMembers();
            if (children != null) {
                for (BodyDeclaration child : children) {
                    if (!(child instanceof MethodDeclaration)) continue;
                    MethodDeclaration md = (MethodDeclaration)child;
                    List<SymbolDefinition> sd = aux.get(md.getName());
                    if (sd == null) {
                        sd = new LinkedList<SymbolDefinition>();
                        aux.put(md.getName(), sd);
                    }
                    sd.add(md);
                }
            }
            return aux;
        }
        return new HashMap<String, List<SymbolDefinition>>();
    }

    @Override
    public Map<String, SymbolDefinition> getVariableDefinitions() {
        Node parent;
        for (parent = this.getParentNode(); parent != null && !(parent instanceof ScopeAware); parent = parent.getParentNode()) {
        }
        if (parent != null && parent instanceof ScopeAware) {
            Map<String, SymbolDefinition> aux = ((ScopeAware)((Object)parent)).getVariableDefinitions();
            List<BodyDeclaration> children = this.getMembers();
            if (children != null) {
                for (BodyDeclaration child : children) {
                    BodyDeclaration ecd;
                    if (child instanceof FieldDeclaration) {
                        FieldDeclaration fd = (FieldDeclaration)child;
                        List<VariableDeclarator> vars = fd.getVariables();
                        if (vars == null) continue;
                        for (VariableDeclarator var : vars) {
                            aux.put(var.getSymbolName(), var);
                        }
                        continue;
                    }
                    if (child instanceof EnumConstantDeclaration) {
                        ecd = (EnumConstantDeclaration)child;
                        aux.put(((EnumConstantDeclaration)ecd).getName(), (SymbolDefinition)((Object)ecd));
                        continue;
                    }
                    if (!(child instanceof AnnotationMemberDeclaration)) continue;
                    ecd = (AnnotationMemberDeclaration)child;
                    aux.put(((AnnotationMemberDeclaration)ecd).getName(), (SymbolDefinition)((Object)ecd));
                }
            }
            return aux;
        }
        return new HashMap<String, SymbolDefinition>();
    }

    @Override
    public Map<String, SymbolDefinition> getTypeDefinitions() {
        Node parent;
        for (parent = this.getParentNode(); parent != null && parent instanceof ScopeAware; parent = parent.getParentNode()) {
        }
        if (parent != null) {
            Map<String, SymbolDefinition> aux = ((ScopeAware)((Object)parent)).getVariableDefinitions();
            List<BodyDeclaration> children = this.getMembers();
            if (children != null) {
                for (BodyDeclaration child : children) {
                    if (!(child instanceof TypeDeclaration)) continue;
                    TypeDeclaration td = (TypeDeclaration)child;
                    aux.put(td.getName(), td);
                }
            }
            return aux;
        }
        return new HashMap<String, SymbolDefinition>();
    }

    @Override
    public String getSymbolName() {
        return this.name;
    }
}

