/*
 * Decompiled with CFR 0.152.
 */
package org.walkmod.javalang.ast.body;

import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.walkmod.javalang.ast.Node;
import org.walkmod.javalang.ast.Refactorizable;
import org.walkmod.javalang.ast.Refactorization;
import org.walkmod.javalang.ast.ScopeAware;
import org.walkmod.javalang.ast.SymbolDefinition;
import org.walkmod.javalang.ast.SymbolReference;
import org.walkmod.javalang.ast.body.VariableDeclaratorId;
import org.walkmod.javalang.ast.expr.Expression;
import org.walkmod.javalang.comparators.VariableDeclaratorComparator;
import org.walkmod.javalang.visitors.GenericVisitor;
import org.walkmod.javalang.visitors.VoidVisitor;
import org.walkmod.merger.MergeEngine;
import org.walkmod.merger.Mergeable;

public final class VariableDeclarator
extends Node
implements Mergeable<VariableDeclarator>,
SymbolDefinition,
Refactorizable {
    private VariableDeclaratorId id;
    private Expression init;
    private List<SymbolReference> usages;
    private List<SymbolReference> bodyReferences;
    private int scopeLevel;

    public VariableDeclarator() {
    }

    public VariableDeclarator(VariableDeclaratorId id) {
        this.setId(id);
    }

    public VariableDeclarator(VariableDeclaratorId id, Expression init) {
        this.setId(id);
        this.setInit(init);
    }

    public VariableDeclarator(int beginLine, int beginColumn, int endLine, int endColumn, VariableDeclaratorId id, Expression init) {
        super(beginLine, beginColumn, endLine, endColumn);
        this.setId(id);
        this.setInit(init);
    }

    @Override
    public boolean removeChild(Node child) {
        boolean result = false;
        if (child != null) {
            if (this.id != null && this.id == child) {
                this.id = null;
                result = true;
            }
            if (!result && this.init != null) {
                this.init = null;
                result = true;
            }
        }
        if (result) {
            this.updateReferences(child);
        }
        return result;
    }

    @Override
    public List<Node> getChildren() {
        LinkedList<Node> children = new LinkedList<Node>();
        if (this.id != null) {
            children.add(this.id);
        }
        if (this.init != null) {
            children.add(this.init);
        }
        return children;
    }

    @Override
    public <R, A> R accept(GenericVisitor<R, A> v, A arg) {
        if (!this.check()) {
            return null;
        }
        return v.visit(this, arg);
    }

    @Override
    public <A> void accept(VoidVisitor<A> v, A arg) {
        if (this.check()) {
            v.visit(this, arg);
        }
    }

    public VariableDeclaratorId getId() {
        return this.id;
    }

    public Expression getInit() {
        return this.init;
    }

    public void setId(VariableDeclaratorId id) {
        if (this.id != null) {
            this.updateReferences(this.id);
        }
        this.id = id;
        this.setAsParentNodeOf(id);
    }

    public void setInit(Expression init) {
        if (this.init != null) {
            this.updateReferences(this.init);
        }
        this.init = init;
        this.setAsParentNodeOf(init);
    }

    public Comparator<?> getIdentityComparator() {
        return new VariableDeclaratorComparator();
    }

    public void merge(VariableDeclarator remote, MergeEngine configuration) {
        this.setInit((Expression)configuration.apply((Object)this.getInit(), (Object)remote.getInit(), Expression.class));
        this.setId((VariableDeclaratorId)configuration.apply((Object)this.getId(), (Object)remote.getId(), VariableDeclaratorId.class));
    }

    @Override
    public List<SymbolReference> getUsages() {
        return this.usages;
    }

    @Override
    public void setUsages(List<SymbolReference> usages) {
        this.usages = usages;
    }

    @Override
    public List<SymbolReference> getBodyReferences() {
        return this.bodyReferences;
    }

    @Override
    public void setBodyReferences(List<SymbolReference> bodyReferences) {
        this.bodyReferences = bodyReferences;
    }

    @Override
    public int getScopeLevel() {
        return this.scopeLevel;
    }

    @Override
    public void setScopeLevel(int scopeLevel) {
        this.scopeLevel = scopeLevel;
    }

    @Override
    public boolean addBodyReference(SymbolReference bodyReference) {
        int scope;
        SymbolDefinition definition;
        if (bodyReference != null && (definition = bodyReference.getSymbolDefinition()) != null && (scope = definition.getScopeLevel()) <= this.scopeLevel) {
            if (this.bodyReferences == null) {
                this.bodyReferences = new LinkedList<SymbolReference>();
            }
            return this.bodyReferences.add(bodyReference);
        }
        return false;
    }

    @Override
    public boolean addUsage(SymbolReference usage) {
        if (usage != null) {
            usage.setSymbolDefinition(this);
            if (this.usages == null) {
                this.usages = new LinkedList<SymbolReference>();
            }
            return this.usages.add(usage);
        }
        return false;
    }

    @Override
    public boolean replaceChildNode(Node oldChild, Node newChild) {
        boolean update = false;
        if (oldChild == this.id) {
            this.setId((VariableDeclaratorId)newChild);
            update = true;
        }
        if (!update && this.init == oldChild) {
            this.setInit((Expression)newChild);
        }
        return update;
    }

    @Override
    public VariableDeclarator clone() throws CloneNotSupportedException {
        return new VariableDeclarator(this.clone(this.getId()), this.clone(this.getInit()));
    }

    @Override
    public Map<String, SymbolDefinition> getVariableDefinitions() {
        Node parent;
        for (parent = this.getParentNode(); parent != null && parent instanceof ScopeAware; parent = parent.getParentNode()) {
        }
        if (parent != null && parent instanceof ScopeAware) {
            return ((ScopeAware)((Object)parent)).getVariableDefinitions();
        }
        return new HashMap<String, SymbolDefinition>();
    }

    @Override
    public Map<String, List<SymbolDefinition>> getMethodDefinitions() {
        Node parent;
        for (parent = this.getParentNode(); parent != null && parent instanceof ScopeAware; parent = parent.getParentNode()) {
        }
        if (parent != null && parent instanceof ScopeAware) {
            return ((ScopeAware)((Object)parent)).getMethodDefinitions();
        }
        return new HashMap<String, List<SymbolDefinition>>();
    }

    @Override
    public Map<String, SymbolDefinition> getTypeDefinitions() {
        Node parent;
        for (parent = this.getParentNode(); parent != null && parent instanceof ScopeAware; parent = parent.getParentNode()) {
        }
        if (parent != null && parent instanceof ScopeAware) {
            return ((ScopeAware)((Object)parent)).getTypeDefinitions();
        }
        return new HashMap<String, SymbolDefinition>();
    }

    @Override
    public String getSymbolName() {
        return this.getId().getName();
    }

    @Override
    public boolean rename(String newName) {
        Refactorization refactorization = new Refactorization();
        if (refactorization.refactorVariable(this, newName)) {
            this.replaceChildNode(this.getId(), new VariableDeclaratorId(newName));
            return true;
        }
        return false;
    }
}

