/*
 * Decompiled with CFR 0.152.
 */
package org.walkmod.javalang.ast.expr;

import java.util.LinkedList;
import java.util.List;
import org.walkmod.javalang.ast.Node;
import org.walkmod.javalang.ast.expr.AnnotationExpr;
import org.walkmod.javalang.ast.expr.ArrayInitializerExpr;
import org.walkmod.javalang.ast.expr.Expression;
import org.walkmod.javalang.ast.type.Type;
import org.walkmod.javalang.visitors.GenericVisitor;
import org.walkmod.javalang.visitors.VoidVisitor;

public final class ArrayCreationExpr
extends Expression {
    private Type type;
    private int arrayCount;
    private ArrayInitializerExpr initializer;
    private List<Expression> dimensions;
    private List<List<AnnotationExpr>> arraysAnnotations;

    public ArrayCreationExpr() {
    }

    public ArrayCreationExpr(Type type, int arrayCount, ArrayInitializerExpr initializer) {
        this.setType(type);
        this.arrayCount = arrayCount;
        this.setInitializer(initializer);
        this.dimensions = null;
    }

    public ArrayCreationExpr(Type type, int arrayCount, ArrayInitializerExpr initializer, List<List<AnnotationExpr>> arraysAnnotations) {
        this.setType(type);
        this.arrayCount = arrayCount;
        this.setInitializer(initializer);
        this.dimensions = null;
        this.setArraysAnnotations(arraysAnnotations);
    }

    public ArrayCreationExpr(int beginLine, int beginColumn, int endLine, int endColumn, Type type, int arrayCount, ArrayInitializerExpr initializer) {
        super(beginLine, beginColumn, endLine, endColumn);
        this.setType(type);
        this.arrayCount = arrayCount;
        this.setInitializer(initializer);
        this.dimensions = null;
    }

    public ArrayCreationExpr(Type type, List<Expression> dimensions, int arrayCount) {
        this.setType(type);
        this.arrayCount = arrayCount;
        this.setDimensions(dimensions);
        this.initializer = null;
    }

    public ArrayCreationExpr(Type type, List<Expression> dimensions, int arrayCount, List<List<AnnotationExpr>> arraysAnnotations) {
        this.setType(type);
        this.arrayCount = arrayCount;
        this.setDimensions(dimensions);
        this.initializer = null;
        this.setArraysAnnotations(arraysAnnotations);
    }

    public ArrayCreationExpr(int beginLine, int beginColumn, int endLine, int endColumn, Type type, List<Expression> dimensions, int arrayCount) {
        super(beginLine, beginColumn, endLine, endColumn);
        this.setType(type);
        this.arrayCount = arrayCount;
        this.setDimensions(dimensions);
        this.initializer = null;
    }

    public ArrayCreationExpr(int beginLine, int beginColumn, int endLine, int endColumn, Type type, List<Expression> dimensions, int arrayCount, List<List<AnnotationExpr>> arraysAnnotations) {
        super(beginLine, beginColumn, endLine, endColumn);
        this.setType(type);
        this.arrayCount = arrayCount;
        this.setDimensions(dimensions);
        this.initializer = null;
        this.setArraysAnnotations(arraysAnnotations);
    }

    @Override
    public boolean removeChild(Node child) {
        boolean result = false;
        if (child != null && this.type == child) {
            this.type = null;
            result = true;
        }
        if (result) {
            this.updateReferences(child);
        }
        return result;
    }

    @Override
    public List<Node> getChildren() {
        LinkedList<Node> children = new LinkedList<Node>();
        if (this.type != null) {
            children.add(this.type);
        }
        if (this.initializer != null) {
            children.add(this.initializer);
        }
        if (this.dimensions != null) {
            children.addAll(this.dimensions);
        }
        if (this.arraysAnnotations != null) {
            for (List<AnnotationExpr> l : this.arraysAnnotations) {
                children.addAll(l);
            }
        }
        return children;
    }

    @Override
    public <R, A> R accept(GenericVisitor<R, A> v, A arg) {
        if (!this.check()) {
            return null;
        }
        return v.visit(this, arg);
    }

    @Override
    public <A> void accept(VoidVisitor<A> v, A arg) {
        if (this.check()) {
            v.visit(this, arg);
        }
    }

    public int getArrayCount() {
        return this.arrayCount;
    }

    public List<Expression> getDimensions() {
        return this.dimensions;
    }

    public ArrayInitializerExpr getInitializer() {
        return this.initializer;
    }

    public Type getType() {
        return this.type;
    }

    public void setArrayCount(int arrayCount) {
        this.arrayCount = arrayCount;
    }

    public void setDimensions(List<Expression> dimensions) {
        this.dimensions = dimensions;
        this.setAsParentNodeOf(dimensions);
    }

    public void setInitializer(ArrayInitializerExpr initializer) {
        if (this.initializer != null) {
            this.updateReferences(this.initializer);
        }
        this.initializer = initializer;
        this.setAsParentNodeOf(initializer);
    }

    public void setType(Type type) {
        if (this.type != null) {
            this.updateReferences(this.type);
        }
        this.type = type;
    }

    public List<List<AnnotationExpr>> getArraysAnnotations() {
        return this.arraysAnnotations;
    }

    public void setArraysAnnotations(List<List<AnnotationExpr>> arraysAnnotations) {
        this.arraysAnnotations = arraysAnnotations;
        if (arraysAnnotations != null) {
            for (List<AnnotationExpr> ann : arraysAnnotations) {
                this.setAsParentNodeOf(ann);
            }
        }
    }

    @Override
    public boolean replaceChildNode(Node oldChild, Node newChild) {
        LinkedList<List<AnnotationExpr>> auxArraysAnn;
        LinkedList<Expression> auxDimensions;
        boolean updated = false;
        if (this.type == oldChild) {
            this.setType((Type)newChild);
            updated = true;
        }
        if (!updated && this.initializer == oldChild) {
            this.setInitializer((ArrayInitializerExpr)newChild);
            updated = true;
        }
        if (!updated && this.dimensions != null && (updated = this.replaceChildNodeInList(oldChild, newChild, auxDimensions = new LinkedList<Expression>(this.dimensions)))) {
            this.dimensions = auxDimensions;
        }
        if (!updated && this.arraysAnnotations != null && (updated = this.replaceChildNodeInList(oldChild, newChild, auxArraysAnn = new LinkedList<List<AnnotationExpr>>(this.arraysAnnotations)))) {
            this.arraysAnnotations = auxArraysAnn;
        }
        return updated;
    }

    @Override
    public ArrayCreationExpr clone() throws CloneNotSupportedException {
        LinkedList<List<AnnotationExpr>> copy = null;
        if (this.arraysAnnotations != null) {
            copy = new LinkedList<List<AnnotationExpr>>();
            for (List<AnnotationExpr> item : this.arraysAnnotations) {
                copy.add(this.clone(item));
            }
        }
        return new ArrayCreationExpr(this.clone(this.getType()), this.clone(this.dimensions), this.arrayCount, copy);
    }
}

