/*
 * Decompiled with CFR 0.152.
 */
package org.walkmod.javalang.ast.expr;

import java.util.LinkedList;
import java.util.List;
import org.walkmod.javalang.ast.Node;
import org.walkmod.javalang.ast.expr.Expression;
import org.walkmod.javalang.visitors.GenericVisitor;
import org.walkmod.javalang.visitors.VoidVisitor;

public final class ArrayInitializerExpr
extends Expression {
    private List<Expression> values;

    public ArrayInitializerExpr() {
    }

    public ArrayInitializerExpr(List<Expression> values) {
        this.values = values;
    }

    public ArrayInitializerExpr(int beginLine, int beginColumn, int endLine, int endColumn, List<Expression> values) {
        super(beginLine, beginColumn, endLine, endColumn);
        this.setValues(values);
    }

    @Override
    public boolean removeChild(Node child) {
        boolean result = false;
        if (child != null && this.values != null && child instanceof Expression) {
            LinkedList<Expression> valuesAux = new LinkedList<Expression>();
            result = valuesAux.remove(child);
            this.values = valuesAux;
        }
        if (result) {
            this.updateReferences(child);
        }
        return result;
    }

    @Override
    public List<Node> getChildren() {
        LinkedList<Node> children = new LinkedList<Node>();
        if (this.values != null) {
            children.addAll(this.values);
        }
        return children;
    }

    @Override
    public <R, A> R accept(GenericVisitor<R, A> v, A arg) {
        if (!this.check()) {
            return null;
        }
        return v.visit(this, arg);
    }

    @Override
    public <A> void accept(VoidVisitor<A> v, A arg) {
        if (this.check()) {
            v.visit(this, arg);
        }
    }

    public List<Expression> getValues() {
        return this.values;
    }

    public void setValues(List<Expression> values) {
        this.values = values;
        this.setAsParentNodeOf(values);
    }

    @Override
    public boolean replaceChildNode(Node oldChild, Node newChild) {
        boolean updated = false;
        if (this.values != null) {
            LinkedList<Expression> auxValues = new LinkedList<Expression>(this.values);
            updated = this.replaceChildNodeInList(oldChild, newChild, auxValues);
            this.values = auxValues;
        }
        return updated;
    }

    @Override
    public ArrayInitializerExpr clone() throws CloneNotSupportedException {
        return new ArrayInitializerExpr(this.clone(this.values));
    }
}

