/*
 * Decompiled with CFR 0.152.
 */
package org.walkmod.javalang.ast.expr;

import java.util.LinkedList;
import java.util.List;
import org.walkmod.javalang.ast.Node;
import org.walkmod.javalang.ast.expr.Expression;
import org.walkmod.javalang.visitors.GenericVisitor;
import org.walkmod.javalang.visitors.VoidVisitor;

public final class BinaryExpr
extends Expression {
    private Expression left;
    private Expression right;
    private Operator op;

    public BinaryExpr() {
    }

    public BinaryExpr(Expression left, Expression right, Operator op) {
        this.setLeft(left);
        this.setRight(right);
        this.setOperator(op);
    }

    public BinaryExpr(int beginLine, int beginColumn, int endLine, int endColumn, Expression left, Expression right, Operator op) {
        super(beginLine, beginColumn, endLine, endColumn);
        this.setLeft(left);
        this.setRight(right);
        this.setOperator(op);
    }

    @Override
    public boolean removeChild(Node child) {
        boolean result = false;
        if (child != null) {
            if (this.left != null && this.left == child) {
                this.left = null;
                result = true;
            }
            if (!result && this.right != null && this.right == child) {
                this.right = null;
                result = true;
            }
        }
        if (result) {
            this.updateReferences(child);
        }
        return result;
    }

    @Override
    public List<Node> getChildren() {
        LinkedList<Node> children = new LinkedList<Node>();
        if (this.left != null) {
            children.add(this.left);
        }
        if (this.right != null) {
            children.add(this.right);
        }
        return children;
    }

    @Override
    public <R, A> R accept(GenericVisitor<R, A> v, A arg) {
        if (!this.check()) {
            return null;
        }
        return v.visit(this, arg);
    }

    @Override
    public <A> void accept(VoidVisitor<A> v, A arg) {
        if (this.check()) {
            v.visit(this, arg);
        }
    }

    public Expression getLeft() {
        return this.left;
    }

    public Operator getOperator() {
        return this.op;
    }

    public Expression getRight() {
        return this.right;
    }

    public void setLeft(Expression left) {
        if (this.left != null) {
            this.updateReferences(this.left);
        }
        this.left = left;
        this.setAsParentNodeOf(left);
    }

    public void setOperator(Operator op) {
        this.op = op;
    }

    public void setRight(Expression right) {
        if (this.right != null) {
            this.updateReferences(this.right);
        }
        this.right = right;
        this.setAsParentNodeOf(right);
    }

    @Override
    public boolean replaceChildNode(Node oldChild, Node newChild) {
        boolean updated = false;
        if (this.left == oldChild) {
            this.setLeft((Expression)newChild);
            updated = true;
        }
        if (this.right == oldChild) {
            this.setRight((Expression)newChild);
            updated = true;
        }
        return updated;
    }

    @Override
    public BinaryExpr clone() throws CloneNotSupportedException {
        return new BinaryExpr(this.clone(this.getLeft()), this.clone(this.getRight()), this.getOperator());
    }

    public static enum Operator {
        or,
        and,
        binOr,
        binAnd,
        xor,
        equals,
        notEquals,
        less,
        greater,
        lessEquals,
        greaterEquals,
        lShift,
        rSignedShift,
        rUnsignedShift,
        plus,
        minus,
        times,
        divide,
        remainder;

    }
}

