/*
 * Decompiled with CFR 0.152.
 */
package org.walkmod.javalang.ast.expr;

import java.util.LinkedList;
import java.util.List;
import org.walkmod.javalang.ast.Node;
import org.walkmod.javalang.ast.expr.Expression;
import org.walkmod.javalang.visitors.GenericVisitor;
import org.walkmod.javalang.visitors.VoidVisitor;

public final class EnclosedExpr
extends Expression {
    private Expression inner;

    public EnclosedExpr() {
    }

    public EnclosedExpr(Expression inner) {
        this.setInner(inner);
    }

    public EnclosedExpr(int beginLine, int beginColumn, int endLine, int endColumn, Expression inner) {
        super(beginLine, beginColumn, endLine, endColumn);
        this.setInner(inner);
    }

    @Override
    public boolean removeChild(Node child) {
        boolean result = false;
        if (child != null && this.inner == child) {
            this.inner = null;
            result = true;
        }
        if (result) {
            this.updateReferences(child);
        }
        return result;
    }

    @Override
    public List<Node> getChildren() {
        LinkedList<Node> children = new LinkedList<Node>();
        if (this.inner != null) {
            children.add(this.inner);
        }
        return children;
    }

    @Override
    public <R, A> R accept(GenericVisitor<R, A> v, A arg) {
        if (!this.check()) {
            return null;
        }
        return v.visit(this, arg);
    }

    @Override
    public <A> void accept(VoidVisitor<A> v, A arg) {
        if (this.check()) {
            v.visit(this, arg);
        }
    }

    public Expression getInner() {
        return this.inner;
    }

    public void setInner(Expression inner) {
        if (this.inner != null) {
            this.updateReferences(this.inner);
        }
        this.inner = inner;
        this.setAsParentNodeOf(inner);
    }

    @Override
    public boolean replaceChildNode(Node oldChild, Node newChild) {
        boolean updated = false;
        if (oldChild == this.inner) {
            this.setInner((Expression)newChild);
            updated = true;
        }
        return updated;
    }

    @Override
    public EnclosedExpr clone() throws CloneNotSupportedException {
        return new EnclosedExpr(this.clone(this.inner));
    }
}

