/*
 * Decompiled with CFR 0.152.
 */
package org.walkmod.javalang.ast.expr;

import java.util.LinkedList;
import java.util.List;
import org.walkmod.javalang.ast.Node;
import org.walkmod.javalang.ast.expr.Expression;
import org.walkmod.javalang.ast.type.Type;
import org.walkmod.javalang.visitors.GenericVisitor;
import org.walkmod.javalang.visitors.VoidVisitor;

public final class InstanceOfExpr
extends Expression {
    private Expression expr;
    private Type type;

    public InstanceOfExpr() {
    }

    public InstanceOfExpr(Expression expr, Type type) {
        this.setExpr(expr);
        this.setType(type);
    }

    public InstanceOfExpr(int beginLine, int beginColumn, int endLine, int endColumn, Expression expr, Type type) {
        super(beginLine, beginColumn, endLine, endColumn);
        this.setExpr(expr);
        this.setType(type);
    }

    @Override
    public boolean removeChild(Node child) {
        boolean result = false;
        if (child != null) {
            if (this.expr == child) {
                this.expr = null;
                result = true;
            }
            if (!result && this.type == child) {
                this.type = null;
                result = true;
            }
        }
        if (result) {
            this.updateReferences(child);
        }
        return result;
    }

    @Override
    public List<Node> getChildren() {
        LinkedList<Node> children = new LinkedList<Node>();
        if (this.expr != null) {
            children.add(this.expr);
        }
        if (this.type != null) {
            children.add(this.type);
        }
        return children;
    }

    @Override
    public <R, A> R accept(GenericVisitor<R, A> v, A arg) {
        if (!this.check()) {
            return null;
        }
        return v.visit(this, arg);
    }

    @Override
    public <A> void accept(VoidVisitor<A> v, A arg) {
        if (this.check()) {
            v.visit(this, arg);
        }
    }

    public Expression getExpr() {
        return this.expr;
    }

    public Type getType() {
        return this.type;
    }

    public void setExpr(Expression expr) {
        if (this.expr != null) {
            this.updateReferences(this.expr);
        }
        this.expr = expr;
        this.setAsParentNodeOf(expr);
    }

    public void setType(Type type) {
        if (this.type != null) {
            this.updateReferences(this.type);
        }
        this.type = type;
        this.setAsParentNodeOf(type);
    }

    @Override
    public boolean replaceChildNode(Node oldChild, Node newChild) {
        boolean updated = false;
        if (oldChild == this.expr) {
            this.setExpr((Expression)newChild);
            updated = true;
        }
        if (!updated && this.type == oldChild) {
            this.setType((Type)newChild);
            updated = true;
        }
        return updated;
    }

    @Override
    public InstanceOfExpr clone() throws CloneNotSupportedException {
        return new InstanceOfExpr(this.clone(this.expr), this.clone(this.type));
    }
}

