/*
 * Decompiled with CFR 0.152.
 */
package org.walkmod.javalang.ast.expr;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.walkmod.javalang.ast.Node;
import org.walkmod.javalang.ast.ScopeAware;
import org.walkmod.javalang.ast.SymbolDefinition;
import org.walkmod.javalang.ast.SymbolReference;
import org.walkmod.javalang.ast.body.Parameter;
import org.walkmod.javalang.ast.expr.Expression;
import org.walkmod.javalang.ast.stmt.Statement;
import org.walkmod.javalang.visitors.GenericVisitor;
import org.walkmod.javalang.visitors.VoidVisitor;

public class LambdaExpr
extends Expression
implements SymbolReference {
    private List<Parameter> parameters;
    private boolean parametersEnclosed;
    private Statement body;
    private SymbolDefinition symbolDefinition;

    public LambdaExpr() {
    }

    public LambdaExpr(int beginLine, int beginColumn, int endLine, int endColumn, List<Parameter> parameters, Statement body, boolean parametersEnclosed) {
        super(beginLine, beginColumn, endLine, endColumn);
        this.setParameters(parameters);
        this.setBody(body);
        this.parametersEnclosed = this.parameters != null && this.parameters.size() == 1 && this.parameters.get(0).getType() == null ? parametersEnclosed : true;
    }

    public LambdaExpr(List<Parameter> parameters, Statement body, boolean parametersEnclosed) {
        this.setParameters(parameters);
        this.setBody(body);
        this.parametersEnclosed = this.parameters != null && this.parameters.size() == 1 && this.parameters.get(0).getType() == null ? parametersEnclosed : true;
    }

    @Override
    public boolean removeChild(Node child) {
        boolean result = false;
        if (child != null) {
            if (this.parameters != null && child instanceof Parameter) {
                LinkedList<Parameter> parametersAux = new LinkedList<Parameter>(this.parameters);
                result = parametersAux.remove(child);
                this.parameters = parametersAux;
            }
            if (!result && this.body == child) {
                this.body = null;
                result = true;
            }
        }
        if (result) {
            this.updateReferences(child);
        }
        return result;
    }

    @Override
    public List<Node> getChildren() {
        LinkedList<Node> children = new LinkedList<Node>();
        if (this.parameters != null) {
            children.addAll(this.parameters);
        }
        if (this.body != null) {
            children.add(this.body);
        }
        return children;
    }

    public List<Parameter> getParameters() {
        return this.parameters;
    }

    public void setParameters(List<Parameter> parameters) {
        this.parameters = parameters;
        this.setAsParentNodeOf(parameters);
    }

    public Statement getBody() {
        return this.body;
    }

    public void setBody(Statement body) {
        if (this.body != null) {
            this.updateReferences(this.body);
        }
        this.body = body;
        this.setAsParentNodeOf(body);
    }

    @Override
    public <R, A> R accept(GenericVisitor<R, A> v, A arg) {
        if (!this.check()) {
            return null;
        }
        return v.visit(this, arg);
    }

    @Override
    public <A> void accept(VoidVisitor<A> v, A arg) {
        if (this.check()) {
            v.visit(this, arg);
        }
    }

    public boolean isParametersEnclosed() {
        return this.parametersEnclosed;
    }

    public void setParametersEnclosed(boolean parametersEnclosed) {
        this.parametersEnclosed = parametersEnclosed;
    }

    @Override
    public SymbolDefinition getSymbolDefinition() {
        return this.symbolDefinition;
    }

    @Override
    public void setSymbolDefinition(SymbolDefinition symbolDefinition) {
        this.symbolDefinition = symbolDefinition;
    }

    @Override
    public boolean replaceChildNode(Node oldChild, Node newChild) {
        List<Parameter> auxParams;
        boolean updated = false;
        if (oldChild == this.body) {
            this.setBody((Statement)newChild);
            updated = true;
        }
        if (!updated && this.parameters != null && (updated = this.replaceChildNodeInList(oldChild, newChild, auxParams = new LinkedList<Parameter>(this.parameters)))) {
            auxParams = this.parameters;
        }
        return updated;
    }

    @Override
    public LambdaExpr clone() throws CloneNotSupportedException {
        return new LambdaExpr(this.clone(this.parameters), this.clone(this.body), this.parametersEnclosed);
    }

    @Override
    public Map<String, SymbolDefinition> getVariableDefinitions() {
        Node parent;
        for (parent = this.getParentNode(); parent != null && parent instanceof ScopeAware; parent = parent.getParentNode()) {
        }
        if (parent != null && parent instanceof ScopeAware) {
            return ((ScopeAware)((Object)parent)).getVariableDefinitions();
        }
        return new HashMap<String, SymbolDefinition>();
    }

    @Override
    public Map<String, List<SymbolDefinition>> getMethodDefinitions() {
        Node parent;
        for (parent = this.getParentNode(); parent != null && parent instanceof ScopeAware; parent = parent.getParentNode()) {
        }
        if (parent != null && parent instanceof ScopeAware) {
            return ((ScopeAware)((Object)parent)).getMethodDefinitions();
        }
        return new HashMap<String, List<SymbolDefinition>>();
    }

    @Override
    public Map<String, SymbolDefinition> getTypeDefinitions() {
        Node parent;
        for (parent = this.getParentNode(); parent != null && parent instanceof ScopeAware; parent = parent.getParentNode()) {
        }
        if (parent != null && parent instanceof ScopeAware) {
            return ((ScopeAware)((Object)parent)).getTypeDefinitions();
        }
        return new HashMap<String, SymbolDefinition>();
    }
}

