/*
 * Decompiled with CFR 0.152.
 */
package org.walkmod.javalang.ast.expr;

import java.util.LinkedList;
import java.util.List;
import org.walkmod.javalang.ast.Node;
import org.walkmod.javalang.ast.expr.Expression;
import org.walkmod.javalang.visitors.GenericVisitor;
import org.walkmod.javalang.visitors.VoidVisitor;

public final class MemberValuePair
extends Node {
    private String name;
    private Expression value;

    public MemberValuePair() {
    }

    public MemberValuePair(String name, Expression value) {
        this.name = name;
        this.setValue(value);
    }

    public MemberValuePair(int beginLine, int beginColumn, int endLine, int endColumn, String name, Expression value) {
        super(beginLine, beginColumn, endLine, endColumn);
        this.name = name;
        this.setValue(value);
    }

    @Override
    public boolean removeChild(Node child) {
        boolean result = false;
        if (child != null && this.value == child) {
            this.value = null;
            result = true;
        }
        if (result) {
            this.updateReferences(child);
        }
        return result;
    }

    @Override
    public List<Node> getChildren() {
        LinkedList<Node> children = new LinkedList<Node>();
        if (this.value != null) {
            children.add(this.value);
        }
        return children;
    }

    @Override
    public <R, A> R accept(GenericVisitor<R, A> v, A arg) {
        if (!this.check()) {
            return null;
        }
        return v.visit(this, arg);
    }

    @Override
    public <A> void accept(VoidVisitor<A> v, A arg) {
        if (this.check()) {
            v.visit(this, arg);
        }
    }

    public String getName() {
        return this.name;
    }

    public Expression getValue() {
        return this.value;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setValue(Expression value) {
        if (this.value != null) {
            this.updateReferences(this.value);
        }
        this.value = value;
        this.setAsParentNodeOf(value);
    }

    @Override
    public boolean replaceChildNode(Node oldChild, Node newChild) {
        boolean updated = false;
        if (oldChild == this.value) {
            this.setValue((Expression)newChild);
            updated = true;
        }
        return updated;
    }

    @Override
    public MemberValuePair clone() throws CloneNotSupportedException {
        return new MemberValuePair(new String(this.name), this.clone(this.value));
    }
}

