/*
 * Decompiled with CFR 0.152.
 */
package org.walkmod.javalang.ast.expr;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.walkmod.javalang.ast.MethodSymbolData;
import org.walkmod.javalang.ast.Node;
import org.walkmod.javalang.ast.ScopeAware;
import org.walkmod.javalang.ast.SymbolDefinition;
import org.walkmod.javalang.ast.SymbolReference;
import org.walkmod.javalang.ast.expr.Expression;
import org.walkmod.javalang.ast.type.Type;
import org.walkmod.javalang.visitors.GenericVisitor;
import org.walkmod.javalang.visitors.VoidVisitor;

public final class MethodCallExpr
extends Expression
implements SymbolReference {
    private Expression scope;
    private List<Type> typeArgs;
    private String name;
    private List<Expression> args;
    private SymbolDefinition symbolDefinition;

    public MethodCallExpr() {
    }

    public MethodCallExpr(Expression scope, String name) {
        this.setScope(scope);
        this.name = name;
    }

    public MethodCallExpr(Expression scope, String name, List<Expression> args) {
        this.setScope(scope);
        this.name = name;
        this.setArgs(args);
    }

    public MethodCallExpr(Expression scope, List<Type> typeArgs, String name, List<Expression> args) {
        this.setScope(scope);
        this.setTypeArgs(typeArgs);
        this.name = name;
        this.setArgs(args);
    }

    public MethodCallExpr(int beginLine, int beginColumn, int endLine, int endColumn, Expression scope, List<Type> typeArgs, String name, List<Expression> args) {
        super(beginLine, beginColumn, endLine, endColumn);
        this.setScope(scope);
        this.setTypeArgs(typeArgs);
        this.name = name;
        this.setArgs(args);
    }

    @Override
    public boolean removeChild(Node child) {
        boolean result = false;
        if (child != null) {
            if (this.scope == child) {
                this.scope = null;
                result = true;
            }
            if (!result && this.typeArgs != null && child instanceof Type) {
                LinkedList<Type> typeArgsAux = new LinkedList<Type>(this.typeArgs);
                result = typeArgsAux.remove(child);
                this.typeArgs = typeArgsAux;
            }
            if (!result && this.args != null && child instanceof Expression) {
                LinkedList<Expression> argsAux = new LinkedList<Expression>(this.args);
                result = argsAux.remove(child);
                this.args = argsAux;
            }
        }
        if (result) {
            this.updateReferences(child);
        }
        return result;
    }

    @Override
    public List<Node> getChildren() {
        LinkedList<Node> children = new LinkedList<Node>();
        if (this.scope != null) {
            children.add(this.scope);
        }
        if (this.typeArgs != null) {
            children.addAll(this.typeArgs);
        }
        if (this.args != null) {
            children.addAll(this.args);
        }
        return children;
    }

    @Override
    public <R, A> R accept(GenericVisitor<R, A> v, A arg) {
        if (!this.check()) {
            return null;
        }
        return v.visit(this, arg);
    }

    @Override
    public <A> void accept(VoidVisitor<A> v, A arg) {
        if (this.check()) {
            v.visit(this, arg);
        }
    }

    public List<Expression> getArgs() {
        return this.args;
    }

    public String getName() {
        return this.name;
    }

    public Expression getScope() {
        return this.scope;
    }

    public List<Type> getTypeArgs() {
        return this.typeArgs;
    }

    public void setArgs(List<Expression> args) {
        this.args = args;
        this.setAsParentNodeOf(args);
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setScope(Expression scope) {
        if (this.scope != null) {
            this.updateReferences(this.scope);
        }
        this.scope = scope;
        this.setAsParentNodeOf(scope);
    }

    public void setTypeArgs(List<Type> typeArgs) {
        this.typeArgs = typeArgs;
        this.setAsParentNodeOf(typeArgs);
    }

    @Override
    public MethodSymbolData getSymbolData() {
        return (MethodSymbolData)super.getSymbolData();
    }

    @Override
    public SymbolDefinition getSymbolDefinition() {
        return this.symbolDefinition;
    }

    @Override
    public void setSymbolDefinition(SymbolDefinition symbolDefinition) {
        this.symbolDefinition = symbolDefinition;
    }

    @Override
    public boolean replaceChildNode(Node oldChild, Node newChild) {
        boolean updated = false;
        if (oldChild == this.scope) {
            this.setScope((Expression)newChild);
            updated = true;
        }
        if (!updated) {
            LinkedList<Expression> argsAux;
            if (this.typeArgs != null) {
                LinkedList<Type> typeArgsAux = new LinkedList<Type>(this.typeArgs);
                updated = this.replaceChildNodeInList(oldChild, newChild, typeArgsAux);
                this.typeArgs = typeArgsAux;
            }
            if (!updated && this.args != null && (updated = this.replaceChildNodeInList(oldChild, newChild, argsAux = new LinkedList<Expression>(this.args)))) {
                this.args = argsAux;
            }
        }
        return updated;
    }

    @Override
    public MethodCallExpr clone() throws CloneNotSupportedException {
        return new MethodCallExpr(this.clone(this.scope), this.clone(this.typeArgs), this.name, this.clone(this.args));
    }

    @Override
    public Map<String, SymbolDefinition> getVariableDefinitions() {
        Node parent;
        for (parent = this.getParentNode(); parent != null && parent instanceof ScopeAware; parent = parent.getParentNode()) {
        }
        if (parent != null && parent instanceof ScopeAware) {
            return ((ScopeAware)((Object)parent)).getVariableDefinitions();
        }
        return new HashMap<String, SymbolDefinition>();
    }

    @Override
    public Map<String, List<SymbolDefinition>> getMethodDefinitions() {
        Node parent;
        for (parent = this.getParentNode(); parent != null && parent instanceof ScopeAware; parent = parent.getParentNode()) {
        }
        if (parent != null && parent instanceof ScopeAware) {
            return ((ScopeAware)((Object)parent)).getMethodDefinitions();
        }
        return new HashMap<String, List<SymbolDefinition>>();
    }

    @Override
    public Map<String, SymbolDefinition> getTypeDefinitions() {
        Node parent;
        for (parent = this.getParentNode(); parent != null && parent instanceof ScopeAware; parent = parent.getParentNode()) {
        }
        if (parent != null && parent instanceof ScopeAware) {
            return ((ScopeAware)((Object)parent)).getTypeDefinitions();
        }
        return new HashMap<String, SymbolDefinition>();
    }
}

