/*
 * Decompiled with CFR 0.152.
 */
package org.walkmod.javalang.ast.expr;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.walkmod.javalang.ast.MethodSymbolData;
import org.walkmod.javalang.ast.Node;
import org.walkmod.javalang.ast.ScopeAware;
import org.walkmod.javalang.ast.SymbolData;
import org.walkmod.javalang.ast.SymbolDefinition;
import org.walkmod.javalang.ast.SymbolReference;
import org.walkmod.javalang.ast.TypeParameter;
import org.walkmod.javalang.ast.expr.Expression;
import org.walkmod.javalang.visitors.GenericVisitor;
import org.walkmod.javalang.visitors.VoidVisitor;

public class MethodReferenceExpr
extends Expression
implements SymbolReference {
    private Expression scope;
    private List<TypeParameter> typeParameters;
    private String identifier;
    private MethodSymbolData referencedMethodSymbolData;
    private SymbolData[] referencedArgsSymbolData;
    private SymbolDefinition symbolDefinition;

    public MethodReferenceExpr() {
    }

    public MethodReferenceExpr(Expression scope, List<TypeParameter> typeParameters, String identifier) {
        this.setScope(scope);
        this.setTypeParameters(typeParameters);
        this.identifier = identifier;
    }

    public MethodReferenceExpr(int beginLine, int beginColumn, int endLine, int endColumn, Expression scope, List<TypeParameter> typeParameters, String identifier) {
        super(beginLine, beginColumn, endLine, endColumn);
        this.setScope(scope);
        this.setTypeParameters(typeParameters);
        this.identifier = identifier;
    }

    @Override
    public boolean removeChild(Node child) {
        boolean result = false;
        if (child != null) {
            if (this.scope == child) {
                this.scope = null;
                result = true;
            }
            if (!result && this.typeParameters != null && child instanceof TypeParameter) {
                LinkedList<TypeParameter> typeParametersAux = new LinkedList<TypeParameter>(this.typeParameters);
                result = typeParametersAux.remove(child);
                this.typeParameters = typeParametersAux;
            }
        }
        if (result) {
            this.updateReferences(child);
        }
        return result;
    }

    @Override
    public List<Node> getChildren() {
        LinkedList<Node> children = new LinkedList<Node>();
        if (this.scope != null) {
            children.add(this.scope);
        }
        if (this.typeParameters != null) {
            children.addAll(this.typeParameters);
        }
        return children;
    }

    @Override
    public <R, A> R accept(GenericVisitor<R, A> v, A arg) {
        if (!this.check()) {
            return null;
        }
        return v.visit(this, arg);
    }

    @Override
    public <A> void accept(VoidVisitor<A> v, A arg) {
        if (this.check()) {
            v.visit(this, arg);
        }
    }

    public Expression getScope() {
        return this.scope;
    }

    public void setScope(Expression scope) {
        if (this.scope != null) {
            this.updateReferences(this.scope);
        }
        this.scope = scope;
        this.setAsParentNodeOf(scope);
    }

    public List<TypeParameter> getTypeParameters() {
        return this.typeParameters;
    }

    public void setTypeParameters(List<TypeParameter> typeParameters) {
        this.typeParameters = typeParameters;
        this.setAsParentNodeOf(typeParameters);
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    @Override
    public SymbolData getSymbolData() {
        return super.getSymbolData();
    }

    public MethodSymbolData getReferencedMethodSymbolData() {
        return this.referencedMethodSymbolData;
    }

    public void setReferencedMethodSymbolData(MethodSymbolData referencedMethodSymbolData) {
        this.referencedMethodSymbolData = referencedMethodSymbolData;
    }

    public SymbolData[] getReferencedArgsSymbolData() {
        return this.referencedArgsSymbolData;
    }

    public void setReferencedArgsSymbolData(SymbolData[] referencedArgsSymbolData) {
        this.referencedArgsSymbolData = referencedArgsSymbolData;
    }

    @Override
    public SymbolDefinition getSymbolDefinition() {
        return this.symbolDefinition;
    }

    @Override
    public void setSymbolDefinition(SymbolDefinition symbolDefinition) {
        this.symbolDefinition = symbolDefinition;
    }

    @Override
    public boolean replaceChildNode(Node oldChild, Node newChild) {
        LinkedList<TypeParameter> auxTypeParameters;
        boolean updated = false;
        if (oldChild == this.scope) {
            this.setScope((Expression)newChild);
            updated = true;
        }
        if (!updated && (updated = this.replaceChildNodeInList(oldChild, newChild, auxTypeParameters = new LinkedList<TypeParameter>(this.typeParameters)))) {
            this.typeParameters = auxTypeParameters;
        }
        return updated;
    }

    @Override
    public MethodReferenceExpr clone() throws CloneNotSupportedException {
        return new MethodReferenceExpr(this.clone(this.scope), this.clone(this.typeParameters), this.identifier);
    }

    @Override
    public Map<String, SymbolDefinition> getVariableDefinitions() {
        Node parent;
        for (parent = this.getParentNode(); parent != null && parent instanceof ScopeAware; parent = parent.getParentNode()) {
        }
        if (parent != null && parent instanceof ScopeAware) {
            return ((ScopeAware)((Object)parent)).getVariableDefinitions();
        }
        return new HashMap<String, SymbolDefinition>();
    }

    @Override
    public Map<String, List<SymbolDefinition>> getMethodDefinitions() {
        Node parent;
        for (parent = this.getParentNode(); parent != null && parent instanceof ScopeAware; parent = parent.getParentNode()) {
        }
        if (parent != null && parent instanceof ScopeAware) {
            return ((ScopeAware)((Object)parent)).getMethodDefinitions();
        }
        return new HashMap<String, List<SymbolDefinition>>();
    }

    @Override
    public Map<String, SymbolDefinition> getTypeDefinitions() {
        Node parent;
        for (parent = this.getParentNode(); parent != null && parent instanceof ScopeAware; parent = parent.getParentNode()) {
        }
        if (parent != null && parent instanceof ScopeAware) {
            return ((ScopeAware)((Object)parent)).getTypeDefinitions();
        }
        return new HashMap<String, SymbolDefinition>();
    }
}

