/*
 * Decompiled with CFR 0.152.
 */
package org.walkmod.javalang.ast.expr;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.walkmod.javalang.ast.Node;
import org.walkmod.javalang.ast.ScopeAware;
import org.walkmod.javalang.ast.SymbolDefinition;
import org.walkmod.javalang.ast.expr.AnnotationExpr;
import org.walkmod.javalang.ast.expr.MemberValuePair;
import org.walkmod.javalang.ast.expr.NameExpr;
import org.walkmod.javalang.visitors.GenericVisitor;
import org.walkmod.javalang.visitors.VoidVisitor;
import org.walkmod.merger.MergeEngine;

public final class NormalAnnotationExpr
extends AnnotationExpr {
    private List<MemberValuePair> pairs;

    public NormalAnnotationExpr() {
    }

    public NormalAnnotationExpr(NameExpr name, List<MemberValuePair> pairs) {
        this.setName(name);
        this.setPairs(pairs);
    }

    public NormalAnnotationExpr(int beginLine, int beginColumn, int endLine, int endColumn, NameExpr name, List<MemberValuePair> pairs) {
        super(beginLine, beginColumn, endLine, endColumn);
        this.setName(name);
        this.setPairs(pairs);
    }

    @Override
    public boolean removeChild(Node child) {
        boolean result = false;
        if (child != null && !(result = super.removeChild(child)) && this.pairs != null) {
            LinkedList<MemberValuePair> pairsAux = new LinkedList<MemberValuePair>(this.pairs);
            result = pairsAux.remove(child);
            this.pairs = pairsAux;
        }
        if (result) {
            this.updateReferences(child);
        }
        return result;
    }

    @Override
    public List<Node> getChildren() {
        List<Node> children = super.getChildren();
        if (this.pairs != null) {
            children.addAll(this.pairs);
        }
        return children;
    }

    @Override
    public <R, A> R accept(GenericVisitor<R, A> v, A arg) {
        if (!this.check()) {
            return null;
        }
        return v.visit(this, arg);
    }

    @Override
    public <A> void accept(VoidVisitor<A> v, A arg) {
        if (this.check()) {
            v.visit(this, arg);
        }
    }

    public List<MemberValuePair> getPairs() {
        return this.pairs;
    }

    public void setPairs(List<MemberValuePair> pairs) {
        this.pairs = pairs;
        this.setAsParentNodeOf(pairs);
    }

    public void merge(AnnotationExpr t1, MergeEngine configuration) {
        LinkedList<MemberValuePair> pairsList = new LinkedList<MemberValuePair>();
        configuration.apply(this.getPairs(), ((NormalAnnotationExpr)t1).getPairs(), pairsList, MemberValuePair.class);
        if (!pairsList.isEmpty()) {
            this.setPairs(pairsList);
        } else {
            this.setPairs(null);
        }
    }

    @Override
    public boolean replaceChildNode(Node oldChild, Node newChild) {
        LinkedList<MemberValuePair> auxPairs;
        boolean updated = false;
        if (this.pairs != null && (updated = this.replaceChildNodeInList(oldChild, newChild, auxPairs = new LinkedList<MemberValuePair>(this.pairs)))) {
            this.pairs = auxPairs;
        }
        return updated;
    }

    @Override
    public NormalAnnotationExpr clone() throws CloneNotSupportedException {
        return new NormalAnnotationExpr(this.clone(this.name), this.clone(this.pairs));
    }

    @Override
    public Map<String, SymbolDefinition> getVariableDefinitions() {
        Node parent;
        for (parent = this.getParentNode(); parent != null && parent instanceof ScopeAware; parent = parent.getParentNode()) {
        }
        if (parent != null && parent instanceof ScopeAware) {
            return ((ScopeAware)((Object)parent)).getVariableDefinitions();
        }
        return new HashMap<String, SymbolDefinition>();
    }

    @Override
    public Map<String, List<SymbolDefinition>> getMethodDefinitions() {
        Node parent;
        for (parent = this.getParentNode(); parent != null && parent instanceof ScopeAware; parent = parent.getParentNode()) {
        }
        if (parent != null && parent instanceof ScopeAware) {
            return ((ScopeAware)((Object)parent)).getMethodDefinitions();
        }
        return new HashMap<String, List<SymbolDefinition>>();
    }

    @Override
    public Map<String, SymbolDefinition> getTypeDefinitions() {
        Node parent;
        for (parent = this.getParentNode(); parent != null && parent instanceof ScopeAware; parent = parent.getParentNode()) {
        }
        if (parent != null && parent instanceof ScopeAware) {
            return ((ScopeAware)((Object)parent)).getTypeDefinitions();
        }
        return new HashMap<String, SymbolDefinition>();
    }
}

