/*
 * Decompiled with CFR 0.152.
 */
package org.walkmod.javalang.ast.expr;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.walkmod.javalang.ast.Node;
import org.walkmod.javalang.ast.ScopeAware;
import org.walkmod.javalang.ast.SymbolDefinition;
import org.walkmod.javalang.ast.expr.AnnotationExpr;
import org.walkmod.javalang.ast.expr.Expression;
import org.walkmod.javalang.ast.expr.NameExpr;
import org.walkmod.javalang.visitors.GenericVisitor;
import org.walkmod.javalang.visitors.VoidVisitor;
import org.walkmod.merger.MergeEngine;

public final class SingleMemberAnnotationExpr
extends AnnotationExpr {
    private Expression memberValue;

    public SingleMemberAnnotationExpr() {
    }

    public SingleMemberAnnotationExpr(NameExpr name, Expression memberValue) {
        this.setName(name);
        this.setMemberValue(memberValue);
    }

    public SingleMemberAnnotationExpr(int beginLine, int beginColumn, int endLine, int endColumn, NameExpr name, Expression memberValue) {
        super(beginLine, beginColumn, endLine, endColumn);
        this.setName(name);
        this.setMemberValue(memberValue);
    }

    @Override
    public List<Node> getChildren() {
        List<Node> children = super.getChildren();
        if (this.memberValue != null) {
            children.add(this.memberValue);
        }
        return children;
    }

    @Override
    public <R, A> R accept(GenericVisitor<R, A> v, A arg) {
        if (!this.check()) {
            return null;
        }
        return v.visit(this, arg);
    }

    @Override
    public <A> void accept(VoidVisitor<A> v, A arg) {
        if (this.check()) {
            v.visit(this, arg);
        }
    }

    public Expression getMemberValue() {
        return this.memberValue;
    }

    public void setMemberValue(Expression memberValue) {
        this.memberValue = memberValue;
        this.setAsParentNodeOf(memberValue);
    }

    public void merge(AnnotationExpr t1, MergeEngine configuration) {
    }

    @Override
    public SingleMemberAnnotationExpr clone() throws CloneNotSupportedException {
        return new SingleMemberAnnotationExpr(this.clone(this.name), this.clone(this.memberValue));
    }

    @Override
    public Map<String, SymbolDefinition> getVariableDefinitions() {
        Node parent;
        for (parent = this.getParentNode(); parent != null && parent instanceof ScopeAware; parent = parent.getParentNode()) {
        }
        if (parent != null && parent instanceof ScopeAware) {
            return ((ScopeAware)((Object)parent)).getVariableDefinitions();
        }
        return new HashMap<String, SymbolDefinition>();
    }

    @Override
    public Map<String, List<SymbolDefinition>> getMethodDefinitions() {
        Node parent;
        for (parent = this.getParentNode(); parent != null && parent instanceof ScopeAware; parent = parent.getParentNode()) {
        }
        if (parent != null && parent instanceof ScopeAware) {
            return ((ScopeAware)((Object)parent)).getMethodDefinitions();
        }
        return new HashMap<String, List<SymbolDefinition>>();
    }

    @Override
    public Map<String, SymbolDefinition> getTypeDefinitions() {
        Node parent;
        for (parent = this.getParentNode(); parent != null && parent instanceof ScopeAware; parent = parent.getParentNode()) {
        }
        if (parent != null && parent instanceof ScopeAware) {
            return ((ScopeAware)((Object)parent)).getTypeDefinitions();
        }
        return new HashMap<String, SymbolDefinition>();
    }
}

