/*
 * Decompiled with CFR 0.152.
 */
package org.walkmod.javalang.ast.expr;

import java.util.LinkedList;
import java.util.List;
import org.walkmod.javalang.ast.Node;
import org.walkmod.javalang.ast.expr.Expression;
import org.walkmod.javalang.visitors.GenericVisitor;
import org.walkmod.javalang.visitors.VoidVisitor;

public final class UnaryExpr
extends Expression {
    private Expression expr;
    private Operator op;

    public UnaryExpr() {
    }

    public UnaryExpr(Expression expr, Operator op) {
        this.setExpr(expr);
        this.op = op;
    }

    public UnaryExpr(int beginLine, int beginColumn, int endLine, int endColumn, Expression expr, Operator op) {
        super(beginLine, beginColumn, endLine, endColumn);
        this.setExpr(expr);
        this.op = op;
    }

    @Override
    public boolean removeChild(Node child) {
        boolean result = false;
        if (child != null && this.expr == child) {
            this.expr = null;
            result = true;
        }
        if (result) {
            this.updateReferences(child);
        }
        return result;
    }

    @Override
    public List<Node> getChildren() {
        LinkedList<Node> children = new LinkedList<Node>();
        if (this.expr != null) {
            children.add(this.expr);
        }
        return children;
    }

    @Override
    public <R, A> R accept(GenericVisitor<R, A> v, A arg) {
        if (!this.check()) {
            return null;
        }
        return v.visit(this, arg);
    }

    @Override
    public <A> void accept(VoidVisitor<A> v, A arg) {
        if (this.check()) {
            v.visit(this, arg);
        }
    }

    public Expression getExpr() {
        return this.expr;
    }

    public Operator getOperator() {
        return this.op;
    }

    public void setExpr(Expression expr) {
        if (this.expr != null) {
            this.updateReferences(this.expr);
        }
        this.expr = expr;
        this.setAsParentNodeOf(expr);
    }

    public void setOperator(Operator op) {
        this.op = op;
    }

    @Override
    public boolean replaceChildNode(Node oldChild, Node newChild) {
        boolean updated = false;
        if (oldChild == this.expr) {
            this.setExpr((Expression)newChild);
            updated = true;
        }
        return updated;
    }

    @Override
    public UnaryExpr clone() throws CloneNotSupportedException {
        return new UnaryExpr(this.clone(this.expr), this.op);
    }

    public static enum Operator {
        positive,
        negative,
        preIncrement,
        preDecrement,
        not,
        inverse,
        posIncrement,
        posDecrement;

    }
}

