/*
 * Decompiled with CFR 0.152.
 */
package org.walkmod.javalang.ast.stmt;

import java.util.LinkedList;
import java.util.List;
import org.walkmod.javalang.ast.Node;
import org.walkmod.javalang.ast.body.MultiTypeParameter;
import org.walkmod.javalang.ast.body.VariableDeclaratorId;
import org.walkmod.javalang.ast.expr.AnnotationExpr;
import org.walkmod.javalang.ast.stmt.BlockStmt;
import org.walkmod.javalang.ast.type.Type;
import org.walkmod.javalang.visitors.GenericVisitor;
import org.walkmod.javalang.visitors.VoidVisitor;

public final class CatchClause
extends Node {
    private MultiTypeParameter except;
    private BlockStmt catchBlock;

    public CatchClause() {
    }

    public CatchClause(MultiTypeParameter except, BlockStmt catchBlock) {
        this.setExcept(except);
        this.setCatchBlock(catchBlock);
    }

    public CatchClause(int exceptModifier, List<AnnotationExpr> exceptAnnotations, List<Type> exceptTypes, VariableDeclaratorId exceptId, BlockStmt catchBlock) {
        this(new MultiTypeParameter(exceptModifier, exceptAnnotations, exceptTypes, exceptId), catchBlock);
    }

    public CatchClause(int beginLine, int beginColumn, int endLine, int endColumn, int exceptModifier, List<AnnotationExpr> exceptAnnotations, List<Type> exceptTypes, VariableDeclaratorId exceptId, BlockStmt catchBlock) {
        super(beginLine, beginColumn, endLine, endColumn);
        this.setExcept(new MultiTypeParameter(beginLine, beginColumn, endLine, endColumn, exceptModifier, exceptAnnotations, exceptTypes, exceptId));
        this.setCatchBlock(catchBlock);
    }

    @Override
    public boolean removeChild(Node child) {
        boolean result = false;
        if (child != null) {
            if (this.except == child) {
                this.except = null;
                result = true;
            }
            if (!result && this.catchBlock == child) {
                this.catchBlock = null;
                result = true;
            }
        }
        if (result) {
            this.updateReferences(child);
        }
        return result;
    }

    @Override
    public List<Node> getChildren() {
        LinkedList<Node> children = new LinkedList<Node>();
        if (this.except != null) {
            children.add(this.except);
        }
        if (this.catchBlock != null) {
            children.add(this.catchBlock);
        }
        return children;
    }

    @Override
    public <R, A> R accept(GenericVisitor<R, A> v, A arg) {
        if (!this.check()) {
            return null;
        }
        return v.visit(this, arg);
    }

    @Override
    public <A> void accept(VoidVisitor<A> v, A arg) {
        if (this.check()) {
            v.visit(this, arg);
        }
    }

    public BlockStmt getCatchBlock() {
        return this.catchBlock;
    }

    public MultiTypeParameter getExcept() {
        return this.except;
    }

    public void setCatchBlock(BlockStmt catchBlock) {
        if (this.catchBlock != null) {
            this.updateReferences(this.catchBlock);
        }
        this.catchBlock = catchBlock;
        this.setAsParentNodeOf(catchBlock);
    }

    public void setExcept(MultiTypeParameter except) {
        if (this.except != null) {
            this.updateReferences(this.except);
        }
        this.except = except;
        this.setAsParentNodeOf(except);
    }

    @Override
    public boolean replaceChildNode(Node oldChild, Node newChild) {
        boolean updated = false;
        if (oldChild == this.except) {
            this.setExcept((MultiTypeParameter)newChild);
            updated = true;
        }
        if (!updated && oldChild == this.catchBlock) {
            this.setCatchBlock((BlockStmt)newChild);
            updated = true;
        }
        return updated;
    }

    @Override
    public CatchClause clone() throws CloneNotSupportedException {
        return new CatchClause(this.clone(this.except), this.clone(this.catchBlock));
    }
}

