/*
 * Decompiled with CFR 0.152.
 */
package org.walkmod.javalang.ast.stmt;

import java.util.LinkedList;
import java.util.List;
import org.walkmod.javalang.ast.Node;
import org.walkmod.javalang.ast.expr.Expression;
import org.walkmod.javalang.ast.stmt.Statement;
import org.walkmod.javalang.ast.type.Type;
import org.walkmod.javalang.visitors.GenericVisitor;
import org.walkmod.javalang.visitors.VoidVisitor;

public final class ExplicitConstructorInvocationStmt
extends Statement {
    private List<Type> typeArgs;
    private boolean isThis;
    private Expression expr;
    private List<Expression> args;

    public ExplicitConstructorInvocationStmt() {
    }

    public ExplicitConstructorInvocationStmt(boolean isThis, Expression expr, List<Expression> args) {
        this.isThis = isThis;
        this.setExpr(expr);
        this.setArgs(args);
    }

    public ExplicitConstructorInvocationStmt(int beginLine, int beginColumn, int endLine, int endColumn, List<Type> typeArgs, boolean isThis, Expression expr, List<Expression> args) {
        super(beginLine, beginColumn, endLine, endColumn);
        this.setTypeArgs(typeArgs);
        this.isThis = isThis;
        this.setExpr(expr);
        this.setArgs(args);
    }

    @Override
    public boolean removeChild(Node child) {
        boolean result = false;
        if (child != null) {
            if (this.expr == child) {
                this.expr = null;
                result = true;
            }
            if (!result && this.typeArgs != null && child instanceof Type) {
                LinkedList<Type> typeArgsAux = new LinkedList<Type>(this.typeArgs);
                result = typeArgsAux.remove(child);
                this.typeArgs = typeArgsAux;
            }
        }
        if (result) {
            this.updateReferences(child);
        }
        return result;
    }

    @Override
    public List<Node> getChildren() {
        List<Node> children = super.getChildren();
        if (this.typeArgs != null) {
            children.addAll(this.typeArgs);
        }
        if (this.expr != null) {
            children.add(this.expr);
        }
        if (this.args != null) {
            children.addAll(this.args);
        }
        return children;
    }

    @Override
    public <R, A> R accept(GenericVisitor<R, A> v, A arg) {
        if (!this.check()) {
            return null;
        }
        return v.visit(this, arg);
    }

    @Override
    public <A> void accept(VoidVisitor<A> v, A arg) {
        if (this.check()) {
            v.visit(this, arg);
        }
    }

    public List<Expression> getArgs() {
        return this.args;
    }

    public Expression getExpr() {
        return this.expr;
    }

    public List<Type> getTypeArgs() {
        return this.typeArgs;
    }

    public boolean isThis() {
        return this.isThis;
    }

    public void setArgs(List<Expression> args) {
        this.args = args;
        this.setAsParentNodeOf(args);
    }

    public void setExpr(Expression expr) {
        if (this.expr != null) {
            this.updateReferences(this.expr);
        }
        this.expr = expr;
        this.setAsParentNodeOf(expr);
    }

    public void setThis(boolean isThis) {
        this.isThis = isThis;
    }

    public void setTypeArgs(List<Type> typeArgs) {
        this.typeArgs = typeArgs;
        this.setAsParentNodeOf(typeArgs);
    }

    @Override
    public boolean replaceChildNode(Node oldChild, Node newChild) {
        LinkedList<Type> auxTypeArgs;
        LinkedList<Expression> auxArgs;
        boolean updated = false;
        if (oldChild == this.expr) {
            this.setExpr((Expression)newChild);
            updated = true;
        }
        if (!updated && this.args != null && (updated = this.replaceChildNodeInList(oldChild, newChild, auxArgs = new LinkedList<Expression>(this.args)))) {
            this.args = auxArgs;
        }
        if (!updated && this.typeArgs != null && (updated = this.replaceChildNodeInList(oldChild, newChild, auxTypeArgs = new LinkedList<Type>(this.typeArgs)))) {
            this.typeArgs = auxTypeArgs;
        }
        return updated;
    }

    @Override
    public ExplicitConstructorInvocationStmt clone() throws CloneNotSupportedException {
        return new ExplicitConstructorInvocationStmt(this.isThis, this.clone(this.expr), this.clone(this.args));
    }
}

