/*
 * Decompiled with CFR 0.152.
 */
package org.walkmod.javalang.ast.stmt;

import java.util.LinkedList;
import java.util.List;
import org.walkmod.javalang.ast.Node;
import org.walkmod.javalang.ast.expr.Expression;
import org.walkmod.javalang.ast.stmt.Statement;
import org.walkmod.javalang.visitors.GenericVisitor;
import org.walkmod.javalang.visitors.VoidVisitor;

public final class ForStmt
extends Statement {
    private List<Expression> init;
    private Expression compare;
    private List<Expression> update;
    private Statement body;

    public ForStmt() {
    }

    public ForStmt(List<Expression> init, Expression compare, List<Expression> update, Statement body) {
        this.setCompare(compare);
        this.setInit(init);
        this.setUpdate(update);
        this.setBody(body);
    }

    public ForStmt(int beginLine, int beginColumn, int endLine, int endColumn, List<Expression> init, Expression compare, List<Expression> update, Statement body) {
        super(beginLine, beginColumn, endLine, endColumn);
        this.setCompare(compare);
        this.setInit(init);
        this.setUpdate(update);
        this.setBody(body);
    }

    @Override
    public boolean removeChild(Node child) {
        boolean result = false;
        if (child != null) {
            if (this.compare == child) {
                this.compare = null;
                result = true;
            }
            if (!result && this.init != null && child instanceof Expression) {
                LinkedList<Expression> initAux = new LinkedList<Expression>(this.init);
                result = initAux.remove(child);
                this.init = initAux;
            }
            if (!result && this.update != null && child instanceof Expression) {
                LinkedList<Expression> updateAux = new LinkedList<Expression>(this.update);
                result = updateAux.remove(child);
                this.update = updateAux;
            }
            if (!result && this.body == child) {
                this.body = null;
                result = true;
            }
        }
        if (result) {
            this.updateReferences(child);
        }
        return result;
    }

    @Override
    public List<Node> getChildren() {
        List<Node> children = super.getChildren();
        if (this.init != null) {
            children.addAll(this.init);
        }
        if (this.compare != null) {
            children.add(this.compare);
        }
        if (this.update != null) {
            children.addAll(this.update);
        }
        if (this.body != null) {
            children.add(this.body);
        }
        return children;
    }

    @Override
    public <R, A> R accept(GenericVisitor<R, A> v, A arg) {
        if (!this.check()) {
            return null;
        }
        return v.visit(this, arg);
    }

    @Override
    public <A> void accept(VoidVisitor<A> v, A arg) {
        if (this.check()) {
            v.visit(this, arg);
        }
    }

    public Statement getBody() {
        return this.body;
    }

    public Expression getCompare() {
        return this.compare;
    }

    public List<Expression> getInit() {
        return this.init;
    }

    public List<Expression> getUpdate() {
        return this.update;
    }

    public void setBody(Statement body) {
        if (this.body != null) {
            this.updateReferences(this.body);
        }
        this.body = body;
        this.setAsParentNodeOf(body);
    }

    public void setCompare(Expression compare) {
        if (this.compare != null) {
            this.updateReferences(this.compare);
        }
        this.compare = compare;
        this.setAsParentNodeOf(compare);
    }

    public void setInit(List<Expression> init) {
        this.init = init;
        this.setAsParentNodeOf(init);
    }

    public void setUpdate(List<Expression> update) {
        this.update = update;
        this.setAsParentNodeOf(update);
    }

    @Override
    public boolean replaceChildNode(Node oldChild, Node newChild) {
        LinkedList<Expression> auxUpdate;
        LinkedList<Expression> auxInit;
        boolean updated = false;
        if (oldChild == this.compare) {
            this.setCompare((Expression)newChild);
            updated = true;
        }
        if (!updated && oldChild == this.body) {
            this.setBody((Statement)newChild);
            updated = true;
        }
        if (!updated && this.init != null && (updated = this.replaceChildNodeInList(oldChild, newChild, auxInit = new LinkedList<Expression>(this.init)))) {
            this.init = auxInit;
        }
        if (!updated && this.update != null && (updated = this.replaceChildNodeInList(oldChild, newChild, auxUpdate = new LinkedList<Expression>(this.update)))) {
            this.update = auxUpdate;
        }
        return updated;
    }

    @Override
    public ForStmt clone() throws CloneNotSupportedException {
        return new ForStmt(this.clone(this.init), this.clone(this.compare), this.clone(this.update), this.clone(this.body));
    }
}

