/*
 * Decompiled with CFR 0.152.
 */
package org.walkmod.javalang.ast.stmt;

import java.util.List;
import org.walkmod.javalang.ast.Node;
import org.walkmod.javalang.ast.expr.Expression;
import org.walkmod.javalang.ast.expr.VariableDeclarationExpr;
import org.walkmod.javalang.ast.stmt.Statement;
import org.walkmod.javalang.visitors.GenericVisitor;
import org.walkmod.javalang.visitors.VoidVisitor;

public final class ForeachStmt
extends Statement {
    private VariableDeclarationExpr var;
    private Expression iterable;
    private Statement body;

    public ForeachStmt() {
    }

    public ForeachStmt(VariableDeclarationExpr var, Expression iterable, Statement body) {
        this.setVariable(var);
        this.setIterable(iterable);
        this.setBody(body);
    }

    public ForeachStmt(int beginLine, int beginColumn, int endLine, int endColumn, VariableDeclarationExpr var, Expression iterable, Statement body) {
        super(beginLine, beginColumn, endLine, endColumn);
        this.setVariable(var);
        this.setIterable(iterable);
        this.setBody(body);
    }

    @Override
    public boolean removeChild(Node child) {
        boolean result = false;
        if (child != null) {
            if (this.var == child) {
                this.var = null;
                result = true;
            }
            if (!result && this.iterable == child) {
                this.iterable = null;
                result = true;
            }
            if (!result && this.body == child) {
                this.body = null;
                result = true;
            }
        }
        if (result) {
            this.updateReferences(child);
        }
        return result;
    }

    @Override
    public List<Node> getChildren() {
        List<Node> children = super.getChildren();
        if (this.var != null) {
            children.add(this.var);
        }
        if (this.iterable != null) {
            children.add(this.iterable);
        }
        if (this.body != null) {
            children.add(this.body);
        }
        return children;
    }

    @Override
    public <R, A> R accept(GenericVisitor<R, A> v, A arg) {
        if (!this.check()) {
            return null;
        }
        return v.visit(this, arg);
    }

    @Override
    public <A> void accept(VoidVisitor<A> v, A arg) {
        if (this.check()) {
            v.visit(this, arg);
        }
    }

    public Statement getBody() {
        return this.body;
    }

    public Expression getIterable() {
        return this.iterable;
    }

    public VariableDeclarationExpr getVariable() {
        return this.var;
    }

    public void setBody(Statement body) {
        if (this.body != null) {
            this.updateReferences(this.body);
        }
        this.body = body;
        this.setAsParentNodeOf(body);
    }

    public void setIterable(Expression iterable) {
        if (this.iterable != null) {
            this.updateReferences(this.iterable);
        }
        this.iterable = iterable;
        this.setAsParentNodeOf(iterable);
    }

    public void setVariable(VariableDeclarationExpr var) {
        this.var = var;
        this.setAsParentNodeOf(var);
    }

    @Override
    public boolean replaceChildNode(Node oldChild, Node newChild) {
        boolean updated = false;
        if (oldChild == this.iterable) {
            this.setIterable((Expression)newChild);
            updated = true;
        }
        if (!updated) {
            if (oldChild == this.var) {
                this.setVariable((VariableDeclarationExpr)newChild);
                updated = true;
            }
            if (!updated && oldChild == this.body) {
                this.setBody((Statement)newChild);
                updated = true;
            }
        }
        return updated;
    }

    @Override
    public ForeachStmt clone() throws CloneNotSupportedException {
        return new ForeachStmt(this.clone(this.var), this.clone(this.iterable), this.clone(this.body));
    }
}

