/*
 * Decompiled with CFR 0.152.
 */
package org.walkmod.javalang.ast.stmt;

import java.util.List;
import org.walkmod.javalang.ast.Node;
import org.walkmod.javalang.ast.expr.Expression;
import org.walkmod.javalang.ast.stmt.Statement;
import org.walkmod.javalang.visitors.GenericVisitor;
import org.walkmod.javalang.visitors.VoidVisitor;

public final class ReturnStmt
extends Statement {
    private Expression expr;

    public ReturnStmt() {
    }

    public ReturnStmt(Expression expr) {
        this.setExpr(expr);
    }

    public ReturnStmt(int beginLine, int beginColumn, int endLine, int endColumn, Expression expr) {
        super(beginLine, beginColumn, endLine, endColumn);
        this.setExpr(expr);
    }

    @Override
    public boolean removeChild(Node child) {
        boolean result = false;
        if (child != null && this.expr == child) {
            this.expr = null;
            result = true;
        }
        if (result) {
            this.updateReferences(child);
        }
        return result;
    }

    @Override
    public List<Node> getChildren() {
        List<Node> children = super.getChildren();
        if (this.expr != null) {
            children.add(this.expr);
        }
        return children;
    }

    @Override
    public <R, A> R accept(GenericVisitor<R, A> v, A arg) {
        if (!this.check()) {
            return null;
        }
        return v.visit(this, arg);
    }

    @Override
    public <A> void accept(VoidVisitor<A> v, A arg) {
        if (this.check()) {
            v.visit(this, arg);
        }
    }

    public Expression getExpr() {
        return this.expr;
    }

    public void setExpr(Expression expr) {
        if (this.expr != null) {
            this.updateReferences(this.expr);
        }
        this.expr = expr;
        this.setAsParentNodeOf(expr);
    }

    @Override
    public boolean replaceChildNode(Node oldChild, Node newChild) {
        boolean updated = false;
        if (oldChild == this.expr) {
            this.setExpr((Expression)newChild);
            updated = true;
        }
        return updated;
    }

    @Override
    public ReturnStmt clone() throws CloneNotSupportedException {
        return new ReturnStmt(this.clone(this.expr));
    }
}

