/*
 * Decompiled with CFR 0.152.
 */
package org.walkmod.javalang.ast.stmt;

import java.util.List;
import org.walkmod.javalang.ast.Node;
import org.walkmod.javalang.ast.expr.Expression;
import org.walkmod.javalang.ast.stmt.BlockStmt;
import org.walkmod.javalang.ast.stmt.Statement;
import org.walkmod.javalang.visitors.GenericVisitor;
import org.walkmod.javalang.visitors.VoidVisitor;

public final class SynchronizedStmt
extends Statement {
    private Expression expr;
    private BlockStmt block;

    public SynchronizedStmt() {
    }

    public SynchronizedStmt(Expression expr, BlockStmt block) {
        this.setExpr(expr);
        this.setBlock(block);
    }

    public SynchronizedStmt(int beginLine, int beginColumn, int endLine, int endColumn, Expression expr, BlockStmt block) {
        super(beginLine, beginColumn, endLine, endColumn);
        this.setExpr(expr);
        this.setBlock(block);
    }

    @Override
    public boolean removeChild(Node child) {
        boolean result = false;
        if (child != null) {
            if (this.expr == child) {
                this.expr = null;
                result = true;
            }
            if (!result && this.block == child) {
                this.block = null;
                result = true;
            }
        }
        if (result) {
            this.updateReferences(child);
        }
        return result;
    }

    @Override
    public List<Node> getChildren() {
        List<Node> children = super.getChildren();
        if (this.expr != null) {
            children.add(this.expr);
        }
        if (this.block != null) {
            children.add(this.block);
        }
        return children;
    }

    @Override
    public <R, A> R accept(GenericVisitor<R, A> v, A arg) {
        if (!this.check()) {
            return null;
        }
        return v.visit(this, arg);
    }

    @Override
    public <A> void accept(VoidVisitor<A> v, A arg) {
        if (this.check()) {
            v.visit(this, arg);
        }
    }

    public BlockStmt getBlock() {
        return this.block;
    }

    public Expression getExpr() {
        return this.expr;
    }

    public void setBlock(BlockStmt block) {
        if (this.block != null) {
            this.updateReferences(this.block);
        }
        this.block = block;
        this.setAsParentNodeOf(block);
    }

    public void setExpr(Expression expr) {
        if (this.expr != null) {
            this.updateReferences(this.expr);
        }
        this.expr = expr;
        this.setAsParentNodeOf(expr);
    }

    @Override
    public boolean replaceChildNode(Node oldChild, Node newChild) {
        boolean updated = false;
        if (oldChild == this.expr) {
            this.setExpr((Expression)newChild);
            updated = true;
        }
        if (!updated && oldChild == this.block) {
            this.setBlock((BlockStmt)newChild);
            updated = true;
        }
        return updated;
    }

    @Override
    public SynchronizedStmt clone() throws CloneNotSupportedException {
        return new SynchronizedStmt(this.clone(this.expr), this.clone(this.block));
    }
}

