/*
 * Decompiled with CFR 0.152.
 */
package org.walkmod.javalang.ast.stmt;

import java.util.LinkedList;
import java.util.List;
import org.walkmod.javalang.ast.Node;
import org.walkmod.javalang.ast.expr.VariableDeclarationExpr;
import org.walkmod.javalang.ast.stmt.BlockStmt;
import org.walkmod.javalang.ast.stmt.CatchClause;
import org.walkmod.javalang.ast.stmt.Statement;
import org.walkmod.javalang.visitors.GenericVisitor;
import org.walkmod.javalang.visitors.VoidVisitor;

public final class TryStmt
extends Statement {
    private List<VariableDeclarationExpr> resources;
    private BlockStmt tryBlock;
    private List<CatchClause> catchs;
    private BlockStmt finallyBlock;

    public TryStmt() {
    }

    public TryStmt(BlockStmt tryBlock, List<CatchClause> catchs, BlockStmt finallyBlock) {
        this.setTryBlock(tryBlock);
        this.setCatchs(catchs);
        this.setFinallyBlock(finallyBlock);
    }

    public TryStmt(int beginLine, int beginColumn, int endLine, int endColumn, List<VariableDeclarationExpr> resources, BlockStmt tryBlock, List<CatchClause> catchs, BlockStmt finallyBlock) {
        super(beginLine, beginColumn, endLine, endColumn);
        this.setResources(resources);
        this.setTryBlock(tryBlock);
        this.setCatchs(catchs);
        this.setFinallyBlock(finallyBlock);
    }

    @Override
    public boolean removeChild(Node child) {
        boolean result = false;
        if (child != null) {
            if (this.tryBlock == child) {
                this.tryBlock = null;
                result = true;
            }
            if (!result && this.finallyBlock == child) {
                this.finallyBlock = null;
                result = true;
            }
            if (!result && this.resources != null && child instanceof VariableDeclarationExpr) {
                LinkedList<VariableDeclarationExpr> resourcesAux = new LinkedList<VariableDeclarationExpr>(this.resources);
                result = resourcesAux.remove(child);
                this.resources = resourcesAux;
            }
            if (!result && this.catchs != null && child instanceof CatchClause) {
                LinkedList<CatchClause> catchsAux = new LinkedList<CatchClause>(this.catchs);
                result = catchsAux.remove(child);
                this.catchs = catchsAux;
            }
        }
        if (result) {
            this.updateReferences(child);
        }
        return result;
    }

    @Override
    public List<Node> getChildren() {
        List<Node> children = super.getChildren();
        if (this.resources != null) {
            children.addAll(this.resources);
        }
        if (this.tryBlock != null) {
            children.add(this.tryBlock);
        }
        if (this.catchs != null) {
            children.addAll(this.catchs);
        }
        if (this.finallyBlock != null) {
            children.add(this.finallyBlock);
        }
        return children;
    }

    @Override
    public <R, A> R accept(GenericVisitor<R, A> v, A arg) {
        if (!this.check()) {
            return null;
        }
        return v.visit(this, arg);
    }

    @Override
    public <A> void accept(VoidVisitor<A> v, A arg) {
        if (this.check()) {
            v.visit(this, arg);
        }
    }

    public List<CatchClause> getCatchs() {
        return this.catchs;
    }

    public BlockStmt getFinallyBlock() {
        return this.finallyBlock;
    }

    public BlockStmt getTryBlock() {
        return this.tryBlock;
    }

    public List<VariableDeclarationExpr> getResources() {
        return this.resources;
    }

    public void setCatchs(List<CatchClause> catchs) {
        this.catchs = catchs;
        this.setAsParentNodeOf(catchs);
    }

    public void setFinallyBlock(BlockStmt finallyBlock) {
        if (this.finallyBlock != null) {
            this.updateReferences(this.finallyBlock);
        }
        this.finallyBlock = finallyBlock;
        this.setAsParentNodeOf(finallyBlock);
    }

    public void setTryBlock(BlockStmt tryBlock) {
        if (this.tryBlock != null) {
            this.updateReferences(this.tryBlock);
        }
        this.tryBlock = tryBlock;
        this.setAsParentNodeOf(tryBlock);
    }

    public void setResources(List<VariableDeclarationExpr> resources) {
        this.resources = resources;
        this.setAsParentNodeOf(resources);
    }

    @Override
    public boolean replaceChildNode(Node oldChild, Node newChild) {
        boolean updated = false;
        if (oldChild == this.tryBlock) {
            this.setTryBlock((BlockStmt)newChild);
            updated = true;
        }
        if (!updated) {
            LinkedList<VariableDeclarationExpr> auxResources;
            LinkedList<CatchClause> auxCatchs;
            if (oldChild == this.finallyBlock) {
                this.setFinallyBlock((BlockStmt)newChild);
                updated = true;
            }
            if (!updated && this.catchs != null && (updated = this.replaceChildNodeInList(oldChild, newChild, auxCatchs = new LinkedList<CatchClause>(this.catchs)))) {
                this.catchs = auxCatchs;
            }
            if (!updated && this.resources != null && (updated = this.replaceChildNodeInList(oldChild, newChild, auxResources = new LinkedList<VariableDeclarationExpr>(this.resources)))) {
                this.resources = auxResources;
            }
        }
        return updated;
    }

    @Override
    public TryStmt clone() throws CloneNotSupportedException {
        return new TryStmt(this.clone(this.tryBlock), this.clone(this.catchs), this.clone(this.finallyBlock));
    }
}

