/*
 * Decompiled with CFR 0.152.
 */
package org.walkmod.javalang.ast.stmt;

import java.util.List;
import org.walkmod.javalang.ast.Node;
import org.walkmod.javalang.ast.expr.Expression;
import org.walkmod.javalang.ast.stmt.Statement;
import org.walkmod.javalang.visitors.GenericVisitor;
import org.walkmod.javalang.visitors.VoidVisitor;

public final class WhileStmt
extends Statement {
    private Expression condition;
    private Statement body;

    public WhileStmt() {
    }

    public WhileStmt(Expression condition, Statement body) {
        this.setCondition(condition);
        this.setBody(body);
    }

    public WhileStmt(int beginLine, int beginColumn, int endLine, int endColumn, Expression condition, Statement body) {
        super(beginLine, beginColumn, endLine, endColumn);
        this.setCondition(condition);
        this.setBody(body);
    }

    @Override
    public boolean removeChild(Node child) {
        boolean result = false;
        if (child != null) {
            if (this.condition == child) {
                this.condition = null;
                result = true;
            }
            if (!result && this.body == child) {
                this.body = null;
                result = true;
            }
        }
        if (result) {
            this.updateReferences(child);
        }
        return result;
    }

    @Override
    public List<Node> getChildren() {
        List<Node> children = super.getChildren();
        children.add(this.condition);
        children.add(this.body);
        return children;
    }

    @Override
    public <R, A> R accept(GenericVisitor<R, A> v, A arg) {
        if (!this.check()) {
            return null;
        }
        return v.visit(this, arg);
    }

    @Override
    public <A> void accept(VoidVisitor<A> v, A arg) {
        if (this.check()) {
            v.visit(this, arg);
        }
    }

    public Statement getBody() {
        return this.body;
    }

    public Expression getCondition() {
        return this.condition;
    }

    public void setBody(Statement body) {
        if (this.body != null) {
            this.updateReferences(this.body);
        }
        this.body = body;
        this.setAsParentNodeOf(body);
    }

    public void setCondition(Expression condition) {
        if (this.condition != null) {
            this.updateReferences(this.condition);
        }
        this.condition = condition;
        this.setAsParentNodeOf(condition);
    }

    @Override
    public boolean replaceChildNode(Node oldChild, Node newChild) {
        boolean updated = false;
        if (oldChild == this.condition) {
            this.setCondition((Expression)newChild);
            updated = true;
        }
        if (!updated && oldChild == this.body) {
            this.setBody((Statement)newChild);
            updated = true;
        }
        return updated;
    }

    @Override
    public WhileStmt clone() throws CloneNotSupportedException {
        return new WhileStmt(this.clone(this.condition), this.clone(this.body));
    }
}

