/*
 * Decompiled with CFR 0.152.
 */
package org.walkmod.javalang.ast.type;

import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import org.walkmod.javalang.ast.Node;
import org.walkmod.javalang.ast.SymbolData;
import org.walkmod.javalang.ast.SymbolDefinition;
import org.walkmod.javalang.ast.SymbolReference;
import org.walkmod.javalang.ast.expr.AnnotationExpr;
import org.walkmod.javalang.ast.type.Type;
import org.walkmod.javalang.comparators.ClassOrInterfaceTypeComparator;
import org.walkmod.javalang.visitors.GenericVisitor;
import org.walkmod.javalang.visitors.VoidVisitor;
import org.walkmod.merger.IdentificableNode;

public final class ClassOrInterfaceType
extends Type
implements IdentificableNode,
SymbolDefinition {
    private ClassOrInterfaceType scope;
    private String name;
    private List<Type> typeArgs;
    private SymbolData symbolData;
    private List<SymbolReference> usages;
    private List<SymbolReference> bodyReferences;
    private int scopeLevel = 0;

    public ClassOrInterfaceType() {
    }

    public ClassOrInterfaceType(String name) {
        this.name = name;
    }

    public ClassOrInterfaceType(ClassOrInterfaceType scope, String name) {
        this.setScope(scope);
        this.name = name;
    }

    public ClassOrInterfaceType(ClassOrInterfaceType scope, String name, List<Type> typeArgs, List<AnnotationExpr> annotations) {
        this.setScope(scope);
        this.name = name;
        this.setTypeArgs(typeArgs);
        this.setAnnotations(annotations);
    }

    public ClassOrInterfaceType(int beginLine, int beginColumn, int endLine, int endColumn, ClassOrInterfaceType scope, String name, List<Type> typeArgs) {
        super(beginLine, beginColumn, endLine, endColumn);
        this.setScope(scope);
        this.name = name;
        this.setTypeArgs(typeArgs);
    }

    public ClassOrInterfaceType(int beginLine, int beginColumn, int endLine, int endColumn, ClassOrInterfaceType scope, String name, List<Type> typeArgs, List<AnnotationExpr> annotations) {
        super(beginLine, beginColumn, endLine, endColumn, annotations);
        this.setScope(scope);
        this.name = name;
        this.setTypeArgs(typeArgs);
    }

    @Override
    public boolean removeChild(Node child) {
        boolean result = false;
        if (child != null) {
            if (this.scope == child) {
                this.scope = null;
                result = true;
            }
            if (!result && this.typeArgs != null && child instanceof Type) {
                LinkedList<Type> typeArgsAux = new LinkedList<Type>(this.typeArgs);
                result = typeArgsAux.remove(child);
                this.typeArgs = typeArgsAux;
            }
        }
        if (result) {
            this.updateReferences(child);
        }
        return result;
    }

    @Override
    public List<Node> getChildren() {
        List<Node> children = super.getChildren();
        if (this.scope != null) {
            children.add(this.scope);
        }
        if (this.typeArgs != null) {
            children.addAll(this.typeArgs);
        }
        return children;
    }

    @Override
    public <R, A> R accept(GenericVisitor<R, A> v, A arg) {
        if (!this.check()) {
            return null;
        }
        return v.visit(this, arg);
    }

    @Override
    public <A> void accept(VoidVisitor<A> v, A arg) {
        if (this.check()) {
            v.visit(this, arg);
        }
    }

    public String getName() {
        return this.name;
    }

    public ClassOrInterfaceType getScope() {
        return this.scope;
    }

    public List<Type> getTypeArgs() {
        return this.typeArgs;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setScope(ClassOrInterfaceType scope) {
        if (this.scope != null) {
            this.updateReferences(this.scope);
        }
        this.scope = scope;
        this.setAsParentNodeOf(scope);
    }

    public void setTypeArgs(List<Type> typeArgs) {
        this.typeArgs = typeArgs;
        this.setAsParentNodeOf(typeArgs);
    }

    public Comparator<?> getIdentityComparator() {
        return new ClassOrInterfaceTypeComparator();
    }

    @Override
    public SymbolData getSymbolData() {
        return this.symbolData;
    }

    @Override
    public void setSymbolData(SymbolData symbolData) {
        this.symbolData = symbolData;
    }

    @Override
    public List<SymbolReference> getUsages() {
        return this.usages;
    }

    @Override
    public List<SymbolReference> getBodyReferences() {
        return this.bodyReferences;
    }

    @Override
    public void setUsages(List<SymbolReference> usages) {
        this.usages = usages;
    }

    @Override
    public void setBodyReferences(List<SymbolReference> bodyReferences) {
        this.bodyReferences = bodyReferences;
    }

    @Override
    public boolean addBodyReference(SymbolReference bodyReference) {
        int scope;
        SymbolDefinition definition;
        if (bodyReference != null && (definition = bodyReference.getSymbolDefinition()) != null && (scope = definition.getScopeLevel()) <= this.scopeLevel) {
            if (this.bodyReferences == null) {
                this.bodyReferences = new LinkedList<SymbolReference>();
            }
            return this.bodyReferences.add(bodyReference);
        }
        return false;
    }

    @Override
    public boolean addUsage(SymbolReference usage) {
        if (usage != null) {
            usage.setSymbolDefinition(this);
            if (this.usages == null) {
                this.usages = new LinkedList<SymbolReference>();
            }
            return this.usages.add(usage);
        }
        return false;
    }

    @Override
    public int getScopeLevel() {
        return this.scopeLevel;
    }

    @Override
    public void setScopeLevel(int scopeLevel) {
        this.scopeLevel = scopeLevel;
    }

    @Override
    public boolean replaceChildNode(Node oldChild, Node newChild) {
        LinkedList<Type> auxTypeArgs;
        boolean updated = super.replaceChildNode(oldChild, newChild);
        if (oldChild == this.scope) {
            this.setScope((ClassOrInterfaceType)newChild);
            updated = true;
        }
        if (!updated && this.typeArgs != null && (updated = this.replaceChildNodeInList(oldChild, newChild, auxTypeArgs = new LinkedList<Type>(this.typeArgs)))) {
            this.typeArgs = auxTypeArgs;
        }
        return updated;
    }

    @Override
    public ClassOrInterfaceType clone() throws CloneNotSupportedException {
        return new ClassOrInterfaceType(this.clone(this.getScope()), this.getName(), this.clone(this.getTypeArgs()), this.clone(this.getAnnotations()));
    }

    @Override
    public String getSymbolName() {
        return this.name;
    }
}

