/*
 * Decompiled with CFR 0.152.
 */
package org.walkmod.javalang.comparators;

import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import org.walkmod.javalang.ast.body.BodyDeclaration;
import org.walkmod.javalang.comparators.AnnotationMemberDeclarationComparator;
import org.walkmod.javalang.comparators.EnumConstantComparator;
import org.walkmod.javalang.comparators.FieldDeclarationComparator;
import org.walkmod.javalang.comparators.MethodDeclarationComparator;

public class BodyDeclaratorComparator
implements Comparator<BodyDeclaration> {
    private String[] order;
    private Map<String, Comparator> comparator = new HashMap<String, Comparator>();

    public BodyDeclaratorComparator() {
        this.order = new String[]{"FieldDeclaration", "EnumConstantDeclaration", "InitializerDeclaration", "ConstructorDeclaration", "AnnotationMemberDeclaration", "MethodDeclaration", "TypeDeclaration", "EmptyMemberDeclaration"};
        this.comparator.put("FieldDeclaration", new FieldDeclarationComparator());
        this.comparator.put("MethodDeclaration", new MethodDeclarationComparator());
        this.comparator.put("EnumConstantDeclaration", new EnumConstantComparator());
        this.comparator.put("AnnotationMemberDeclaration", new AnnotationMemberDeclarationComparator());
    }

    @Override
    public int compare(BodyDeclaration o1, BodyDeclaration o2) {
        Integer o1_position = Arrays.binarySearch(this.order, o1.getClass().getSimpleName());
        Integer o2_position = Arrays.binarySearch(this.order, o2.getClass().getSimpleName());
        if (o1_position < 0) {
            return 0;
        }
        if (o1_position == o2_position) {
            if (this.comparator.containsKey(this.order[o1_position])) {
                return this.comparator.get(this.order[o1_position]).compare(o1, o2);
            }
            return 0;
        }
        return o1_position.compareTo(o2_position);
    }
}

