/*
 * Decompiled with CFR 0.152.
 */
package org.web3j.protocol.core.methods.request;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.ArrayList;
import java.util.List;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public abstract class Filter<T extends Filter> {
    private T thisObj = this.getThis();
    private List<FilterTopic> topics = new ArrayList<FilterTopic>();

    Filter() {
    }

    public T addSingleTopic(String topic) {
        this.topics.add(new SingleTopic(topic));
        return this.getThis();
    }

    public T addNullTopic() {
        this.topics.add(new SingleTopic());
        return this.getThis();
    }

    public T addOptionalTopics(String ... optionalTopics) {
        this.topics.add(new ListTopic(optionalTopics));
        return this.getThis();
    }

    public List<FilterTopic> getTopics() {
        return this.topics;
    }

    abstract T getThis();

    public static class SingleTopic
    implements FilterTopic<String> {
        private String topic;

        public SingleTopic() {
            this.topic = null;
        }

        public SingleTopic(String topic) {
            this.topic = topic;
        }

        @Override
        public String getValue() {
            return this.topic;
        }
    }

    public static class ListTopic
    implements FilterTopic<List<SingleTopic>> {
        private List<SingleTopic> topics = new ArrayList<SingleTopic>();

        public ListTopic(String ... optionalTopics) {
            for (String topic : optionalTopics) {
                if (topic != null) {
                    this.topics.add(new SingleTopic(topic));
                    continue;
                }
                this.topics.add(new SingleTopic());
            }
        }

        @Override
        public List<SingleTopic> getValue() {
            return this.topics;
        }
    }

    public static interface FilterTopic<T> {
        @JsonValue
        public T getValue();
    }
}

