/*
 * Decompiled with CFR 0.152.
 */
package org.web3j.protocol.core.methods.response;

import java.util.Collections;
import java.util.List;
import org.web3j.abi.FunctionReturnDecoder;
import org.web3j.abi.TypeReference;
import org.web3j.abi.datatypes.AbiTypes;
import org.web3j.abi.datatypes.Type;
import org.web3j.abi.datatypes.Utf8String;
import org.web3j.protocol.core.Response;
import org.web3j.utils.EnsUtils;

public class EthCall
extends Response<String> {
    private static final String errorMethodId = "0x08c379a0";
    private static final List<TypeReference<Type>> revertReasonType = Collections.singletonList(TypeReference.create((Class)AbiTypes.getType((String)"string")));

    public String getValue() {
        return (String)this.getResult();
    }

    public boolean isReverted() {
        if (this.hasError() && this.getError().getCode() == 3 && this.getError().getData() != null) {
            return !EnsUtils.isEIP3668(this.getError().getData());
        }
        return this.hasError() || this.isErrorInResult();
    }

    @Deprecated
    public boolean reverts() {
        return this.isReverted();
    }

    private boolean isErrorInResult() {
        return this.getValue() != null && this.getValue().startsWith(errorMethodId);
    }

    public String getRevertReason() {
        if (this.isErrorInResult()) {
            String hexRevertReason = this.getValue().substring(errorMethodId.length());
            List decoded = FunctionReturnDecoder.decode((String)hexRevertReason, revertReasonType);
            Utf8String decodedRevertReason = (Utf8String)decoded.get(0);
            return decodedRevertReason.getValue();
        }
        if (this.hasError()) {
            return this.getError().getMessage();
        }
        return null;
    }
}

