/*
 * Decompiled with CFR 0.152.
 */
package org.web3j.ens;

import org.web3j.crypto.WalletUtils;
import org.web3j.ens.Contracts;
import org.web3j.ens.EnsResolutionException;
import org.web3j.ens.NameHash;
import org.web3j.ens.contracts.generated.ENS;
import org.web3j.ens.contracts.generated.PublicResolver;
import org.web3j.protocol.Web3j;
import org.web3j.protocol.core.DefaultBlockParameterName;
import org.web3j.protocol.core.methods.response.EthBlock;
import org.web3j.protocol.core.methods.response.EthSyncing;
import org.web3j.protocol.core.methods.response.NetVersion;
import org.web3j.tx.ClientTransactionManager;
import org.web3j.tx.TransactionManager;
import org.web3j.tx.gas.DefaultGasProvider;
import org.web3j.utils.Numeric;

public class EnsResolver {
    public static final long DEFAULT_SYNC_THRESHOLD = 180000L;
    public static final String REVERSE_NAME_SUFFIX = ".addr.reverse";
    private final Web3j web3j;
    private final int addressLength;
    private final TransactionManager transactionManager;
    private long syncThreshold;

    public EnsResolver(Web3j web3j, long syncThreshold, int addressLength) {
        this.web3j = web3j;
        this.transactionManager = new ClientTransactionManager(web3j, null);
        this.syncThreshold = syncThreshold;
        this.addressLength = addressLength;
    }

    public EnsResolver(Web3j web3j, long syncThreshold) {
        this(web3j, syncThreshold, 40);
    }

    public EnsResolver(Web3j web3j) {
        this(web3j, 180000L);
    }

    public void setSyncThreshold(long syncThreshold) {
        this.syncThreshold = syncThreshold;
    }

    public long getSyncThreshold() {
        return this.syncThreshold;
    }

    protected PublicResolver obtainPublicResolver(String ensName) {
        if (EnsResolver.isValidEnsName(ensName, this.addressLength)) {
            try {
                if (!this.isSynced()) {
                    throw new EnsResolutionException("Node is not currently synced");
                }
                return this.lookupResolver(ensName);
            }
            catch (Exception e) {
                throw new EnsResolutionException("Unable to determine sync status of node", e);
            }
        }
        throw new EnsResolutionException("EnsName is invalid: " + ensName);
    }

    public String resolve(String contractId) {
        if (EnsResolver.isValidEnsName(contractId, this.addressLength)) {
            PublicResolver resolver = this.obtainPublicResolver(contractId);
            byte[] nameHash = NameHash.nameHashAsBytes(contractId);
            String contractAddress = null;
            try {
                contractAddress = resolver.addr(nameHash).send();
            }
            catch (Exception e) {
                throw new RuntimeException("Unable to execute Ethereum request", e);
            }
            if (!WalletUtils.isValidAddress(contractAddress)) {
                throw new RuntimeException("Unable to resolve address for name: " + contractId);
            }
            return contractAddress;
        }
        return contractId;
    }

    public String reverseResolve(String address) {
        if (WalletUtils.isValidAddress(address, this.addressLength)) {
            String name;
            String reverseName = Numeric.cleanHexPrefix((String)address) + REVERSE_NAME_SUFFIX;
            PublicResolver resolver = this.obtainPublicResolver(reverseName);
            byte[] nameHash = NameHash.nameHashAsBytes(reverseName);
            try {
                name = resolver.name(nameHash).send();
            }
            catch (Exception e) {
                throw new RuntimeException("Unable to execute Ethereum request", e);
            }
            if (!EnsResolver.isValidEnsName(name, this.addressLength)) {
                throw new RuntimeException("Unable to resolve name for address: " + address);
            }
            return name;
        }
        throw new EnsResolutionException("Address is invalid: " + address);
    }

    private PublicResolver lookupResolver(String ensName) throws Exception {
        NetVersion netVersion = this.web3j.netVersion().send();
        String registryContract = Contracts.resolveRegistryContract(netVersion.getNetVersion());
        ENS ensRegistry = ENS.load(registryContract, this.web3j, this.transactionManager, DefaultGasProvider.GAS_PRICE, DefaultGasProvider.GAS_LIMIT);
        byte[] nameHash = NameHash.nameHashAsBytes(ensName);
        String resolverAddress = ensRegistry.resolver(nameHash).send();
        return PublicResolver.load(resolverAddress, this.web3j, this.transactionManager, DefaultGasProvider.GAS_PRICE, DefaultGasProvider.GAS_LIMIT);
    }

    boolean isSynced() throws Exception {
        EthSyncing ethSyncing = this.web3j.ethSyncing().send();
        if (ethSyncing.isSyncing()) {
            return false;
        }
        EthBlock ethBlock = this.web3j.ethGetBlockByNumber(DefaultBlockParameterName.LATEST, false).send();
        long timestamp = ethBlock.getBlock().getTimestamp().longValueExact() * 1000L;
        return System.currentTimeMillis() - this.syncThreshold < timestamp;
    }

    public static boolean isValidEnsName(String input) {
        return EnsResolver.isValidEnsName(input, 40);
    }

    public static boolean isValidEnsName(String input, int addressLength) {
        return input != null && (input.contains(".") || !WalletUtils.isValidAddress(input, addressLength));
    }
}

