/*
 * Decompiled with CFR 0.152.
 */
package org.web3j.protocol.core.methods.response;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import java.util.List;
import java.util.stream.Collectors;

@JsonIgnoreProperties(ignoreUnknown=true)
public class AbiDefinition {
    private boolean constant;
    private List<NamedType> inputs;
    private String name;
    private List<NamedType> outputs;
    private String type;
    private boolean payable;
    private String stateMutability;

    public AbiDefinition() {
    }

    public AbiDefinition(AbiDefinition from) {
        this(from.constant, AbiDefinition.clone(from.inputs), from.name, AbiDefinition.clone(from.outputs), from.type, from.payable, from.stateMutability);
    }

    public AbiDefinition(boolean constant, List<NamedType> inputs, String name, List<NamedType> outputs, String type, boolean payable) {
        this(constant, inputs, name, outputs, type, payable, null);
    }

    public AbiDefinition(boolean constant, List<NamedType> inputs, String name, List<NamedType> outputs, String type, boolean payable, String stateMutability) {
        this.constant = constant;
        this.inputs = inputs;
        this.name = name;
        this.outputs = outputs;
        this.type = type;
        this.payable = payable;
        this.stateMutability = stateMutability;
    }

    public boolean isConstant() {
        return this.constant;
    }

    public void setConstant(boolean constant) {
        this.constant = constant;
    }

    public List<NamedType> getInputs() {
        return this.inputs;
    }

    public void setInputs(List<NamedType> inputs) {
        this.inputs = inputs;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List<NamedType> getOutputs() {
        return this.outputs;
    }

    public boolean hasOutputs() {
        return !this.outputs.isEmpty();
    }

    public void setOutputs(List<NamedType> outputs) {
        this.outputs = outputs;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public boolean isPayable() {
        return this.payable;
    }

    public void setPayable(boolean payable) {
        this.payable = payable;
    }

    public String getStateMutability() {
        return this.stateMutability;
    }

    public void setStateMutability(String stateMutability) {
        this.stateMutability = stateMutability;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AbiDefinition)) {
            return false;
        }
        AbiDefinition that = (AbiDefinition)o;
        if (this.isConstant() != that.isConstant()) {
            return false;
        }
        if (this.isPayable() != that.isPayable()) {
            return false;
        }
        if (this.getInputs() != null ? !this.getInputs().equals(that.getInputs()) : that.getInputs() != null) {
            return false;
        }
        if (this.getName() != null ? !this.getName().equals(that.getName()) : that.getName() != null) {
            return false;
        }
        if (this.getOutputs() != null ? !this.getOutputs().equals(that.getOutputs()) : that.getOutputs() != null) {
            return false;
        }
        if (this.getStateMutability() != null ? !this.getStateMutability().equals(that.getStateMutability()) : that.getStateMutability() != null) {
            return false;
        }
        return this.getType() != null ? this.getType().equals(that.getType()) : that.getType() == null;
    }

    public int hashCode() {
        int result = this.isConstant() ? 1 : 0;
        result = 31 * result + (this.getInputs() != null ? this.getInputs().hashCode() : 0);
        result = 31 * result + (this.getName() != null ? this.getName().hashCode() : 0);
        result = 31 * result + (this.getOutputs() != null ? this.getOutputs().hashCode() : 0);
        result = 31 * result + (this.getType() != null ? this.getType().hashCode() : 0);
        result = 31 * result + (this.isPayable() ? 1 : 0);
        result = 31 * result + (this.getStateMutability() != null ? this.getStateMutability().hashCode() : 0);
        return result;
    }

    private static List<NamedType> clone(List<NamedType> from) {
        return from.stream().map(NamedType::new).collect(Collectors.toList());
    }

    public static class NamedType {
        private String name;
        private String type;
        private boolean indexed;

        public NamedType() {
        }

        public NamedType(NamedType from) {
            this(from.name, from.type, from.indexed);
        }

        public NamedType(String name, String type) {
            this.name = name;
            this.type = type;
        }

        public NamedType(String name, String type, boolean indexed) {
            this.name = name;
            this.type = type;
            this.indexed = indexed;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public boolean isIndexed() {
            return this.indexed;
        }

        public void setIndexed(boolean indexed) {
            this.indexed = indexed;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof NamedType)) {
                return false;
            }
            NamedType namedType = (NamedType)o;
            if (this.isIndexed() != namedType.isIndexed()) {
                return false;
            }
            if (this.getName() != null ? !this.getName().equals(namedType.getName()) : namedType.getName() != null) {
                return false;
            }
            return this.getType() != null ? this.getType().equals(namedType.getType()) : namedType.getType() == null;
        }

        public int hashCode() {
            int result = this.getName() != null ? this.getName().hashCode() : 0;
            result = 31 * result + (this.getType() != null ? this.getType().hashCode() : 0);
            result = 31 * result + (this.isIndexed() ? 1 : 0);
            return result;
        }
    }
}

