/*
 * Decompiled with CFR 0.152.
 */
package org.web3j.crypto;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import java.math.BigInteger;
import java.util.Base64;
import org.bouncycastle.jcajce.provider.asymmetric.ec.BCECPrivateKey;
import org.bouncycastle.jcajce.provider.asymmetric.ec.BCECPublicKey;

@JsonDeserialize(builder=Builder.class)
public final class Secp256k1JWK {
    private static final String kty = "EC";
    private static final String crv = "secp256k1";
    private String x;
    private String y;
    private String d;

    private Secp256k1JWK(String xCoordinate, String yCoordinate) {
        this.x = xCoordinate;
        this.y = yCoordinate;
    }

    private Secp256k1JWK(String xCoordinate, String yCoordinate, String dCoordinate) {
        this(xCoordinate, yCoordinate);
        this.d = dCoordinate;
    }

    public String getKty() {
        return kty;
    }

    public String getCrv() {
        return crv;
    }

    public String getX() {
        return this.x;
    }

    public String getY() {
        return this.y;
    }

    public String getD() {
        return this.d;
    }

    public static boolean isEcCoordBase64Valid(String s) {
        return s.matches("(?:[A-Za-z0-9-_]{4})*(?:[A-Za-z0-9-_]{2}|[A-Za-z0-9-_]{3})");
    }

    @JsonPOJOBuilder
    public static class Builder {
        private String kty;
        private String crv;
        private String x;
        private String y;
        private String d;

        public Builder(BCECPublicKey key) {
            this.withPublicKey(key);
        }

        public Builder() {
        }

        public Builder withKty(String kty) {
            if (!kty.equals(Secp256k1JWK.kty)) {
                throw new IllegalArgumentException("Invalid key type: " + kty);
            }
            return this;
        }

        public Builder withCrv(String crv) {
            if (!crv.equals(Secp256k1JWK.crv)) {
                throw new IllegalArgumentException("Invalid curve type: " + crv);
            }
            return this;
        }

        public Builder withD(String d) {
            if (!Secp256k1JWK.isEcCoordBase64Valid(d)) {
                throw new IllegalArgumentException("Specified d jwk is not a valid base 64 value");
            }
            this.d = d;
            return this;
        }

        public Builder withX(String x) {
            if (!Secp256k1JWK.isEcCoordBase64Valid(x)) {
                throw new IllegalArgumentException("Specified x jwk is not a valid base 64 value");
            }
            this.x = x;
            return this;
        }

        public Builder withY(String y) {
            if (!Secp256k1JWK.isEcCoordBase64Valid(y)) {
                throw new IllegalArgumentException("Specified y jwk is not a valid base 64 value");
            }
            this.y = y;
            return this;
        }

        public Builder withPrivateKey(BCECPrivateKey pk) {
            this.d = this.encodeCoordinate(pk.getS());
            return this;
        }

        public Builder withPublicKey(BCECPublicKey pk) {
            this.x = this.encodeCoordinate(pk.getW().getAffineX());
            this.y = this.encodeCoordinate(pk.getW().getAffineY());
            return this;
        }

        private String encodeCoordinate(BigInteger coordinate) {
            byte[] bytes = coordinate.toByteArray();
            if (bytes[0] == 0) {
                byte[] unsignedBytes = new byte[bytes.length - 1];
                System.arraycopy(bytes, 1, unsignedBytes, 0, unsignedBytes.length);
                return this.encodeEcToBase64(unsignedBytes);
            }
            return this.encodeEcToBase64(bytes);
        }

        private String encodeEcToBase64(byte[] bytes) {
            String paddedEncoding = Base64.getEncoder().encodeToString(bytes);
            paddedEncoding = paddedEncoding.replaceAll("[+]", "-").replaceAll("[/]", "_");
            return paddedEncoding.substring(0, paddedEncoding.length() - 1);
        }

        public Secp256k1JWK build() {
            if (this.d == null) {
                return new Secp256k1JWK(this.x, this.y);
            }
            return new Secp256k1JWK(this.x, this.y, this.d);
        }
    }
}

