/*
 * Decompiled with CFR 0.152.
 */
package org.web3j.crypto;

import java.math.BigInteger;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.tuweni.bytes.Bytes;
import org.web3j.crypto.AccessListObject;
import org.web3j.crypto.AuthorizationTuple;
import org.web3j.crypto.Blob;
import org.web3j.crypto.RawTransaction;
import org.web3j.crypto.Sign;
import org.web3j.crypto.SignedRawTransaction;
import org.web3j.crypto.transaction.type.TransactionType;
import org.web3j.rlp.RlpDecoder;
import org.web3j.rlp.RlpList;
import org.web3j.rlp.RlpString;
import org.web3j.rlp.RlpType;
import org.web3j.utils.Numeric;

public class TransactionDecoder {
    private static final int UNSIGNED_EIP1559TX_RLP_LIST_SIZE = 9;
    private static final int UNSIGNED_EIP2930TX_RLP_LIST_SIZE = 8;
    private static final int UNSIGNED_EIP4844TX_RLP_LIST_SIZE = 11;
    private static final int UNSIGNED_EIP7702TX_RLP_LIST_SIZE = 10;

    public static RawTransaction decode(String hexTransaction) {
        byte[] transaction = Numeric.hexStringToByteArray((String)hexTransaction);
        TransactionType transactionType = TransactionDecoder.getTransactionType(transaction);
        switch (transactionType) {
            case EIP1559: {
                return TransactionDecoder.decodeEIP1559Transaction(transaction);
            }
            case EIP4844: {
                return TransactionDecoder.decodeEIP4844Transaction(transaction);
            }
            case EIP2930: {
                return TransactionDecoder.decodeEIP2930Transaction(transaction);
            }
            case EIP7702: {
                return TransactionDecoder.decodeEIP7702Transaction(transaction);
            }
        }
        return TransactionDecoder.decodeLegacyTransaction(transaction);
    }

    private static RawTransaction decodeEIP7702Transaction(byte[] transaction) {
        byte[] encodedTx = Arrays.copyOfRange(transaction, 1, transaction.length);
        RlpList rlpList = RlpDecoder.decode((byte[])encodedTx);
        RlpList values = (RlpList)rlpList.getValues().get(0);
        List fields = values.getValues();
        long chainId = ((RlpString)fields.get(0)).asPositiveBigInteger().longValue();
        BigInteger nonce = ((RlpString)fields.get(1)).asPositiveBigInteger();
        BigInteger maxPriorityFeePerGas = ((RlpString)fields.get(2)).asPositiveBigInteger();
        BigInteger maxFeePerGas = ((RlpString)fields.get(3)).asPositiveBigInteger();
        BigInteger gasLimit = ((RlpString)fields.get(4)).asPositiveBigInteger();
        String to = ((RlpString)fields.get(5)).asString();
        BigInteger value = ((RlpString)fields.get(6)).asPositiveBigInteger();
        String data = ((RlpString)fields.get(7)).asString();
        List accessListRlp = ((RlpList)fields.get(8)).getValues();
        List<AccessListObject> accessList = TransactionDecoder.decodeAccessList(accessListRlp);
        List<AuthorizationTuple> authorizationList = TransactionDecoder.decodeAuthorizationList(((RlpList)fields.get(9)).getValues());
        RawTransaction rawTransaction = RawTransaction.createTransaction(chainId, nonce, maxPriorityFeePerGas, maxFeePerGas, gasLimit, to, value, data, accessList, authorizationList);
        if (fields.size() == 10) {
            return rawTransaction;
        }
        int yParity = Numeric.toBigInt((byte[])((RlpString)fields.get(10)).getBytes()).intValue();
        byte[] rBytes = Numeric.toBytesPadded((BigInteger)Numeric.toBigInt((byte[])((RlpString)fields.get(11)).getBytes()), (int)32);
        byte[] sBytes = Numeric.toBytesPadded((BigInteger)Numeric.toBigInt((byte[])((RlpString)fields.get(12)).getBytes()), (int)32);
        byte[] vBytes = Sign.getVFromRecId(yParity);
        Sign.SignatureData signatureData = new Sign.SignatureData(vBytes, rBytes, sBytes);
        return new SignedRawTransaction(rawTransaction.getTransaction(), signatureData);
    }

    private static TransactionType getTransactionType(byte[] transaction) {
        byte firstByte = transaction[0];
        if (firstByte == TransactionType.EIP1559.getRlpType()) {
            return TransactionType.EIP1559;
        }
        if (firstByte == TransactionType.EIP4844.getRlpType()) {
            return TransactionType.EIP4844;
        }
        if (firstByte == TransactionType.EIP2930.getRlpType()) {
            return TransactionType.EIP2930;
        }
        if (firstByte == TransactionType.EIP7702.getRlpType()) {
            return TransactionType.EIP7702;
        }
        return TransactionType.LEGACY;
    }

    private static RawTransaction decodeEIP4844Transaction(byte[] transaction) {
        List<Bytes> kzgProofs;
        List<Bytes> kzgCommitments;
        List<Blob> blobs;
        RlpList txPayload;
        byte[] encodedTx = Arrays.copyOfRange(transaction, 1, transaction.length);
        RlpList rlpList = RlpDecoder.decode((byte[])encodedTx);
        RlpList outerList = (RlpList)rlpList.getValues().get(0);
        if (outerList.getValues().get(0) instanceof RlpList) {
            txPayload = (RlpList)outerList.getValues().get(0);
            blobs = TransactionDecoder.decodeBlobs(((RlpList)outerList.getValues().get(1)).getValues());
            kzgCommitments = TransactionDecoder.decodeBytesList(((RlpList)outerList.getValues().get(2)).getValues());
            kzgProofs = TransactionDecoder.decodeBytesList(((RlpList)outerList.getValues().get(3)).getValues());
        } else {
            txPayload = outerList;
            blobs = null;
            kzgCommitments = null;
            kzgProofs = null;
        }
        List txValues = txPayload.getValues();
        long chainId = ((RlpString)txValues.get(0)).asPositiveBigInteger().longValue();
        BigInteger nonce = ((RlpString)txValues.get(1)).asPositiveBigInteger();
        BigInteger maxPriorityFeePerGas = ((RlpString)txValues.get(2)).asPositiveBigInteger();
        BigInteger maxFeePerGas = ((RlpString)txValues.get(3)).asPositiveBigInteger();
        BigInteger gasLimit = ((RlpString)txValues.get(4)).asPositiveBigInteger();
        String to = ((RlpString)txValues.get(5)).asString();
        BigInteger value = ((RlpString)txValues.get(6)).asPositiveBigInteger();
        String data = ((RlpString)txValues.get(7)).asString();
        BigInteger maxFeePerBlobGas = ((RlpString)txValues.get(9)).asPositiveBigInteger();
        List<Bytes> versionedHashes = TransactionDecoder.decodeVersionedHashes(((RlpList)txValues.get(10)).getValues());
        RawTransaction rawTransaction = RawTransaction.createTransaction(blobs, kzgCommitments, kzgProofs, chainId, nonce, maxPriorityFeePerGas, maxFeePerGas, gasLimit, to, value, data, maxFeePerBlobGas, versionedHashes);
        if (txValues.size() > 11) {
            byte[] v = Sign.getVFromRecId(Numeric.toBigInt((byte[])((RlpString)txValues.get(11)).getBytes()).intValue());
            byte[] r = Numeric.toBytesPadded((BigInteger)Numeric.toBigInt((byte[])((RlpString)txValues.get(12)).getBytes()), (int)32);
            byte[] s = Numeric.toBytesPadded((BigInteger)Numeric.toBigInt((byte[])((RlpString)txValues.get(13)).getBytes()), (int)32);
            Sign.SignatureData signatureData = new Sign.SignatureData(v, r, s);
            return new SignedRawTransaction(rawTransaction.getTransaction(), signatureData);
        }
        return rawTransaction;
    }

    private static List<Blob> decodeBlobs(List<RlpType> rlpBlobs) {
        return rlpBlobs.stream().map(r -> new Blob(((RlpString)r).getBytes())).collect(Collectors.toList());
    }

    private static List<Bytes> decodeBytesList(List<RlpType> rlpBytesList) {
        return rlpBytesList.stream().map(r -> Bytes.wrap((byte[])((RlpString)r).getBytes())).collect(Collectors.toList());
    }

    private static RawTransaction decodeEIP1559Transaction(byte[] transaction) {
        byte[] encodedTx = Arrays.copyOfRange(transaction, 1, transaction.length);
        RlpList rlpList = RlpDecoder.decode((byte[])encodedTx);
        RlpList values = (RlpList)rlpList.getValues().get(0);
        long chainId = ((RlpString)values.getValues().get(0)).asPositiveBigInteger().longValue();
        BigInteger nonce = ((RlpString)values.getValues().get(1)).asPositiveBigInteger();
        BigInteger maxPriorityFeePerGas = ((RlpString)values.getValues().get(2)).asPositiveBigInteger();
        BigInteger maxFeePerGas = ((RlpString)values.getValues().get(3)).asPositiveBigInteger();
        BigInteger gasLimit = ((RlpString)values.getValues().get(4)).asPositiveBigInteger();
        String to = ((RlpString)values.getValues().get(5)).asString();
        BigInteger value = ((RlpString)values.getValues().get(6)).asPositiveBigInteger();
        String data = ((RlpString)values.getValues().get(7)).asString();
        List<AccessListObject> accessList = TransactionDecoder.decodeAccessList(((RlpList)values.getValues().get(8)).getValues());
        RawTransaction rawTransaction = RawTransaction.createTransaction(chainId, nonce, gasLimit, to, value, data, maxPriorityFeePerGas, maxFeePerGas, accessList);
        if (values.getValues().size() == 9) {
            return rawTransaction;
        }
        byte[] v = Sign.getVFromRecId(Numeric.toBigInt((byte[])((RlpString)values.getValues().get(9)).getBytes()).intValue());
        byte[] r = Numeric.toBytesPadded((BigInteger)Numeric.toBigInt((byte[])((RlpString)values.getValues().get(10)).getBytes()), (int)32);
        byte[] s = Numeric.toBytesPadded((BigInteger)Numeric.toBigInt((byte[])((RlpString)values.getValues().get(11)).getBytes()), (int)32);
        Sign.SignatureData signatureData = new Sign.SignatureData(v, r, s);
        return new SignedRawTransaction(rawTransaction.getTransaction(), signatureData);
    }

    private static RawTransaction decodeLegacyTransaction(byte[] transaction) {
        RlpList rlpList = RlpDecoder.decode((byte[])transaction);
        RlpList values = (RlpList)rlpList.getValues().get(0);
        BigInteger nonce = ((RlpString)values.getValues().get(0)).asPositiveBigInteger();
        BigInteger gasPrice = ((RlpString)values.getValues().get(1)).asPositiveBigInteger();
        BigInteger gasLimit = ((RlpString)values.getValues().get(2)).asPositiveBigInteger();
        String to = ((RlpString)values.getValues().get(3)).asString();
        BigInteger value = ((RlpString)values.getValues().get(4)).asPositiveBigInteger();
        String data = ((RlpString)values.getValues().get(5)).asString();
        if (values.getValues().size() == 6 || values.getValues().size() == 8 && ((RlpString)values.getValues().get(7)).getBytes().length == 10 || values.getValues().size() == 9 && ((RlpString)values.getValues().get(8)).getBytes().length == 10) {
            return RawTransaction.createTransaction(nonce, gasPrice, gasLimit, to, value, data);
        }
        byte[] v = ((RlpString)values.getValues().get(6)).getBytes();
        byte[] r = Numeric.toBytesPadded((BigInteger)Numeric.toBigInt((byte[])((RlpString)values.getValues().get(7)).getBytes()), (int)32);
        byte[] s = Numeric.toBytesPadded((BigInteger)Numeric.toBigInt((byte[])((RlpString)values.getValues().get(8)).getBytes()), (int)32);
        Sign.SignatureData signatureData = new Sign.SignatureData(v, r, s);
        return new SignedRawTransaction(nonce, gasPrice, gasLimit, to, value, data, signatureData);
    }

    private static RawTransaction decodeEIP2930Transaction(byte[] transaction) {
        byte[] encodedTx = Arrays.copyOfRange(transaction, 1, transaction.length);
        RlpList rlpList = RlpDecoder.decode((byte[])encodedTx);
        RlpList values = (RlpList)rlpList.getValues().get(0);
        long chainId = ((RlpString)values.getValues().get(0)).asPositiveBigInteger().longValue();
        BigInteger nonce = ((RlpString)values.getValues().get(1)).asPositiveBigInteger();
        BigInteger gasPrice = ((RlpString)values.getValues().get(2)).asPositiveBigInteger();
        BigInteger gasLimit = ((RlpString)values.getValues().get(3)).asPositiveBigInteger();
        String to = ((RlpString)values.getValues().get(4)).asString();
        BigInteger value = ((RlpString)values.getValues().get(5)).asPositiveBigInteger();
        String data = ((RlpString)values.getValues().get(6)).asString();
        List<AccessListObject> accessList = TransactionDecoder.decodeAccessList(((RlpList)values.getValues().get(7)).getValues());
        RawTransaction rawTransaction = RawTransaction.createTransaction(chainId, nonce, gasPrice, gasLimit, to, value, data, accessList);
        if (values.getValues().size() == 8) {
            return rawTransaction;
        }
        byte[] v = Sign.getVFromRecId(Numeric.toBigInt((byte[])((RlpString)values.getValues().get(8)).getBytes()).intValue());
        byte[] r = Numeric.toBytesPadded((BigInteger)Numeric.toBigInt((byte[])((RlpString)values.getValues().get(9)).getBytes()), (int)32);
        byte[] s = Numeric.toBytesPadded((BigInteger)Numeric.toBigInt((byte[])((RlpString)values.getValues().get(10)).getBytes()), (int)32);
        Sign.SignatureData signatureData = new Sign.SignatureData(v, r, s);
        return new SignedRawTransaction(rawTransaction.getTransaction(), signatureData);
    }

    private static List<AccessListObject> decodeAccessList(List<RlpType> rlp) {
        return rlp.stream().map(rawEntry -> ((RlpList)rawEntry).getValues()).map(values -> new AccessListObject(((RlpString)values.get(0)).asString(), ((RlpList)values.get(1)).getValues().stream().map(rawKey -> ((RlpString)rawKey).asString()).collect(Collectors.toList()))).collect(Collectors.toList());
    }

    public static List<Bytes> decodeVersionedHashes(List<RlpType> rlp) {
        return rlp.stream().map(rlpType -> {
            if (rlpType instanceof RlpString) {
                RlpString rlpString = (RlpString)rlpType;
                return Bytes.wrap((byte[])rlpString.getBytes());
            }
            throw new IllegalArgumentException("List contains non-RlpString elements");
        }).collect(Collectors.toList());
    }

    private static List<AuthorizationTuple> decodeAuthorizationList(List<RlpType> rlpList) {
        return rlpList.stream().map(item -> (RlpList)item).map(tuple -> {
            List elements = tuple.getValues();
            BigInteger authChainId = ((RlpString)elements.get(0)).asPositiveBigInteger();
            String address = ((RlpString)elements.get(1)).asString();
            BigInteger authNonce = ((RlpString)elements.get(2)).asPositiveBigInteger();
            BigInteger yParity = ((RlpString)elements.get(3)).asPositiveBigInteger();
            BigInteger rValue = ((RlpString)elements.get(4)).asPositiveBigInteger();
            BigInteger sValue = ((RlpString)elements.get(5)).asPositiveBigInteger();
            return new AuthorizationTuple(authChainId, address, authNonce, yParity, rValue, sValue);
        }).collect(Collectors.toList());
    }
}

