/*
 * Decompiled with CFR 0.152.
 */
package org.web3j.evm;

import io.reactivex.Flowable;
import java.io.IOException;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import org.hyperledger.besu.ethereum.core.Hash;
import org.hyperledger.besu.ethereum.vm.OperationTracer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.web3j.abi.datatypes.Address;
import org.web3j.evm.Configuration;
import org.web3j.evm.EmbeddedEthereum;
import org.web3j.evm.PassthroughTracer;
import org.web3j.protocol.Web3jService;
import org.web3j.protocol.core.BatchRequest;
import org.web3j.protocol.core.BatchResponse;
import org.web3j.protocol.core.Request;
import org.web3j.protocol.core.Response;
import org.web3j.protocol.core.methods.request.Transaction;
import org.web3j.protocol.core.methods.response.EthBlock;
import org.web3j.protocol.core.methods.response.EthBlockNumber;
import org.web3j.protocol.core.methods.response.EthCall;
import org.web3j.protocol.core.methods.response.EthEstimateGas;
import org.web3j.protocol.core.methods.response.EthGasPrice;
import org.web3j.protocol.core.methods.response.EthGetBalance;
import org.web3j.protocol.core.methods.response.EthGetBlockTransactionCountByHash;
import org.web3j.protocol.core.methods.response.EthGetBlockTransactionCountByNumber;
import org.web3j.protocol.core.methods.response.EthGetCode;
import org.web3j.protocol.core.methods.response.EthGetTransactionCount;
import org.web3j.protocol.core.methods.response.EthGetTransactionReceipt;
import org.web3j.protocol.core.methods.response.EthSendTransaction;
import org.web3j.protocol.core.methods.response.EthSyncing;
import org.web3j.protocol.core.methods.response.NetVersion;
import org.web3j.protocol.core.methods.response.TransactionReceipt;
import org.web3j.protocol.core.methods.response.Web3ClientVersion;
import org.web3j.protocol.websocket.events.Notification;
import org.web3j.utils.Async;
import org.web3j.utils.Numeric;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0084\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 72\u00020\u0001:\u00017B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010\n\u001a\u00020\u000bH\u0016J\u001a\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\n\u0010\u000f\u001a\u0006\u0012\u0002\b\u00030\u0010H\u0002J\u001a\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\r2\n\u0010\u000f\u001a\u0006\u0012\u0002\b\u00030\u0010H\u0002J\u001a\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00120\r2\n\u0010\u000f\u001a\u0006\u0012\u0002\b\u00030\u0010H\u0002J\u000e\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0002J\u001a\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\n\u0010\u000f\u001a\u0006\u0012\u0002\b\u00030\u0010H\u0002J\u000e\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0002J\u001a\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\n\u0010\u000f\u001a\u0006\u0012\u0002\b\u00030\u0010H\u0002J\u001a\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\n\u0010\u000f\u001a\u0006\u0012\u0002\b\u00030\u0010H\u0002J\u001a\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\n\u0010\u000f\u001a\u0006\u0012\u0002\b\u00030\u0010H\u0002J\u001a\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\n\u0010\u000f\u001a\u0006\u0012\u0002\b\u00030\u0010H\u0002J\u001c\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u001c0\u0010H\u0002J\u001a\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001e0\r2\n\u0010\u000f\u001a\u0006\u0012\u0002\b\u00030\u0010H\u0002J\u001c\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u001c0\u0010H\u0002J\u001c\u0010 \u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u001c0\u0010H\u0002J\u000e\u0010!\u001a\b\u0012\u0004\u0012\u00020\"0\rH\u0002J\u000e\u0010#\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0002J\u001c\u0010$\u001a\u0006\u0012\u0002\b\u00030\r2\u000e\u0010%\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030&H\u0002J9\u0010$\u001a\u0002H'\"\f\b\u0000\u0010'*\u0006\u0012\u0002\b\u00030\r2\u000e\u0010%\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030&2\f\u0010(\u001a\b\u0012\u0004\u0012\u0002H'0)H\u0016\u00a2\u0006\u0002\u0010*J:\u0010+\u001a\b\u0012\u0004\u0012\u0002H'0,\"\f\b\u0000\u0010'*\u0006\u0012\u0002\b\u00030\r2\u000e\u0010%\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030&2\f\u0010(\u001a\b\u0012\u0004\u0012\u0002H'0)H\u0016J\u0012\u0010-\u001a\u00020.2\b\u0010/\u001a\u0004\u0018\u000100H\u0016J\u0018\u00101\u001a\b\u0012\u0004\u0012\u00020.0,2\b\u0010/\u001a\u0004\u0018\u000100H\u0016JB\u00102\u001a\b\u0012\u0004\u0012\u0002H'03\"\f\b\u0000\u0010'*\u0006\u0012\u0002\b\u0003042\u000e\u0010%\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030&2\u0006\u00105\u001a\u00020\u000e2\f\u0010(\u001a\b\u0012\u0004\u0012\u0002H'0)H\u0016J\u000e\u00106\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0002R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00068"}, d2={"Lorg/web3j/evm/EmbeddedWeb3jService;", "Lorg/web3j/protocol/Web3jService;", "configuration", "Lorg/web3j/evm/Configuration;", "(Lorg/web3j/evm/Configuration;)V", "operationTracer", "Lorg/hyperledger/besu/ethereum/vm/OperationTracer;", "(Lorg/web3j/evm/Configuration;Lorg/hyperledger/besu/ethereum/vm/OperationTracer;)V", "embeddedEthereum", "Lorg/web3j/evm/EmbeddedEthereum;", "close", "", "estimateGas", "Lorg/web3j/protocol/core/Response;", "", "params", "", "ethBlockByHash", "Lorg/web3j/protocol/core/methods/response/EthBlock$Block;", "ethBlockByNumber", "ethBlockNumber", "ethCall", "ethGasPrice", "ethGetBalance", "ethGetBlockTransactionCountByHash", "ethGetBlockTransactionCountByNumber", "ethGetCode", "ethGetTransactionCount", "", "ethGetTransactionReceipt", "Lorg/web3j/protocol/core/methods/response/TransactionReceipt;", "ethSendRawTransaction", "ethSendTransaction", "ethSyncing", "Lorg/web3j/protocol/core/methods/response/EthSyncing$Result;", "netVersion", "send", "request", "Lorg/web3j/protocol/core/Request;", "T", "responseType", "Ljava/lang/Class;", "(Lorg/web3j/protocol/core/Request;Ljava/lang/Class;)Lorg/web3j/protocol/core/Response;", "sendAsync", "Ljava/util/concurrent/CompletableFuture;", "sendBatch", "Lorg/web3j/protocol/core/BatchResponse;", "p0", "Lorg/web3j/protocol/core/BatchRequest;", "sendBatchAsync", "subscribe", "Lio/reactivex/Flowable;", "Lorg/web3j/protocol/websocket/events/Notification;", "unsubscribeMethod", "web3ClientVersion", "Companion", "web3j-evm"})
public final class EmbeddedWeb3jService
implements Web3jService {
    private final EmbeddedEthereum embeddedEthereum;
    private static final Logger LOG;
    public static final Companion Companion;

    @NotNull
    public <T extends Response<?>> T send(@NotNull Request<?, ?> request, @NotNull Class<T> responseType) throws IOException {
        Intrinsics.checkNotNullParameter(request, (String)"request");
        Intrinsics.checkNotNullParameter(responseType, (String)"responseType");
        T t = responseType.cast(this.send(request));
        Intrinsics.checkNotNullExpressionValue(t, (String)"responseType.cast(send(request))");
        return (T)((Response)t);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final Response<?> send(Request<?, ?> request) {
        LOG.trace("About to execute: " + request.getMethod() + " with params " + request.getParams());
        String string = request.getMethod();
        if (string == null) throw (Throwable)new UnsupportedOperationException(request.getMethod());
        switch (string) {
            case "admin_nodeInfo": {
                throw (Throwable)new UnsupportedOperationException(request.getMethod());
            }
            case "db_getHex": {
                throw (Throwable)new UnsupportedOperationException(request.getMethod());
            }
            case "db_getString": {
                throw (Throwable)new UnsupportedOperationException(request.getMethod());
            }
            case "db_putHex": {
                throw (Throwable)new UnsupportedOperationException(request.getMethod());
            }
            case "db_putString": {
                throw (Throwable)new UnsupportedOperationException(request.getMethod());
            }
            case "eth_accounts": {
                throw (Throwable)new UnsupportedOperationException(request.getMethod());
            }
            case "eth_blockNumber": {
                Response<String> response = this.ethBlockNumber();
                return response;
            }
            case "eth_call": {
                List list = request.getParams();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"request.params");
                Response<String> response = this.ethCall(list);
                return response;
            }
            case "eth_coinbase": {
                throw (Throwable)new UnsupportedOperationException(request.getMethod());
            }
            case "eth_compileLLL": {
                throw (Throwable)new UnsupportedOperationException(request.getMethod());
            }
            case "eth_compileSerpent": {
                throw (Throwable)new UnsupportedOperationException(request.getMethod());
            }
            case "eth_compileSolidity": {
                throw (Throwable)new UnsupportedOperationException(request.getMethod());
            }
            case "eth_estimateGas": {
                List list = request.getParams();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"request.params");
                Response<String> response = this.estimateGas(list);
                return response;
            }
            case "eth_gasPrice": {
                Response<String> response = this.ethGasPrice();
                return response;
            }
            case "eth_getBalance": {
                List list = request.getParams();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"request.params");
                Response<String> response = this.ethGetBalance(list);
                return response;
            }
            case "eth_getBlockByHash": {
                List list = request.getParams();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"request.params");
                Response<String> response = this.ethBlockByHash(list);
                return response;
            }
            case "eth_getBlockByNumber": {
                List list = request.getParams();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"request.params");
                Response<String> response = this.ethBlockByNumber(list);
                return response;
            }
            case "eth_getBlockTransactionCountByHash": {
                List list = request.getParams();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"request.params");
                Response<String> response = this.ethGetBlockTransactionCountByHash(list);
                return response;
            }
            case "eth_getBlockTransactionCountByNumber": {
                List list = request.getParams();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"request.params");
                Response<String> response = this.ethGetBlockTransactionCountByNumber(list);
                return response;
            }
            case "eth_getCode": {
                List list = request.getParams();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"request.params");
                Response<String> response = this.ethGetCode(list);
                return response;
            }
            case "eth_getCompilers": {
                throw (Throwable)new UnsupportedOperationException(request.getMethod());
            }
            case "eth_getFilterChanges": {
                throw (Throwable)new UnsupportedOperationException(request.getMethod());
            }
            case "eth_getFilterLogs": {
                throw (Throwable)new UnsupportedOperationException(request.getMethod());
            }
            case "eth_getLogs": {
                throw (Throwable)new UnsupportedOperationException(request.getMethod());
            }
            case "eth_getStorageAt": {
                throw (Throwable)new UnsupportedOperationException(request.getMethod());
            }
            case "eth_getTransactionByBlockHashAndIndex": {
                throw (Throwable)new UnsupportedOperationException(request.getMethod());
            }
            case "eth_getTransactionByBlockNumberAndIndex": {
                throw (Throwable)new UnsupportedOperationException(request.getMethod());
            }
            case "eth_getTransactionByHash": {
                throw (Throwable)new UnsupportedOperationException(request.getMethod());
            }
            case "eth_getTransactionCount": {
                List list = request.getParams();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"request.params");
                Response<String> response = this.ethGetTransactionCount(list);
                return response;
            }
            case "eth_getTransactionReceipt": {
                List list = request.getParams();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"request.params");
                Response<String> response = this.ethGetTransactionReceipt(list);
                return response;
            }
            case "eth_getUncleByBlockHashAndIndex": {
                throw (Throwable)new UnsupportedOperationException(request.getMethod());
            }
            case "eth_getUncleByBlockNumberAndIndex": {
                throw (Throwable)new UnsupportedOperationException(request.getMethod());
            }
            case "eth_getUncleCountByBlockHash": {
                throw (Throwable)new UnsupportedOperationException(request.getMethod());
            }
            case "eth_getUncleCountByBlockNumber": {
                throw (Throwable)new UnsupportedOperationException(request.getMethod());
            }
            case "eth_getWork": {
                throw (Throwable)new UnsupportedOperationException(request.getMethod());
            }
            case "eth_hashrate": {
                throw (Throwable)new UnsupportedOperationException(request.getMethod());
            }
            case "eth_mining": {
                throw (Throwable)new UnsupportedOperationException(request.getMethod());
            }
            case "eth_newBlockFilter": {
                throw (Throwable)new UnsupportedOperationException(request.getMethod());
            }
            case "eth_newFilter": {
                throw (Throwable)new UnsupportedOperationException(request.getMethod());
            }
            case "eth_newPendingTransactionFilter": {
                throw (Throwable)new UnsupportedOperationException(request.getMethod());
            }
            case "eth_protocolVersion": {
                throw (Throwable)new UnsupportedOperationException(request.getMethod());
            }
            case "eth_sendRawTransaction": {
                List list = request.getParams();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"request.params");
                Response<String> response = this.ethSendRawTransaction(list);
                return response;
            }
            case "eth_sendTransaction": {
                List list = request.getParams();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"request.params");
                Response<String> response = this.ethSendTransaction(list);
                return response;
            }
            case "eth_sign": {
                throw (Throwable)new UnsupportedOperationException(request.getMethod());
            }
            case "eth_submitHashrate": {
                throw (Throwable)new UnsupportedOperationException(request.getMethod());
            }
            case "eth_submitWork": {
                throw (Throwable)new UnsupportedOperationException(request.getMethod());
            }
            case "eth_syncing": {
                Response<String> response = this.ethSyncing();
                return response;
            }
            case "eth_uninstallFilter": {
                throw (Throwable)new UnsupportedOperationException(request.getMethod());
            }
            case "net_listening": {
                throw (Throwable)new UnsupportedOperationException(request.getMethod());
            }
            case "net_peerCount": {
                throw (Throwable)new UnsupportedOperationException(request.getMethod());
            }
            case "net_version": {
                Response<String> response = this.netVersion();
                return response;
            }
            case "web3_clientVersion": {
                Response<String> response = this.web3ClientVersion();
                return response;
            }
            case "web3_sha3": {
                throw (Throwable)new UnsupportedOperationException(request.getMethod());
            }
            default: {
                throw (Throwable)new UnsupportedOperationException(request.getMethod());
            }
        }
    }

    private final Response<String> web3ClientVersion() {
        return (Response)new Web3ClientVersion(){

            @NotNull
            public String getResult() {
                String string = Numeric.encodeQuantity((BigInteger)BigInteger.ONE);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"Numeric.encodeQuantity(BigInteger.ONE)");
                return string;
            }
        };
    }

    private final Response<String> netVersion() {
        return (Response)new NetVersion(){

            @NotNull
            public String getResult() {
                String string = Numeric.encodeQuantity((BigInteger)BigInteger.ONE);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"Numeric.encodeQuantity(BigInteger.ONE)");
                return string;
            }
        };
    }

    private final Response<String> ethGasPrice() {
        return (Response)new EthGasPrice(){

            @NotNull
            public String getResult() {
                String string = Numeric.encodeQuantity((BigInteger)BigInteger.ONE);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"Numeric.encodeQuantity(BigInteger.ONE)");
                return string;
            }
        };
    }

    private final Response<String> ethGetTransactionCount(List<? extends Object> params) {
        Address address = new Address(params.get(0).toString());
        String result2 = Numeric.encodeQuantity((BigInteger)this.embeddedEthereum.getTransactionCount(address));
        return (Response)new EthGetTransactionCount(result2){
            final /* synthetic */ String $result;

            @NotNull
            public String getResult() {
                String string = this.$result;
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"result");
                return string;
            }
            {
                this.$result = $captured_local_variable$0;
            }
        };
    }

    private final Response<String> ethSendTransaction(List<? extends Object> params) {
        Object object = params.get(0);
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.web3j.protocol.core.methods.request.Transaction");
        }
        Transaction transaction = (Transaction)object;
        String result2 = this.embeddedEthereum.processTransaction(transaction);
        return (Response)new EthSendTransaction(result2){
            final /* synthetic */ String $result;

            @NotNull
            public String getResult() {
                return this.$result;
            }
            {
                this.$result = $captured_local_variable$0;
            }
        };
    }

    private final Response<String> ethSendRawTransaction(List<? extends Object> params) {
        Object object = params.get(0);
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.String");
        }
        String signedTransactionData = (String)object;
        String result2 = this.embeddedEthereum.processTransaction(signedTransactionData);
        return (Response)new EthSendTransaction(result2){
            final /* synthetic */ String $result;

            @NotNull
            public String getResult() {
                return this.$result;
            }
            {
                this.$result = $captured_local_variable$0;
            }
        };
    }

    private final Response<TransactionReceipt> ethGetTransactionReceipt(List<?> params) {
        Object obj = params.get(0);
        if (obj == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.String");
        }
        String transactionHash = (String)obj;
        TransactionReceipt result2 = this.embeddedEthereum.getTransactionReceipt(transactionHash);
        return (Response)new EthGetTransactionReceipt(result2){
            final /* synthetic */ TransactionReceipt $result;

            @Nullable
            public TransactionReceipt getResult() {
                return this.$result;
            }
            {
                this.$result = $captured_local_variable$0;
            }
        };
    }

    private final Response<String> ethCall(List<?> params) {
        Object obj = params.get(0);
        if (obj == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.web3j.protocol.core.methods.request.Transaction");
        }
        Transaction transaction = (Transaction)obj;
        String result2 = this.embeddedEthereum.ethCall(transaction);
        return (Response)new EthCall(result2){
            final /* synthetic */ String $result;

            @NotNull
            public String getResult() {
                return this.$result;
            }
            {
                this.$result = $captured_local_variable$0;
            }
        };
    }

    private final Response<String> estimateGas(List<?> params) {
        Object obj = params.get(0);
        if (obj == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.web3j.protocol.core.methods.request.Transaction");
        }
        Transaction transaction = (Transaction)obj;
        String result2 = this.embeddedEthereum.estimateGas(transaction);
        return (Response)new EthEstimateGas(result2){
            final /* synthetic */ String $result;

            @NotNull
            public String getResult() {
                return this.$result;
            }
            {
                this.$result = $captured_local_variable$0;
            }
        };
    }

    private final Response<String> ethBlockNumber() {
        String result2 = this.embeddedEthereum.ethBlockNumber();
        return (Response)new EthBlockNumber(result2){
            final /* synthetic */ String $result;

            @NotNull
            public String getResult() {
                return this.$result;
            }
            {
                this.$result = $captured_local_variable$0;
            }
        };
    }

    private final Response<String> ethGetBalance(List<?> params) {
        Object obj = params.get(0);
        if (obj == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.String");
        }
        String address = (String)obj;
        Object obj2 = params.get(1);
        if (obj2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.String");
        }
        String defaultBlockParameter = (String)obj2;
        String result2 = this.embeddedEthereum.ethGetBalance(new Address(address), defaultBlockParameter);
        return (Response)new EthGetBalance(result2){
            final /* synthetic */ String $result;

            @Nullable
            public String getResult() {
                return this.$result;
            }
            {
                this.$result = $captured_local_variable$0;
            }
        };
    }

    private final Response<EthBlock.Block> ethBlockByHash(List<?> params) {
        Object obj = params.get(0);
        if (obj == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.String");
        }
        String hash = (String)obj;
        Object obj2 = params.get(1);
        if (obj2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Boolean");
        }
        boolean fullTransactionObjects = (Boolean)obj2;
        EthBlock.Block result2 = this.embeddedEthereum.ethBlockByHash(hash, fullTransactionObjects);
        return (Response)new EthBlock(result2){
            final /* synthetic */ EthBlock.Block $result;

            @Nullable
            public EthBlock.Block getResult() {
                return this.$result;
            }
            {
                this.$result = $captured_local_variable$0;
            }
        };
    }

    private final Response<EthBlock.Block> ethBlockByNumber(List<?> params) {
        Object obj = params.get(0);
        if (obj == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.String");
        }
        String blockNumber = (String)obj;
        Object obj2 = params.get(1);
        if (obj2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Boolean");
        }
        boolean fullTransactionObjects = (Boolean)obj2;
        EthBlock.Block result2 = this.embeddedEthereum.ethBlockByNumber(blockNumber, fullTransactionObjects);
        return (Response)new EthBlock(result2){
            final /* synthetic */ EthBlock.Block $result;

            @Nullable
            public EthBlock.Block getResult() {
                return this.$result;
            }
            {
                this.$result = $captured_local_variable$0;
            }
        };
    }

    private final Response<String> ethGetBlockTransactionCountByHash(List<?> params) {
        Object obj = params.get(0);
        if (obj == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.String");
        }
        String blockHash = (String)obj;
        Hash hash = Hash.fromHexString((String)blockHash);
        Intrinsics.checkNotNullExpressionValue((Object)hash, (String)"Hash.fromHexString(blockHash)");
        String result2 = this.embeddedEthereum.ethGetBlockTransactionCountByHash(hash);
        return (Response)new EthGetBlockTransactionCountByHash(result2){
            final /* synthetic */ String $result;

            @NotNull
            public String getResult() {
                return this.$result;
            }
            {
                this.$result = $captured_local_variable$0;
            }
        };
    }

    private final Response<String> ethGetCode(List<?> params) {
        Object obj = params.get(0);
        if (obj == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.String");
        }
        String address = (String)obj;
        Object obj2 = params.get(1);
        if (obj2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.String");
        }
        String defaultBlockParameter = (String)obj2;
        String result2 = this.embeddedEthereum.ethGetCode(new Address(address), defaultBlockParameter);
        return (Response)new EthGetCode(result2){
            final /* synthetic */ String $result;

            @NotNull
            public String getResult() {
                return this.$result;
            }
            {
                this.$result = $captured_local_variable$0;
            }
        };
    }

    private final Response<String> ethGetBlockTransactionCountByNumber(List<?> params) {
        Object obj = params.get(0);
        if (obj == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.String");
        }
        BigInteger blockNumber = Numeric.decodeQuantity((String)((String)obj));
        String result2 = this.embeddedEthereum.ethGetBlockTransactionCountByNumber(blockNumber.longValue());
        return (Response)new EthGetBlockTransactionCountByNumber(result2){
            final /* synthetic */ String $result;

            @NotNull
            public String getResult() {
                return this.$result;
            }
            {
                this.$result = $captured_local_variable$0;
            }
        };
    }

    private final Response<EthSyncing.Result> ethSyncing() {
        return (Response)new EthSyncing(){

            @NotNull
            public EthSyncing.Result getResult() {
                EthSyncing.Result result2 = new EthSyncing.Result();
                boolean bl = false;
                boolean bl2 = false;
                EthSyncing.Result $this$apply = result2;
                boolean bl3 = false;
                $this$apply.setSyncing(true);
                return result2;
            }
        };
    }

    @NotNull
    public BatchResponse sendBatch(@Nullable BatchRequest p0) {
        throw (Throwable)new UnsupportedOperationException("Batch send is not supported");
    }

    @NotNull
    public CompletableFuture<BatchResponse> sendBatchAsync(@Nullable BatchRequest p0) {
        throw (Throwable)new UnsupportedOperationException("Batch send is not supported");
    }

    @NotNull
    public <T extends Response<?>> CompletableFuture<T> sendAsync(@NotNull Request<?, ?> request, @NotNull Class<T> responseType) {
        Intrinsics.checkNotNullParameter(request, (String)"request");
        Intrinsics.checkNotNullParameter(responseType, (String)"responseType");
        CompletableFuture completableFuture = Async.run((Callable)new Callable<T>(this, request, responseType){
            final /* synthetic */ EmbeddedWeb3jService this$0;
            final /* synthetic */ Request $request;
            final /* synthetic */ Class $responseType;

            public final T call() {
                return this.this$0.send(this.$request, this.$responseType);
            }
            {
                this.this$0 = embeddedWeb3jService;
                this.$request = request;
                this.$responseType = clazz;
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)completableFuture, (String)"Async.run { send(request, responseType) }");
        return completableFuture;
    }

    @NotNull
    public <T extends Notification<?>> Flowable<T> subscribe(@NotNull Request<?, ?> request, @NotNull String unsubscribeMethod, @NotNull Class<T> responseType) {
        Intrinsics.checkNotNullParameter(request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)unsubscribeMethod, (String)"unsubscribeMethod");
        Intrinsics.checkNotNullParameter(responseType, (String)"responseType");
        StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
        String string = "Service %s does not support subscriptions";
        Object[] objectArray = new Object[]{this.getClass().getSimpleName()};
        boolean bl = false;
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"java.lang.String.format(format, *args)");
        throw (Throwable)new UnsupportedOperationException(string2);
    }

    public void close() throws IOException {
    }

    public EmbeddedWeb3jService(@NotNull Configuration configuration, @NotNull OperationTracer operationTracer) {
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)operationTracer, (String)"operationTracer");
        this.embeddedEthereum = new EmbeddedEthereum(configuration, operationTracer);
    }

    public EmbeddedWeb3jService(@NotNull Configuration configuration) {
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        this(configuration, new PassthroughTracer(null, 1, null));
    }

    static {
        Companion = new Companion(null);
        LOG = LoggerFactory.getLogger(EmbeddedWeb3jService.class);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/web3j/evm/EmbeddedWeb3jService$Companion;", "", "()V", "LOG", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "web3j-evm"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

