/*
 * Decompiled with CFR 0.152.
 */
package org.web3j.mavenplugin.solidity;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.Scanner;

public class SolC {
    private File solc = null;
    private String canonicalPath;
    private String canonicalWorkingDirectory;
    private File workingDirectory;

    SolC() {
        try {
            this.initBundled();
            this.canonicalPath = this.solc.getCanonicalPath();
            this.canonicalWorkingDirectory = this.solc.getParentFile().getCanonicalPath();
            this.workingDirectory = this.solc.getParentFile();
        }
        catch (IOException e) {
            throw new RuntimeException("Can't init solc compiler: ", e);
        }
    }

    private void initBundled() throws IOException {
        File tmpDir = new File(System.getProperty("java.io.tmpdir"), "solc");
        tmpDir.setReadable(true);
        tmpDir.setWritable(true);
        tmpDir.setExecutable(true);
        tmpDir.mkdirs();
        String solcPath = "/native/" + this.getOS() + "/solc/";
        InputStream is = this.getClass().getResourceAsStream(solcPath + "file.list");
        Scanner scanner = new Scanner(is);
        while (scanner.hasNext()) {
            String s = scanner.next();
            File targetFile = new File(tmpDir, s);
            InputStream fis = this.getClass().getResourceAsStream(solcPath + s);
            Files.copy(fis, targetFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
            if (this.solc == null) {
                this.solc = targetFile;
                this.solc.setExecutable(true);
            }
            targetFile.deleteOnExit();
        }
        tmpDir.deleteOnExit();
    }

    private String getOS() {
        String osName = System.getProperty("os.name").toLowerCase();
        if (osName.contains("win")) {
            return "win";
        }
        if (osName.contains("linux")) {
            return "linux";
        }
        if (osName.contains("mac")) {
            return "mac";
        }
        throw new RuntimeException("Can't find solc compiler: unrecognized OS: " + osName);
    }

    public String getCanonicalPath() {
        return this.canonicalPath;
    }

    public String getCanonicalWorkingDirectory() {
        return this.canonicalWorkingDirectory;
    }

    public File getWorkingDirectory() {
        return this.workingDirectory;
    }
}

