/*
 * Decompiled with CFR 0.152.
 */
package org.web3j.mavenplugin.solidity;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Scanner;
import java.util.stream.Collectors;
import org.apache.maven.plugin.logging.Log;
import org.web3j.mavenplugin.solidity.CompilerResult;
import org.web3j.mavenplugin.solidity.SolC;

public class SolidityCompiler {
    private SolC solc;
    private Log LOG;
    private static SolidityCompiler INSTANCE;

    private SolidityCompiler(Log log) {
        this.LOG = log;
        if (!this.solidityCompilerExists()) {
            this.LOG.info((CharSequence)"Solidity Compiler from library is used");
            this.solc = new SolC();
        }
    }

    public static SolidityCompiler getInstance(Log log) {
        if (INSTANCE == null) {
            INSTANCE = new SolidityCompiler(log);
        }
        return INSTANCE;
    }

    public CompilerResult compileSrc(String rootDirectory, Collection<String> sources, Options ... options) {
        String output;
        String error;
        boolean success = false;
        try {
            Process process = this.solc != null ? this.getSolCProcessFromLibrary(rootDirectory, sources, options) : this.getSolCProcessFromSystem(rootDirectory, sources, options);
            ParallelReader errorReader = new ParallelReader(process.getErrorStream());
            ParallelReader outputReader = new ParallelReader(process.getInputStream());
            errorReader.start();
            outputReader.start();
            success = process.waitFor() == 0;
            error = errorReader.getContent();
            output = outputReader.getContent();
        }
        catch (IOException | InterruptedException e) {
            StringWriter errorWriter = new StringWriter();
            e.printStackTrace(new PrintWriter(errorWriter));
            error = errorWriter.toString();
            output = "";
        }
        return new CompilerResult(error, output, success);
    }

    private Process getSolCProcessFromLibrary(String rootDirectory, Collection<String> sources, Options[] options) throws IOException {
        assert (this.solc != null);
        String canonicalSolCPath = this.solc.getCanonicalPath();
        List<String> commandParts = this.prepareCommandOptions(canonicalSolCPath, rootDirectory, sources, options);
        this.LOG.warn((CharSequence)("Issue with travis [canonicalSolCPath=" + canonicalSolCPath + ",commandParts=" + commandParts.stream().collect(Collectors.joining(",")) + "],getWorkingDirectory=" + this.solc.getWorkingDirectory().getAbsolutePath() + "]"));
        Files.list(this.solc.getWorkingDirectory().toPath()).forEach(file -> this.LOG.warn((CharSequence)file.toString()));
        ProcessBuilder processBuilder = new ProcessBuilder(commandParts).directory(this.solc.getWorkingDirectory());
        processBuilder.environment().put("LD_LIBRARY_PATH", this.solc.getCanonicalWorkingDirectory());
        Process process = processBuilder.start();
        return process;
    }

    private Process getSolCProcessFromSystem(String rootDirectory, Collection<String> sources, Options[] options) throws IOException {
        List<String> commandParts = this.prepareCommandOptions("solc", rootDirectory, sources, options);
        Process process = Runtime.getRuntime().exec(commandParts.toArray(new String[commandParts.size()]));
        return process;
    }

    private List<String> prepareCommandOptions(String canonicalSolCPath, String rootDirectory, Collection<String> sources, Options ... options) {
        ArrayList<String> commandParts = new ArrayList<String>();
        commandParts.add(canonicalSolCPath);
        commandParts.add("--optimize");
        commandParts.add("--combined-json");
        commandParts.add(Arrays.stream(options).map(option -> option.toString()).collect(Collectors.joining(",")));
        commandParts.add("--allow-paths");
        commandParts.add(Paths.get(rootDirectory, new String[0]).toFile().getAbsolutePath());
        sources.forEach(f -> commandParts.add(Paths.get(rootDirectory, f).toFile().getAbsolutePath()));
        return commandParts;
    }

    private boolean solidityCompilerExists() {
        try {
            String output;
            Process p = Runtime.getRuntime().exec("solc --version");
            try (Scanner s = new Scanner(p.getInputStream());){
                output = s.useDelimiter("\\A").hasNext() ? s.next() : "";
            }
            if (p.waitFor() == 0) {
                this.LOG.info((CharSequence)"Solidity Compiler found");
                this.LOG.debug((CharSequence)output);
                return true;
            }
            this.LOG.error((CharSequence)output);
        }
        catch (IOException | InterruptedException e) {
            this.LOG.info((CharSequence)"Solidity Compiler not installed.");
        }
        return false;
    }

    private static class ParallelReader
    extends Thread {
        private InputStream stream;
        private String content;

        ParallelReader(InputStream stream) {
            this.stream = stream;
        }

        public String getContent() {
            return this.getContent(true);
        }

        public synchronized String getContent(boolean waitForComplete) {
            if (waitForComplete) {
                while (this.stream != null) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        return null;
                    }
                }
            }
            return this.content;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try (BufferedReader buffer = new BufferedReader(new InputStreamReader(this.stream));){
                this.content = buffer.lines().collect(Collectors.joining(System.lineSeparator()));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            finally {
                ParallelReader parallelReader = this;
                synchronized (parallelReader) {
                    this.stream = null;
                    this.notifyAll();
                }
            }
        }
    }

    public static enum Options {
        BIN("bin"),
        INTERFACE("interface"),
        ABI("abi"),
        METADATA("metadata");

        private String name;

        private Options(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public String toString() {
            return this.name;
        }
    }
}

