/*
 * Decompiled with CFR 0.152.
 */
package org.web3j.mavenplugin.solidity;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.Scanner;
import java.util.regex.Matcher;
import org.apache.commons.lang3.StringUtils;
import org.web3j.mavenplugin.solidity.Constant;

public class SolC {
    private File solc;
    private String canonicalPath;
    private String canonicalWorkingDirectory;
    private File workingDirectory;
    private String version;

    SolC() {
        try {
            this.solc = this.initBundled();
            this.canonicalPath = this.solc.getCanonicalPath();
            this.canonicalWorkingDirectory = this.solc.getParentFile().getCanonicalPath();
            this.workingDirectory = this.solc.getParentFile();
        }
        catch (IOException e) {
            throw new RuntimeException("Can't init solc compiler: ", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String evaluateSolCVersion() {
        try {
            Process p = Runtime.getRuntime().exec(this.getCanonicalPath() + " --version");
            try (Scanner s = new Scanner(p.getInputStream());){
                String output = s.useDelimiter("\\A").hasNext() ? s.next() : "";
                if (p.waitFor() != 0) throw new RuntimeException("Could not evaluate SolC Version from '" + this.getCanonicalPath() + "'");
                Matcher matcher = Constant.SOLC_VERSION_PATTERN.matcher(output);
                if (!matcher.find()) throw new RuntimeException("Could not evaluate SolC Version from '" + this.getCanonicalPath() + "'");
                String string2 = matcher.group(1);
                return string2;
            }
        }
        catch (IOException | InterruptedException e) {
            throw new RuntimeException("Could not evaluate SolC Version from '" + this.getCanonicalPath() + "'", e);
        }
    }

    public String getCanonicalPath() {
        return this.canonicalPath;
    }

    public String getCanonicalWorkingDirectory() {
        return this.canonicalWorkingDirectory;
    }

    private String getOS() {
        String osName = System.getProperty("os.name").toLowerCase();
        if (osName.contains("win")) {
            return "win";
        }
        if (osName.contains("linux")) {
            return "linux";
        }
        if (osName.contains("mac")) {
            return "mac";
        }
        throw new RuntimeException("Can't find solc compiler: unrecognized OS: " + osName);
    }

    public String getVersion() {
        if (StringUtils.isEmpty((CharSequence)this.version)) {
            this.version = this.evaluateSolCVersion();
        }
        return this.version;
    }

    public File getWorkingDirectory() {
        return this.workingDirectory;
    }

    private File initBundled() throws IOException {
        File solC = null;
        File tmpDir = new File(System.getProperty("java.io.tmpdir"), "solc");
        tmpDir.setReadable(true);
        tmpDir.setWritable(true);
        tmpDir.setExecutable(true);
        tmpDir.mkdirs();
        String solcPath = "/native/" + this.getOS() + "/solc/";
        InputStream is = this.getClass().getResourceAsStream(solcPath + "file.list");
        Scanner scanner = new Scanner(is);
        if (scanner.hasNext()) {
            String s = scanner.next();
            File targetFile = new File(tmpDir, s);
            InputStream fis = this.getClass().getResourceAsStream(solcPath + s);
            Files.copy(fis, targetFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
            solC = targetFile;
            solC.setExecutable(true);
            targetFile.deleteOnExit();
        }
        tmpDir.deleteOnExit();
        return solC;
    }
}

