/*
 * Decompiled with CFR 0.152.
 */
package org.web3j.sokt;

import com.github.zafarkhaja.semver.Version;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.HttpsURLConnection;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Charsets;
import kotlin.text.Regex;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.ShorthandsKt;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonConfiguration;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.web3j.sokt.SolcRelease;
import org.web3j.sokt.VersionResolver;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0011\u0010\u0005\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u0003H\u0086\u0002J\"\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u00032\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\t0\bJ\u0012\u0010\f\u001a\u0004\u0018\u00010\t2\b\u0010\n\u001a\u0004\u0018\u00010\u0003J\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\t0\bJ\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00030\b2\u0006\u0010\u000f\u001a\u00020\u0003R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/web3j/sokt/VersionResolver;", "", "directoryPath", "", "(Ljava/lang/String;)V", "get", "uri", "getCompatibleVersions", "", "Lorg/web3j/sokt/SolcRelease;", "pragmaRequirement", "releases", "getLatestCompatibleVersion", "getSolcReleases", "versionsFromString", "input", "web3j-sokt"})
public final class VersionResolver {
    private final String directoryPath;

    @NotNull
    public final String get(@NotNull String uri) {
        Intrinsics.checkParameterIsNotNull((Object)uri, (String)"uri");
        URLConnection uRLConnection = new URL(uri).openConnection();
        if (uRLConnection == null) {
            throw new TypeCastException("null cannot be cast to non-null type javax.net.ssl.HttpsURLConnection");
        }
        HttpsURLConnection con = (HttpsURLConnection)uRLConnection;
        con.setConnectTimeout((int)TimeUnit.MILLISECONDS.toMillis(200L));
        con.setReadTimeout((int)TimeUnit.SECONDS.toMillis(1L));
        con.setRequestMethod("GET");
        con.setRequestProperty("Content-Type", "application/json");
        con.setRequestProperty("Accept", "application/json");
        con.setDoOutput(true);
        BufferedReader reader = new BufferedReader(new InputStreamReader(con.getInputStream()));
        Ref.ObjectRef inputLine = new Ref.ObjectRef();
        StringBuffer response = new StringBuffer();
        while (true) {
            String string = reader.readLine();
            boolean bl = false;
            boolean bl2 = false;
            String it = string;
            boolean bl3 = false;
            inputLine.element = it;
            if (string == null) break;
            response.append((String)inputLine.element);
        }
        reader.close();
        String string = response.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"response.toString()");
        return string;
    }

    @NotNull
    public final List<SolcRelease> getSolcReleases() {
        File versionsFile = Paths.get(System.getProperty("user.home"), this.directoryPath, "solc", "releases.json").toFile();
        try {
            String result2 = this.get("https://raw.githubusercontent.com/web3j/web3j-sokt/master/src/main/resources/releases.json");
            File file = versionsFile;
            Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"versionsFile");
            file.getParentFile().mkdirs();
            FilesKt.writeText$default((File)versionsFile, (String)result2, null, (int)2, null);
            return (List)new Json(JsonConfiguration.Companion.getStable(), null, 2, null).parse((DeserializationStrategy)ShorthandsKt.getList(SolcRelease.Companion.serializer()), result2);
        }
        catch (Exception e) {
            List list;
            if (versionsFile.exists()) {
                Json json = new Json(JsonConfiguration.Companion.getStable(), null, 2, null);
                DeserializationStrategy deserializationStrategy = (DeserializationStrategy)ShorthandsKt.getList(SolcRelease.Companion.serializer());
                File file = versionsFile;
                Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"versionsFile");
                list = (List)json.parse(deserializationStrategy, FilesKt.readText$default((File)file, null, (int)1, null));
            } else {
                URL uRL = ClassLoader.getSystemResource("releases.json");
                Intrinsics.checkExpressionValueIsNotNull((Object)uRL, (String)"ClassLoader.getSystemResource(\"releases.json\")");
                URL uRL2 = uRL;
                Charset charset = Charsets.UTF_8;
                boolean bl = false;
                byte[] byArray = TextStreamsKt.readBytes((URL)uRL2);
                boolean bl2 = false;
                boolean bl3 = false;
                String defaultReleases = new String(byArray, charset);
                list = (List)new Json(JsonConfiguration.Companion.getStable(), null, 2, null).parse((DeserializationStrategy)ShorthandsKt.getList(SolcRelease.Companion.serializer()), defaultReleases);
            }
            return list;
        }
    }

    @NotNull
    public final List<String> versionsFromString(@NotNull String input) {
        Intrinsics.checkParameterIsNotNull((Object)input, (String)"input");
        return SequencesKt.toList((Sequence)SequencesKt.map((Sequence)SequencesKt.filter((Sequence)Regex.findAll$default((Regex)new Regex("\\s*[\\^<>=~!]{0,3}\\s*(\\d*(\\.?)\\s*){1,3}"), (CharSequence)input, (int)0, (int)2, null), (Function1)versionsFromString.1.INSTANCE), (Function1)versionsFromString.2.INSTANCE));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<SolcRelease> getCompatibleVersions(@NotNull String pragmaRequirement, @NotNull List<SolcRelease> releases) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkParameterIsNotNull((Object)pragmaRequirement, (String)"pragmaRequirement");
        Intrinsics.checkParameterIsNotNull(releases, (String)"releases");
        List<String> requiredVersions = this.versionsFromString(pragmaRequirement);
        Iterable $this$filter$iv = releases;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            boolean bl;
            block4: {
                SolcRelease it = (SolcRelease)element$iv$iv;
                boolean bl2 = false;
                Iterable $this$all$iv = requiredVersions;
                boolean $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$all$iv) {
                        String nr = (String)element$iv;
                        boolean bl3 = false;
                        if (Version.valueOf((String)it.getVersion()).satisfies(nr) && it.isCompatibleWithOs()) continue;
                        bl = false;
                        break block4;
                    }
                    bl = true;
                }
            }
            if (!bl) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @Nullable
    public final SolcRelease getLatestCompatibleVersion(@Nullable String pragmaRequirement) {
        List<SolcRelease> solcReleases = this.getSolcReleases();
        return pragmaRequirement != null ? (SolcRelease)CollectionsKt.lastOrNull(this.getCompatibleVersions(pragmaRequirement, solcReleases)) : (SolcRelease)CollectionsKt.last(solcReleases);
    }

    public VersionResolver(@NotNull String directoryPath) {
        Intrinsics.checkParameterIsNotNull((Object)directoryPath, (String)"directoryPath");
        this.directoryPath = directoryPath;
    }

    public /* synthetic */ VersionResolver(String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            string = ".web3j";
        }
        this(string);
    }

    public VersionResolver() {
        this(null, 1, null);
    }
}

