import { default as BaseComponent } from 'bootstrap/js/dist/base-component'
import { type GetInstanceFactory, type GetOrCreateInstanceFactory } from 'bootstrap/js/dist/base-component';

declare class HistoryBack extends BaseComponent {
  static get NAME(): string
  /**
   * Static method which allows you to get the instance associated
   * with a DOM element.
   */
  static getInstance: GetInstanceFactory<HistoryBack>;
  /**
   * Static method which allows you to get the modal instance associated with
   * a DOM element, or create a new one in case it wasn’t initialised
   */
  static getOrCreateInstance: GetOrCreateInstanceFactory<HistoryBack>;

  constructor(element: HTMLElement)

  back(): void

  _bindEvents(): void
}

export { HistoryBack }
