/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['jquery.sap.global','./P13nConditionPanel','./P13nPanel','./library','sap/ui/core/Control'],function(q,P,a,l,C){"use strict";var c=a.extend("sap.m.P13nGroupPanel",{metadata:{library:"sap.m",properties:{maxGroups:{type:"string",group:"Misc",defaultValue:'-1'},containerQuery:{type:"boolean",group:"Misc",defaultValue:false},layoutMode:{type:"string",group:"Misc",defaultValue:null}},aggregations:{content:{type:"sap.ui.core.Control",multiple:true,singularName:"content",visibility:"hidden"},groupItems:{type:"sap.m.P13nGroupItem",multiple:true,singularName:"groupItem",bindable:"bindable"}},events:{addGroupItem:{parameters:{}},removeGroupItem:{},updateGroupItem:{}}}});c.prototype.setMaxGroups=function(m){this.setProperty("maxGroups",m);if(this._oGroupPanel){this._oGroupPanel.setMaxConditions(m);}};c.prototype._getConditions=function(){return this._oGroupPanel.getConditions();};c.prototype.setContainerQuery=function(b){this.setProperty("containerQuery",b);this._oGroupPanel.setContainerQuery(b);};c.prototype.setLayoutMode=function(m){this.setProperty("layoutMode",m);this._oGroupPanel.setLayoutMode(m);};c.prototype.validateConditions=function(){return this._oGroupPanel.validateConditions();};c.prototype.removeInvalidConditions=function(){this._oGroupPanel.removeInvalidConditions();};c.prototype.removeValidationErrors=function(){this._oGroupPanel.removeValidationErrors();};c.prototype.onBeforeNavigationFrom=function(){return this.validateConditions();};c.prototype.onAfterNavigationFrom=function(){return this.removeInvalidConditions();};c.prototype.setOperations=function(o){this._aOperations=o;if(this._oGroupPanel){this._oGroupPanel.setOperations(this._aOperations);}};c.prototype.init=function(){sap.ui.getCore().loadLibrary("sap.ui.layout");q.sap.require("sap.ui.layout.Grid");sap.ui.layout.Grid.prototype.init.apply(this);this._aKeyFields=[];this.addStyleClass("sapMGroupPanel");if(!this._aOperations){this.setOperations([sap.m.P13nConditionOperation.GroupAscending,sap.m.P13nConditionOperation.GroupDescending]);}this._oGroupPanel=new P({maxConditions:this.getMaxGroups(),autoReduceKeyFieldItems:true,layoutMode:this.getLayoutMode(),dataChange:this._handleDataChange()});this._oGroupPanel.setOperations(this._aOperations);this.addAggregation("content",this._oGroupPanel);};c.prototype.exit=function(){this._aKeyFields=null;this._aOperations=null;};c.prototype.addItem=function(i){a.prototype.addItem.apply(this,arguments);var k={key:i.getColumnKey(),text:i.getText(),tooltip:i.getTooltip()};this._aKeyFields.push(k);if(this._oGroupPanel){this._oGroupPanel.addKeyField(k);}};c.prototype.destroyItems=function(){this.destroyAggregation("items");if(this._oGroupPanel){this._oGroupPanel.removeAllKeyFields();}return this;};c.prototype.addGroupItem=function(g){this.addAggregation("groupItems",g);var b=[];this.getGroupItems().forEach(function(G){b.push({key:G.getKey(),keyField:G.getColumnKey(),operation:G.getOperation(),showIfGrouped:G.getShowIfGrouped()});});if(!this._bIgnoreBindCalls){this._oGroupPanel.setConditions(b);}};c.prototype.insertGroupItem=function(g){this.insertAggregation("groupItems",g);return this;};c.prototype.removeGroupItem=function(g){g=this.removeAggregation("groupItems",g);return g;};c.prototype.removeAllGroupItems=function(){var g=this.removeAllAggregation("groupItems");this._oGroupPanel.setConditions([]);return g;};c.prototype.destroyGroupItems=function(){this.destroyAggregation("groupItems");if(!this._bIgnoreBindCalls){this._oGroupPanel.setConditions([]);}return this;};c.prototype._handleDataChange=function(){var t=this;return function(e){var n=e.getParameter("newData");var o=e.getParameter("operation");var k=e.getParameter("key");var i=e.getParameter("index");var g=null;if(n){g=new sap.m.P13nGroupItem({key:k,columnKey:n.keyField,operation:n.operation,showIfGrouped:n.showIfGrouped});}if(o==="update"){var G=t.getGroupItems()[i];if(G){G.setColumnKey(n.keyField);G.setOperation(n.operation);G.setShowIfGrouped(n.showIfGrouped);}t.fireUpdateGroupItem({key:k,index:i,groupItemData:g});}if(o==="add"){t._bIgnoreBindCalls=true;t.fireAddGroupItem({key:k,index:i,groupItemData:g});t._bIgnoreBindCalls=false;}if(o==="remove"){t.fireRemoveGroupItem({key:k,index:i});}};};return c;},true);
