/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['jquery.sap.global','./library','sap/ui/core/Control','sap/ui/core/EnabledPropagator','sap/ui/core/delegate/ItemNavigation'],function(q,l,C,E,I){"use strict";var S=C.extend("sap.m.SegmentedButton",{metadata:{library:"sap.m",properties:{width:{type:"sap.ui.core.CSSSize",group:"Misc",defaultValue:null},enabled:{type:"boolean",group:"Behavior",defaultValue:true},selectedKey:{type:"string",group:"Data",defaultValue:"",bindable:"bindable"}},defaultAggregation:"buttons",aggregations:{buttons:{type:"sap.m.Button",multiple:true,singularName:"button"},items:{type:"sap.m.SegmentedButtonItem",multiple:true,singularName:"item",bindable:"bindable"}},associations:{selectedButton:{type:"sap.m.Button",multiple:false},ariaDescribedBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaDescribedBy"},ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}},events:{select:{parameters:{button:{type:"sap.m.Button"},id:{type:"string"},key:{type:"string"}}}}}});E.call(S.prototype);S.prototype.init=function(){if(sap.ui.Device.browser.internet_explorer&&sap.ui.Device.browser.version<=10){this._isMie=true;}this._aButtonWidth=[];this._oGhostButton=null;this._createGhostButton();this._oItemNavigation=new I();this._oItemNavigation.setCycling(false);this.addDelegate(this._oItemNavigation);this.removeButton=function(b){S.prototype.removeButton.call(this,b);this.setSelectedButton(this.getButtons()[0]);};};S.prototype._createGhostButton=function(b){if(q("#segMtBtn_calc").length==0){this._oGhostButton=document.createElement("ul");var $=q("<li>");$.addClass("sapMBtnContent sapMSegBBtn");this._oGhostButton.setAttribute("id","segMtBtn_calc");q(this._oGhostButton).append($).addClass("sapMSegBIcons sapMBtn sapMBtnDefault sapMBtnPaddingLeft");this._oGhostButton=q(this._oGhostButton);}else{this._oGhostButton=q("#segMtBtn_calc");}};S.prototype._setGhostButtonText=function(b){var t=b.getText(),i=b.getIcon(),o,a,h,r,g=0,$=q("#segMtBtn_calc").find("li");$.text(t);if(i.length>0){r=new sap.ui.core.RenderManager();o=b._getImage(null,b.getIcon());if(o instanceof sap.m.Image){h=r.getHTML(o);$.prepend(h);}else{a=new sap.ui.core.Icon({src:i});h=r.getHTML(a);$.prepend(h);}}if(b.getWidth().length===0){if(sap.ui.getCore().getConfiguration().getLanguage()==="ar"){g=1;}g+=$.outerWidth();this._aButtonWidth.push(g);}else{this._aButtonWidth.push(0);}};S.prototype._addGhostButton=function(){this._createGhostButton();if(q("#segMtBtn_calc").length===0){var s=sap.ui.getCore().getStaticAreaRef();s.appendChild(this._oGhostButton[0]);}};S.prototype._removeGhostButton=function(){var t=this;sap.m.SegmentedButton._ghostTimer=window.setTimeout(function(){q("#segMtBtn_calc").remove();t._oGhostButton=null;sap.m.SegmentedButton._ghostTimer=null;},1000);};S.prototype._getButtonWidths=function(){var b=this.getButtons(),i=0;if(this._oGhostButton&&this._oGhostButton.length==0){return;}else{for(;i<b.length;i++){this._setGhostButtonText(b[i]);}}};S.prototype.onBeforeRendering=function(){var s=sap.ui.getCore().getStaticAreaRef();this._aButtonWidth=[];if(this._sResizeListenerId){sap.ui.core.ResizeHandler.deregister(this._sResizeListenerId);this._sResizeListenerId=null;}if(q("#segMtBtn_calc").length===0&&this._oGhostButton){s.appendChild(this._oGhostButton[0]);this._removeGhostButton();}this.setSelectedKey(this.getProperty("selectedKey"));if(!this.getSelectedButton()){this._selectDefaultButton();}};S.prototype.onAfterRendering=function(){if(!this._sResizeListenerId){var p=this.getParent(),P=null;if(p instanceof C){P=p.getDomRef();}else if(p instanceof sap.ui.core.UIArea){P=p.getRootNode();}if(P){this._sResizeListenerId=sap.ui.core.ResizeHandler.register(P,q.proxy(this._fHandleResize,this));}}this._getButtonWidths();this._bInsidePopup=(this.$().closest(".sapMPopup-CTX").length>0);this._bInsideBar=(this.$().closest('.sapMIBar').length>0)?true:false;this._bInsideDialog=(this.$().closest('.sapMDialogScrollCont').length>0);var b=this.getButtons();var a=true;var t=this;for(var i=0;i<b.length;i++){if(b[i].getIcon()===""){a=false;}b[i].$().attr("aria-posinset",i+1).attr("aria-setsize",b.length);}if(a){this.$().toggleClass("sapMSegBIcons",true);}if(this._isMie||this._bInsideDialog){setTimeout(function(){t._fCalcBtnWidth();},0);}else{t._fCalcBtnWidth();}this.$().removeClass("sapMSegBHide");this._setItemNavigation();};S.prototype.onThemeChanged=function(e){};S.prototype._fCalcBtnWidth=function(){if(!sap.m.SegmentedButton._ghostTimer){this._addGhostButton();}else{window.clearTimeout(sap.m.SegmentedButton._ghostTimer);sap.m.SegmentedButton._ghostTimer=null;}var a=this.getButtons().length;if(a===0||!this.$().is(":visible")){return;}var m=5,$=this.$(),p=0,c=$.outerWidth(true)-$.width(),b=$.closest('.sapMBarContainer').outerWidth()-$.closest('.sapMBarContainer').width(),B=2,d=$.children('#'+this.getButtons()[0].getId()).outerWidth(true)-$.children('#'+this.getButtons()[0].getId()).width(),o=this.getButtons();p;if(q(window).width()<$.parent().outerWidth()){p=q(window).width();}else if(this._bInsideBar){p=$.closest('.sapMBar').width();}else{p=$.parent().width();}if(this._bInsideBar&&b>0){p-=b+B;}if(this.getWidth()&&this.getWidth().indexOf("%")===-1){m=parseInt(this.getWidth(),10);var e=a;for(var i=0;i<a;i++){var w=this.getButtons()[i].getWidth();if(w.length>0&&w.indexOf("%")===-1){m=m-parseInt(w,10);e--;}}m=m/e;m=m-d;}else{m=Math.max.apply(null,this._aButtonWidth);if(!(((p-c)>m*a)&&this.getWidth().indexOf("%")===-1)){m=(p-c)/a;m=m-d;}}for(var i=0;i<a;i++){var f=$.children('#'+o[i].getId()),s=o[i].getWidth();if(!isNaN(m)&&m>0){m=this._isMie&&!this._bInsidePopup?m+2:m;if(s.length>0){if(s.indexOf("%")===-1){var W=parseInt(s,10)-d;f.width(W);}else{f.width(s).css("padding",0);}}else{f.width(m);}}else{var W=s.indexOf("%")!==-1?d:s;f.width(W);}}this._removeGhostButton();};S.prototype._fHandleResize=function(){this._fCalcBtnWidth();};S.prototype.exit=function(){if(this._sResizeListenerId){sap.ui.core.ResizeHandler.deregister(this._sResizeListenerId);this._sResizeListenerId=null;}if(this._oGhostButton){q("#segMtBtn_calc").remove();this._oGhostButton=null;}if(this._oItemNavigation){this.removeDelegate(this._oItemNavigation);this._oItemNavigation.destroy();delete this._oItemNavigation;}};S.prototype._setItemNavigation=function(){var b,d=this.getDomRef();if(d){this._oItemNavigation.setRootDomRef(d);b=this.$().find(".sapMSegBBtn:not(.sapMSegBBtnDis)");this._oItemNavigation.setItemDomRefs(b);this._focusSelectedButton();}};S.prototype.createButton=function(t,u,e,T){var b=new sap.m.Button();if(t!==null){b.setText(t);}if(u!==null){b.setIcon(u);}if(e||e===undefined){b.setEnabled(true);}else{b.setEnabled(false);}if(T){b.setTextDirection(T);}this.addButton(b);return b;};S.prototype._createButtonFromItem=function(i){var b=new sap.m.Button({text:i.getText(),icon:i.getIcon(),enabled:i.getEnabled(),textDirection:i.getTextDirection(),width:i.getWidth(),tooltip:i.getTooltip(),press:function(){i.firePress();}});i.oButton=b;this.addButton(b);};(function(){S.prototype.addButton=function(b){if(b){p(b,this);this.addAggregation('buttons',b);return this;}};S.prototype.insertButton=function(b,i){if(b){p(b,this);this.insertAggregation('buttons',b,i);return this;}};function p(b,P){b.attachPress(function(e){P._buttonPressed(e);});var o=sap.m.Button.prototype.setEnabled;b.setEnabled=function(e){b.$().toggleClass("sapMSegBBtnDis",!e).toggleClass("sapMFocusable",e);o.apply(b,arguments);};}})();S.prototype.updateItems=function(r){var b=this.getButtons(),o=null,i=0;if(r!==undefined){this.updateAggregation("items");}o=this.getAggregation("items");if(o&&b.length!==0){this.removeAllButtons();}for(;i<o.length;i++){this._createButtonFromItem(o[i]);}};S.prototype.getSelectedKey=function(){var b=this.getButtons(),a=this.getItems(),s=this.getSelectedButton(),i=0;if(a.length>0){for(;i<b.length;i++){if(b[i]&&b[i].getId()===s){this.setProperty("selectedKey",a[i].getKey(),true);return a[i].getKey();}}}return"";};S.prototype.setSelectedKey=function(k){var b=this.getButtons(),a=this.getItems(),i=0;if(b.length===0&&a.length>0){this.updateItems();}if(a.length>0&&b.length>0){for(;i<a.length;i++){if(a[i]&&a[i].getKey()===k){this.setSelectedButton(b[i]);break;}}}this.setProperty("selectedKey",k,true);};S.prototype.removeButton=function(b){if(b){delete b.setEnabled;this.removeAggregation("buttons",b);}};S.prototype.removeAllButtons=function(){var b=this.getButtons();if(b){for(var i=0;i<b.length;i++){var B=b[i];if(B){delete B.setEnabled;this.removeAggregation("buttons",B);}}}};S.prototype._buttonPressed=function(e){var b=e.getSource();if(this.getSelectedButton()!==b.getId()){this.getButtons().forEach(function(B){B.$().removeClass("sapMSegBBtnSel");B.$().attr("aria-checked",false);});b.$().addClass("sapMSegBBtnSel");b.$().attr("aria-checked",true);this.setAssociation('selectedButton',b,true);this.setProperty("selectedKey",this.getSelectedKey(),true);this.fireSelect({button:b,id:b.getId(),key:this.getSelectedKey()});}};S.prototype._selectDefaultButton=function(){var b=this.getButtons();if(b.length>0){this.setAssociation('selectedButton',b[0],true);}};S.prototype.setSelectedButton=function(b){var s=this.getSelectedButton(),o;this.setAssociation("selectedButton",b,true);if(s!==this.getSelectedButton()){if(this.$().length){if(!this.getSelectedButton()){this._selectDefaultButton();}o=sap.ui.getCore().byId(this.getSelectedButton());this.getButtons().forEach(function(B){B.$().removeClass("sapMSegBBtnSel");B.$().attr("aria-checked",false);});if(o){o.$().addClass("sapMSegBBtnSel");o.$().attr("aria-checked",true);}this._focusSelectedButton();}}};S.prototype._focusSelectedButton=function(){var b=this.getButtons(),s=this.getSelectedButton(),i=0;for(;i<b.length;i++){if(b[i]&&b[i].getId()===s){this._oItemNavigation.setFocusedIndex(i);break;}}};S.prototype.onsappagedown=function(e){this._oItemNavigation.onsapend(e);};S.prototype.onsappageup=function(e){this._oItemNavigation.onsaphome(e);};S.prototype._overwriteImageOnload=function(i){var t=this;if(i.onload===sap.m.Image.prototype.onload){i.onload=function(){if(sap.m.Image.prototype.onload){sap.m.Image.prototype.onload.apply(this,arguments);}window.setTimeout(function(){t._fCalcBtnWidth();},20);};}};S.prototype._getIconAriaLabel=function(i){var o=sap.ui.core.IconPool.getIconInfo(i.getSrc()),r="";if(o&&o.name){r=o.name;}return r;};return S;},true);
