// This file has been generated by the SAPUI5 'AllInOne' Builder
jQuery.sap.declare('sap.ui.table.library-all');
if ( !jQuery.sap.isDeclared('sap.ui.table.ColumnMenuRenderer') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides default renderer for control sap.ui.table.ColumnMenuRenderer
jQuery.sap.declare('sap.ui.table.ColumnMenuRenderer'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.Renderer'); // unlisted dependency retained
jQuery.sap.require('sap.ui.unified.MenuRenderer'); // unlisted dependency retained
sap.ui.define("sap/ui/table/ColumnMenuRenderer",['jquery.sap.global', 'sap/ui/core/Renderer', 'sap/ui/unified/MenuRenderer'],
	function(jQuery, Renderer, MenuRenderer) {
	"use strict";


	/**
	 * Renderer for the sap.ui.table.ColumnMenuRendere
	 * @namespace
	 */
	var ColumnMenuRenderer = Renderer.extend(MenuRenderer);

	return ColumnMenuRenderer;

}, /* bExport= */ true);

}; // end of sap/ui/table/ColumnMenuRenderer.js
if ( !jQuery.sap.isDeclared('sap.ui.table.TablePersoController') ) {
/*
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides TablePersoController
jQuery.sap.declare('sap.ui.table.TablePersoController'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
jQuery.sap.require('sap.ui.base.ManagedObject'); // unlisted dependency retained
sap.ui.define("sap/ui/table/TablePersoController",['jquery.sap.global', 'sap/ui/base/ManagedObject'],
	function(jQuery, ManagedObject) {
	"use strict";


	/**
	 * Constructor for a new TablePersoController.
	 *
	 * @param {string} [sId] id for the new control, generated automatically if no id is given
	 * @param {object} [mSettings] initial settings for the new control
	 *
	 * @class
	 * The TablePersoController can be used to connect a table with a persistence service.
	 * @extends sap.ui.base.ManagedObject
	 *
	 * @author SAP SE
	 * @version 1.28.10
	 * @since 1.21.1
	 *
	 * @constructor
	 * @public
	 * @alias sap.ui.table.TablePersoController
	 */
	var TablePersoController = ManagedObject.extend("sap.ui.table.TablePersoController", /** @lends sap.ui.table.TablePersoController.prototype */ {
	
		constructor: function(sId, mSettings) {
			ManagedObject.apply(this, arguments);
		},
	
		metadata: {
			properties: {
				
				/**
				 * Auto save state
				 */
				"autoSave": {
					type: "boolean",
					defaultValue: true
				},
				
				/**
				 * Personalization Service object. Needs to have the following methods:
				 * <ul>
				 * <li>getPersData() : <code>jQuery Promise</code> (http://api.jquery.com/promise/)</li>
				 * <li>setPersData(oBundle) : <code>jQuery Promise</code> (http://api.jquery.com/promise/)</li>
				 * <li>delPersData() : <code>jQuery Promise</code> (http://api.jquery.com/promise/)</li>
				 * </ul>
				 */
				"persoService": {
					type: "any"
				},
				
				/**
				 * By defining a custom data key the <code>TablePersoController</code>
				 * will try to get the key for saving the perso data from the custom
				 * data of the Table and Column instead of creating it by concatenating 
				 * the ID of the Table and the Column. Basically this will be more stable 
				 * than using the auto IDs.
				 */
				"customDataKey": {
					type: "string",
					defaultValue: "persoKey"
				}
			},
			associations: {
				/**
				 * The target table of this controller.
				 */
				"table": {
					type: "sap.ui.table.Table",
					multiple: false
				}
			},
			library: "sap.ui.table"
		}
	
	});
	
	/**
	 * @private
	 */
	TablePersoController.prototype.init = function() {
	
		// Table Personalization schema
		this._schemaProperty = "_persoSchemaVersion";
		this._schemaVersion = "1.0";
	
		this._oInitialPersoData = null;
		
		this._aTableEvents = ["columnResize", "columnMove", "columnVisibility", "sort", "filter", "group"];
		this._aColumnProperties = ["visible", "width", "sorted", "sortOrder", "grouped", "summed"];
		
		this._bSaveFilters = false;
		if (this._bSaveFilters) {
			this._aTableEvents.push("filter");
			this._aColumnProperties.push("filtered");
			this._aColumnProperties.push("filterValue");
		}
		
	};
	
	/**
	 * @private
	 */
	TablePersoController.prototype.exit = function() {
	
		var oTable = this._getTable();
	
		if (oTable) {
			this._manageTableEventHandlers(oTable, false);
		}
	
		delete this._schemaProperty;
		delete this._schemaVersion;
	
		delete this._oInitialPersoData;
		
		delete this._oDialog;
	
	};
	
	TablePersoController.prototype.setPersoService = function(oService) {
		oService = this.validateProperty("persoService", oService);
		if (oService &&
			(!jQuery.isFunction(oService.getPersData) ||
			!jQuery.isFunction(oService.setPersData) ||
			!jQuery.isFunction(oService.delPersData))) {
			throw new Error("Value of property \"persoService\" needs to be null/undefined or an object that has the methods " +
					"\"getPersData\", \"setPersData\" and \"delPersData\".");
		}
	
		var oOldService = this.getPersoService();
		this.setProperty("persoService", oService, true);
		var oNewService = this.getPersoService();
	
		// refresh data using new service if there was a new service set and a table was set
		if (oNewService && oNewService !== oOldService && this._getTable() && (this.getAutoSave() || !oOldService )) {
			this.refresh();
		}
	
		return this;
	};
	
	TablePersoController.prototype.setAutoSave = function(bAutoSave) {
		var oOldValue = this.getAutoSave();
		this.setProperty("autoSave", bAutoSave, true);
		var oNewValue = this.getAutoSave();
	
		// save data if autoSave is turned from false to true
		if (oNewValue && !oOldValue) {
			this.savePersonalizations();
		}
	
		return this;
	};
	
	TablePersoController.prototype.setTable = function(vTable) {
		var oOldTable = this._getTable();
		if (oOldTable) {
			oOldTable._oPersoController = undefined; // remove the relationship to the controller
		}
		this.setAssociation("table", vTable, true);
		var oNewTable = this._getTable();
		if (oNewTable) {
			oNewTable._oPersoController = this; // set the relationship to controller (debugging & performance opts)
		}
	
		// detach handlers from old table
		if (oOldTable) {
			this._manageTableEventHandlers(oOldTable, false);
		}
	
		if (oNewTable && oNewTable !== oOldTable) {
	
			// save initial table configuration (incl. text for perso dialog)
			this._oInitialPersoData = this._getCurrentTablePersoData(true);
	
			// attach handlers to new table
			this._manageTableEventHandlers(oNewTable, true);
	
			// only refresh if there is a service set and autoSave is on or no table was set before
			if (this.getPersoService() && (this.getAutoSave() || !oOldTable )) {
				this.refresh();
			}
		} else if (!oNewTable) {
			// remove initial data if table is set to null
			this._oInitialPersoData = null;
		}
	
		return this;
	};
	
	TablePersoController.prototype.setCustomDataKey = function(sCustomDataKey) {
		var sOldValue = this.getCustomDataKey();
		this.setProperty("customDataKey", sCustomDataKey, true);
		var sNewValue = this.getCustomDataKey();
	
		// save data if the autosave is on and the perso key has been changed
		if (sOldValue !== sNewValue && this.getAutoSave()) {
			this.savePersonalizations();
		}
		
		return this;
	};
	
	TablePersoController.prototype._manageTableEventHandlers = function(oTable, bAttach) {
		// attach or detach the Table Event Handlers (necessary for autosave)
		for (var i = 0, l = this._aTableEvents.length; i < l; i++) {
			var fn = oTable[(bAttach ? "attachEvent" : "detachEvent")];
			fn.apply(oTable, [this._aTableEvents[i], this._tableEventHandler, this]);
		}
	};
	
	/**
	 * Refresh the personalizations (reloads data from service).
	 *
	 * @return {jQuery.Promise} <code>jQuery Promise</code> which is resolved once the refresh is finished
	 * @public
	 */
	TablePersoController.prototype.refresh = function() {
		var that = this;
	
		var oService = this.getPersoService();
		if (oService) {
			return oService.getPersData().done(function(oServiceData) {
				var oData = (oServiceData && jQuery.isArray(oServiceData.aColumns))
						? oServiceData
						: that._oInitialPersoData; // use initial column definitions
				that._adjustTable(oData);
			}).fail(function() {
				jQuery.sap.log.error("Problem reading persisted personalization data.");
			});
		} else {
			jQuery.sap.log.error("The Personalization Service is not available!");
			// return a dummy promise and reject it immediately
			var oDeferred = jQuery.Deferred();
			oDeferred.reject();
			return oDeferred.promise();
		}
	};
	
	/**
	 * Saves the current personalization state.
	 *
	 * @return {jQuery.Promise} <code>jQuery Promise</code> which is resolved once the save is finished
	 * @public
	 */
	TablePersoController.prototype.savePersonalizations = function() {
		var oService = this.getPersoService();
		if (oService) {
	
			var oData = this._getCurrentTablePersoData();
			oData[this._schemaProperty] = this._schemaVersion;
	
			return oService.setPersData(oData).fail(function() {
				jQuery.sap.log.error("Problem persisting personalization data.");
			});
			
		} else {
			jQuery.sap.log.error("The Personalization Service is not available!");
			// return a dummy promise and reject it immediately
			var oDeferred = jQuery.Deferred();
			oDeferred.reject();
			return oDeferred.promise();
		}
	};
	
	TablePersoController.prototype._adjustTable = function(oData) {
		var oTable = this._getTable();
		if (!oTable || !oData || !jQuery.isArray(oData.aColumns)) {
			return;
		}
	
		// create a persoKey to column map
		var mColumns = {}, aCols = oTable.getColumns();
		for (var i = 0, l = aCols.length; i < l; i++) {
			mColumns[this._getColumnPersoKey(aCols[i])] = aCols[i];
		}
		
		var aColumns = oData.aColumns;
	
		for (var i = 0, l = aColumns.length; i < l; i++) {
			var oColumnInfo = aColumns[i]; // P13N info object
			var oColumn = mColumns[oColumnInfo.id];
	
			// only if the column is available in the table 
			// e.g. if the Table has been removed or renamed => ignore!
			if (oColumn) {
				
				// apply the order
				if (oTable.indexOfColumn(oColumn) !== oColumnInfo.order) {
					oTable.removeColumn(oColumn);
					oTable.insertColumn(oColumn, oColumnInfo.order);
				}
	
				var oMetadata = oColumn.getMetadata();
				for (var j = 0, lj = this._aColumnProperties.length; j < lj; j++) {
					var sProperty = this._aColumnProperties[j];
					if (oColumnInfo[sProperty] !== undefined) {
						try {
							if (oMetadata.hasProperty(sProperty) && oColumn.getProperty(sProperty) != oColumnInfo[sProperty]) {
								oColumn.setProperty(sProperty, oColumnInfo[sProperty]);
							}
						} catch (ex) {
							jQuery.sap.log.error("sap.ui.table.TablePersoController: failed to apply the value \"" + oColumn[sProperty] + "\" for the property + \"" + sProperty + "\".");
						}
					}
				}
				
			}
	
		}
		
		if (typeof oTable._onPersoApplied === "function") {
			oTable._onPersoApplied();
		}
		
	};
	
	TablePersoController.prototype._tableEventHandler = function(oEvent) {
		if (this.getAutoSave() && !this._iTriggerSaveTimeout) {
			var that = this;
			this._iTriggerSaveTimeout = setTimeout(function() {
				that.savePersonalizations();
				that._iTriggerSaveTimeout = null;
			}, 0);
		}
	};
	
	TablePersoController.prototype._getCurrentTablePersoData = function(bForDialog) {
		var oTable = this._getTable(),
			aColumns = oTable.getColumns();
	
		var oData = {
			aColumns: []
		};
	
		for (var i = 0, l = aColumns.length; i < l; i++) {
			var oColumn = aColumns[i];
			var sPersoKey = this._getColumnPersoKey(oColumn);
			var oColumnInfo = {
				id: sPersoKey,
				order: i
			};
			var oMetadata = oColumn.getMetadata();
			for (var j = 0, lj = this._aColumnProperties.length; j < lj; j++) {
				var sProperty = this._aColumnProperties[j];
				if (oMetadata.hasProperty(sProperty)) {
					oColumnInfo[sProperty] = oColumn.getProperty(sProperty);
				}
			}
			if (bForDialog) {
				oColumnInfo.text = oColumn.getLabel() && oColumn.getLabel().getText() || sPersoKey;
			}
			oData.aColumns.push(oColumnInfo);
		}
	
		return oData;
	};
	
	TablePersoController.prototype._getTable = function() {
		return sap.ui.getCore().byId(this.getTable());
	};
	
	TablePersoController.prototype._getColumnPersoKey = function(oColumn) {
		return this._getPersoKey(this._getTable()) + "-" + this._getPersoKey(oColumn);
	};
	
	TablePersoController.prototype._getPersoKey = function(oControl) {
		var sPersoKey = oControl.data(this.getCustomDataKey());
		if (!sPersoKey) {
			sPersoKey = oControl.getId();
			if (sPersoKey.indexOf(sap.ui.getCore().getConfiguration().getUIDPrefix()) === 0) {
				jQuery.sap.log.warning("Generated IDs should not be used as personalization keys! The stability cannot be ensured! (Control: \"" + oControl.getId() + "\")");
			}
		}
		return sPersoKey;
	};
	
	/**
	 * Opens the personalization dialog for the Table to modify the visibility and
	 * the order of the columns.
	 * 
	 * <i>Using this functionality will require to load the sap.m library because the
	 * personalization dialog is only available in this library for now.</i>
	 * 
	 * @param {object} mSettings
	 * @public
	 * @experimental since 1.21.2 - API might change / feature requires the sap.m library!
	 */
	TablePersoController.prototype.openDialog = function(mSettings) {
	
		// include the mobile library to re-use the sap.m.TablePersoDialog
		sap.ui.getCore().loadLibrary("sap.m");
		jQuery.sap.require("sap.m.TablePersoDialog");
			
		// create and open the dialog
		if (!this._oDialog) {
			var that = this;
			this._oDialog = new sap.m.TablePersoDialog({
				persoService: this.getPersoService(),
				showSelectAll: true,
				showResetAll: true,
				grouping: false,
				contentWidth: mSettings && mSettings.contentWidth,
				contentHeight: mSettings && mSettings.contentHeight || "20rem",
				initialColumnState: this._oInitialPersoData.aColumns,
				columnInfoCallback: function(oTable, mPersoMap, oPersoService) {
					return that._getCurrentTablePersoData(true).aColumns;
				},
				confirm : function() {
					that._adjustTable(this.retrievePersonalizations());
					if (that.getAutoSave()) {
						that.savePersonalizations();
					}
				}
			});
			this._oDialog._oDialog.removeStyleClass("sapUiPopupWithPadding"); // otherwise height calculation doesn't work properly!
			jQuery.sap.syncStyleClass("sapUiSizeCompact", this._getTable(), this._oDialog._oDialog);
		}
		
		this._oDialog.open();
		
	};
	

	return TablePersoController;

}, /* bExport= */ true);

}; // end of sap/ui/table/TablePersoController.js
if ( !jQuery.sap.isDeclared('sap.ui.table.TableRenderer') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

//Provides default renderer for control sap.ui.table.Table
jQuery.sap.declare('sap.ui.table.TableRenderer'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
sap.ui.define("sap/ui/table/TableRenderer",['jquery.sap.global'],
	function(jQuery) {
	"use strict";


	/**
	 * Table renderer.
	 * @namespace
	 */
	var TableRenderer = {};

	/**
	 * Renders the HTML for the given control, using the provided {@link sap.ui.core.RenderManager}.
	 *
	 * @param {sap.ui.core.RenderManager} rm the RenderManager that can be used for writing to the Render-Output-Buffer
	 * @param {sap.ui.core.Control} oTable an object representation of the control that should be rendered
	 */
	TableRenderer.render = function(rm, oTable) {
		// create the rows of the table
		// (here we could think about a swith to allow the programmatic usage of the table)
		oTable._createRows();

		// basic table div
		rm.write("<div");
		if (oTable._bAccMode) {
			var aAriaOwnsIds = [];
			if (oTable.getToolbar()) {
				aAriaOwnsIds.push(oTable.getToolbar().getId());
			}
			aAriaOwnsIds.push(oTable.getId() + "-table");
			rm.writeAttribute("aria-owns", aAriaOwnsIds.join(" "));
			rm.writeAttribute("aria-readonly", "true");
			if (oTable.getTitle()) {
				rm.writeAttribute("aria-labelledby", oTable.getTitle().getId());
			}
			if (oTable.getSelectionMode() === sap.ui.table.SelectionMode.Multi) {
				rm.writeAttribute("aria-multiselectable", "true");
			}
		}
		rm.writeControlData(oTable);
		rm.addClass("sapUiTable");
		rm.addClass("sapUiTableSelMode" + oTable.getSelectionMode());
		if (oTable.getColumnHeaderVisible()) {
			rm.addClass("sapUiTableCHdr"); // show column headers
		}
		if (oTable.getSelectionMode() !== sap.ui.table.SelectionMode.None &&
				oTable.getSelectionBehavior() !== sap.ui.table.SelectionBehavior.RowOnly) {
			rm.addClass("sapUiTableRSel"); // show row selector
		}

		// This class flags whether the sap.m. library is loaded or not.
		var sSapMTableClass = sap.ui.table.TableHelper.addTableClass();
		if (sSapMTableClass) {
			rm.addClass(sSapMTableClass);
		}

		rm.addClass("sapUiTableSelMode" + oTable.getSelectionMode()); // row selection mode
		//rm.addClass("sapUiTableHScr"); // show horizontal scrollbar
		if (oTable.getNavigationMode() === sap.ui.table.NavigationMode.Scrollbar) {
			rm.addClass("sapUiTableVScr"); // show vertical scrollbar
		}
		if (oTable.getEditable()) {
			rm.addClass("sapUiTableEdt"); // editable (background color)
		}
		rm.addClass("sapUiTableShNoDa");
		if (oTable.getShowNoData() && oTable._getRowCount() === 0) {
			rm.addClass("sapUiTableEmpty"); // no data!
		}
		if (oTable.getEnableGrouping()) {
			rm.addClass("sapUiTableGrouping");
		}
		rm.writeClasses();
		if (oTable.getWidth()) {
			rm.addStyle("width", oTable.getWidth());
		}
		rm.writeStyles();
		rm.write(">");

		if (oTable.getTitle()) {
			this.renderHeader(rm, oTable, oTable.getTitle());
		}

		if (oTable.getToolbar()) {
			this.renderToolbar(rm, oTable, oTable.getToolbar());
		}

		if (oTable.getExtension() && oTable.getExtension().length > 0) {
			this.renderExtensions(rm, oTable, oTable.getExtension());
		}

		rm.write("<div");
		rm.addClass("sapUiTableCnt");
		rm.writeClasses();
		// Define group for F6 handling
		rm.writeAttribute("data-sap-ui-fastnavgroup", "true");
		if (oTable._bAccMode) {
			rm.writeAttribute("aria-describedby", oTable.getId() + "-ariacount");
		}
		rm.write(">");

		this.renderColHdr(rm, oTable);

		this.renderTable(rm, oTable);

		if (oTable._bAccMode) {
			// aria description for the row count
			rm.write("<span");
			rm.writeAttribute("id", oTable.getId() + "-ariadesc");
			rm.addStyle("position", "absolute");
			rm.addStyle("top", "-20000px");
			rm.writeStyles();
			rm.write(">");
			rm.write(oTable._oResBundle.getText("TBL_TABLE"));
			rm.write("</span>");
			// aria description for the row count
			rm.write("<span");
			rm.writeAttribute("id", oTable.getId() + "-ariacount");
			rm.addStyle("position", "absolute");
			rm.addStyle("top", "-20000px");
			rm.writeStyles();
			rm.write(">");
			rm.write("</span>");
			// aria description for toggling the edit mode
			rm.write("<span");
			rm.writeAttribute("id", oTable.getId() + "-toggleedit");
			rm.addStyle("position", "absolute");
			rm.addStyle("top", "-20000px");
			rm.writeStyles();
			rm.write(">");
			rm.write(oTable._oResBundle.getText("TBL_TOGGLE_EDIT_KEY"));
			rm.write("</span>");
			// aria description for row selection behavior with no line selected
			rm.write("<span");
			rm.writeAttribute("id", oTable.getId() + "-selectrow");
			rm.addStyle("position", "absolute");
			rm.addStyle("top", "-20000px");
			rm.writeStyles();
			rm.write(">");
			rm.write(oTable._oResBundle.getText("TBL_ROW_SELECT_KEY"));
			rm.write("</span>");
			// aria description for row selection behavior with line selected
			rm.write("<span");
			rm.writeAttribute("id", oTable.getId() + "-selectrowmulti");
			rm.addStyle("position", "absolute");
			rm.addStyle("top", "-20000px");
			rm.writeStyles();
			rm.write(">");
			rm.write(oTable._oResBundle.getText("TBL_ROW_SELECT_MULTI_KEY"));
			rm.write("</span>");
			// aria description for row deselection behavior with no line selected
			rm.write("<span");
			rm.writeAttribute("id", oTable.getId() + "-deselectrow");
			rm.addStyle("position", "absolute");
			rm.addStyle("top", "-20000px");
			rm.writeStyles();
			rm.write(">");
			rm.write(oTable._oResBundle.getText("TBL_ROW_DESELECT_KEY"));
			rm.write("</span>");
			// aria description for row deselection behavior with line selected
			rm.write("<span");
			rm.writeAttribute("id", oTable.getId() + "-deselectrowmulti");
			rm.addStyle("position", "absolute");
			rm.addStyle("top", "-20000px");
			rm.writeStyles();
			rm.write(">");
			rm.write(oTable._oResBundle.getText("TBL_ROW_DESELECT_MULTI_KEY"));
			rm.write("</span>");
		}

		rm.write("</div>");

		if (oTable.getNavigationMode() === sap.ui.table.NavigationMode.Paginator) {
			rm.write("<div");
			rm.addClass("sapUiTablePaginator");
			rm.writeClasses();
			rm.write(">");
			if (!oTable._oPaginator) {
				jQuery.sap.require("sap.ui.commons.Paginator");
				oTable._oPaginator = new sap.ui.commons.Paginator(oTable.getId() + "-paginator");
				oTable._oPaginator.attachPage(jQuery.proxy(oTable.onvscroll, oTable));
			}
			rm.renderControl(oTable._oPaginator);
			rm.write("</div>");
		}

		if (oTable.getFooter()) {
			this.renderFooter(rm, oTable, oTable.getFooter());
		}

		if (oTable.getVisibleRowCountMode() == sap.ui.table.VisibleRowCountMode.Interactive) {
			this.renderVariableHeight(rm ,oTable);
		}

		rm.write("</div>");

	};

	// =============================================================================
	// BASIC AREAS OF THE TABLE
	// =============================================================================

	TableRenderer.renderHeader = function(rm, oTable, oTitle) {
		rm.write("<div");
		rm.addClass("sapUiTableHdr");
		rm.writeClasses();
		if (oTable._bAccMode) {
			rm.writeAttribute("role", "heading");
		}
		rm.write(">");

		rm.renderControl(oTitle);

		rm.write("</div>");
	};

	TableRenderer.renderToolbar = function(rm, oTable, oToolbar) {
		rm.write("<div");
		rm.addClass("sapUiTableTbr");
		if (typeof oToolbar.getStandalone !== "function") {
			// for the mobile toolbar we add another class
			rm.addClass("sapUiTableMTbr");
		}
		rm.writeClasses();
		rm.write(">");

		// toolbar has to be embedded (not standalone)!
		if (typeof oToolbar.getStandalone === "function" && oToolbar.getStandalone()) {
			oToolbar.setStandalone(false);
		}

		rm.renderControl(oToolbar);

		rm.write("</div>");
	};

	TableRenderer.renderExtensions = function(rm, oTable, aExtensions) {
		for (var i = 0, l = aExtensions.length; i < l; i++) {
			this.renderExtension(rm, oTable, aExtensions[i]);
		}
	};

	TableRenderer.renderExtension = function(rm, oTable, oExtension) {
		rm.write("<div");
		rm.addClass("sapUiTableExt");
		rm.writeClasses();
		rm.write(">");

		rm.renderControl(oExtension);

		rm.write("</div>");
	};

	TableRenderer.renderTable = function(rm, oTable) {
		rm.write("<div");
		rm.addClass("sapUiTableCCnt");
		rm.writeClasses();
		rm.write(">");

		rm.write("<div");
		rm.addClass("sapUiTableCtrlBefore");
		rm.writeClasses();
		rm.writeAttribute("tabindex", "0");
		rm.write("></div>");

		this.renderRowHdr(rm, oTable);
		this.renderTableCtrl(rm, oTable);
		this.renderVSb(rm, oTable);

		rm.write("</div>");

		this.renderHSb(rm, oTable);

	};

	TableRenderer.renderFooter = function(rm, oTable, oFooter) {
		rm.write("<div");
		rm.addClass("sapUiTableFtr");
		rm.writeClasses();
		rm.write(">");

		rm.renderControl(oFooter);

		rm.write("</div>");
	};

	TableRenderer.renderVariableHeight = function(rm, oTable) {
		rm.write('<div id="' + oTable.getId() + '-sb" tabIndex="-1"');
		rm.addClass("sapUiTableSplitterBar");
		rm.addStyle("height", "5px");
		rm.writeClasses();
		rm.writeStyles();
		rm.write(">");
		rm.write("</div>");
	};

	// =============================================================================
	// COLUMN HEADER OF THE TABLE
	// =============================================================================

	TableRenderer.renderColHdr = function(rm, oTable) {

		rm.write("<div");
		rm.addClass("sapUiTableColHdrCnt");
		rm.writeClasses();
		if (oTable.getColumnHeaderHeight() > 0) {
			rm.addStyle("height", (oTable.getColumnHeaderHeight() * oTable._getHeaderRowCount()) + "px");
		}
		if (oTable._bAccMode &&
			 (oTable.getSelectionMode() === sap.ui.table.SelectionMode.None ||
					 oTable.getSelectionBehavior() === sap.ui.table.SelectionBehavior.RowOnly)) {
			rm.writeAttribute("role", "row");
		}
		rm.writeStyles();
		rm.write(">");

		this.renderColRowHdr(rm, oTable);

		var aCols = oTable.getColumns();

		if (oTable.getFixedColumnCount() > 0) {
			rm.write("<div");
			rm.addClass("sapUiTableColHdrFixed");
			rm.writeClasses();
			rm.write(">");

			for (var h = 0; h < oTable._getHeaderRowCount(); h++) {

				rm.write("<div");
				rm.addClass("sapUiTableColHdr");
				rm.writeClasses();
				rm.addStyle("min-width", oTable._getColumnsWidth(0, oTable.getFixedColumnCount()) + "px");
				rm.writeStyles();
				rm.write(">");

				var iSpan = 1;
				for (var i = 0, l = oTable.getFixedColumnCount(); i < l; i++) {
					if (aCols[i] && aCols[i].shouldRender()) {
						if (iSpan <= 1) {
							this.renderCol(rm, oTable, aCols[i], i, h);
							var aHeaderSpan = aCols[i].getHeaderSpan();
							if (jQuery.isArray(aHeaderSpan)) {
								iSpan = aCols[i].getHeaderSpan()[h] + 1;
							} else {
								iSpan = aCols[i].getHeaderSpan() + 1;
							}
						} else {
							//Render column header but this is invisible because of the span
							this.renderCol(rm, oTable, aCols[i], i, h, true);
						}
						if (h == 0) {
							this.renderColRsz(rm, oTable, aCols[i], i);
						}
						iSpan--;
					}
				}

				rm.write("<p style=\"clear: both;\"></p>");
				rm.write("</div>");

			}

			rm.write("</div>");
		}

		rm.write("<div");
		rm.addClass("sapUiTableColHdrScr");
		rm.writeClasses();
		if (oTable.getFixedColumnCount() > 0) {
			if (oTable._bRtlMode) {
				rm.addStyle("margin-right", "0");
			} else {
				rm.addStyle("margin-left", "0");
			}
			rm.writeStyles();
		}
		rm.write(">");

		for (var h = 0; h < oTable._getHeaderRowCount(); h++) {

			rm.write("<div");
			rm.addClass("sapUiTableColHdr");
			rm.writeClasses();
			rm.addStyle("min-width", oTable._getColumnsWidth(oTable.getFixedColumnCount(), aCols.length) + "px");
			rm.writeStyles();
			rm.write(">");

			var iSpan = 1;
			for (var i = oTable.getFixedColumnCount(), l = aCols.length; i < l; i++) {
				if (aCols[i].shouldRender()) {
					if (iSpan <= 1) {
						this.renderCol(rm, oTable, aCols[i], i, h);
						var aHeaderSpan = aCols[i].getHeaderSpan();
						if (jQuery.isArray(aHeaderSpan)) {
							iSpan = aCols[i].getHeaderSpan()[h] + 1;
						} else {
							iSpan = aCols[i].getHeaderSpan() + 1;
						}
					} else {
						//Render column header but this is invisible because of the span
						this.renderCol(rm, oTable, aCols[i], i, h, true);
					}
					if (h == 0) {
						this.renderColRsz(rm, oTable, aCols[i], i);
					}
					iSpan--;
				}
			}

			rm.write("<p style=\"clear: both;\"></p>");
			rm.write("</div>");

		}

		rm.write("</div>");

		rm.write("</div>");

	};

	TableRenderer.renderColRowHdr = function(rm, oTable) {
		rm.write("<div");
		rm.writeAttribute("id", oTable.getId() + "-selall");
		var oSelMode = oTable.getSelectionMode();
		if ((oSelMode == "Multi" || oSelMode == "MultiToggle") && oTable.getEnableSelectAll()) {
			rm.writeAttributeEscaped("title", oTable._oResBundle.getText("TBL_SELECT_ALL"));
			if (oTable._getSelectableRowCount() == 0 || oTable._getSelectableRowCount() !== oTable.getSelectedIndices().length) {
				rm.addClass("sapUiTableSelAll");
			}
			rm.addClass("sapUiTableSelAllEnabled");
		}
		rm.addClass("sapUiTableColRowHdr");
		rm.writeClasses();
		if (oTable._bAccMode) {
			rm.writeAttribute("tabindex", "-1");
			rm.writeAttributeEscaped("aria-label", oTable._oResBundle.getText("TBL_SELECT_ALL_KEY"));
		}
		rm.write(">");
		if (oTable.getSelectionMode() !== sap.ui.table.SelectionMode.Single) {
			rm.write("<div");
			rm.addClass("sapUiTableColRowHdrIco");
			rm.writeClasses();
			if (oTable.getColumnHeaderHeight() > 0) {
				rm.addStyle("height", oTable.getColumnHeaderHeight() + "px");
			}
			rm.write(">");
			rm.write("</div>");
		}
		rm.write("</div>");
	};

	TableRenderer.renderCol = function(rm, oTable, oColumn, iIndex, iHeader, bInvisible) {
		var oLabel;
		if (oColumn.getMultiLabels().length > 0) {
			oLabel = oColumn.getMultiLabels()[iHeader];
		} else if (iHeader == 0) {
			oLabel = oColumn.getLabel();
		}

		rm.write("<div");
		if (iHeader === 0) {
			rm.writeElementData(oColumn);
		} else {
			// TODO: we need a writeElementData with suffix - it is another HTML element
			//       which belongs to the same column but it is not in one structure!
			rm.writeAttribute('id', oColumn.getId() + "_" + iHeader);
		}
		rm.writeAttribute('data-sap-ui-colid', oColumn.getId());
		rm.writeAttribute("data-sap-ui-colindex", iIndex);
		if (oTable._bAccMode) {
			if (!!sap.ui.Device.browser.internet_explorer) {
				rm.writeAttribute("role", "columnheader");
			}
			// TODO: determine if the column has a column menu
			rm.writeAttribute("aria-haspopup", "true");
			rm.writeAttribute("tabindex", "-1");
		}
		rm.addClass("sapUiTableCol");
		rm.writeClasses();
		rm.addStyle("width", oColumn.getWidth());
		if (oTable.getColumnHeaderHeight() > 0) {
			rm.addStyle("height", oTable.getColumnHeaderHeight() + "px");
		}
		if (bInvisible) {
			rm.addStyle("display", "none");
		}
		rm.writeStyles();
		var sTooltip = oColumn.getTooltip_AsString();
		if (sTooltip) {
			rm.writeAttributeEscaped("title", sTooltip);
		}
		rm.write("><div");
		rm.addClass("sapUiTableColCell");
		rm.writeClasses();
		var sHAlign = this.getHAlign(oColumn.getHAlign(), oTable._bRtlMode);
		if (sHAlign) {
			rm.addStyle("text-align", sHAlign);
		}
		rm.writeStyles();
		rm.write(">");

		// TODO: rework column sort / filter status integration
		rm.write("<div id=\"" + oColumn.getId() + "-icons\" class=\"sapUiTableColIcons\"></div>");

		if (oLabel) {
			rm.renderControl(oLabel);
		}

		rm.write("</div></div>");
	};

	TableRenderer.renderColRsz = function(rm, oTable, oColumn, iIndex) {
		if (oColumn.getResizable()) {
			rm.write("<div");
			rm.writeAttribute("id", oColumn.getId() + "-rsz");
			rm.writeAttribute("data-sap-ui-colindex", iIndex);
			rm.writeAttribute("tabindex", "-1");
			rm.addClass("sapUiTableColRsz");
			rm.writeClasses();
			rm.addStyle("left", oTable._bRtlMode ? "99000px" : "-99000px");
			rm.writeStyles();
			rm.write("></div>");
		}
	};


	// =============================================================================
	// CONTENT AREA OF THE TABLE
	// =============================================================================

	TableRenderer.renderRowHdr = function(rm, oTable) {
		rm.write("<div");
		rm.addClass("sapUiTableRowHdrScr");
		rm.writeClasses();
		rm.write(">");

		// start with the first current top visible row
		for (var row = 0, count = oTable.getRows().length; row < count; row++) {
			this.renderRowHdrRow(rm, oTable, oTable.getRows()[row], row);
		}

		rm.write("</div>");
	};

	TableRenderer.renderRowHdrRow = function(rm, oTable, oRow, iRowIndex) {
		rm.write("<div");
		rm.writeAttribute("id", oTable.getId() + "-rowsel" + iRowIndex);
		rm.writeAttribute("data-sap-ui-rowindex", iRowIndex);
		rm.addClass("sapUiTableRowHdr");
		if (oRow._bHidden) {
			rm.addClass("sapUiTableRowHidden");
		}
		rm.writeClasses();
		if (oTable.getRowHeight() > 0) {
			rm.addStyle("height", oTable.getRowHeight() + "px");
		}
		if (oTable._bAccMode) {
			// defined via ARIA spec but not yet supported
			var aCellIds = [];
			jQuery.each(oRow.getCells(), function(iIndex, oCell) {
				aCellIds.push(oRow.getId() + "-col" + iIndex);
			});
			if (oTable.getSelectionMode() === sap.ui.table.SelectionMode.Multi) {
				rm.writeAttribute("aria-selected", "false");
			}
			if (oTable.getSelectionMode() !== sap.ui.table.SelectionMode.None) {
				rm.writeAttributeEscaped("title", oTable._oResBundle.getText("TBL_ROW_SELECT"));
				if (oTable.getSelectionMode() === sap.ui.table.SelectionMode.Multi && oTable._oSelection.getSelectedIndices().length > 1) {
					rm.writeAttributeEscaped("aria-label", oTable._oResBundle.getText("TBL_ROW_SELECT_MULTI_KEY"));
				} else {
					rm.writeAttributeEscaped("aria-label", oTable._oResBundle.getText("TBL_ROW_SELECT_KEY"));
				}
			}
			rm.writeAttribute("tabindex", "-1");
		}
		rm.writeStyles();
		rm.write("></div>");
	};

	TableRenderer.renderTableCtrl = function(rm, oTable) {

		if (oTable.getFixedColumnCount() > 0) {
			rm.write("<div");
			rm.addClass("sapUiTableCtrlScrFixed");
			rm.writeClasses();
			rm.write(">");

			this.renderTableControl(rm, oTable, true);

			rm.write("</div>");
		}

		rm.write("<div");
		rm.addClass("sapUiTableCtrlScr");
		rm.writeClasses();
		if (oTable.getFixedColumnCount() > 0) {
			if (oTable._bRtlMode) {
				rm.addStyle("margin-right", "0");
			} else {
				rm.addStyle("margin-left", "0");
			}
			rm.writeStyles();
		}
		rm.write(">");

		rm.write("<div");
		rm.addClass("sapUiTableCtrlCnt");
		rm.writeClasses();
		rm.write(">");

		this.renderTableControl(rm, oTable, false);

		rm.write("</div>");

		rm.write("<div");
		rm.addClass("sapUiTableCtrlAfter");
		rm.writeClasses();
		rm.writeAttribute("tabindex", "0");
		rm.write("></div>");
		rm.write("</div>");

		rm.write("<div");
		rm.addClass("sapUiTableCtrlEmpty");
		rm.writeClasses();
		rm.writeAttribute("tabindex", "0");
		rm.write(">");
		if (oTable.getNoData() && oTable.getNoData() instanceof sap.ui.core.Control) {
			rm.renderControl(oTable.getNoData());
		} else {
			rm.write("<span");
			rm.addClass("sapUiTableCtrlEmptyMsg");
			rm.writeClasses();
			rm.write(">");
			if (typeof oTable.getNoData() === "string" || oTable.getNoData() instanceof String) {
				rm.writeEscaped(oTable.getNoData());
			} else if (oTable.getNoDataText()) {
				rm.writeEscaped(oTable.getNoDataText());
			} else {
				rm.writeEscaped(oTable._oResBundle.getText("TBL_NO_DATA"));
			}
			rm.write("</span>");
		}
		rm.write("</div>");
	};


	TableRenderer.renderTableControl = function(rm, oTable, bFixedTable) {
		var iStartColumn, iEndColumn;
		if (bFixedTable) {
			iStartColumn = 0;
			iEndColumn = oTable.getFixedColumnCount();
		} else {
			iStartColumn = oTable.getFixedColumnCount();
			iEndColumn = oTable.getColumns().length;
		}
		var iFixedRows = oTable.getFixedRowCount();
		var iFixedBottomRows = oTable.getFixedBottomRowCount();
		var aRows = oTable.getRows();

		if (iFixedRows > 0) {
			this.renderTableControlCnt(rm, oTable, bFixedTable, iStartColumn, iEndColumn, true, false, 0, iFixedRows);
		}
		this.renderTableControlCnt(rm, oTable, bFixedTable, iStartColumn, iEndColumn, false, false, iFixedRows, aRows.length - iFixedBottomRows);
		if (iFixedBottomRows > 0) {
			this.renderTableControlCnt(rm, oTable, bFixedTable, iStartColumn, iEndColumn, false, true, aRows.length - iFixedBottomRows, aRows.length);
		}
	};

	TableRenderer.renderTableControlCnt = function(rm, oTable, bFixedTable, iStartColumn, iEndColumn, bFixedRow, bFixedBottomRow, iStartRow, iEndRow) {
		rm.write("<table");
		var sId = oTable.getId() + "-table";
		if (bFixedTable) {
			sId += "-fixed";
			rm.addClass("sapUiTableCtrlFixed");
		} else {
			rm.addClass("sapUiTableCtrlScroll");
		}
		if (bFixedRow) {
			sId += "-fixrow";
			rm.addClass("sapUiTableCtrlRowFixed");
		} else if (bFixedBottomRow) {
			sId += "-fixrow-bottom";
			rm.addClass("sapUiTableCtrlRowFixedBottom");
		} else {
			rm.addClass("sapUiTableCtrlRowScroll");
		}
		rm.writeAttribute("id", sId);
		if (oTable._bAccMode) {
			rm.writeAttribute("role", "grid");
		}
		rm.addClass("sapUiTableCtrl");
		rm.writeClasses();
		rm.addStyle("min-width", oTable._getColumnsWidth(iStartColumn, iEndColumn) + "px");
		//Firefox and chrome and safari need a defined width for the fixed table
		if (bFixedTable && (!!sap.ui.Device.browser.firefox || !!sap.ui.Device.browser.chrome || !!sap.ui.Device.browser.safari)) {
			rm.addStyle("width", oTable._getColumnsWidth(iStartColumn, iEndColumn) + "px");
		}
		rm.writeStyles();
		rm.write(">");

		rm.write("<thead>");

		rm.write("<tr");
		rm.addClass("sapUiTableCtrlCol");
		if (iStartRow == 0) {
			rm.addClass("sapUiTableCtrlFirstCol");
		}
		rm.writeClasses();
		rm.write(">");

		var aCols = oTable.getColumns();
		if (oTable.getSelectionMode() !== sap.ui.table.SelectionMode.None &&
				oTable.getSelectionBehavior() !== sap.ui.table.SelectionBehavior.RowOnly) {
			rm.write("<th");
			rm.addStyle("width", "0px");
			rm.writeStyles();
			if (oTable._bAccMode && iStartRow == 0) {
				rm.writeAttribute("role", "columnheader");
				rm.writeAttribute("scope", "col");
				rm.writeAttribute("id", oTable.getId() + "_colsel");
			}
			rm.write("></th>");
		} else {
			if (aCols.length === 0) {
				// no cols => render th => avoids rendering issue in firefox
				rm.write("<th></th>");
			}
		}

		for (var col = iStartColumn, count = iEndColumn; col < count; col++) {
			var oColumn = aCols[col];
			if (oColumn && oColumn.shouldRender()) {
				rm.write("<th");
				rm.addStyle("width", oColumn.getWidth());
				rm.writeStyles();
				if (iStartRow == 0) {
					if (oTable._bAccMode) {
						rm.writeAttribute("aria-owns", oColumn.getId());
						rm.writeAttribute("aria-labelledby", oColumn.getId());
						rm.writeAttribute("role", "columnheader");
						rm.writeAttribute("scope", "col");
						rm.writeAttribute("id", oTable.getId() + "_col" + col);
					}
				}
				rm.writeAttribute("data-sap-ui-headcolindex", col);
				rm.write(">");
				if (iStartRow == 0) {
					if (oColumn.getMultiLabels().length > 0) {
						rm.renderControl(oColumn.getMultiLabels()[0]);
					} else {
						rm.renderControl(oColumn.getLabel());
					}
				}
				rm.write("</th>");
			}
		}

		// dummy column to fill the table width
		if (!bFixedTable && oTable._hasOnlyFixColumnWidths() && aCols.length > 0) {
			rm.write("<th></th>");
		}

		rm.write("</tr>");
		rm.write("</thead>");

		rm.write("<tbody>");

		// render the table rows
		var aRows = oTable.getRows();
		for (var row = iStartRow, count = iEndRow; row < count; row++) {
			this.renderTableRow(rm, oTable, aRows[row], row, bFixedTable, iStartColumn, iEndColumn, false);
		}

		rm.write("</tbody>");
		rm.write("</table>");
	};

	TableRenderer.renderTableRow = function(rm, oTable, oRow, iRowIndex, bFixedTable, iStartColumn, iEndColumn, bFixedRow) {

		rm.write("<tr");
		rm.addClass("sapUiTableTr");
		if (bFixedTable) {
			rm.writeAttribute("id", oRow.getId() + "-fixed");
		} else {
			rm.writeElementData(oRow);
		}
		if (oRow._bHidden) {
			rm.addClass("sapUiTableRowHidden");
		}
		if (iRowIndex % 2 === 0) {
			rm.addClass("sapUiTableRowEven");
		} else {
			rm.addClass("sapUiTableRowOdd");
		}
		rm.writeClasses();
		rm.writeAttribute("data-sap-ui-rowindex", iRowIndex);
		if (oTable.getRowHeight() > 0) {
			rm.addStyle("height", oTable.getRowHeight() + "px");
		}
		rm.writeStyles();
		if (oTable._bAccMode) {
			rm.writeAttribute("role", "row");
			if (oTable.getSelectionMode() === sap.ui.table.SelectionMode.Multi) {
				rm.writeAttribute("aria-selected", "false");
			}
	//		if (oTable.getSelectionMode() !== sap.ui.table.SelectionMode.None) {
	//			rm.writeAttributeEscaped("title", oTable._oResBundle.getText("TBL_ROW_SELECT"));
	//			rm.writeAttributeEscaped("aria-label", oTable._oResBundle.getText("TBL_ROW_SELECT_KEY"));
	//		}
		}
		rm.write(">");
		var aCells = oRow.getCells();
		if (oTable.getSelectionMode() !== sap.ui.table.SelectionMode.None &&
				oTable.getSelectionBehavior() !== sap.ui.table.SelectionBehavior.RowOnly) {
			rm.write("<td");
			if (oTable._bAccMode) {
				rm.writeAttribute("role", "gridcell");
				rm.writeAttribute("headers", oTable.getId() + "_colsel");
				rm.writeAttribute("aria-owns", oTable.getId() + "-rowsel" + iRowIndex);
				if (oTable.getSelectionMode() === sap.ui.table.SelectionMode.Multi) {
					rm.writeAttribute("aria-selected", "false");
				}
			}
			rm.write(">");
			if (oTable._bAccMode) {
				rm.write("<div");
				rm.addClass("sapUiTableAriaRowSel");
				rm.writeClasses();
				rm.write(">");
				rm.write(oTable._oResBundle.getText("TBL_ROW_SELECT_KEY"));
				rm.write("</div>");
			}
			rm.write("</td>");
		} else {
			if (aCells.length === 0) {
				rm.write("<td");
				if (oTable._bAccMode) {
					rm.writeAttribute("role", "gridcell");
					rm.writeAttribute("headers", oTable.getId() + "_colsel");
					rm.writeAttribute("aria-owns", oTable.getId() + "-rowsel" + iRowIndex);
					if (oTable.getSelectionMode() === sap.ui.table.SelectionMode.Multi) {
						rm.writeAttribute("aria-selected", "false");
					}
				}
				rm.write(">");
				if (oTable._bAccMode) {
					rm.write("<div");
					rm.addClass("sapUiTableAriaRowSel");
					rm.writeClasses();
					rm.write(">");
					rm.write(oTable._oResBundle.getText("TBL_ROW_SELECT_KEY"));
					rm.write("</div>");
				}
				rm.write("</td>");
			}
		}
		for (var cell = 0, count = aCells.length; cell < count; cell++) {
			this.renderTableCell(rm, oTable, oRow, aCells[cell], cell, bFixedTable, iStartColumn, iEndColumn);
		}
		if (!bFixedTable && oTable._hasOnlyFixColumnWidths() && aCells.length > 0) {
			rm.write("<td></td>");
		}
		rm.write("</tr>");

	};

	TableRenderer.renderTableCell = function(rm, oTable, oRow, oCell, iCellIndex, bFixedTable, iStartColumn, iEndColumn) {
		var iColIndex = oCell.data("sap-ui-colindex");
		var oColumn = oTable.getColumns()[iColIndex];
		if (oColumn.shouldRender() && iStartColumn <= iColIndex && iEndColumn > iColIndex) {
			rm.write("<td");
			var sId = oRow.getId() + "-col" + iCellIndex;
			rm.writeAttribute("id", sId);
			rm.writeAttribute("tabindex", "-1");
			if (oTable._bAccMode) {
				// correct would be aria-labelledby but doesn't work for JAWS
				rm.writeAttribute("headers", oTable.getId() + "_col" + iColIndex);
				rm.writeAttribute("role", "gridcell");
				var sLabelledBy = oTable.getId() + "-ariadesc " + oColumn.getId();
				var iMultiLabels = oColumn.getMultiLabels().length;
				if (iMultiLabels > 1) {
					for (var i = 1; i < iMultiLabels; i++) {
						sLabelledBy +=  " " + oColumn.getId() + "_" + i;
					}
				}
				sLabelledBy +=  " " + oCell.getId();
				rm.writeAttribute("aria-labelledby", sLabelledBy);
				rm.writeAttribute("aria-describedby", oTable.getId() + "-toggleedit");
				rm.writeAttribute("aria-activedescendant", oCell.getId());
				if (oTable.getSelectionMode() === sap.ui.table.SelectionMode.Multi) {
					rm.writeAttribute("aria-selected", "false");
				}
			}
			var sHAlign = this.getHAlign(oColumn.getHAlign(), oTable._bRtlMode);
			if (sHAlign) {
				rm.addStyle("text-align", sHAlign);
			}
			rm.writeStyles();
			var aVisibleColumns = oTable._getVisibleColumns();
			if (aVisibleColumns.length > 0 && aVisibleColumns[0] === oColumn) {
				rm.addClass("sapUiTableTdFirst");
			}
			// grouping support to show/hide values of grouped columns
			if (oColumn.getGrouped()) {
				rm.addClass("sapUiTableTdGroup");
			}
			rm.writeClasses();
			rm.write("><div");
			rm.addClass("sapUiTableCell");
			
			rm.writeClasses();
			
			if (oTable.getRowHeight() && oTable.getVisibleRowCountMode() == sap.ui.table.VisibleRowCountMode.Auto) {
				rm.addStyle("max-height", oTable.getRowHeight() + "px");
			}
			rm.writeStyles();
			
			rm.write(">");
			this.renderTableCellControl(rm, oTable, oCell, iCellIndex);
			rm.write("</div></td>");
		}
	};

	TableRenderer.renderTableCellControl = function(rm, oTable, oCell, iCellIndex) {
		rm.renderControl(oCell);
	};

	TableRenderer.renderVSb = function(rm, oTable) {
		rm.write("<div");
		rm.addClass("sapUiTableVSb");
		rm.writeClasses();
		rm.write(">");
		rm.renderControl(oTable._oVSb);
		rm.write("</div>");
	};

	TableRenderer.renderHSb = function(rm, oTable) {
		rm.write("<div");
		rm.addClass("sapUiTableHSb");
		rm.writeClasses();
		rm.write(">");
		rm.renderControl(oTable._oHSb);
		rm.write("</div>");
	};


	// =============================================================================
	// HELPER FUNCTIONALITY
	// =============================================================================

	/**
	 * Returns the value for the HTML "align" attribute according to the given
	 * horizontal alignment and RTL mode, or NULL if the HTML default is fine.
	 *
	 * @param {sap.ui.core.HorizontalAlign} oHAlign
	 * @param {boolean} bRTL
	 * @type string
	 */
	TableRenderer.getHAlign = function(oHAlign, bRTL) {
	  switch (oHAlign) {
		case sap.ui.core.HorizontalAlign.Center:
		  return "center";
		case sap.ui.core.HorizontalAlign.End:
		case sap.ui.core.HorizontalAlign.Right:
		  return bRTL ? "left" : "right";
	  }
	  // case sap.ui.core.HorizontalAlign.Left:
	  // case sap.ui.core.HorizontalAlign.Begin:
	  return bRTL ? "right" : "left";
	};


	return TableRenderer;

}, /* bExport= */ true);

}; // end of sap/ui/table/TableRenderer.js
if ( !jQuery.sap.isDeclared('sap.ui.table.TreeAutoExpandMode') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides enumeration sap.ui.table.TreeAutoExpandMode
jQuery.sap.declare('sap.ui.table.TreeAutoExpandMode'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
sap.ui.define("sap/ui/table/TreeAutoExpandMode",['jquery.sap.global'],
	function(jQuery) {
	"use strict";


	/**
	* @class
	* Different modes for setting the auto expand mode on different tables (Analytical-, TreeTable, ...)
	*
	* @static
	* @public
	* @alias sap.ui.table.TreeAutoExpandMode
	*/
	var TreeAutoExpandMode = {
			/**
			 * Tree nodes will be expanded in sequence, level by level (Single requests are sent)
			 * @public
			 */
			Sequential: "Sequential",
	
			/**
			 * If supported by a backend provider with analytical capabilities, the requests needed for an automatic node expansion are bundled.
			 * @public
			 */
			Bundled: "Bundled"
	};

	return TreeAutoExpandMode;

}, /* bExport= */ true);
}; // end of sap/ui/table/TreeAutoExpandMode.js
if ( !jQuery.sap.isDeclared('sap.ui.table.TreeTableRenderer') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

//Provides default renderer for control sap.ui.table.TreeTable
jQuery.sap.declare('sap.ui.table.TreeTableRenderer'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.Renderer'); // unlisted dependency retained
sap.ui.define("sap/ui/table/TreeTableRenderer",['jquery.sap.global', 'sap/ui/core/Renderer', './TableRenderer'],
	function(jQuery, Renderer, TableRenderer) {
	"use strict";


	/**
	 * TreeTable renderer.
	 * @namespace
	 */
	var TreeTableRenderer = Renderer.extend(TableRenderer);
	
	
	TreeTableRenderer.renderTableCellControl = function(rm, oTable, oCell, iCellIndex) {
		if (oTable.isTreeBinding("rows") && iCellIndex === 0 && !oTable.getUseGroupMode()) {
			rm.write("<span");
			rm.addClass("sapUiTableTreeIcon");
			rm.addClass("sapUiTableTreeIconLeaf");
			rm.writeClasses();
			rm.writeAttribute("tabindex", -1);
			rm.write(">&nbsp;</span>");
		}
		rm.renderControl(oCell);
	};
	

	return TreeTableRenderer;

}, /* bExport= */ true);

}; // end of sap/ui/table/TreeTableRenderer.js
if ( !jQuery.sap.isDeclared('sap.ui.table.library') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

/**
 * Initialization Code and shared classes of library sap.ui.table.
 */
jQuery.sap.declare('sap.ui.table.library'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.library'); // unlisted dependency retained
jQuery.sap.require('sap.ui.unified.library'); // unlisted dependency retained
sap.ui.define("sap/ui/table/library",['jquery.sap.global',
	'sap/ui/core/library', // library dependency
	'sap/ui/unified/library'], // library dependency
	function(jQuery) {

	"use strict";

	/**
	 * Table-like controls, mainly for desktop scenarios.
	 *
	 * @namespace
	 * @name sap.ui.table
	 * @author SAP SE
	 * @version 1.28.10
	 * @public
	 */

	// delegate further initialization of this library to the Core
	sap.ui.getCore().initLibrary({
		name : "sap.ui.table",
		version: "1.28.10",
		dependencies : ["sap.ui.core","sap.ui.unified"],
		types: [
			"sap.ui.table.NavigationMode",
			"sap.ui.table.SelectionBehavior",
			"sap.ui.table.SelectionMode",
			"sap.ui.table.SortOrder",
			"sap.ui.table.VisibleRowCountMode"
		],
		interfaces: [],
		controls: [
			"sap.ui.table.AnalyticalColumnMenu",
			"sap.ui.table.AnalyticalTable",
			"sap.ui.table.ColumnMenu",
			"sap.ui.table.DataTable",
			"sap.ui.table.Table",
			"sap.ui.table.TreeTable"
		],
		elements: [
			"sap.ui.table.AnalyticalColumn",
			"sap.ui.table.Column",
			"sap.ui.table.Row"
		]
	});


	/**
	 * Navigation mode of the table
	 *
	 * @version 1.28.10
	 * @enum {string}
	 * @public
	 * @ui5-metamodel This enumeration also will be described in the UI5 (legacy) designtime metamodel
	 */
	sap.ui.table.NavigationMode = {

		/**
		 * Uses the scrollbar control.
		 * @public
		 */
		Scrollbar : "Scrollbar",

		/**
		 * Uses the paginator control.
		 * @public
		 */
		Paginator : "Paginator"

	};


	/**
	 * Selection behavior of the table
	 *
	 * @version 1.28.10
	 * @enum {string}
	 * @public
	 * @ui5-metamodel This enumeration also will be described in the UI5 (legacy) designtime metamodel
	 */
	sap.ui.table.SelectionBehavior = {

		/**
		 * Rows can be selected on the complete row.
		 * @public
		 */
		Row : "Row",

		/**
		 * Rows can only be selected on the row selector.
		 * @public
		 */
		RowSelector : "RowSelector",

		/**
		 * Rows can only be selected on the row (and the selector is hidden).
		 * @public
		 */
		RowOnly : "RowOnly"

	};


	/**
	 * Selection mode of the table
	 *
	 * @version 1.28.10
	 * @enum {string}
	 * @public
	 * @ui5-metamodel This enumeration also will be described in the UI5 (legacy) designtime metamodel
	 */
	sap.ui.table.SelectionMode = {

		/**
		 * Select multiple rows at a time (toggle behavior).
		 * @public
		 */
		MultiToggle : "MultiToggle",

		/**
		 * Select multiple rows at a time.
		 * @public
		 */
		Multi : "Multi",

		/**
		 * Select one row at a time.
		 * @public
		 */
		Single : "Single",

		/**
		 * No rows can be selected.
		 * @public
		 */
		None : "None"

	};


	/**
	 * Sort order of a column
	 *
	 * @version 1.28.10
	 * @enum {string}
	 * @public
	 * @ui5-metamodel This enumeration also will be described in the UI5 (legacy) designtime metamodel
	 */
	sap.ui.table.SortOrder = {

		/**
		 * Sort Order: ascending.
		 * @public
		 */
		Ascending : "Ascending",

		/**
		 * Sort Order: descending.
		 * @public
		 */
		Descending : "Descending"

	};


	/**
	 * VisibleRowCountMode of the table
	 *
	 * @version 1.28.10
	 * @enum {string}
	 * @public
	 * @ui5-metamodel This enumeration also will be described in the UI5 (legacy) designtime metamodel
	 */
	sap.ui.table.VisibleRowCountMode = {

		/**
		 * The table always has as many rows as defined in the visibleRowCount property.
		 * @public
		 */
		Fixed : "Fixed",

		/**
		 * After rendering the table has as many rows as defined in visibleRowCount property. The user is able to change the visible rows by moving a grip with the mouse. The visibleRowCount property is changed accordingly.
		 * @public
		 */
		Interactive : "Interactive",

		/**
		 * The table automatically fills the height of the surrounding container. The visibleRowCount property is automatically changed accordingly. All rows need the same height, otherwise the auto mode doesn't always work as expected.
		 * @public
		 */
		Auto : "Auto"

	};

	/**
	 * Details about the group event to distinguish between different actions associated with grouping
	 * @enum {string}
	 * @public
	 * @type {{group: string, ungroup: string, ungroupAll: string, moveUp: string, moveDown: string, showGroupedColumn: string, hideGroupedColumn: string}}
	 */
	sap.ui.table.GroupEventType = {
		/**
		 * Group Column
		 * @public
		 */
		group: "group",
		/**
		 * Ungroup Column
		 * @public
		 */
		ungroup: "ungroup",
		/**
		 * Ungroup All Columns
		 * @public
		 */
		ungroupAll: "ungroupAll",
		/**
		 * Change the group order of the columns. Move column one position up in the group sequence
		 * @public
		 */
		moveUp: "moveUp",
		/**
		 * Change the group order of the columns. Move column one position down in the group sequence
		 * @public
		 */
		moveDown: "moveDown",
		/**
		 * Show grouped column also as a column, not just as group header
		 * @public
		 */
		showGroupedColumn: "showGroupedColumn",
		/**
		 * Show grouped column only as group header
		 * @public
		 */
		hideGroupedColumn: "hideGroupedColumn"
	};

	// map the new Column to the old ColumnHeader
	sap.ui.table.ColumnHeader = sap.ui.table.Column;

	// map the SelectionMode All to Multi
	sap.ui.table.SelectionMode.All = sap.ui.table.SelectionMode.Multi;

	//factory for table to create labels an textviews to be overwritten by commons and mobile library
	if (!sap.ui.table.TableHelper) {
		sap.ui.table.TableHelper = {
			createLabel: function(mConfig){ throw new Error("no Label control available!"); }, /* must return a Label control */
			createTextView: function(mConfig){ throw new Error("no TextView control available!"); }, /* must return a textview control */
			createTextField: function(mConfig){ throw new Error("no TextField control available!"); }, /* must return a textfield control */
			createImage: function(mConfig){ throw new Error("no Image control available!"); }, /* must return a textview control */
			bFinal: false /* if true, the helper must not be overwritten by an other library */
		};
	}

	return sap.ui.table;

});

}; // end of sap/ui/table/library.js
if ( !jQuery.sap.isDeclared('sap.ui.table.AnalyticalColumnMenuRenderer') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

jQuery.sap.declare('sap.ui.table.AnalyticalColumnMenuRenderer'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.Renderer'); // unlisted dependency retained
sap.ui.define("sap/ui/table/AnalyticalColumnMenuRenderer",['jquery.sap.global', 'sap/ui/core/Renderer', './ColumnMenuRenderer'],
	function(jQuery, Renderer, ColumnMenuRenderer) {
	"use strict";


	/**
	 * AnalyticalTable renderer.
	 * @namespace
	 */
	var AnalyticalColumnMenuRenderer = Renderer.extend(ColumnMenuRenderer);

	return AnalyticalColumnMenuRenderer;

}, /* bExport= */ true);

}; // end of sap/ui/table/AnalyticalColumnMenuRenderer.js
if ( !jQuery.sap.isDeclared('sap.ui.table.AnalyticalTableRenderer') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

jQuery.sap.declare('sap.ui.table.AnalyticalTableRenderer'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.Renderer'); // unlisted dependency retained
sap.ui.define("sap/ui/table/AnalyticalTableRenderer",['jquery.sap.global', 'sap/ui/core/Renderer', './TableRenderer'],
	function(jQuery, Renderer, TableRenderer) {
	"use strict";


	/**
	 * AnalyticalTable renderer. 
	 * @namespace
	 */
	var AnalyticalTableRenderer = Renderer.extend(TableRenderer);

	return AnalyticalTableRenderer;

}, /* bExport= */ true);

}; // end of sap/ui/table/AnalyticalTableRenderer.js
if ( !jQuery.sap.isDeclared('sap.ui.table.Column') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides control sap.ui.table.Column.
jQuery.sap.declare('sap.ui.table.Column'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.Element'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.RenderManager'); // unlisted dependency retained
jQuery.sap.require('sap.ui.model.Filter'); // unlisted dependency retained
jQuery.sap.require('sap.ui.model.Sorter'); // unlisted dependency retained
jQuery.sap.require('sap.ui.model.Type'); // unlisted dependency retained
jQuery.sap.require('sap.ui.model.type.String'); // unlisted dependency retained
sap.ui.define("sap/ui/table/Column",['jquery.sap.global', 'sap/ui/core/Element', 'sap/ui/core/RenderManager', 'sap/ui/model/Filter', 'sap/ui/model/Sorter', 'sap/ui/model/Type', 'sap/ui/model/type/String', './library'],
	function(jQuery, Element, RenderManager, Filter, Sorter, Type, String, library) {
	"use strict";


	/**
	 * Constructor for a new Column.
	 *
	 * @param {string} [sId] id for the new control, generated automatically if no id is given
	 * @param {object} [mSettings] initial settings for the new control
	 *
	 * @class
	 * The column allows to define column specific properties that will be applied when rendering the table.
	 * @extends sap.ui.core.Element
	 * @version 1.28.10
	 *
	 * @constructor
	 * @public
	 * @alias sap.ui.table.Column
	 * @ui5-metamodel This control/element also will be described in the UI5 (legacy) designtime metamodel
	 */
	var Column = Element.extend("sap.ui.table.Column", /** @lends sap.ui.table.Column.prototype */ { metadata : {

		library : "sap.ui.table",
		properties : {

			/**
			 * Width of the column.
			 */
			width : {type : "sap.ui.core.CSSSize", group : "Dimension", defaultValue : null},

			/**
			 * Is the width of the column flexible (grows on resize)?
			 */
			flexible : {type : "boolean", group : "Behavior", defaultValue : true},

			/**
			 * Is the column resizable or not?
			 */
			resizable : {type : "boolean", group : "Behavior", defaultValue : true},

			/**
			 * Horizontal alignment of the column content. Controls with a text align do not inherit the horizontal alignment. You have to set the text align directly on the template.
			 */
			hAlign : {type : "sap.ui.core.HorizontalAlign", group : "Appearance", defaultValue : sap.ui.core.HorizontalAlign.Begin},

			/**
			 * flag, if the column is sorted or not (displays the sorting indicator, does not trigger the sort method!)
			 */
			sorted : {type : "boolean", group : "Appearance", defaultValue : false},

			/**
			 * Sort order for this column.
			 * @see sap.ui.table.SortOrder (default value: "Ascending")
			 */
			sortOrder : {type : "sap.ui.table.SortOrder", group : "Appearance", defaultValue : sap.ui.table.SortOrder.Ascending},

			/**
			 * Specifies the binding property on which the column will sort.
			 */
			sortProperty : {type : "string", group : "Behavior", defaultValue : null},

			/**
			 * flag, if the column is filtered or not (displays the filter indicator, does not trigger the filter method!)
			 */
			filtered : {type : "boolean", group : "Appearance", defaultValue : false},

			/**
			 * Specifies the binding property on which the column will filter.
			 */
			filterProperty : {type : "string", group : "Behavior", defaultValue : null},

			/**
			 * Specifies the value of the filter as string (will be converted into the propert data type).
			 */
			filterValue : {type : "string", group : "Behavior", defaultValue : null},

			/**
			 * Filter operator to use when filtering this column.
			 * @see sap.ui.model.FilterOperator (default value: "Contains")
			 */
			filterOperator : {type : "string", group : "Behavior", defaultValue : null},

			/**
			 * flag, if the column is grouped or not (hides the column!)
			 */
			grouped : {type : "boolean", group : "Appearance", defaultValue : false},

			/**
			 * Invisible controls are not rendered.
			 */
			visible : {type : "boolean", group : "Appearance", defaultValue : true},

			/**
			 * Type of Filter. This is used to transform the search term to the specified type, to make sure that the right columns are displayed. This should be the same as defined in binding for this column. As alternative you can pass a function which does the conversion. The function receives the entered filter value as parameter and returns the proper value for the filter expression. Another option is to pass the classname of the type, e.g.: sap.ui.model.type.Date or an expression similar to the binding syntax, e.g.: "\{type: 'sap.ui.model.type.Date', formatOptions: \{UTC: true\}, constraints: {} \}". Here the escaping is mandatory to avoid handling by the binding parser. By default the filter type is sap.ui.model.type.String.
			 * @since 1.9.2
			 */
			filterType : {type : "any", group : "Misc", defaultValue : null},

			/**
			 * The name of the column which is used in the column visibility menu item as text. If not set as fallback the column menu tries to get the text from the nested Label.
			 * @since 1.11.1
			 */
			name : {type : "string", group : "Appearance", defaultValue : null},

			/**
			 * Define if the filter menu entry is displayed
			 * @since 1.13.0
			 */
			showFilterMenuEntry : {type : "boolean", group : "Appearance", defaultValue : true},

			/**
			 * Define if the sort menu entries are displayed
			 * @since 1.13.0
			 */
			showSortMenuEntry : {type : "boolean", group : "Appearance", defaultValue : true},

			/**
			 * If this property is set a span is applied for the header. When moving columns all columns which are part of the header will be moved. This can be either an integer or an array of integers (if you use the multi header feature of the table). If you only specify an integer this span is applied for all header rows, with multiple integers you can specify a seperate span for each header row.
			 */
			headerSpan : {type : "any", group : "Behavior", defaultValue : 1},

			/**
			 * Enables auto-resizing of the column on doubleclicking the resizer. Currently only implemented to work with the following controls: sap.m.Text, sap.m.Label, sap.m.Link , sap.m.Input, sap.ui.commons.TextView, sap.ui.commons.Label, sap.ui.commons.Link and sap.ui.commons.TextField, sap.ui.commons.Checkbox, sap.m.Checkbox
			 * @since 1.21.1
			 */
			autoResizable : {type : "boolean", group : "Behavior", defaultValue : false},

			/**
			 * If this property is set the default filter operator of the column is overwritten.
			 * By default "Contains" is used for string and "EQ" for other types. A valid sap.ui.model.FilterOperator needs to be passed.
			 */
			defaultFilterOperator : {type : "string", group : "Behavior", defaultValue : null}
		},
		defaultAggregation : "label",
		aggregations : {

			/**
			 * Label (header renderer) of the column which is displayed in the column header. Define a control for each header row in the table. This aggregation is for the standard behaviour, if you only want to display one single row header.
			 */
			label : {type : "sap.ui.core.Control", multiple : false},

			/**
			 * Labels (header renderer) of the column which are displayed in the column header. Define a control for each header row in the table. Use this aggregation, if you want to use multiple headers per column.
			 * @since 1.13.1
			 */
			multiLabels : {type : "sap.ui.core.Control", multiple : true, singularName : "multiLabel"},

			/**
			 * Template (cell renderer) of this column. A template is decoupled from the column which means after changing the templates' properties or aggregations an explicit invalidation of the column or table is required. The default is: sap.ui.commons.TextView.
			 */
			template : {type : "sap.ui.core.Control", multiple : false},

			/**
			 * The menu used by the column. By default the {@link sap.ui.table.ColumnMenu} is used.
			 */
			menu : {type : "sap.ui.unified.Menu", multiple : false}
		}
	}});


	


	


	/** default filter type for the columns */
	Column._DEFAULT_FILTER_TYPE = new String();

	/**
	 * called when the column is initialized
	 */
	Column.prototype.init = function() {

		this.oResBundle = sap.ui.getCore().getLibraryResourceBundle("sap.ui.table");
		this._oSorter = null;

		// Skip proppagation of databinding properties to the template
		this.mSkipPropagation = {template: true};

	};

	/**
	 * called when the column is destroyed
	 */
	Column.prototype.exit = function() {

		// destroy the sort image
		var oSortImage = sap.ui.getCore().byId(this.getId() + "-sortIcon");
		if (oSortImage) {
			oSortImage.destroy();
		}

		// destroy the filter image
		var oFilterImage = sap.ui.getCore().byId(this.getId() + "-filterIcon");
		if (oFilterImage) {
			oFilterImage.destroy();
		}

	};

	/**
	 * called when the columns parent is set
	 */
	Column.prototype.setParent = function(oParent, sAggregationName, bSuppressRerendering) {
		Element.prototype.setParent.apply(this, arguments);
		var oMenu = this.getAggregation("menu");
		if (oMenu && typeof oMenu._updateReferences === "function") {
			//if menu is set update menus internal references
			oMenu._updateReferences(this);
		}
	};

	/*
	 * @see JSDoc generated by SAPUI5 control API generator
	 */
	Column.prototype.invalidate = function(oOrigin) {
		// prevent changes in the template (especially the databinding ones)
		//  - what about exchanging the template? => implemented in setTemplate
		//  - what about modifiying properties? => developer must call invalidate!
		// The problem is that we just need to prevent databinding changes. The
		// problem here is that the databinding bindings are created ones the template
		// is created and has its own model. If now changes are done in the model
		// this directly affects the template which invalidates the column invalidating
		// the complete Table.
		/*
		 * PART1: When you create the Tooltip (deferred) then it establishes the
		 * connection to its data (also for the template of the column!) and this
		 * finally invalidates the Table which triggers the re-rendering. One
		 * option is to complete decouple the template from the Table by
		 * supressing the invalidate. But this finally also decouples the Table
		 * from any changes on the template after the template has been applied
		 * to the Column. But when re-rendering it would update the column cells.
		 * To notify the Table on proper changes one has to call the method
		 * invalidate on the Table.
		*/
		/*
		 * PART2: we also suppress the re-rendering in case of the column menu is
		 * rerendered. This is a popup and we use the instance check because of the
		 * menu behind the getMenu function is lazy created when first accessed.
		 */
	  if (oOrigin !== this.getTemplate() && !(oOrigin instanceof sap.ui.table.ColumnMenu)) {
			// changes on the template require to call invalidate on the column or table
	    Element.prototype.invalidate.apply(this, arguments);
	  }
	};

	/*
	 * @see JSDoc generated by SAPUI5 control API generator
	 */
	Column.prototype.setLabel = function(vLabel) {
		var oLabel = vLabel;
		if (typeof (vLabel) === "string") {
			oLabel = sap.ui.table.TableHelper.createLabel({text: vLabel});
		}
		this.setAggregation("label", oLabel);
		return this;
	};

	/*
	 * @see JSDoc generated by SAPUI5 control API generator
	 */
	Column.prototype.setTemplate = function(vTemplate) {
		var oTemplate = vTemplate;
		if (typeof (vTemplate) === "string") {
			oTemplate = sap.ui.table.TableHelper.createTextView().bindProperty("text", vTemplate);
		}
		this.setAggregation("template", oTemplate);
		// manually invalidate the Column (because of the invalidate decoupling to
		// prevent invalidations from the databinding part)
		this.invalidate();
		return this;
	};


	/*
	 * @see JSDoc generated by SAPUI5 control API generator
	 */
	Column.prototype.getMenu = function() {
		var oMenu = this.getAggregation("menu");
		if (!oMenu) {
			oMenu = this._createMenu();
			this.setMenu(oMenu);
		}
		return oMenu;
	};

	/*
	 * @see JSDoc generated by SAPUI5 control API generator
	 */
	Column.prototype.setMenu = function(oMenu) {
		this.setAggregation("menu", oMenu, true);
		return this;
	};

	/*
	 * Factory method. Creates the column menu.
	 *
	 * @return {sap.ui.table.ColumnMenu} The created column menu.
	 */
	Column.prototype._createMenu = function() {
		jQuery.sap.require("sap.ui.table.ColumnMenu");
		return new sap.ui.table.ColumnMenu(this.getId() + "-menu");
	};


	/*
	 * @see JSDoc generated by SAPUI5 control API generator
	sap.ui.table.Column.prototype.setEditorTemplate = function(vTemplate) {
		var oTemplate = vTemplate;
		if (typeof (vTemplate) === "string") {
			oTemplate = sap.ui.table.TableHelper.createTextField().bindProperty("value", vTemplate);
		}
		this.setAggregation("editorTemplate", oTemplate);
		return this;
	};
	*/

	/*
	 * @see JSDoc generated by SAPUI5 control API generator
	 */
	Column.prototype.setWidth = function(sWidth) {
		this.setProperty("width", sWidth);
		this.fireEvent('_widthChanged', { newWidth: sWidth });
		return this;
	};

	Column.prototype._setAppDefault = function(sProperty, mValue) {
		if (!this._appDefaults) {
			this._appDefaults = {};
		}

		if (sProperty == "sorted") {
			this._appDefaults.sorted = mValue;
		} else if (sProperty == "sortOrder") {
			this._appDefaults.sortOrder = mValue;
		} else if (sProperty == "filtered") {
			this._appDefaults.filtered = mValue;
		} else if (sProperty == "filterValue") {
			this._appDefaults.filterValue = mValue;
		} else if (sProperty == "filterOperator") {
			this._appDefaults.filterOperator = mValue;
		}
	};

	Column.prototype._restoreAppDefaults = function() {
		if (this._appDefaults) {
			this.setProperty("sorted", this._appDefaults.sorted, true);
			this.setProperty("sortOrder", this._appDefaults.sortOrder, true);
			this.setProperty("filtered", this._appDefaults.filtered, true);
			this.setProperty("filterValue", this._appDefaults.filterValue, true);
			this.setProperty("filterOperator", this._appDefaults.filterOperator, true);
			this._renderSortIcon();
			this._renderFilterIcon();
		}
	};

	/*
	 * @see JSDoc generated by SAPUI5 control API generator
	 */
	Column.prototype.setSorted = function(bFlag) {
		this.setProperty("sorted", bFlag, true);
		this._setAppDefault("sorted", bFlag);
		this._renderSortIcon();
		return this;
	};

	/*
	 * @see JSDoc generated by SAPUI5 control API generator
	 */
	Column.prototype.setSortOrder = function(tSortOrder) {
		this.setProperty("sortOrder", tSortOrder, true);
		this._setAppDefault("sortOrder", tSortOrder);
		this._renderSortIcon();
		return this;
	};

	/*
	 * @see JSDoc generated by SAPUI5 control API generator
	 */
	Column.prototype.setFiltered = function(bFlag) {
		this.setProperty("filtered", bFlag, true);
		this._setAppDefault("filtered", bFlag);
		this._renderFilterIcon();
		return this;
	};

	/*
	 * @see JSDoc generated by SAPUI5 control API generator
	 */
	Column.prototype.setFilterValue = function(sValue) {
		this.setProperty("filterValue", sValue, true);
		this._setAppDefault("filterValue", sValue);
		if (this.getMenu()) {
			this.getMenu()._setFilterValue(sValue);
		}
		return this;
	};

	/*
	 * @see JSDoc generated by SAPUI5 control API generator
	 */
	Column.prototype.setFilterOperator = function(sValue) {
		this.setProperty("filterOperator", sValue, true);
		this._setAppDefault("filterOperator", sValue);
		return this;
	};


	/**
	 * Function is called when mouse key is clicked down.
	 *
	 * @param {jQuery.Event} oEvent
	 * @private
	 */
	Column.prototype.onmousedown = function(oEvent) {
		var oMenu = this.getAggregation("menu");
		this._bSkipOpen = oMenu && oMenu.bOpen;
	};


	/**
	 * Function is called when mouse leaves the control.
	 *
	 * @param {jQuery.Event} oEvent
	 * @private
	 */
	Column.prototype.onmouseout = function(oEvent) {
		if (this._bSkipOpen && jQuery.sap.checkMouseEnterOrLeave(oEvent, this.getDomRef())){
			this._bSkipOpen = false;
		}
	};


	Column.prototype._openMenu = function(oDomRef) {
		if (this._bSkipOpen){
			this._bSkipOpen = false;
			return;
		}
		var oMenu = this.getMenu();
		var eDock = sap.ui.core.Popup.Dock;
		var oFocusDomRef = oDomRef;
		if (!oDomRef) {
			oDomRef = this.getDomRef();
			oFocusDomRef = this.getFocusDomRef();
		}
		oMenu.open(false, oFocusDomRef, eDock.BeginTop, eDock.BeginBottom, oDomRef, "none none");
	};


	/**
	 * toggles the sort order of the column
	 *
	 * @type sap.ui.table.Column
	 * @public
	 * @deprecated Since version 1.5.1.
	 * Please use the function "sap.ui.Table.prototype.sort".
	 * @ui5-metamodel This method also will be described in the UI5 (legacy) designtime metamodel
	 */
	Column.prototype.toggleSort = function() {
		// by default we sort ascending / only if already is sorted ascending then we toggle
		this.sort(this.getSorted() && this.getSortOrder() === sap.ui.table.SortOrder.Ascending);
	};


	/**
	 * sorts the current column ascending or descending
	 *
	 * @param {boolean} bDescending
	 *         sort order of the column (if undefined the default will be ascending)
	 * @type sap.ui.table.Column
	 * @public
	 * @deprecated Since version 1.5.1.
	 * Please use the function "sap.ui.Table.prototype.sort".
	 * @ui5-metamodel This method also will be described in the UI5 (legacy) designtime metamodel
	 */
	Column.prototype.sort = function(bDescending, bAdd) {

		var oTable = this.getParent();
		if (oTable) {

			// get the sort order type
			var oNewSortOrder = bDescending ? sap.ui.table.SortOrder.Descending : sap.ui.table.SortOrder.Ascending;

			// notify the event listeners
			var bExecuteDefault = oTable.fireSort({
				column: this,
				sortOrder: oNewSortOrder,
				columnAdded: bAdd
			});

			if (bExecuteDefault) {

				// reset the sorting status of all columns
				var aSorters = [];
				var aCols = oTable.getColumns();
				if (bAdd) {
					for (var i = 0, l = aCols.length; i < l; i++) {
						if (aCols[i] == this) {
							// set the sort property of the current column
							this.setProperty("sorted", true, true);
							this.setProperty("sortOrder", oNewSortOrder, true);
							this._oSorter = new Sorter(this.getSortProperty(), this.getSortOrder() === sap.ui.table.SortOrder.Descending);
							aSorters.push(this._oSorter);
						} else {
							var oSorter = aCols[i]._oSorter;
							if (oSorter) {
								aSorters.push(oSorter);
							}
						}
					}
				} else {
					for (var i = 0, l = aCols.length; i < l; i++) {
						if (aCols[i] !== this) {
							aCols[i].setProperty("sorted", false, true);
							aCols[i].setProperty("sortOrder", sap.ui.table.SortOrder.Ascending, true);
							aCols[i]._renderSortIcon();
							delete aCols[i]._oSorter;
						}
					}
					// set the sort property of the current column
					this.setProperty("sorted", true, true);
					this.setProperty("sortOrder", oNewSortOrder, true);
					this._oSorter = new Sorter(this.getSortProperty(), this.getSortOrder() === sap.ui.table.SortOrder.Descending);
					aSorters.push(this._oSorter);
				}

				// set the sorted flag and sort the model
				if (oTable.isBound("rows")) {

					// sort the binding
					oTable.getBinding("rows").sort(aSorters);

					if (this._afterSort) {
						this._afterSort();
					}
				}

				// update the sort icon
				this._renderSortIcon();

			}

		}

		return this;

	};

	Column.prototype._renderSortIcon = function() {

		var oTable = this.getParent();
		if (oTable && oTable.getDomRef()) {
			if (this.getSorted()) {

				// create the image for the sort order visualization
				var sCurrentTheme = sap.ui.getCore().getConfiguration().getTheme();
				var oImage = sap.ui.getCore().byId(this.getId() + "-sortIcon") || sap.ui.table.TableHelper.createImage(this.getId() + "-sortIcon");
				oImage.addStyleClass("sapUiTableColIconsOrder");
				if (this.getSortOrder() === sap.ui.table.SortOrder.Ascending) {
					oImage.setSrc(sap.ui.resource("sap.ui.table", "themes/" + sCurrentTheme + "/img/ico12_sort_asc.gif"));
				} else {
					oImage.setSrc(sap.ui.resource("sap.ui.table", "themes/" + sCurrentTheme + "/img/ico12_sort_desc.gif"));
				}

				// apply the image and aria property to the column
				var oRenderManager = new RenderManager();
				var htmlImage = oRenderManager.getHTML(oImage);
				this.$().find(".sapUiTableColIconsOrder").remove();
				jQuery(htmlImage).prependTo(this.getDomRef("icons"));
				this.$().attr("aria-sort", this.getSortOrder() === sap.ui.table.SortOrder.Ascending ? "ascending" : "descending");

				this.$().find(".sapUiTableColCell").addClass("sapUiTableColSorted");

			} else {

				// remove the sort indicators
				this.$().find(".sapUiTableColIconsOrder").remove();
				this.$().removeAttr("aria-sort");

				this.$().find(".sapUiTableColCell").removeClass("sapUiTableColSorted");

			}
		}

	};

	Column.prototype._getFilter = function() {

		var oFilter,
		    sPath = this.getFilterProperty(),
		    sValue = this.getFilterValue(),
		    sOperator = this.getFilterOperator(),
		    sParsedValue,
		    sSecondaryParsedValue,
		    oType = this.getFilterType() || Column._DEFAULT_FILTER_TYPE,
		    bIsString = oType instanceof String,
		    aBetween;

		if (sValue) {

			// determine the operator
			if (!sOperator) {

				aBetween = sValue.match(/(.*)\s*\.\.\s*(.*)/);

				// determine the filter operator depending on the
				if (sValue.indexOf("=") == 0) {
					sOperator = sap.ui.model.FilterOperator.EQ;
					sParsedValue = sValue.substr(1);
				} else if (sValue.indexOf("!=") == 0) {
					sOperator = sap.ui.model.FilterOperator.NE;
					sParsedValue = sValue.substr(2);
				} else if (sValue.indexOf("<=") == 0) {
					sOperator = sap.ui.model.FilterOperator.LE;
					sParsedValue = sValue.substr(2);
				} else if (sValue.indexOf("<") == 0) {
					sOperator = sap.ui.model.FilterOperator.LT;
					sParsedValue = sValue.substr(1);
				} else if (sValue.indexOf(">=") == 0) {
					sOperator = sap.ui.model.FilterOperator.GE;
					sParsedValue = sValue.substr(2);
				} else if (sValue.indexOf(">") == 0) {
					sOperator = sap.ui.model.FilterOperator.GT;
					sParsedValue = sValue.substr(1);
				} else if (aBetween) {
					if (aBetween[1] && aBetween[2]) {
						sOperator = sap.ui.model.FilterOperator.BT;
						sParsedValue = aBetween[1];
						sSecondaryParsedValue = aBetween[2];
					} else if (aBetween[1] && !aBetween[2]) {
						sOperator = sap.ui.model.FilterOperator.GE;
						sParsedValue = aBetween[1];
					} else {
						sOperator = sap.ui.model.FilterOperator.LE;
						sParsedValue = aBetween[2];
					}
				} else if (bIsString && sValue.indexOf("*") == 0 && sValue.lastIndexOf("*") == sValue.length - 1) {
					sOperator = sap.ui.model.FilterOperator.Contains;
					sParsedValue = sValue.substr(1, sValue.length - 2);
				} else if (bIsString && sValue.indexOf("*") == 0) {
					sOperator = sap.ui.model.FilterOperator.EndsWith;
					sParsedValue = sValue.substr(1);
				} else if (bIsString && sValue.lastIndexOf("*") == sValue.length - 1) {
					sOperator = sap.ui.model.FilterOperator.StartsWith;
					sParsedValue = sValue.substr(0, sValue.length - 1);
				} else {
					if (this.getDefaultFilterOperator()) {
						sOperator = this.getDefaultFilterOperator();
					} else {
						if (bIsString) {
							// Due to compatibility reason we need to use Contains for Strings instead of EQ as default!!
							sOperator = sap.ui.model.FilterOperator.Contains;
						} else {
							sOperator = sap.ui.model.FilterOperator.EQ;
						}
					}
					sParsedValue = sValue.substr(0);
				}
				if (!sSecondaryParsedValue) {
					oFilter = new Filter(sPath, sOperator, this._parseFilterValue(sParsedValue));
				} else {
					oFilter = new Filter(sPath, sOperator, this._parseFilterValue(sParsedValue), this._parseFilterValue(sSecondaryParsedValue));
				}
			} else {
				oFilter = new Filter(sPath, sOperator, this._parseFilterValue(sValue));
			}

		}

		return oFilter;

	};

	Column.prototype.filter = function(sValue) {

		var oTable = this.getParent();
		if (oTable && oTable.isBound("rows")) {

			// notify the event listeners
			var bExecuteDefault = oTable.fireFilter({
				column: this,
				value: sValue
			});

			if (bExecuteDefault) {

				this.setProperty("filtered", !!sValue, true);
				this.setProperty("filterValue", sValue, true);

				var aFilters = [];
				var aCols = oTable.getColumns();
				for (var i = 0, l = aCols.length; i < l; i++) {
					var oCol = aCols[i],
						oMenu = oCol.getMenu(),
						oFilter;

					try {
						oFilter = oCol._getFilter();
						if (oMenu._setFilterState) {
							oMenu._setFilterState(sap.ui.core.ValueState.None);
						}
					} catch (e) {
						if (oMenu._setFilterState) {
							oMenu._setFilterState(sap.ui.core.ValueState.Error);
						}
						continue;
					}
					if (oFilter) {
						aFilters.push(oFilter);
					}
				}
				oTable.getBinding("rows").filter(aFilters, sap.ui.model.FilterType.Control);

				this._renderFilterIcon();

			}

		}

		return this;

	};

	Column.prototype._parseFilterValue = function(sValue) {
		var oFilterType = this.getFilterType();

		if (oFilterType) {
			if (jQuery.isFunction(oFilterType)) {
				sValue = oFilterType(sValue);
			} else {
				sValue = oFilterType.parseValue(sValue, "string");
			}
		}

		return sValue;
	};

	Column.prototype._renderFilterIcon = function() {
		var oTable = this.getParent();
		if (oTable && oTable.getDomRef()) {
			var sCurrentTheme = sap.ui.getCore().getConfiguration().getTheme();
			var oImage = sap.ui.getCore().byId(this.getId() + "-filterIcon") || sap.ui.table.TableHelper.createImage(this.getId() + "-filterIcon");
			oImage.$().remove();
			oImage.addStyleClass("sapUiTableColIconsFilter");
			if (this.getFiltered()) {
				oImage.setSrc(sap.ui.resource("sap.ui.table", "themes/" + sCurrentTheme + "/img/ico12_filter.gif"));
				var oRenderManager = new RenderManager();
				var htmlImage = oRenderManager.getHTML(oImage);
				jQuery(htmlImage).prependTo(this.getDomRef("icons"));
				this.$().find(".sapUiTableColCell").addClass("sapUiTableColFiltered");
			} else {
				this.$().find(".sapUiTableColCell").removeClass("sapUiTableColFiltered");
			}
		}
	};

	Column.prototype._restoreIcons = function() {

		if (this.getSorted()) {
			this._renderSortIcon();
		}

		if (this.getFiltered()) {
			this._renderFilterIcon();
		}

	};

	/**
	 * Returns whether the column should be rendered or not.
	 * @return {boolean} true, if the column should be rendered
	 * @protected
	 */
	Column.prototype.shouldRender = function() {
		return this.getVisible() && !this.getGrouped();
	};

	/*
	 * support the declarative usage of the filter type
	 * @see JSDoc generated by SAPUI5 control API generator
	 */
	Column.prototype.setFilterType = function(vType) {
		var oType = vType;
		if (typeof (vType) === "string") {
			try {
				// similar to BindingParser allow to specify formatOptions and constraints for types
				var mConfig = jQuery.sap.parseJS(vType);
				if (typeof (mConfig.type) === "string") {
					var fnType = jQuery.sap.getObject(mConfig.type);
					oType = fnType && new fnType(mConfig.formatOptions, mConfig.constraints);
				}
			} catch (ex) {
				var fnType = jQuery.sap.getObject(vType);
				oType = fnType && new fnType();
			}
			// check for a valid type
			if (!(oType instanceof Type)) {
				jQuery.sap.log.error("The filter type is not an instance of sap.ui.model.Type! Ignoring the filter type!");
				oType = undefined;
			}
		}
		this.setProperty("filterType", oType, true);
		return this;
	};



	return Column;

}, /* bExport= */ true);

}; // end of sap/ui/table/Column.js
if ( !jQuery.sap.isDeclared('sap.ui.table.ColumnMenu') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides control sap.ui.table.ColumnMenu.
jQuery.sap.declare('sap.ui.table.ColumnMenu'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.RenderManager'); // unlisted dependency retained
jQuery.sap.require('sap.ui.unified.Menu'); // unlisted dependency retained
jQuery.sap.require('sap.ui.unified.MenuItem'); // unlisted dependency retained
sap.ui.define("sap/ui/table/ColumnMenu",['jquery.sap.global', 'sap/ui/core/RenderManager', './library', 'sap/ui/unified/Menu', 'sap/ui/unified/MenuItem'],
	function(jQuery, RenderManager, library, Menu, MenuItem) {
	"use strict";


	
	/**
	 * Constructor for a new ColumnMenu.
	 *
	 * @param {string} [sId] id for the new control, generated automatically if no id is given 
	 * @param {object} [mSettings] initial settings for the new control
	 *
	 * @class
	 * The column menu provides all common actions that can be performed on a column.
	 * @extends sap.ui.unified.Menu
	 * @version 1.28.10
	 *
	 * @constructor
	 * @public
	 * @alias sap.ui.table.ColumnMenu
	 * @ui5-metamodel This control/element also will be described in the UI5 (legacy) designtime metamodel
	 */
	var ColumnMenu = Menu.extend("sap.ui.table.ColumnMenu", /** @lends sap.ui.table.ColumnMenu.prototype */ { metadata : {
	
		library : "sap.ui.table"
	}});
	
	
	/**
	 * This file defines behavior for the control,
	 */
	
	
	/**
	 * Initialization of the ColumnMenu control
	 * @private
	 */
	ColumnMenu.prototype.init = function() {
		if (Menu.prototype.init) {
			Menu.prototype.init.apply(this, arguments);
		}
		this.addStyleClass("sapUiTableColumnMenu");
		this.oResBundle = sap.ui.getCore().getLibraryResourceBundle("sap.ui.table");
		this._bInvalidated = true;
		this._iPopupClosedTimeoutId = null;
		this._oColumn = null;
		this._oTable = null;
		this._attachPopupClosed();
	};
	
	
	/**
	 * Termination of the ColumnMenu control
	 * @private
	 */
	ColumnMenu.prototype.exit = function() {
		if (Menu.prototype.exit) {
			Menu.prototype.exit.apply(this, arguments);
		}
		window.clearTimeout(this._iPopupClosedTimeoutId);
		this._detachEvents();
		this._oColumn = this._oTable = null;
	};
	
	
	/**
	 * Event handler. Called when the theme is changed.
	 * @private
	 */
	ColumnMenu.prototype.onThemeChanged = function() {
		if (this.getDomRef()) {
			this._invalidate();
		}
	};
	
	
	/**
	 * Overwrite of {@link sap.ui.unified.Menu#setParent} method.
	 * @see sap.ui.unified.Menu#setParent
	 * @private
	 */
	ColumnMenu.prototype.setParent = function(oParent) {
		this._detachEvents();
		this._invalidate();
		this._updateReferences(oParent);
		this._attachEvents();
		return Menu.prototype.setParent.apply(this, arguments);
	};
	
	ColumnMenu.prototype._updateReferences = function(oParent) {
		this._oColumn = oParent;
		if (oParent) {
			jQuery.sap.assert(oParent instanceof sap.ui.table.Column, "ColumnMenu.setParent: parent must be a subclass of sap.ui.table.Column");
	
			this._oTable = this._oColumn.getParent();
			if (this._oTable) {
				jQuery.sap.assert(this._oTable instanceof sap.ui.table.Table, "ColumnMenu.setParent: parent of parent must be subclass of sap.ui.table.Table");
			}
		}
	};
	
	
	/**
	 * Attaches the required event handlers.
	 * @private
	 */
	ColumnMenu.prototype._attachEvents = function() {
		if (this._oTable) {
			this._oTable.attachColumnVisibility(this._invalidate, this);
			this._oTable.attachColumnMove(this._invalidate, this);
		}
	};
	
	
	/**
	 * Detaches the required event handlers.
	 * @private
	 */
	ColumnMenu.prototype._detachEvents = function() {
		if (this._oTable) {
			this._oTable.detachColumnVisibility(this._invalidate, this);
			this._oTable.detachColumnMove(this._invalidate, this);
		}
	};
	
	/**
	 * Invalidates the column menu control items. Forces recreation of the menu items when the menu is opened.
	 * @private
	 */
	ColumnMenu.prototype._invalidate = function() {
		this._bInvalidated = true;
	};
	
	
	/**
	 * Special handling for IE < 9 when the popup is closed.
	 * The associated column of the menu is focused when the menu is closed.
	 * @private
	 */
	ColumnMenu.prototype._attachPopupClosed = function() {
		// put the focus back into the column header after the 
		// popup is being closed.
		var that = this;

		if (!sap.ui.Device.support.touch) {
			this.getPopup().attachClosed(function(oEvent) {
				that._iPopupClosedTimeoutId = window.setTimeout(function() {
					if (that._oColumn) {
						if (that._lastFocusedDomRef) {
							that._lastFocusedDomRef.focus();
						} else {
							that._oColumn.focus();
						}
					}
				}, 0);
			});
		}
	};
	
	
	/**
	 * Overwrite of {@link sap.ui.unified.Menu#open} method.
	 * @see sap.ui.unified.Menu#open
	 * @private
	 */
	ColumnMenu.prototype.open = function() {
		if (this._bInvalidated) {
			this._bInvalidated = false;
			this.destroyItems();
			this._addMenuItems();
		}
	
		if (this.getItems().length > 0) {
			this._lastFocusedDomRef = arguments[4];
			Menu.prototype.open.apply(this, arguments);
		}
	};
	
	
	/**
	 * Adds the menu items to the menu.
	 * @private
	 */
	ColumnMenu.prototype._addMenuItems = function() {
		if (this._oColumn) {
			this._addSortMenuItem(false);
			this._addSortMenuItem(true);
			this._addFilterMenuItem();
			this._addGroupMenuItem();
			this._addFreezeMenuItem();
			this._addColumnVisibilityMenuItem();
		}
	};
	
	
	/**
	 * Adds the sort menu item to the menu.
	 * @param {boolean} bDesc the sort direction. <code>true</code> for descending.
	 * @private
	 */
	ColumnMenu.prototype._addSortMenuItem = function(bDesc) {
		var oColumn = this._oColumn;
	
		var sDir = bDesc ? "desc" : "asc";
		var sIcon = bDesc ? "sort-descending" : "sort-ascending";
		if (oColumn.getSortProperty() && oColumn.getShowSortMenuEntry()) {
			this.addItem(this._createMenuItem(
				sDir,
				"TBL_SORT_" + sDir.toUpperCase(),
				sIcon,
				function(oEvent) {
					oColumn.sort(bDesc, oEvent.getParameter("ctrlKey") === true);
				}
			));
		}
	};
	
	
	/**
	 * Adds the filter menu item to the menu.
	 * @private
	 */
	ColumnMenu.prototype._addFilterMenuItem = function() {
		var oColumn = this._oColumn;
		var oTable = oColumn.getParent();
		var bEnableCustomFilter = false;
	
		if (oTable) {
			bEnableCustomFilter = oTable.getEnableCustomFilter();
		}
	
		if (oColumn.getFilterProperty() && oColumn.getShowFilterMenuEntry()) {
	
			if (bEnableCustomFilter) {
				this.addItem(this._createMenuItem(
					"filter",
					"TBL_FILTER_ITEM",
					"filter",
					function(oEvent) {
						oTable.fireCustomFilter({
							column: oColumn
						});
					}
				));
			} else {
				this.addItem(this._createMenuTextFieldItem(
					"filter",
					"TBL_FILTER",
					"filter",
					oColumn.getFilterValue(),
					function(oEvent) {
						oColumn.filter(this.getValue());
					}
				));
			}
		}
	};
	
	
	/**
	 * Adds the group menu item to the menu.
	 * @private
	 */
	ColumnMenu.prototype._addGroupMenuItem = function() {
		var oColumn = this._oColumn;
		var oTable = this._oTable;
		if (oTable && oTable.getEnableGrouping() && oColumn.getSortProperty()) {
			this.addItem(this._createMenuItem(
				"group",
				"TBL_GROUP",
				null,
				jQuery.proxy(function(oEvent) {
					oTable.setGroupBy(oColumn);
				},this)
			));
		}
	};
	
	
	/**
	 * Adds the freeze menu item to the menu.
	 * @private
	 */
	ColumnMenu.prototype._addFreezeMenuItem = function() {
		var oColumn = this._oColumn;
		var oTable = this._oTable;
		if (oTable && oTable.getEnableColumnFreeze()) {
			var iColumnIndex = jQuery.inArray(oColumn, oTable.getColumns());
			var bIsFixedColumn = iColumnIndex + 1 == oTable.getFixedColumnCount();
			this.addItem(this._createMenuItem(
				"freeze",
				bIsFixedColumn ? "TBL_UNFREEZE" : "TBL_FREEZE",
				null,
				function(oEvent) {
					
					// forward the event
					var bExecuteDefault = oTable.fireColumnFreeze({
						column: oColumn
					});
	
					// execute the column freezing
					if (bExecuteDefault) {
						if (bIsFixedColumn) {
							oTable.setFixedColumnCount(0);
						} else {
							oTable.setFixedColumnCount(iColumnIndex + 1);
						}
					}
				}
			));
		}
	};
	
	
	/**
	 * Adds the column visibility menu item to the menu.
	 * @private
	 */
	ColumnMenu.prototype._addColumnVisibilityMenuItem = function() {
		var oTable = this._oTable;
	
		if (oTable && oTable.getShowColumnVisibilityMenu()) {
			var oColumnVisibiltyMenuItem = this._createMenuItem("column-visibilty", "TBL_COLUMNS");
			this.addItem(oColumnVisibiltyMenuItem);
	
			var oColumnVisibiltyMenu = new Menu(oColumnVisibiltyMenuItem.getId() + "-menu");
			oColumnVisibiltyMenu.addStyleClass("sapUiTableColumnVisibilityMenu");
			oColumnVisibiltyMenuItem.setSubmenu(oColumnVisibiltyMenu);
	
			var aColumns = oTable.getColumns();
			
			if (oTable.getColumnVisibilityMenuSorter && typeof oTable.getColumnVisibilityMenuSorter === "function") {
				var oSorter = oTable.getColumnVisibilityMenuSorter();
				if (typeof oSorter === "function") {
					aColumns = aColumns.sort(oSorter);
				}
			}

			var oBinding = oTable.getBinding();
			var bAnalyticalBinding = sap.ui.model && sap.ui.model.analytics && oBinding instanceof sap.ui.model.analytics.AnalyticalBinding;

			for (var i = 0, l = aColumns.length; i < l; i++) {
				var oColumn = aColumns[i];
				// skip columns which are set to invisible by analytical metadata
				if (bAnalyticalBinding && oColumn instanceof sap.ui.table.AnalyticalColumn) {

					var oQueryResult = oBinding.getAnalyticalQueryResult();
					var oEntityType = oQueryResult.getEntityType();
					var oMetadata = oBinding.getModel().getProperty("/#" + oEntityType.getTypeDescription().name + "/" + oColumn.getLeadingProperty() + "/sap:visible");

					if (oMetadata && (oMetadata.value === "false" || oMetadata.value === false)) {
						continue;
					}
				}
				var oMenuItem = this._createColumnVisibilityMenuItem(oColumnVisibiltyMenu.getId() + "-item-" + i, oColumn);
				oColumnVisibiltyMenu.addItem(oMenuItem);
			}
		}
	};
	
	
	/**
	 * Factory method for the column visibility menu item.
	 * @param {string} sId the id of the menu item.
	 * @param {sap.ui.table.Column} oColumn the associated column to the menu item.
	 * @return {sap.ui.unified.MenuItem} the created menu item.
	 * @private
	 */
	ColumnMenu.prototype._createColumnVisibilityMenuItem = function(sId, oColumn) {
		var sText = oColumn.getName() || (oColumn.getLabel() && oColumn.getLabel().getText ? oColumn.getLabel().getText() : null);
		return new MenuItem(sId, {
			text: sText,
			icon: oColumn.getVisible() ? "sap-icon://accept" : null,
			select: jQuery.proxy(function(oEvent) {
				var oMenuItem = oEvent.getSource();
				var bVisible = !oColumn.getVisible();
				if (bVisible || this._oTable._getVisibleColumnCount() > 1) {
					var oTable = oColumn.getParent();
					var bExecuteDefault = true;
					if (oTable && oTable instanceof sap.ui.table.Table) {
						bExecuteDefault = oTable.fireColumnVisibility({
							column: oColumn,
							newVisible: bVisible
						});
					}
					if (bExecuteDefault) {
						oColumn.setVisible(bVisible);
					}
					oMenuItem.setIcon(bVisible ? "sap-icon://accept" : null);
				}
			}, this)
		});
	};
	
	
	/**
	 * Factory method for a menu item.
	 * @param {string} sId the id of the menu item.
	 * @param {string} sTextI18nKey the i18n key that should be used for the menu item text.
	 * @param {string} sIcon the icon name
	 * @param {function} fHandler the handler function to call when the item gets selected.
	 * @return {sap.ui.unified.MenuItem} the created menu item.
	 * @private
	 */
	ColumnMenu.prototype._createMenuItem = function(sId, sTextI18nKey, sIcon, fHandler) {
		return new MenuItem(this.getId() + "-" + sId, {
			text: this.oResBundle.getText(sTextI18nKey),
			icon: sIcon ? "sap-icon://" + sIcon : null,
			select: fHandler || function() {}
		});
	};
	
	
	/**
	 * Factory method for a menu text field item.
	 * @param {string} sId the id of the menu item.
	 * @param {string} sTextI18nKey the i18n key that should be used for the menu item text.
	 * @param {string} sIcon the icon name
	 * @param {string} sValue the default value of the text field
	 * @param {function} fHandler the handler function to call when the item gets selected.
	 * @return {sap.ui.unified.MenuTextFieldItem} the created menu text field item.
	 * @private
	 */
	ColumnMenu.prototype._createMenuTextFieldItem = function(sId, sTextI18nKey, sIcon, sValue, fHandler) {
		jQuery.sap.require("sap.ui.unified.MenuTextFieldItem");
		fHandler = fHandler || function() {};
		return new sap.ui.unified.MenuTextFieldItem(this.getId() + "-" + sId, {
			label: this.oResBundle.getText(sTextI18nKey),
			icon: sIcon ? "sap-icon://" + sIcon : null,
			value: sValue,
			select: fHandler || function() {}
		});
	};
	
	
	/**
	 * sets a new filter value into the filter field
	 * @private
	 */
	ColumnMenu.prototype._setFilterValue = function(sValue) {
		var oFilterField = sap.ui.getCore().byId(this.getId() + "-filter");
		if (oFilterField) {
			oFilterField.setValue(sValue);
		}
		return this;
	};
	
	/**
	 * Sets the value state of the filter field
	 * @private
	 */
	ColumnMenu.prototype._setFilterState = function(sFilterState) {
		var oFilterField = sap.ui.getCore().byId(this.getId() + "-filter");
		if (oFilterField) {
			oFilterField.setValueState(sFilterState);
		}
		return this;
	};
	

	return ColumnMenu;

}, /* bExport= */ true);

}; // end of sap/ui/table/ColumnMenu.js
if ( !jQuery.sap.isDeclared('sap.ui.table.DataTableRenderer') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

//Provides default renderer for control sap.ui.table.DataTable
jQuery.sap.declare('sap.ui.table.DataTableRenderer'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.Renderer'); // unlisted dependency retained
sap.ui.define("sap/ui/table/DataTableRenderer",['jquery.sap.global', 'sap/ui/core/Renderer', './TreeTableRenderer'],
	function(jQuery, Renderer, TreeTableRenderer) {
	"use strict";


	/**
	 * DataTableRenderer
	 * @namespace
	 */
	var DataTableRenderer = Renderer.extend(TreeTableRenderer);
	

	return DataTableRenderer;

}, /* bExport= */ true);

}; // end of sap/ui/table/DataTableRenderer.js
if ( !jQuery.sap.isDeclared('sap.ui.table.Row') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides control sap.ui.table.Row.
jQuery.sap.declare('sap.ui.table.Row'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.Element'); // unlisted dependency retained
sap.ui.define("sap/ui/table/Row",['jquery.sap.global', 'sap/ui/core/Element', './library'],
	function(jQuery, Element, library) {
	"use strict";


	
	/**
	 * Constructor for a new Row.
	 *
	 * @param {string} [sId] id for the new control, generated automatically if no id is given 
	 * @param {object} [mSettings] initial settings for the new control
	 *
	 * @class
	 * The row.
	 * @extends sap.ui.core.Element
	 * @version 1.28.10
	 *
	 * @constructor
	 * @public
	 * @alias sap.ui.table.Row
	 * @ui5-metamodel This control/element also will be described in the UI5 (legacy) designtime metamodel
	 */
	var Row = Element.extend("sap.ui.table.Row", /** @lends sap.ui.table.Row.prototype */ { metadata : {
	
		library : "sap.ui.table",
		defaultAggregation : "cells",
		aggregations : {
	
			/**
			 * The controls for the cells.
			 */
			cells : {type : "sap.ui.core.Control", multiple : true, singularName : "cell"}
		}
	}});
	
	
	/**
	 * Returns the index of the row in the table or -1 if not added to a table.
	 *
	 * @return {int}
	 * @public
	 * @ui5-metamodel This method also will be described in the UI5 (legacy) designtime metamodel
	 */
	Row.prototype.getIndex = function() {
		var oTable = this.getParent();
		if (oTable) {
			var iFirstRow = oTable.getFirstVisibleRow();
			var iRowIndex = oTable.indexOfRow(this);
			return iFirstRow + iRowIndex;
		}
		return -1;
	};

	return Row;

}, /* bExport= */ true);

}; // end of sap/ui/table/Row.js
if ( !jQuery.sap.isDeclared('sap.ui.table.Table') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides control sap.ui.table.Table.
jQuery.sap.declare('sap.ui.table.Table'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.Control'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.IntervalTrigger'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.ScrollBar'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.delegate.ItemNavigation'); // unlisted dependency retained
jQuery.sap.require('sap.ui.core.theming.Parameters'); // unlisted dependency retained
jQuery.sap.require('sap.ui.model.SelectionModel'); // unlisted dependency retained
sap.ui.define("sap/ui/table/Table",['jquery.sap.global', 'sap/ui/core/Control', 'sap/ui/core/IntervalTrigger', 'sap/ui/core/ScrollBar', 'sap/ui/core/delegate/ItemNavigation', 'sap/ui/core/theming/Parameters', 'sap/ui/model/SelectionModel', './Row', './library'],
	function(jQuery, Control, IntervalTrigger, ScrollBar, ItemNavigation, Parameters, SelectionModel, Row, library) {
	"use strict";



	/**
	 * Constructor for a new Table.
	 *
	 * @param {string} [sId] id for the new control, generated automatically if no id is given
	 * @param {object} [mSettings] initial settings for the new control
	 *
	 * @class
	 * The Table control provides a set of sophisticated and comfort functions for table design. For example, you can make settings for the number of visible rows. The first visible row can be explicitly set. For the selection of rows, a Multi, a Single, and a None mode are available.
	 * @extends sap.ui.core.Control
	 * @version 1.28.10
	 *
	 * @constructor
	 * @public
	 * @alias sap.ui.table.Table
	 * @ui5-metamodel This control/element also will be described in the UI5 (legacy) designtime metamodel
	 */
	var Table = Control.extend("sap.ui.table.Table", /** @lends sap.ui.table.Table.prototype */ { metadata : {

		library : "sap.ui.table",
		properties : {

			/**
			 * Width of the Table.
			 */
			width : {type : "sap.ui.core.CSSSize", group : "Dimension", defaultValue : 'auto'},

			/**
			 * Height of a row of the Table in pixel.
			 */
			rowHeight : {type : "int", group : "Appearance", defaultValue : null},

			/**
			 * Height of the column header of the Table in pixel.
			 */
			columnHeaderHeight : {type : "int", group : "Appearance", defaultValue : null},

			/**
			 * Flag whether the column header is visible or not.
			 */
			columnHeaderVisible : {type : "boolean", group : "Appearance", defaultValue : true},

			/**
			 * Count of visible rows (will overwrite the height property).
			 */
			visibleRowCount : {type : "int", group : "Appearance", defaultValue : 10},

			/**
			 * First visible row.
			 */
			firstVisibleRow : {type : "int", group : "Appearance", defaultValue : 0},

			/**
			 * Selection mode of the Table.
			 */
			selectionMode : {type : "sap.ui.table.SelectionMode", group : "Behavior", defaultValue : sap.ui.table.SelectionMode.Multi},

			/**
			 * Selection behavior of the Table.
			 */
			selectionBehavior : {type : "sap.ui.table.SelectionBehavior", group : "Behavior", defaultValue : sap.ui.table.SelectionBehavior.RowSelector},

			/**
			 * Zero-based index of selected item. Index value for no selection is -1. When multi-selection is enabled and multiple items are selected, the method returns the lead selected item. Sets the zero-based index of the currently selected item. This method removes any previous selections. When the given index is invalid, the call is ignored.
			 */
			selectedIndex : {type : "int", group : "Appearance", defaultValue : -1},

			/**
			 * Flag to enable or disable column reordering
			 * @deprecated Since version 1.5.2.
			 * Use the property enableColumnReordering instead.
			 */
			allowColumnReordering : {type : "boolean", group : "Behavior", defaultValue : true, deprecated: true},

			/**
			 * Flag whether the controls of the Table are editable or not (currently this only controls the background color!)
			 */
			editable : {type : "boolean", group : "Behavior", defaultValue : true},

			/**
			 * Flag whether to use the scroll mode or paging mode. If the Paginator mode is used it will require the sap.ui.commons library!
			 */
			navigationMode : {type : "sap.ui.table.NavigationMode", group : "Behavior", defaultValue : sap.ui.table.NavigationMode.Scrollbar},

			/**
			 * Threshold to fetch the next chunk of data. The minimal threshold can be the visible row count of the Table. If the value is 0 then the thresholding is disabled.
			 */
			threshold : {type : "int", group : "Appearance", defaultValue : 100},

			/**
			 * Flag to enable or disable column reordering
			 */
			enableColumnReordering : {type : "boolean", group : "Behavior", defaultValue : true},

			/**
			 * Flag to enable or disable column grouping. (experimental!)
			 */
			enableGrouping : {type : "boolean", group : "Behavior", defaultValue : false},

			/**
			 * Flag to show or hide the column visibility menu.
			 */
			showColumnVisibilityMenu : {type : "boolean", group : "Appearance", defaultValue : false},

			/**
			 * Flag whether to show the no data overlay or not once the table is empty.
			 */
			showNoData : {type : "boolean", group : "Appearance", defaultValue : true},

			/**
			 * This defines how the table handles the visible rows in the table. The default behavior is, that a fixed row count is defined. If you change it to auto the visibleRowCount property is changed by the table automatically. It will then adjust its maximum row count to the space it is allowed to cover (limited by the surrounding container) and its minimum row count to the value of the property minAutoRowCount (default value : 5) In manual mode the user can change the visibleRowCount interactively.
			 * @since 1.9.2
			 */
			visibleRowCountMode : {type : "sap.ui.table.VisibleRowCountMode", group : "Appearance", defaultValue : sap.ui.table.VisibleRowCountMode.Fixed},

			/**
			 * Number of columns that are fix on the left. When you use a horizontal scroll bar, only the columns which are not fixed, will scroll. Fixed columns need a defined width for the feature to work.
			 */
			fixedColumnCount : {type : "int", group : "Appearance", defaultValue : 0},

			/**
			 * Number of rows that are fix on the top. When you use a vertical scroll bar, only the rows which are not fixed, will scroll.
			 */
			fixedRowCount : {type : "int", group : "Appearance", defaultValue : 0},

			/**
			 * This property is used to set the minimum count of visible rows when the property visibleRowCountMode is set to Auto. For any other visibleRowCountMode, it is ignored.
			 */
			minAutoRowCount : {type : "int", group : "Appearance", defaultValue : 5},

			/**
			 * Number of rows that are fix on the bottom. When you use a vertical scroll bar, only the rows which are not fixed, will scroll. (experimental!)
			 * @since 1.18.7
			 */
			fixedBottomRowCount : {type : "int", group : "Appearance", defaultValue : 0},

			/**
			 * Flag whether to show or hide the column menu item to freeze or unfreeze a column.
			 * @since 1.21.0
			 */
			enableColumnFreeze : {type : "boolean", group : "Behavior", defaultValue : false},

			/**
			 * Flag whether to enable or disable the context menu on cells to trigger a filtering with the cell value.
			 * @since 1.21.0
			 */
			enableCellFilter : {type : "boolean", group : "Behavior", defaultValue : false},

			/**
			 * This text is shown, in case there is no data available to be displayed in the Table and no custom noData control is set.
			 * @since 1.21.0
			 * @deprecated Since version 1.22.1.
			 * The aggregation noData also supports string values now. Use noData instead.
			 */
			noDataText : {type : "string", group : "Appearance", defaultValue : null, deprecated: true},

			/**
			 * Setting this property to true will show an overlay on top of the Table content and users cannot click anymore on the Table content.
			 * @since 1.21.2
			 */
			showOverlay : {type : "boolean", group : "Appearance", defaultValue : false},

			/**
			 * Specifies if a select all button should be displayed in the top left corner.
			 * @since 1.23.0
			 */
			enableSelectAll : {type : "boolean", group : "Behavior", defaultValue : true},

			/**
			 * Set this parameter to true to implement your own filter behaviour. Instead of the filter input box a button will be rendered for which' press event (customFilter) you can register an event handler.
			 * @since 1.23.0
			 */
			enableCustomFilter : {type : "boolean", group : "Behavior", defaultValue : false},

			/**
			 * Set this parameter to true to make the table handle the busy indicator by its own. The table will switch to busy as soon as it scrolls into an unpaged area.
			 * @since 1.27.0
			 */
			enableBusyIndicator : {type : "boolean", group : "Behavior", defaultValue : false}
		},
		defaultAggregation : "columns",
		aggregations : {

			/**
			 * Control or text of title section of the Table (if not set it will be hidden)
			 */
			title : {type : "sap.ui.core.Control", altTypes : ["string"], multiple : false},

			/**
			 * Control or text of footer section of the Table (if not set it will be hidden)
			 */
			footer : {type : "sap.ui.core.Control", altTypes : ["string"], multiple : false},

			/**
			 * Toolbar of the Table (if not set it will be hidden)
			 */
			toolbar : {type : "sap.ui.core.Toolbar", multiple : false},

			/**
			 * Extension section of the Table (if not set it will be hidden)
			 */
			extension : {type : "sap.ui.core.Control", multiple : true, singularName : "extension"},

			/**
			 * Columns of the Table
			 */
			columns : {type : "sap.ui.table.Column", multiple : true, singularName : "column", bindable : "bindable"},

			/**
			 * Rows of the Table
			 */
			rows : {type : "sap.ui.table.Row", multiple : true, singularName : "row", bindable : "bindable"},

			/**
			 * The value for the noData aggregation can be either a string value or a control instance. The control is shown, in case there is no data for the Table available. In case of a string value this will simply replace the no data text.
			 */
			noData : {type : "sap.ui.core.Control", altTypes : ["string"], multiple : false}
		},
		associations : {

			/**
			 * Group By Column (experimental!)
			 */
			groupBy : {type : "sap.ui.table.Column", multiple : false}
		},
		events : {

			/**
			 * fired when the row selection of the table has been changed (the event parameters can be used to determine selection changes - to find out the selected rows you should better use the table selection API)
			 */
			rowSelectionChange : {
				parameters : {

					/**
					 * row index which has been clicked so that the selection has been changed (either selected or deselected)
					 */
					rowIndex : {type : "int"},

					/**
					 * binding context of the row which has been clicked so that selection has been changed
					 */
					rowContext : {type : "object"},

					/**
					 * array of row indices which selection has been changed (either selected or deselected)
					 */
					rowIndices : {type : "int[]"}
				}
			},

			/**
			 * fired when a column of the table has been selected
			 */
			columnSelect : {allowPreventDefault : true,
				parameters : {

					/**
					 * reference to the selected column
					 */
					column : {type : "sap.ui.table.Column"}
				}
			},

			/**
			 * fired when a table column is resized.
			 */
			columnResize : {allowPreventDefault : true,
				parameters : {

					/**
					 * resized column.
					 */
					column : {type : "sap.ui.table.Column"},

					/**
					 * new width of the table in pixel.
					 */
					width : {type : "int"}
				}
			},

			/**
			 * fired when a table column is moved.
			 */
			columnMove : {allowPreventDefault : true,
				parameters : {

					/**
					 * moved column.
					 */
					column : {type : "sap.ui.table.Column"},

					/**
					 * new position of the column.
					 */
					newPos : {type : "int"}
				}
			},

			/**
			 * fired when the table is sorted.
			 */
			sort : {allowPreventDefault : true,
				parameters : {

					/**
					 * sorted column.
					 */
					column : {type : "sap.ui.table.Column"},

					/**
					 * Sort Order
					 */
					sortOrder : {type : "sap.ui.table.SortOrder"},

					/**
					 * If column was added to sorter this is true. If new sort is started this is set to false
					 */
					columnAdded : {type : "boolean"}
				}
			},

			/**
			 * fired when the table is filtered.
			 */
			filter : {allowPreventDefault : true,
				parameters : {

					/**
					 * filtered column.
					 */
					column : {type : "sap.ui.table.Column"},

					/**
					 * filter value.
					 */
					value : {type : "string"}
				}
			},

			/**
			 * fired when the table is grouped (experimental!).
			 */
			group : {allowPreventDefault : true,
				parameters : {

					/**
					 * grouped column.
					 */
					column : {type : "sap.ui.table.Column"}
				}
			},

			/**
			 * fired when the visibility of a table column is changed.
			 */
			columnVisibility : {allowPreventDefault : true,
				parameters : {

					/**
					 * affected column.
					 */
					column : {type : "sap.ui.table.Column"},

					/**
					 * new value of the visible property.
					 */
					visible : {type : "boolean"}
				}
			},

			/**
			 * fired when the user clicks a cell of the table (experimental!).
			 * @since 1.21.0
			 */
			cellClick : {allowPreventDefault : true,
				parameters : {

					/**
					 * The control of the cell.
					 */
					cellControl : {type : "sap.ui.core.Control"},

					/**
					 * Row index of the selected cell.
					 */
					rowIndex : {type : "int"},

					/**
					 * Column index of the selected cell.
					 */
					columnIndex : {type : "int"}
				}
			},

			/**
			 * fired when the user clicks a cell of the table (experimental!).
			 * @since 1.21.0
			 */
			cellContextmenu : {allowPreventDefault : true,
				parameters : {

					/**
					 * The control of the cell.
					 */
					cellControl : {type : "sap.ui.core.Control"},

					/**
					 * Row index of the selected cell.
					 */
					rowIndex : {type : "int"},

					/**
					 * Column index of the selected cell.
					 */
					columnIndex : {type : "int"}
				}
			},

			/**
			 * fired when a column of the table should be freezed
			 * @since 1.21.0
			 */
			columnFreeze : {allowPreventDefault : true,
				parameters : {

					/**
					 * reference to the column to freeze
					 */
					column : {type : "sap.ui.table.Column"}
				}
			},

			/**
			 * This event is triggered when the custom filter item of the column menu is pressed. The column on which the event was triggered is passed as parameter.
			 * @since 1.23.0
			 */
			customFilter : {}
		}
	}});
































	// =============================================================================
	// BASIC CONTROL API
	// =============================================================================

	Table.ResizeTrigger = new IntervalTrigger(300);

	/**
	 * Initialization of the Table control
	 * @private
	 */
	Table.prototype.init = function() {

		// create an information object which contains always required infos
		this._oResBundle = sap.ui.getCore().getLibraryResourceBundle("sap.ui.table");
		this._bAccMode = sap.ui.getCore().getConfiguration().getAccessibility();
		this._bRtlMode = sap.ui.getCore().getConfiguration().getRTL();

		// basic selection model (by default the table uses multi selection)
		this._oSelection = new SelectionModel(SelectionModel.MULTI_SELECTION);
		this._oSelection.attachSelectionChanged(this._onSelectionChanged, this);

		// minimum width of a table column in pixel:
		// should at least be larger than the paddings for cols and cells!
		this._iColMinWidth = 20;

		this._oCalcColumnWidths = [];

		// columns to cells map
		this._aIdxCols2Cells = [];

		// visible columns
		this._aVisibleColumns = [];

		// we add a delegate to enable to focus the scrollbar when clicking on them
		// to avoid that the table control grabs the focus and scrolls to the focus
		// element (hide the outline)
		var fnFocusIndex = {
			onAfterRendering: function(oEvent) {
				oEvent.srcControl.$("sb").attr("tabindex", "-1").css("outline", "none");
			}
		};

		// vertical scrollbar
		this._oVSb = new ScrollBar(this.getId() + "-vsb", {size: "100%"});
		this._oVSb.attachScroll(this.onvscroll, this);
		this._oVSb.addDelegate(fnFocusIndex);

		// horizontal scrollbar (configure by default for the pixel mode)
		this._oHSb = new ScrollBar(this.getId() + "-hsb", {size: "100%", contentSize: "0px", vertical: false});
		this._oHSb.attachScroll(this.onhscroll, this);
		this._oHSb.addDelegate(fnFocusIndex);

		// action mode flag (for keyboard navigation)
		this._bActionMode = false;

		// column index of the last fixed column (to prevent column reordering!)
		this._iLastFixedColIndex = -1;

		// flag whether the editable property should be inherited or not
		this._bInheritEditableToControls = false;

		// text selection for column headers?
		this._bAllowColumnHeaderTextSelection = false;

		// flag, whether to call _updateTableCell on cell control or not?
		this._bCallUpdateTableCell = false;

		// timer delay in ms
		this._iTimerDelay = 250;

		this._doubleclickDelay = 300;
		this._clicksRegistered = 0;

		// determine whether jQuery version is less than 1.8 (height and width behaves different!!)
		this._bjQueryLess18 = jQuery.sap.Version(jQuery.fn.jquery).compareTo("1.8") < 0;

		// F6 Handling is done in TableRenderer to make sure the table content gets the focus. The
		// Toolbar has its own F6 stop.
		// this.data("sap-ui-fastnavgroup", "true", true); // Define group for F6 handling
	};


	/**
	 * Termination of the Table control
	 * @private
	 */
	Table.prototype.exit = function() {
		// destroy the child controls
		this._oVSb.destroy();
		this._oHSb.destroy();
		if (this._oPaginator) {
			this._oPaginator.destroy();
		}
		// destroy helpers
		this._destroyItemNavigation();
		// cleanup
		this._cleanUpTimers();
		this._detachEvents();
	};


	/**
	 * theme changed
	 * @private
	 */
	Table.prototype.onThemeChanged = function() {
		if (this.getDomRef()) {
			this.invalidate();
		}
	};


	/**
	 * Rerendering handling
	 * @private
	 */
	Table.prototype.onBeforeRendering = function() {
		this._cleanUpTimers();
		this._detachEvents();
	};


	/**
	 * Rerendering handling
	 * @private
	 */
	Table.prototype.onAfterRendering = function() {

		this._bOnAfterRendering = true;

		var $this = this.$();
		
		if (sap.ui.Device.system.tablet) {
			$this.addClass("sapUiTableTouch");
		}

		this._renderOverlay();
		this._updateVSb(true);
		this._updateTableContent();
		this._handleResize();
		this._attachEvents();

		// restore the column icons
		var aCols = this.getColumns();
		for (var i = 0, l = aCols.length; i < l; i++) {
			if (aCols[i].getVisible()) {
				aCols[i]._restoreIcons();
			}
		}

		// enable/disable text selection for column headers
		if (!this._bAllowColumnHeaderTextSelection) {
			this._disableTextSelection($this.find(".sapUiTableColHdrCnt"));
		}

		this._bOnAfterRendering = false;

		this._initItemNavigation();

		if (this._bDetermineVisibleCols === true) {
			this._determineVisibleCols();
			this._bDetermineVisibleCols = false;
		}
	};

	Table.prototype._renderOverlay = function() {
		var $this = this.$(),
		    $overlay = $this.find(".sapUiTableOverlay"),
		    bShowOverlay = this.getShowOverlay();
		if (bShowOverlay && $overlay.length === 0) {
			$overlay = jQuery("<div>").addClass("sapUiOverlay sapUiTableOverlay").css("z-index", "1");
			$this.append($overlay);
		} else if (!bShowOverlay) {
			$overlay.remove();
		}
	};

	Table.prototype.setShowOverlay = function(bShow) {
		this.setProperty("showOverlay", bShow, true);
		this._renderOverlay();
		return this;
	};

	/**
	 * update the table content (scrollbar, no data overlay, selection, row header, ...)
	 * @private
	 */
	Table.prototype._updateTableContent = function() {

		// show or hide the no data container
		this._updateNoData();

		// update the selection visualization
		this._updateSelection();

		// update the rows (TODO: generalize this for 1.6)
		if (this._modifyRow) {
			var that = this;
			jQuery.each(this.getRows(), function(iIndex, oRow) {
				that._modifyRow(iIndex + that.getFirstVisibleRow(), oRow.$());
				that._modifyRow(iIndex + that.getFirstVisibleRow(), oRow.$("fixed"));
			});
		}

		var oBinding = this.getBinding("rows");
		var iFixedTopRows = this.getFixedRowCount();
		var iFixedBottomRows = this.getFixedBottomRowCount();
		var iVisibleRowCount = this.getVisibleRowCount();
		var that = this;

		if (oBinding) {
			jQuery.each(this.getRows(), function(iIndex, oRow) {

				var $row = oRow.$();
				var $fixedRow = oRow.$("fixed");
				var $rowHdr = that.$().find("div[data-sap-ui-rowindex='" + $row.attr("data-sap-ui-rowindex") + "']");

				// update row header tooltip
				if (oRow.getBindingContext()) {
					$rowHdr.attr("title", that._oResBundle.getText("TBL_ROW_SELECT"));
				} else {
					$rowHdr.attr("title", "");
				}

				if (iFixedTopRows > 0) {
					var bIsTopRow = iIndex < iFixedTopRows;
					if (bIsTopRow) {
						if (!$row.hasClass("sapUiTableFixedTopRow")) {
							$row.addClass('sapUiTableFixedTopRow');
							$fixedRow.addClass('sapUiTableFixedTopRow');
							$rowHdr.addClass('sapUiTableFixedTopRow');
						}
					} else if ($row.hasClass("sapUiTableFixedTopRow")) {
						$row.removeClass('sapUiTableFixedTopRow');
						$fixedRow.removeClass('sapUiTableFixedTopRow');
						$rowHdr.removeClass('sapUiTableFixedTopRow');
					}
				}

				if (iFixedBottomRows > 0) {
					var bIsBottomRow,
						bIsPreBottomRow;
					if (oBinding.getLength() >= iVisibleRowCount) {
						bIsBottomRow = iIndex > iVisibleRowCount - iFixedBottomRows - 1;
						bIsPreBottomRow = iIndex > iVisibleRowCount - iFixedBottomRows - 2;
					} else {
						bIsBottomRow = (that.getFirstVisibleRow() + iIndex) > (oBinding.getLength() - 1 - iFixedBottomRows) && (that.getFirstVisibleRow() + iIndex) < oBinding.getLength();
						bIsPreBottomRow = (that.getFirstVisibleRow() + iIndex) > (oBinding.getLength() - 2 - iFixedBottomRows) && (that.getFirstVisibleRow() + iIndex) < oBinding.getLength();
					}
					if (bIsBottomRow) {
						if (!$row.hasClass("sapUiTableFixedBottomRow")) {
							$row.addClass('sapUiTableFixedBottomRow');
							$fixedRow.addClass('sapUiTableFixedBottomRow');
							$rowHdr.addClass('sapUiTableFixedBottomRow');
						}
					} else if ($row.hasClass("sapUiTableFixedBottomRow")) {
						$row.removeClass('sapUiTableFixedBottomRow');
						$fixedRow.removeClass('sapUiTableFixedBottomRow');
						$rowHdr.removeClass('sapUiTableFixedBottomRow');
					}
					if (bIsPreBottomRow) {
						if (!$row.hasClass("sapUiTableFixedPreBottomRow")) {
							$row.addClass('sapUiTableFixedPreBottomRow');
							$fixedRow.addClass('sapUiTableFixedPreBottomRow');
							$rowHdr.addClass('sapUiTableFixedPreBottomRow');
						}
					} else if ($row.hasClass("sapUiTableFixedPreBottomRow")) {
						$row.removeClass('sapUiTableFixedPreBottomRow');
						$fixedRow.removeClass('sapUiTableFixedPreBottomRow');
						$rowHdr.removeClass('sapUiTableFixedPreBottomRow');
					}
				}
			});
		}

		// update the row header (sync row heights)
		this._updateRowHeader();

		// hook for update table cell after rendering is complete
		if (this._bOnAfterRendering && (this._bCallUpdateTableCell || typeof this._updateTableCell === "function")) {
			var that = this;
			var oBindingInfo = this.mBindingInfos["rows"];
			jQuery.each(this.getRows(), function(iIndex, oRow) {
				
				var iAbsoluteRowIndex = that.getFirstVisibleRow() + iIndex; //get the aboslute row index
				
				jQuery.each(oRow.getCells(), function(iIndex, oCell) {
					if (oCell._updateTableCell) {
						oCell._updateTableCell(oCell /* cell control */,
						                       oCell.getBindingContext(oBindingInfo && oBindingInfo.model) /* cell context */,
						                       oCell.$().closest("td") /* jQuery object for td */,
						                       iAbsoluteRowIndex);
					}
					if (that._updateTableCell) {
						that._updateTableCell(oCell /* cell control */,
						                       oCell.getBindingContext(oBindingInfo && oBindingInfo.model) /* cell context */,
						                       oCell.$().closest("td") /* jQuery object for td */,
						                       iAbsoluteRowIndex);
					}
				});
			});
		}

	};


	// =============================================================================
	// ITEMNAVIGATION
	// =============================================================================


	/**
	 * initialize ItemNavigation. Transfer relevant controls to ItemNavigation.
	 * TabIndexes are set by ItemNavigation
	 * @private
	*/
	Table.prototype._initItemNavigation = function() {

		var $this = this.$();
		var iColumnCount = this._getVisibleColumnCount();
		var iTotalColumnCount = iColumnCount;
		var bHasRowHeader = this.getSelectionMode() !== sap.ui.table.SelectionMode.None && this.getSelectionBehavior() !== sap.ui.table.SelectionBehavior.RowOnly;

		// initialization of item navigation for the Column Headers
		if (!this._oColHdrItemNav) {
			this._oColHdrItemNav = new ItemNavigation();
			this._oColHdrItemNav.setCycling(false);
			this.addDelegate(this._oColHdrItemNav);
		}

		// create the list of item dom refs
		var aItemDomRefs = [];
		if (this.getFixedColumnCount() == 0) {
			aItemDomRefs = $this.find(".sapUiTableCtrl td[tabindex]").get();
		} else {
			var $topLeft = this.$().find('.sapUiTableCtrlFixed.sapUiTableCtrlRowFixed');
			var $topRight = this.$().find('.sapUiTableCtrlScroll.sapUiTableCtrlRowFixed');
			var $middleLeft = this.$().find('.sapUiTableCtrlFixed.sapUiTableCtrlRowScroll');
			var $middleRight = this.$().find('.sapUiTableCtrlScroll.sapUiTableCtrlRowScroll');
			var $bottomLeft = this.$().find('.sapUiTableCtrlFixed.sapUiTableCtrlRowFixedBottom');
			var $bottomRight = this.$().find('.sapUiTableCtrlScroll.sapUiTableCtrlRowFixedBottom');
			for (var i = 0; i < this.getVisibleRowCount(); i++) {
				aItemDomRefs = aItemDomRefs.concat($topLeft.find('tr[data-sap-ui-rowindex="' + i + '"]').find('td[tabindex]').get());
				aItemDomRefs = aItemDomRefs.concat($topRight.find('tr[data-sap-ui-rowindex="' + i + '"]').find('td[tabindex]').get());
				aItemDomRefs = aItemDomRefs.concat($middleLeft.find('tr[data-sap-ui-rowindex="' + i + '"]').find('td[tabindex]').get());
				aItemDomRefs = aItemDomRefs.concat($middleRight.find('tr[data-sap-ui-rowindex="' + i + '"]').find('td[tabindex]').get());
				aItemDomRefs = aItemDomRefs.concat($bottomLeft.find('tr[data-sap-ui-rowindex="' + i + '"]').find('td[tabindex]').get());
				aItemDomRefs = aItemDomRefs.concat($bottomRight.find('tr[data-sap-ui-rowindex="' + i + '"]').find('td[tabindex]').get());
			}
		}

		// to later determine the position of the first TD in the aItemDomRefs we keep the
		// count of TDs => aCount - TDs = first TD (add the row headers to the TD count / except the first one!)
		var iTDCount = aItemDomRefs.length;
		var iInitialIndex = 0;

		// add the row header items (if visible)
		if (bHasRowHeader) {
			var aRowHdrDomRefs = $this.find(".sapUiTableRowHdr").get();
			for (var i = aRowHdrDomRefs.length - 1; i >= 0; i--) {
				aItemDomRefs.splice(i * iColumnCount, 0, aRowHdrDomRefs[i]);
				// we ignore the row headers
				iTDCount++;
			}
			// except the first row header
			iTDCount--;
			// add the row header to the column count
			iTotalColumnCount++;
			iInitialIndex = 1;
		}

		// add the column items
		if (this.getColumnHeaderVisible()) {
			aItemDomRefs = $this.find(".sapUiTableCol").get().concat(aItemDomRefs);
		}

		// add the select all item
		if (bHasRowHeader && this.getColumnHeaderVisible()) {
			var aRowHdr = $this.find(".sapUiTableColRowHdr").get();
			for (var i = this._getHeaderRowCount() - 1; i >= 0; i--) {
				aItemDomRefs.splice(i * iColumnCount, 0, aRowHdr[0]);
			}
		}

		// initialization of item navigation for the Table control
		if (!this._oItemNavigation) {
			this._iLastSelectedDataRow = this._getHeaderRowCount();
			this._oItemNavigation = new ItemNavigation();
			this._oItemNavigation.setTableMode(true);
			this._oItemNavigation.attachEvent(ItemNavigation.Events.BeforeFocus, function(oEvent) {
				this.$("ariadesc").text("");
			}, this);
			this._oItemNavigation.attachEvent(ItemNavigation.Events.AfterFocus, function(oEvent) {
				var iRow = Math.floor(oEvent.getParameter("index") / this._oItemNavigation.iColumns);
				if (iRow > 0) {
					this._iLastSelectedDataRow = iRow;
				}
			}, this);
			this.addDelegate(this._oItemNavigation);
		}

		// configure the item navigation
		this._oItemNavigation.setColumns(iTotalColumnCount);
		this._oItemNavigation.setRootDomRef($this.find(".sapUiTableCnt").get(0));
		this._oItemNavigation.setItemDomRefs(aItemDomRefs);
		this._oItemNavigation.setFocusedIndex(iInitialIndex);

	};

	/**
	 * destroys ItemNavigation
	 * @private
	*/
	Table.prototype._destroyItemNavigation = function() {

		// destroy of item navigation for the Table control
		if (this._oItemNavigation) {
			this._oItemNavigation.destroy();
			this._oItemNavigation = undefined;
		}

	};


	/*
	 * @see JSDoc generated by SAPUI5 control
	 */
	Table.prototype.getFocusInfo = function() {
		var sId = this.$().find(":focus").attr("id");
		if (sId) {
			return {customId: sId};
		} else {
			return sap.ui.core.Element.prototype.getFocusInfo.apply(this, arguments);
		}
	};

	/*
	 * @see JSDoc generated by SAPUI5 control
	 */
	Table.prototype.applyFocusInfo = function(mFocusInfo) {
		if (mFocusInfo && mFocusInfo.customId) {
			this.$().find("#" + mFocusInfo.customId).focus();
		} else {
			sap.ui.core.Element.prototype.getFocusInfo.apply(this, arguments);
		}
		return this;
	};


	// =============================================================================
	// PUBLIC TABLE API
	// =============================================================================


	/*
	 * @see JSDoc generated by SAPUI5 control API generator
	 */
	Table.prototype.setTitle = function(vTitle) {
		var oTitle = vTitle;
		if (typeof (vTitle) === "string" || vTitle instanceof String) {
			oTitle = sap.ui.table.TableHelper.createTextView({
				text: vTitle,
				width: "100%"
			});
			oTitle.addStyleClass("sapUiTableHdrTitle");
		}
		this.setAggregation("title", oTitle);
		return this;
	};


	/*
	 * @see JSDoc generated by SAPUI5 control API generator
	 */
	Table.prototype.setFooter = function(vFooter) {
		var oFooter = vFooter;
		if (typeof (vFooter) === "string" || vFooter instanceof String) {
			oFooter = sap.ui.table.TableHelper.createTextView({
				text: vFooter,
				width: "100%"
			});
		}
		this.setAggregation("footer", oFooter);
		return this;
	};


	/*
	 * @see JSDoc generated by SAPUI5 control API generator
	 */
	Table.prototype.setSelectionMode = function(oSelectionMode) {
		this._oSelection.clearSelection();
		if (oSelectionMode === sap.ui.table.SelectionMode.Single) {
			this._oSelection.setSelectionMode(SelectionModel.SINGLE_SELECTION);
		} else {
			this._oSelection.setSelectionMode(SelectionModel.MULTI_SELECTION);
		}
		this.setProperty("selectionMode", oSelectionMode);
		return this;
	};


	/*
	 * @see JSDoc generated by SAPUI5 control API generator
	 */
	Table.prototype.setFirstVisibleRow = function(iRowIndex, bOnScroll) {
		// TODO: think about this optimization - for now it doesn't work since
		//       this API is used to update the rows afterwards
		//if (iRowIndex !== this.getFirstVisibleRow()) {
			// update the property
			this.setProperty("firstVisibleRow", iRowIndex, true);
			// update the bindings:
			//  - prevent the rerendering
			//  - use the databinding fwk to update the content of the rows
			if (this.getBinding("rows") && !this._bRefreshing) {
				this.updateRows();
			}
		//}
		return this;
	};

	/*
	 * @see JSDoc generated by SAPUI5 control API generator
	 */
	Table.prototype.getAllowColumnReordering = function() {
		jQuery.sap.log.warning("getAllowColumnReordering is deprecated - please use getEnableColumnReordering!");
		return Table.prototype.getEnableColumnReordering.apply(this, arguments);
	};

	/*
	 * @see JSDoc generated by SAPUI5 control API generator
	 */
	Table.prototype.setAllowColumnReordering = function() {
		jQuery.sap.log.warning("setAllowColumnReordering is deprecated - please use setEnableColumnReordering!");
		return Table.prototype.setEnableColumnReordering.apply(this, arguments);
	};


	// enable calling 'bindAggregation("rows")' without a factory
	Table.getMetadata().getAggregation("rows")._doesNotRequireFactory = true;

	/*
	 * @see JSDoc generated by SAPUI5 control API generator
	 */
	Table.prototype.bindRows = function(oBindingInfo, vTemplate, oSorter, aFilters) {
		// ensure old Table API compatibility (sPath, [oSorter], [aFilters])
		if (typeof oBindingInfo === "string" &&
			  (vTemplate instanceof sap.ui.model.Sorter || jQuery.isArray(oSorter) && oSorter[0] instanceof sap.ui.model.Filter) ) {
			aFilters = oSorter;
			oSorter = vTemplate;
			vTemplate = undefined;
		}

		return this.bindAggregation("rows", oBindingInfo, vTemplate, oSorter, aFilters);
	};

	/*
	 * @see JSDoc generated by SAPUI5 control API generator
	 */
	Table.prototype._bindAggregation = function(sName, sPath, oTemplate, oSorter, aFilters) {
		sap.ui.core.Element.prototype._bindAggregation.apply(this, arguments);
		var oBinding = this.getBinding("rows");
		if (sName === "rows" && oBinding) {
			oBinding.attachChange(this._onBindingChange, this);
		}
		return this;
	};

	/**
	 * handler for change events of the binding
	 * @param {sap.ui.base.Event} oEvent change event
	 * @private
	 */
	Table.prototype._onBindingChange = function(oEvent) {
		var sReason = typeof (oEvent) === "object" ? oEvent.getParameter("reason") : oEvent;
		if (sReason === "sort" || sReason === "filter") {
			this.clearSelection();
			this.setFirstVisibleRow(0);
		}
	};

	/*
	 * @see JSDoc generated by SAPUI5 control API generator
	 */
	Table.prototype.unbindAggregation = function(sName, bSuppressReset) {
		var oBinding = this.getBinding("rows");
		if (sName === "rows" && oBinding) {
			oBinding.detachChange(this._onBindingChange);
			//Reset needs to be resetted, else destroyRows is called, which is not allowed to be called
			bSuppressReset = true;
			this._restoreAppDefaultsColumnHeaderSortFilter();
		}
		this.updateRows(); // TODO: shouldn't this be more a central feature?!
		return sap.ui.core.Element.prototype.unbindAggregation.apply(this, [sName, bSuppressReset]);
	};

	/*
	 * @see JSDoc generated by SAPUI5 control API generator
	 */
	Table.prototype.setVisibleRowCountMode = function(oVisibleRowCountMode) {
		this.setProperty("visibleRowCountMode", oVisibleRowCountMode);
		this._handleRowCountMode();
		return this;
	};

	/*
	 * @see JSDoc generated by SAPUI5 control API generator
	 */
	Table.prototype.setVisibleRowCount = function(iVisibleRowCount) {
		if (iVisibleRowCount != null && !isFinite(iVisibleRowCount)) {
			return;
		}
		iVisibleRowCount = this.validateProperty("visibleRowCount", iVisibleRowCount);
		if (this.getBinding("rows") && this.getBinding("rows").getLength() <= iVisibleRowCount) {
			this.setProperty("firstVisibleRow", 0);
		}
		this.setProperty("visibleRowCount", iVisibleRowCount);
		return this;
	};

	/**
	 * refresh rows
	 * @private
	 */
	Table.prototype.refreshRows = function(sReason) {
		this._bBusyIndicatorAllowed = true;
		//needs to be called here to reset the firstVisible row so that the correct data is fetched
		this._bRefreshing = true;
		this._onBindingChange(sReason);
		this._updateBindingContexts(true);
		this._bRefreshing = false;
	};

	/**
	 * updates the rows - called internally by the updateAggregation function when
	 * anything in the model has been changed.
	 * @private
	 */
	Table.prototype.updateRows = function(sReason) {
		this._setBusy(false);

		// by default the start index is the first visible row
		var iStartIndex = this.getFirstVisibleRow();

		// calculate the boundaries (at least 0 - max the row count - visible row count)
		iStartIndex = Math.max(iStartIndex, 0);
		if (this.getNavigationMode() === sap.ui.table.NavigationMode.Scrollbar && this._getRowCount() > 0) {
			iStartIndex = Math.min(iStartIndex, Math.max(this._getRowCount() - this.getVisibleRowCount(), 0));
		}
		this.setProperty("firstVisibleRow", iStartIndex, true);

		// when not scrolling we update also the scroll position of the scrollbar
		if (this._oVSb.getScrollPosition() !== iStartIndex) {
			this._oVSb.setScrollPosition(iStartIndex);
		}

		// update the paginator
		if (this._oPaginator && this.getNavigationMode() === sap.ui.table.NavigationMode.Paginator) {
			// if iStartIndex is equal or greater than the number of total rows go back to page 1
			var iNewPage = 1;
			if (iStartIndex < this.getBinding("rows").getLength()) {
				iNewPage = Math.ceil((iStartIndex + 1) / this.getVisibleRowCount());
			}
			if (iNewPage !== this._oPaginator.getCurrentPage()) {
				this.setProperty("firstVisibleRow", (iNewPage - 1) * this.getVisibleRowCount(), true);
				this._oPaginator.setCurrentPage(iNewPage);
				if (this._oPaginator.getDomRef()) {
					this._oPaginator.rerender();
				}
			}
		}

		// update the bindings only once the table is rendered
		if (this.getDomRef()) {

			// update the bindings by using a delayed mechanism to avoid to many update
			// requests: by using the mechanism below it will trigger an update each 50ms
			this._sBindingTimer = this._sBindingTimer || jQuery.sap.delayedCall(50, this, function() {
				// update only if control not marked as destroyed (could happen because updateRows is called during destroying the table)
				if (!this.bIsDestroyed) {
					this._determineVisibleCols();
					this._updateBindingContexts();
					this._updateVSb(); // this was moved here, before it was done before updatebindingContext
					this._updateTableContent();
					this._sBindingTimer = undefined;
					//Helper event for testing
					this.fireEvent("_rowsUpdated");
				}
			});
		}
	};

	/*
	 * @see JSDoc generated by SAPUI5 control API generator
	 */
	Table.prototype.insertRow = function() {
		jQuery.sap.log.error("The control manages the rows aggregation. The method \"insertRow\" cannot be used programmatically!");
	};

	/*
	 * @see JSDoc generated by SAPUI5 control API generator
	 */
	Table.prototype.addRow = function() {
		jQuery.sap.log.error("The control manages the rows aggregation. The method \"addRow\" cannot be used programmatically!");
	};

	/*
	 * @see JSDoc generated by SAPUI5 control API generator
	 */
	Table.prototype.removeRow = function() {
		jQuery.sap.log.error("The control manages the rows aggregation. The method \"removeRow\" cannot be used programmatically!");
	};

	/*
	 * @see JSDoc generated by SAPUI5 control API generator
	 */
	Table.prototype.removeAllRows = function() {
		jQuery.sap.log.error("The control manages the rows aggregation. The method \"removeAllRows\" cannot be used programmatically!");
	};

	/*
	 * @see JSDoc generated by SAPUI5 control API generator
	 */
	Table.prototype.destroyRows = function() {
		jQuery.sap.log.error("The control manages the rows aggregation. The method \"destroyRows\" cannot be used programmatically!");
	};

	/**
	 * triggers automatic resizing of a column to the widest content.(experimental!)
	 * @experimental Experimental! Presently implemented to only work with pure text-based controls,
	 * the sap.ui.commons.Checkbox and sap.m.Image as well as sap.ui.commons.Image.
	 * It will also work for most simple input fields (TextField, CheckBox, but not ComboBox)
	 *
	 * @param {int} iColId column id
	 * @function
	 * @public
	 */
	Table.prototype.autoResizeColumn = function(iColId) {
		var oCol = this.getColumns()[iColId];
		this._iColumnResizeStart = null;
		var iNewWidth = this._calculateAutomaticColumnWidth(iColId);
		if (iNewWidth == null) {
			return;
		}

		oCol._iNewWidth = iNewWidth;
		this._oCalcColumnWidths[iColId] = oCol._iNewWidth;
		this._onColumnResized(null, iColId);
	};


	// =============================================================================
	// EVENT HANDLING & CLEANUP
	// =============================================================================

	/**
	 * attaches the required native event handlers
	 * @private
	 */
	Table.prototype._attachEvents = function() {

		var $this = this.$();

		// listen to the scroll events of the containers (for keyboard navigation)
		$this.find(".sapUiTableColHdrScr").scroll(jQuery.proxy(this._oncolscroll, this));
		$this.find(".sapUiTableCtrlScr").scroll(jQuery.proxy(this._oncntscroll, this));
		$this.find(".sapUiTableCtrlScrFixed").scroll(jQuery.proxy(this._oncntscroll, this));

		// sync row header > content (hover effect)
		$this.find(".sapUiTableRowHdr").hover(function() {
			jQuery(this).addClass("sapUiTableRowHvr");
			var iIndex = $this.find(".sapUiTableRowHdr").index(this);
			$this.find(".sapUiTableCtrlFixed > tbody > tr").filter(":eq(" + iIndex + ")").addClass("sapUiTableRowHvr");
			$this.find(".sapUiTableCtrlScroll > tbody > tr").filter(":eq(" + iIndex + ")").addClass("sapUiTableRowHvr");
		}, function() {
			jQuery(this).removeClass("sapUiTableRowHvr");
			$this.find(".sapUiTableCtrlFixed > tbody > tr").removeClass("sapUiTableRowHvr");
			$this.find(".sapUiTableCtrlScroll > tbody > tr").removeClass("sapUiTableRowHvr");
		});

		// sync content fixed > row header (hover effect)
		$this.find(".sapUiTableCtrlFixed > tbody > tr").hover(function() {
			jQuery(this).addClass("sapUiTableRowHvr");
			var iIndex = $this.find(".sapUiTableCtrlFixed > tbody > tr").index(this);
			$this.find(".sapUiTableRowHdr").filter(":eq(" + (iIndex) + ")").addClass("sapUiTableRowHvr");
			$this.find(".sapUiTableCtrlScroll > tbody > tr").filter(":eq(" + iIndex + ")").addClass("sapUiTableRowHvr");
		}, function() {
			jQuery(this).removeClass("sapUiTableRowHvr");
			$this.find(".sapUiTableRowHdr").removeClass("sapUiTableRowHvr");
			$this.find(".sapUiTableCtrlScroll > tbody > tr").removeClass("sapUiTableRowHvr");
		});

		// sync content scroll > row header (hover effect)
		$this.find(".sapUiTableCtrlScroll > tbody > tr").hover(function() {
			jQuery(this).addClass("sapUiTableRowHvr");
			var iIndex = $this.find(".sapUiTableCtrlScroll > tbody > tr").index(this);
			$this.find(".sapUiTableRowHdr").filter(":eq(" + iIndex + ")").addClass("sapUiTableRowHvr");
			$this.find(".sapUiTableCtrlFixed > tbody > tr").filter(":eq(" + iIndex + ")").addClass("sapUiTableRowHvr");
		}, function() {
			jQuery(this).removeClass("sapUiTableRowHvr");
			$this.find(".sapUiTableRowHdr").removeClass("sapUiTableRowHvr");
			$this.find(".sapUiTableCtrlFixed > tbody > tr").removeClass("sapUiTableRowHvr");
		});

		// listen to the resize handlers
		$this.find(".sapUiTableColRsz").mousedown(jQuery.proxy(this._onColumnResizeStart, this));

		this._enableColumnAutoResizing();
		Table.ResizeTrigger.addListener(this._checkTableSize, this);

		// the vertical scrollbar listens to the mousewheel on the content section
		this._oHSb.bind($this.find(".sapUiTableCtrlScr").get(0));
		this._oVSb.bind($this.find(".sapUiTableCtrlScr").get(0));
		this._oHSb.bind($this.find(".sapUiTableCtrlScrFixed").get(0));
		this._oVSb.bind($this.find(".sapUiTableCtrlScrFixed").get(0));
		this._oVSb.bind($this.find(".sapUiTableRowHdrScr").get(0));

		jQuery("body").bind('webkitTransitionEnd transitionend',
			jQuery.proxy(function(oEvent) {
				if (jQuery(oEvent.target).has($this).length > 0) {
					this._handleResize();
				}
			}, this));
	};


	/**
	 * detaches the required native event handlers
	 * @private
	 */
	Table.prototype._detachEvents = function() {

		var $this = this.$();

		$this.find(".sapUiTableRowHdrScr").unbind();
		$this.find(".sapUiTableColHdrScr").unbind();

		$this.find(".sapUiTableCtrl > tbody > tr").unbind();
		$this.find(".sapUiTableRowHdr").unbind();

		Table.ResizeTrigger.removeListener(this._checkTableSize, this);

		$this.find(".sapUiTableColRsz").unbind();

		this._oHSb.unbind($this.find(".sapUiTableCtrlScr").get(0));
		this._oVSb.unbind($this.find(".sapUiTableCtrlScr").get(0));
		this._oHSb.unbind($this.find(".sapUiTableCtrlScrFixed").get(0));
		this._oVSb.unbind($this.find(".sapUiTableCtrlScrFixed").get(0));
		this._oVSb.unbind($this.find(".sapUiTableRowHdrScr").get(0));

		jQuery("body").unbind('webkitTransitionEnd transitionend');
	};


	/**
	 * cleanup the timers when not required anymore
	 * @private
	 */
	Table.prototype._cleanUpTimers = function() {

		if (this._sBindingTimer) {
			jQuery.sap.clearDelayedCall(this._sBindingTimer);
			this._sBindingTimer = undefined;
		}

		if (this._sScrollBarTimer) {
			jQuery.sap.clearDelayedCall(this._sScrollBarTimer);
			this._sScrollBarTimer = undefined;
		}

		if (this._sDelayedMenuTimer) {
			jQuery.sap.clearDelayedCall(this._sDelayedMenuTimer);
			this._sDelayedMenuTimer = undefined;
		}

		if (this._sDelayedActionTimer) {
			jQuery.sap.clearDelayedCall(this._sDelayedActionTimer);
			this._sDelayedActionTimer = undefined;
		}

		if (this._sColHdrPosTimer) {
			jQuery.sap.clearDelayedCall(this._sColHdrPosTimer);
			this._sColHdrPosTimer = undefined;
		}

		if (this._visibleRowCountTimer) {
			jQuery.sap.clearDelayedCall(this._visibleRowCountTimer);
			this._visibleRowCountTimer = undefined;
		}

		Table.ResizeTrigger.removeListener(this._checkTableSize, this);
	};


	// =============================================================================
	// PRIVATE TABLE STUFF
	// =============================================================================


	/**
	 * creates the rows for the rows aggregation
	 * @private
	 */
	Table.prototype._createRows = function(iStartIndex) {

		var iFirstVisibleRow = this.getFirstVisibleRow();
		var iVisibleRowCount = this.getVisibleRowCount();

		// by default the start index is the first visible row
		iStartIndex = iStartIndex === undefined ? iFirstVisibleRow : iStartIndex;

		// create the new template
		var oTemplate = new Row(this.getId() + "-rows");
		var aCols = this.getColumns();
		var iCellIndex = 0;
		for (var i = 0, l = aCols.length; i < l; i++) {
			if (aCols[i].getVisible()) {
				var oColTemplate = aCols[i].getTemplate();
				if (oColTemplate) {
					var oClone = oColTemplate.clone("col" + i);
					// inherit the editable property if required to the child controls
					if (this._bInheritEditableToControls && !this.getEditable() && oClone.setEditable) {
						oClone.setEditable(false);
					}
					oClone.data("sap-ui-colindex", i);
					oTemplate.addCell(oClone);
					this._aIdxCols2Cells[i] = iCellIndex++;
				}
			}
		}

		// initially called without iStartIndex and iLength
		this.destroyAggregation("rows", true);
		var aContexts;
		var oBinding = this.getBinding("rows");
		var oBindingInfo = this.mBindingInfos["rows"];
		if (oBinding && iVisibleRowCount > 0) {
			// if thresholding is 0 then it is disabled and we forward 0 to the binding
			var iThreshold = this.getThreshold() ? Math.max(this.getVisibleRowCount(), this.getThreshold()) : 0;
			var iFixedBottomRowCount = this.getFixedBottomRowCount();
			aContexts = oBinding.getContexts(iStartIndex, iVisibleRowCount - iFixedBottomRowCount, iThreshold);
			this._setBusy({
				requestedLength: iVisibleRowCount - iFixedBottomRowCount,
				receivedLength: aContexts.length,
				contexts: aContexts });

			if (iFixedBottomRowCount > 0 && (iVisibleRowCount - iFixedBottomRowCount) < oBinding.getLength()) {
				var aFixedBottomContexts = oBinding.getContexts(oBinding.getLength() - iFixedBottomRowCount, iFixedBottomRowCount, 1);
				aContexts = aContexts.concat(aFixedBottomContexts);
				this._setBusy({
					requestedLength: iFixedBottomRowCount,
					receivedLength: aFixedBottomContexts.length,
					contexts: aFixedBottomContexts });
			}
		}
		for (var i = 0; i < iVisibleRowCount; i++) {
			var oClone = oTemplate.clone("row" + i); // TODO: Isn't the following required! + "-" + this.getId());
			if (aContexts && aContexts[i]) {
				oClone.setBindingContext(aContexts[i], oBindingInfo.model);
				oClone._bHidden = false;
			} else {
				if (oBindingInfo) {
					oClone.setBindingContext(null, oBindingInfo.model);
				} else {
					oClone.setBindingContext(null);
				}

				oClone._bHidden = true;
			}
			this.addAggregation("rows", oClone, true);
		}

		// destroy the template
		oTemplate.destroy();

	};


	/**
	 * updates the horizontal scrollbar
	 * @private
	 */
	Table.prototype._updateHSb = function() {

		// get the width of the container
		var $this = this.$();

		// apply the new content size
		var iColsWidth = $this.find(".sapUiTableCtrlScroll").width();
		if (!!sap.ui.Device.browser.safari) {
			iColsWidth = Math.max(iColsWidth, this._getColumnsWidth(this.getFixedColumnCount()));
		}

		// add the horizontal scrollbar
		if (iColsWidth > $this.find(".sapUiTableCtrlScr").width()) {
			// show the scrollbar
			if (!$this.hasClass("sapUiTableHScr")) {
				$this.addClass("sapUiTableHScr");

				if (!!sap.ui.Device.browser.safari) {
					var $sapUiTableColHdr = $this.find(".sapUiTableCtrlScroll, .sapUiTableColHdrScr > .sapUiTableColHdr");
					// min-width on table elements does not work for safari
					if (this._bjQueryLess18) {
						$sapUiTableColHdr.width(iColsWidth);
					} else {
						$sapUiTableColHdr.outerWidth(iColsWidth);
					}
				}
			}

			var iScrollPadding = $this.find(".sapUiTableCtrlFixed").width();

			if ($this.find(".sapUiTableRowHdrScr:visible").length > 0) {
				iScrollPadding += $this.find(".sapUiTableRowHdrScr").width();
			}

			var $sapUiTableHSb = $this.find(".sapUiTableHSb");
			if (this._bRtlMode) {
				$sapUiTableHSb.css('padding-right', iScrollPadding + 'px');
			} else {
				$sapUiTableHSb.css('padding-left', iScrollPadding + 'px');
			}
			
			// When table has no fixed width, the scrollbar is not allowed to increase the width of the table.
			// We define the max-width of the scrollbar to be limited by its parent width.
			var iMaximumScrollBarWidth = $sapUiTableHSb.parent().width();
			$sapUiTableHSb.css('max-width', iMaximumScrollBarWidth + "px");

			this._oHSb.setContentSize(iColsWidth + "px");

			if (this._oHSb.getDomRef()) {
				this._oHSb.rerender();
			}
		} else {
			// hide the scrollbar
			if ($this.hasClass("sapUiTableHScr")) {
				$this.removeClass("sapUiTableHScr");
				if (!!sap.ui.Device.browser.safari) {
					// min-width on table elements does not work for safari
					$this.find(".sapUiTableCtrlScroll, .sapUiTableColHdr").css("width", "");
				}
			}
		}

		this._syncHeaderAndContent();

	};


	/**
	 * updates the vertical scrollbar
	 * @private
	 */
	Table.prototype._updateVSb = function(bOnAfterRendering) {
		var $this = this.$();
		var bDoResize = false;
		var bForceUpdateVSb = false;
		var oBinding = this.getBinding("rows");
		if (oBinding) {

			// move the vertical scrollbar to the scrolling table only
			var iFixedRows = this.getFixedRowCount();
			if (iFixedRows > 0) {
				var iOffsetTop = $this.find('.sapUiTableCtrl.sapUiTableCtrlRowScroll.sapUiTableCtrlScroll')[0].offsetTop;
				this.$().find('.sapUiTableVSb').css('top', (iOffsetTop - 1) + 'px');
				bForceUpdateVSb = true;
			}
			var iFixedBottomRows = this.getFixedBottomRowCount();
			if (iFixedBottomRows > 0) {
				var iOffsetHeight = $this.find('.sapUiTableCtrl.sapUiTableCtrlRowScroll.sapUiTableCtrlScroll')[0].offsetHeight;
				this.$().find('.sapUiTableVSb').css('height', iOffsetHeight + 'px');
				bForceUpdateVSb = true;
			}

			var iSteps = Math.max(0, (oBinding.getLength() || 0) - this.getVisibleRowCount());
			// check for paging mode or scrollbar mode
			if (this._oPaginator && this.getNavigationMode() === sap.ui.table.NavigationMode.Paginator) {
				// update the paginator (set the first visible row property)
				var iNumberOfPages = Math.ceil((oBinding.getLength() || 0) / this.getVisibleRowCount());
				this._oPaginator.setNumberOfPages(iNumberOfPages);
				var iPage = Math.min(iNumberOfPages, Math.ceil((this.getFirstVisibleRow() + 1) / this.getVisibleRowCount()));
				this.setProperty("firstVisibleRow", (Math.max(iPage,1) - 1) * this.getVisibleRowCount(), true);
				this._oPaginator.setCurrentPage(iPage);
				if (this._oPaginator.getDomRef()) {
					this._oPaginator.rerender();
				}
				if ($this.hasClass("sapUiTableVScr")) {
					$this.removeClass("sapUiTableVScr");
				}
			} else {
				// in case of scrollbar mode show or hide the scrollbar dependening on the
				// calculated steps:
				if (iSteps > 0) {
					if (!$this.hasClass("sapUiTableVScr")) {
						$this.addClass("sapUiTableVScr");
						bDoResize = true;
					}
				} else {
					if ($this.hasClass("sapUiTableVScr")) {
						$this.removeClass("sapUiTableVScr");
						bDoResize = true;
					}
				}
			}

			// update the scrollbar only if it is required
			if (bOnAfterRendering || bForceUpdateVSb || iSteps !== this._oVSb.getSteps() || this.getFirstVisibleRow() !== this._oVSb.getScrollPosition()) {
				jQuery.sap.clearDelayedCall(this._sScrollBarTimer);
				// TODO: in case of bForceUpdateVSb the scrolling doesn't work anymore
				//       height changes of the scrollbar should not require a re-rendering!
				this._sScrollBarTimer = jQuery.sap.delayedCall(bOnAfterRendering ? 0 : 250, this, function() {

					this._oVSb.setSteps(iSteps);
					if (this._oVSb.getDomRef()) {
						this._oVSb.rerender();
					}
					this._oVSb.setScrollPosition(this.getFirstVisibleRow());

				});

			}

		} else {
			// check for paging mode or scrollbar mode
			if (this._oPaginator && this.getNavigationMode() === sap.ui.table.NavigationMode.Paginator) {
				// update the paginator (set the first visible row property)
				this._oPaginator.setNumberOfPages(0);
				this._oPaginator.setCurrentPage(0);
				if (this._oPaginator.getDomRef()) {
					this._oPaginator.rerender();
				}
			} else {
				if ($this.hasClass("sapUiTableVScr")) {
					$this.removeClass("sapUiTableVScr");
					bDoResize = true;
				}
			}
		}
		if (bDoResize && !this._bOnAfterRendering) {
			this._handleResize();
		}
	};


	/**
	 * updates the binding contexts of the currently visible controls
	 * @private
	 */
	Table.prototype._updateBindingContexts = function(bSuppressUpdate) {

		var aRows = this.getRows(),
		    oBinding = this.getBinding("rows"),
		    oBindinginfo = this.mBindingInfos["rows"],
		    aFixedContexts,
		    aContexts,
		    aFixedBottomContexts,
		    iFixedRows = this.getFixedRowCount(),
		    iFixedBottomRows = this.getFixedBottomRowCount(),
		    iVisibleRowCount = this.getVisibleRowCount();

		// fetch the contexts from the binding
		if (oBinding) {
			var iThreshold;
			if (iFixedRows > 0 || iFixedBottomRows > 0) {
				// thresholding is deactivated when value is 0
				var iTotalFixedRows = iFixedRows + iFixedBottomRows;
				iThreshold = this.getThreshold() ? Math.max((this.getVisibleRowCount() - iTotalFixedRows), this.getThreshold()) : 0;
				aContexts = oBinding.getContexts(this.getFirstVisibleRow() + iFixedRows, aRows.length - iTotalFixedRows, iThreshold);
				this._setBusy({
					requestedLength: aRows.length - iTotalFixedRows,
					receivedLength: aContexts.length,
					contexts: aContexts });
				// static rows: we fetch the contexts without threshold to avoid loading
				// of unnecessary data. Make sure to fetch after the normal rows to avoid
				// outgoing double requests for the contexts.
				if (iFixedRows > 0) {
					aFixedContexts = oBinding.getContexts(0, iFixedRows);
					this._setBusy({
						requestedLength: iFixedRows,
						receivedLength: aFixedContexts.length,
						contexts: aFixedContexts });

					aContexts = aFixedContexts.concat(aContexts);
				}
				if (iFixedBottomRows > 0 && (iVisibleRowCount - iFixedBottomRows) < oBinding.getLength()) {
					aFixedBottomContexts = oBinding.getContexts(oBinding.getLength() - iFixedBottomRows, iFixedBottomRows);
					this._setBusy({
						requestedLength: iFixedBottomRows,
						receivedLength: aFixedBottomContexts.length,
						contexts: aFixedBottomContexts });

					aContexts = aContexts.concat(aFixedBottomContexts);
				}
			} else if (aRows.length > 0) {
				// thresholding is deactivated when value is 0
				iThreshold = this.getThreshold() ? Math.max(this.getVisibleRowCount(), this.getThreshold()) : 0;
				aContexts = oBinding.getContexts(this.getFirstVisibleRow(), aRows.length, iThreshold);
				this._setBusy({
					requestedLength: aRows.length,
					receivedLength: aContexts.length,
					contexts: aContexts });
			}
		}

		// update the binding contexts only for the visible columns
		//for (var iIndex = 0, iLength = this.getRows().length; iIndex < iLength; iIndex++) {
		if (!bSuppressUpdate) {
			for (var iIndex = aRows.length - 1; iIndex >= 0; iIndex--) {
				var oContext = aContexts ? aContexts[iIndex] : undefined;
				var oRow = aRows[iIndex];
				if (oRow) {
					//calculate the absolute row index, used by the Tree/AnalyticalTable to find the rendering infos for this row
					var iAbsoluteRowIndex = this.getFirstVisibleRow() + iIndex;
					this._updateRowBindingContext(oRow, oContext, oBindinginfo && oBindinginfo.model, iAbsoluteRowIndex);
				}
			}
		}

	};

	/**
	 * updates the binding context a row
	 * @param {sap.ui.table.Row} row to update
	 * @param {sap.ui.model.Context} binding context of the row
	 * @private
	 */
	Table.prototype._updateRowBindingContext = function(oRow, oContext, sModelName, iAbsoluteRowIndex) {
		var aCells = oRow.getCells();
		var $row = oRow.$();
		var $fixedRow = oRow.$("fixed");
		var $rowHdr = this.$().find("div[data-sap-ui-rowindex='" + $row.attr("data-sap-ui-rowindex") + "']");
		// check for a context object (in case of grouping there could be custom context objects)
		oRow.setBindingContext(oContext, sModelName);
		if (oContext && oContext instanceof sap.ui.model.Context) {
			for (var i = 0, l = this._aVisibleColumns.length; i < l; i++) {
				var col = this._aIdxCols2Cells[this._aVisibleColumns[i]];
				if (aCells[col]) {
					this._updateCellBindingContext(aCells[col], oContext, sModelName, iAbsoluteRowIndex);
				}
			}
			if ($row.hasClass("sapUiTableRowHidden")) {
				$row.removeClass("sapUiTableRowHidden");
				$fixedRow.removeClass("sapUiTableRowHidden");
				$rowHdr.removeClass("sapUiTableRowHidden");
			}
			oRow._bHidden = false;
		} else {
			if (!$row.hasClass("sapUiTableRowHidden")) {
				$row.addClass("sapUiTableRowHidden");
				$fixedRow.addClass("sapUiTableRowHidden");
				$rowHdr.addClass("sapUiTableRowHidden");
			}
			if ($row.hasClass("sapUiTableFixedBottomRow")) {
				$row.removeClass('sapUiTableFixedBottomRow');
				$fixedRow.removeClass('sapUiTableFixedBottomRow');
				$rowHdr.removeClass('sapUiTableFixedBottomRow');
			}
			if ($row.hasClass("sapUiTableFixedPreBottomRow")) {
				$row.removeClass('sapUiTableFixedPreBottomRow');
				$fixedRow.removeClass('sapUiTableFixedPreBottomRow');
				$rowHdr.removeClass('sapUiTableFixedPreBottomRow');
			}
			if ($row.hasClass("sapUiTableFixedTopRow")) {
				$row.removeClass('sapUiTableFixedTopRow');
				$fixedRow.removeClass('sapUiTableFixedTopRow');
				$rowHdr.removeClass('sapUiTableFixedTopRow');
			}
			oRow._bHidden = true;
			for (var i = 0, l = this._aVisibleColumns.length; i < l; i++) {
				var col = this._aIdxCols2Cells[this._aVisibleColumns[i]];
				if (aCells[col]) {
					this._updateCellBindingContext(aCells[col], oContext, sModelName, iAbsoluteRowIndex);
				}
			}
		}
	};

	/**
	 * updates the binding context a cell
	 * @param {sap.ui.core.Control} control of the cell
	 * @param {sap.ui.model.Context} binding context of the cell
	 * @private
	 */
	Table.prototype._updateCellBindingContext = function(oCell, oContext, sModelName, iAbsoluteRowIndex) {
			//oCell.setBindingContext(oContext, sModelName);
			if (this._bCallUpdateTableCell && oCell._updateTableCell) {
				oCell._updateTableCell(oCell /* cell control */, oContext /* cell context */, oCell.$().closest("td") /* jQuery object for td */, iAbsoluteRowIndex);
			}
			if (typeof this._updateTableCell === "function") {
				this._updateTableCell(oCell /* cell control */, oContext /* cell context */, oCell.$().closest("td") /* jQuery object for td */, iAbsoluteRowIndex);
			}
	};

	/**
	 * check if data is available in the table
	 * @private
	 */
	Table.prototype._hasData = function() {
		var oBinding = this.getBinding("rows");
		if (!oBinding || (oBinding.getLength() || 0) === 0) {
			return false;
		}
		return true;
	};

	/**
	 * show or hide the no data container
	 * @private
	 */
	Table.prototype._updateNoData = function() {
		// no data?
		if (this.getShowNoData()) {
			var oBinding = this.getBinding("rows");
			if (!this._hasData()) {
				if (!this.$().hasClass("sapUiTableEmpty")) {
					this.$().addClass("sapUiTableEmpty");
				}
				// update the ARIA text for the row count
				this.$("ariacount").text(this._oResBundle.getText("TBL_DATA_ROWS", [0]));
			} else {
				if (this.$().hasClass("sapUiTableEmpty")) {
					this.$().removeClass("sapUiTableEmpty");
				}
				// update the ARIA text for the row count
				this.$("ariacount").text(this._oResBundle.getText("TBL_DATA_ROWS", [(oBinding.getLength() || 0)]));
			}
		}
	};


	/**
	 * determines the currently visible columns (used for simply updating only the
	 * controls of the visible columns instead of the complete row!)
	 * @private
	 */
	Table.prototype._determineVisibleCols = function() {

		// determine the visible colums
		var $this = this.$(),
		    that = this;

		if ($this.hasClass("sapUiTableHScr")) {

			var bRtl = this._bRtlMode;

			// calculate the view port
			var iScrollLeft = this._oHSb.getNativeScrollPosition();
			if (bRtl && sap.ui.Device.browser.firefox && iScrollLeft < 0) {
				// Firefox deals with negative scrollPosition in RTL mode
				iScrollLeft = iScrollLeft * -1;
			}
			var iScrollRight = iScrollLeft + this._getScrollWidth();

			// has the view port changed?
			if (this._iOldScrollLeft !== iScrollLeft || this._iOldScrollRight !== iScrollRight || this._bForceVisibleColCalc) {

				// calculate the first and last visible column
				var iLeft = bRtl ? $this.find(".sapUiTableCtrlScroll").width() : 0;

				if ((sap.ui.Device.browser.internet_explorer || sap.ui.Device.browser.firefox) && bRtl) {
					// Assume ScrollWidth=100px, Scroll to the very left in RTL mode
					// IE has reverse scroll position (Chrome = 0, IE = 100, FF = -100)
					iLeft = 0;
				}

				this._aVisibleColumns = [];
				for (var i = 0, l = this.getFixedColumnCount(); i < l; i++) {
					this._aVisibleColumns.push(i);
				}
				var $ths = $this.find(".sapUiTableCtrl.sapUiTableCtrlScroll .sapUiTableCtrlFirstCol > th[data-sap-ui-headcolindex]");
				$ths.each(function(iIndex, oElement) {
					var iWidth = jQuery(oElement).width();
					if (bRtl && sap.ui.Device.browser.chrome) {
						iLeft -= iWidth;
					}
					if (iLeft + iWidth >= iScrollLeft && iLeft <= iScrollRight) {
						that._aVisibleColumns.push(parseInt(jQuery(oElement).data('sap-ui-headcolindex'),10));
					}
					if (!bRtl || (sap.ui.Device.browser.internet_explorer || sap.ui.Device.browser.firefox)) {
						iLeft += iWidth;
					}
				});

				// keep the view port information (performance!!)
				this._iOldScrollLeft = iScrollLeft;
				this._iOldScrollRight = iScrollRight;
				this._bForceVisibleColCalc = false;
			}
		} else {
			this._aVisibleColumns = [];
			var aCols = this.getColumns();
			for (var i = 0, l = aCols.length; i < l; i++) {
				if (aCols[i].shouldRender()) {
					this._aVisibleColumns.push(i);
				}
			}
		}

	};

	/**
	 * enables automatic resizing on doubleclick on a column if the corresponding column attribute is set
	 * @experimental Experimental, only works with limited control set
	 * @function
	 * @private
	 */
	Table.prototype._enableColumnAutoResizing = function (){
		var that = this;
		jQuery.each(this.getColumns(), function (iIndex, oCol){
			if (!!oCol.getAutoResizable()){
				var $resizer = jQuery.find(".sapUiTableColRsz[data-sap-ui-colindex=" + iIndex + "]");
				if ($resizer){
					that._bindSimulatedDoubleclick($resizer, null /* fnSingleClick*/, that._onAutomaticColumnResize /* fnDoubleClick */);
				}
			}
		});
	};

	Table.prototype.removeColumn = function (oColumn) {
		this.removeAggregation('columns', oColumn);
		this._bDetermineVisibleCols = true;
		return this;
	};

	Table.prototype.addColumn = function (oColumn) {
		var that = this;
		this.addAggregation('columns', oColumn);
		oColumn.attachEvent('_widthChanged', function(oEvent) {
			that._bForceVisibleColCalc = true;
		});

		this._bDetermineVisibleCols = true;
		return this;
	};

	Table.prototype.insertColumn = function (oColumn, iIndex) {
		var that = this;
		this.insertAggregation('columns', oColumn, iIndex);
		oColumn.attachEvent('_widthChanged', function() {
			that._bForceVisibleColCalc = true;
		});

		this._bDetermineVisibleCols = true;
		return this;
	};

	/**
	 * returns the count of rows when bound or 0
	 * @private
	 */
	Table.prototype._getRowCount = function() {
		var oBinding = this.getBinding("rows");
		return oBinding ? (oBinding.getLength() || 0) : 0;
	};

	/**
	 * returns the count of rows which can ca selected when bound or 0
	 * @private
	 */
	Table.prototype._getSelectableRowCount = function() {
		return this._getRowCount();
	};


	/**
	 * returns the current top scroll position of the scrollbar (row number)
	 * @private
	 */
	Table.prototype._getScrollTop = function() {
		if (this.$().hasClass("sapUiTableVScr")) {
			return this._oVSb.getScrollPosition() || 0;
		} else {
			if (this.getNavigationMode() === sap.ui.table.NavigationMode.Paginator) {
				return (((this._oPaginator.getCurrentPage() || 1) - 1) * this.getVisibleRowCount());
			} else {
				return 0;
			}
		}
	};

	/**
	 * returns the width of the table scroll container
	 * @private
	 */
	Table.prototype._getScrollWidth = function() {
		return this.$().find(".sapUiTableCtrlScr").width();
	};

	/**
	 * returns the height of the table scroll container
	 * @private
	 */
	Table.prototype._getScrollHeight = function() {
		return this.$().find(".sapUiTableCtrlScr").height();
	};

	/**
	 * returns the count of visible columns
	 * @private
	 */
	Table.prototype._getVisibleColumns = function() {
		var aColumns = [];
		var aCols = this.getColumns();
		for (var i = 0, l = aCols.length; i < l; i++) {
			if (aCols[i].shouldRender()) {
				aColumns.push(aCols[i]);
			}
		}
		return aColumns;
	};

	/**
	 * returns the count of visible columns
	 * @private
	 */
	Table.prototype._getVisibleColumnCount = function() {
		return this._getVisibleColumns().length;
	};

	/**
	 * returns the row count of headers
	 * @private
	 */
	Table.prototype._getHeaderRowCount = function() {
		if (!this.getColumnHeaderVisible()) {
			return 0;
		} else if (!this._useMultiHeader()) {
			return 1;
		}
		var iHeaderRows = 0;
		jQuery.each(this._getVisibleColumns(), function(iIndex, oColumn) {
			iHeaderRows = Math.max(iHeaderRows,  oColumn.getMultiLabels().length);
		});
		return iHeaderRows;
	};

	/**
	 * returns if multi header beahviour is used or not
	 * @private
	 */
	Table.prototype._useMultiHeader = function() {
		var useMultiLabels = false;
		jQuery.each(this._getVisibleColumns(), function(iIndex, oColumn) {
			if (oColumn.getMultiLabels().length > 0) {
				useMultiLabels = true;
				return false;
			}
		});
		return useMultiLabels;
	};


	/**
	 * returns the min width of all columns
	 * @private
	 */
	Table.prototype._getColumnsWidth = function(iStartColumn, iEndColumn) {

		// first calculate the min width of the table for all columns
		var aCols = this.getColumns();
		var iColsWidth = 0;

		if (iStartColumn !== 0 && !iStartColumn) {
			iStartColumn = 0;
		}
		if (iEndColumn !== 0 && !iEndColumn) {
			iEndColumn = aCols.length;
		}

		for (var i = iStartColumn, l = iEndColumn; i < l; i++) {
			if (aCols[i] && aCols[i].shouldRender()) {
				var sWidth = aCols[i].getWidth();
				var iWidth = parseInt(sWidth, 10);
				if (jQuery.sap.endsWith(sWidth, "px")) {
					iColsWidth += iWidth;
				} else {
					// for unknown width we use the min width
					iColsWidth += /* aCols[i].getMinWidth() || */ this._iColMinWidth;
				}
			}
		}

		return iColsWidth;

	};

	/**
	 * calculates the width of the columns by using the browsers calculation
	 * mechanism and setting a fix width to the columns
	 * @private
	 */
	Table.prototype._handleResize = function() {

		// when using the native resize handler then this function could be called
		// before the table has been rendered - therefore we interrupt this method
		if (!this.getDomRef()) {
			return;
		}

		// update the horizontal scrollbar
		this._updateHSb();

		// update the column header (sync column widths)
		this._updateColumnHeader();

		this._updateRowHeader();

		this._handleRowCountMode();
	};

	Table.prototype._checkTableSize = function() {
		if (!this.getDomRef()) {
			return;
		}

		var oParentDomRef = this.getDomRef().parentNode,
			iHeight = oParentDomRef.offsetHeight,
			iWidth = oParentDomRef.offsetWidth;

		if (oParentDomRef != this._lastParent || iHeight != this._lastParentHeight || iWidth != this._lastParentWidth) {
			this._handleResize();
			this._lastParent = oParentDomRef;
			this._lastParentHeight = iHeight;
			this._lastParentWidth = iWidth;

			// update the bindings
			if (this.getBinding("rows")) {
				this.updateRows();
			}
		}
	};

	Table.prototype._handleRowCountMode = function() {
		//if visibleRowCountMode is auto change the visibleRowCount according to the parents container height
		if (this.getVisibleRowCountMode() == sap.ui.table.VisibleRowCountMode.Auto) {
			var iCanvasHeight = this.$().parent().height();
			var iRows = this._calculateRowsToDisplay(iCanvasHeight);
			if (isNaN(iRows)) {
				return;
			}
			//Currently this needs to be executed in a timeout because invalidate is lost wenn method is called during onAfterRendering
			//This can be reverted when keeping the invalidate calls, that occur during onAfterRendering are kept
			var that = this;
			this._visibleRowCountTimer = setTimeout(function() {
				that.setVisibleRowCount(iRows);
			}, 0);
		}
	};

	/**
	 * updates the row headers
	 * @private
	 */
	Table.prototype._updateRowHeader = function() {

		// we skip this expensive height and width calculation when not required!
		if (this.getFixedRowCount() >= 0 || this.getFixedColumnCount() >= 0 || this.getRowHeight() <= 0) {

			var $this = this.$();

			var $fixedRows = $this.find(".sapUiTableCtrlFixed > tbody > tr");
			var $scrollRows = $this.find(".sapUiTableCtrlScroll > tbody > tr");
			var $rowHeaders = $this.find(".sapUiTableRowHdr");

			if (this.getFixedColumnCount() > 0 && !this.getRowHeight()) {
				$fixedRows.css('height','');
				$scrollRows.css('height','');
			}

			for (var i = 0, l = $scrollRows.length; i < l; i++) {
				var iHeight = Math.max($fixedRows[i] ? ($fixedRows[i].getBoundingClientRect().bottom - $fixedRows[i].getBoundingClientRect().top) : 0, $scrollRows[i] ? ($scrollRows[i].getBoundingClientRect().bottom - $scrollRows[i].getBoundingClientRect().top) : 0);
				if (this._bjQueryLess18) {
					jQuery($rowHeaders[i]).height(iHeight);
					if (this.getFixedColumnCount() > 0 && !this.getRowHeight()) {
						jQuery($fixedRows[i]).height(iHeight);
						jQuery($scrollRows[i]).height(iHeight);
					}
				} else {
					jQuery($rowHeaders[i]).outerHeight(iHeight);
					if (this.getFixedColumnCount() > 0 && !this.getRowHeight()) {
						jQuery($fixedRows[i]).outerHeight(iHeight);
						jQuery($scrollRows[i]).outerHeight(iHeight);
					}
				}
			}

		}

	};

	/**
	 * updates the column headers (width and position of the resize handles)
	 * @private
	 */
	Table.prototype._updateColumnHeader = function(bUpdateResizeHandlers) {
		if (this._sColHdrPosTimer) {
			jQuery.sap.clearDelayedCall(this._sColHdrPosTimer);
		}
		var bRtl = this._bRtlMode;
		var iLeftAway = this._bRtlMode ? "99000px" : "-99000px";

		var fnSyncColumnHeaders = function() {

			// resize the dependent columns
			// (put the percentage width into relation th fixed widths)
			// TODO: reconsider this behavior: see snippix #98183 (initial display) and #98183 (resizing)
			this._resizeDependentColumns();

			// sync the width of the columns
			var that = this, $this = this.$();
			var $cols = $this.find(".sapUiTableColHdr .sapUiTableCol");
			var $colRszs = $this.find(".sapUiTableColHdr .sapUiTableColRsz");
			var aCols = this._getVisibleColumns();
			//If no header items exist an emty th is rendered but aCols.length is 0
			//Because of that we don't have to do anything of aCols.length = 0
			if (aCols.length == 0) {
				return;
			}
			var iTableWidth = $this.width();
			var $ths = $this.find(".sapUiTableCtrlFirstCol > th");
			var bHasRowHeader = this.getSelectionMode() !== sap.ui.table.SelectionMode.None && this.getSelectionBehavior() !== sap.ui.table.SelectionBehavior.RowOnly;
			var iInvisibleColWidth = 0;
			if (bHasRowHeader) {
				var oHiddenElement = $ths.get(0);
				iInvisibleColWidth = oHiddenElement.getBoundingClientRect().right - oHiddenElement.getBoundingClientRect().left;
				$ths = $ths.not(":nth-child(1)");
			}
			$ths.each(function(iIndex, oElement) {
				if (aCols[iIndex]) {
					jQuery(oElement).css('width', aCols[iIndex].getWidth());
				}
			});
			$ths.each(function(iIndex, oElement) {
				// apply the width of the column
				var iWidth = (oElement.getBoundingClientRect().right - oElement.getBoundingClientRect().left), //get real width (with decimal values),
					vHeaderSpan = aCols[iIndex] ? aCols[iIndex].getHeaderSpan() : 1,
					aHeaderWidths = [],
					aSpans;

					if (vHeaderSpan) {
						if (jQuery.isArray(vHeaderSpan)) {
							jQuery.each(vHeaderSpan, function(iSpanIndex, iSpan) {
								vHeaderSpan[iSpanIndex] = Math.max((iSpan + iIndex > aCols.length) ? Math.min(iSpan, aCols.length - iIndex) : iSpan, 1);
							});
							aSpans = vHeaderSpan;
						} else {
							vHeaderSpan = Math.max((vHeaderSpan + iIndex > aCols.length) ? Math.min(vHeaderSpan, aCols.length - iIndex) : vHeaderSpan, 1);
							aSpans = [vHeaderSpan];
						}
					} else {
						aSpans = [1];
					}

				//for the first column also calculate the width of the hidden column
				if (iIndex == 0) {
					iWidth += iInvisibleColWidth;
				}

				for (var i = 0; i < aSpans.length; i++) {
					aHeaderWidths[i] = iWidth;
					for (var j = 1; j < aSpans[i]; j++) {
						var oHeader = $ths[iIndex + j];
						if (oHeader) {
							aHeaderWidths[i] += oHeader.getBoundingClientRect().right - oHeader.getBoundingClientRect().left;
						}
					}
				}

				var $col = $cols.filter('[data-sap-ui-colindex=' + jQuery(oElement).data('sap-ui-headcolindex') + ']');
				if ($col.length > 0) {
					if (!bUpdateResizeHandlers) {
						// to avoid flickering we store the last real width of the column
						// and update the width of the column only when it has been changed
						var oCol = sap.ui.getCore().byId($col.first().data("sap-ui-colid"));
						for (var i = 0; i < $col.length; i++) {
							if (that._bjQueryLess18) {
								jQuery($col[i]).width(aHeaderWidths[i] || aHeaderWidths[0]);
							} else {
								jQuery($col[i]).outerWidth(aHeaderWidths[i] || aHeaderWidths[0]);
							}
						}
						oCol._iRealWidth = iWidth;
					}
					// the left position is calculated from the sapUiTableCnt element (therefore we need the offset!)
					var iLeft = $col.first().position().left;
					if (iLeft === 0 && $col.css("display") == "none") {
						// in order to get the correct position for the resize handle we need to go via the bounding rect
						// of the header instead of the left position of the colum. Columns could be display=none in case
						// a column span is set.
						oHeader = $ths[iIndex];
						iLeft = oHeader.getBoundingClientRect().left;
					}
					var iStartColIndex = jQuery(oElement).data('sap-ui-headcolindex');
					for (var i = 0; i < aSpans[0]; i++) {
						iLeft += (bRtl ? -2 : ($ths[iIndex + i].getBoundingClientRect().right - $ths[iIndex + i].getBoundingClientRect().left) - 3);
						// PERF-OPT: only positon the visible resize handlers
						var $colrsz = $colRszs.filter('[data-sap-ui-colindex=' + iStartColIndex + ']');
						if (iLeft >= 0 && iLeft <= iTableWidth) {
							$colrsz.css({
								"left": iLeft
							});
						} else if ($colrsz.css("left") !== iLeftAway) {
							$colrsz.css({
								"left": iLeftAway
							});
						}
						iStartColIndex++;
					}
				}
			});

			// we change the height of the cols, col header and the row header to auto to
			// find out whether to use the height of a cell or the min height of the col header
			var bHasColHdrHeight = this.getColumnHeaderHeight() > 0;
			if (!bHasColHdrHeight && !bUpdateResizeHandlers) {
				var $jqColHdr = $this.find(".sapUiTableColHdr");
				var $jqColHdrCnt = $this.find(".sapUiTableColHdrCnt");
				var $jqColRowHdr = $this.find(".sapUiTableColRowHdr");
				var $jqo = $jqColRowHdr.add($jqColHdrCnt);
				$jqo.height("auto");
				$cols.height("auto");
				//Total height of the table header
				var iHeight = Math.max($jqColHdr.height(), $jqColHdrCnt.height());
				//Height of one row within the header
				var iRegularHeight = iHeight / this._getHeaderRowCount();
				if (this._bjQueryLess18) {
					$cols.height(iRegularHeight);
					$jqo.height(iHeight);
				} else {
					$cols.outerHeight(iRegularHeight);
					$jqo.outerHeight(iHeight);
				}
			}
		};

		// instantly execute the synchronization or delay it
		if (this._bOnAfterRendering) {
			fnSyncColumnHeaders.apply(this, arguments);
		} else {
			this._sColHdrPosTimer = jQuery.sap.delayedCall(150, this, fnSyncColumnHeaders);
		}

	};

	/**
	 * disables text selection on the document (disabled fro Dnd)
	 * @private
	 */
	Table.prototype._disableTextSelection = function (oElement) {
		// prevent text selection
		jQuery(oElement || document.body).
			attr("unselectable", "on").
			css({
				"-moz-user-select": "none",
				"-webkit-user-select": "none",
				"user-select": "none"
	        }).
			bind("selectstart", function(oEvent) {
				oEvent.preventDefault();
				return false;
			});
	};

	/**
	 * enables text selection on the document (disabled fro Dnd)
	 * @private
	 */
	Table.prototype._enableTextSelection = function (oElement) {
		jQuery(oElement || document.body).
			attr("unselectable", "off").
			css({
				"-moz-user-select": "",
				"-webkit-user-select": "",
				"user-select": ""
	        }).
			unbind("selectstart");
	};

	/**
	 * clears the text selection on the document (disabled fro Dnd)
	 * @private
	 */
	Table.prototype._clearTextSelection = function () {
		if (window.getSelection) {
		  if (window.getSelection().empty) {  // Chrome
		    window.getSelection().empty();
		  } else if (window.getSelection().removeAllRanges) {  // Firefox
		    window.getSelection().removeAllRanges();
		  }
		} else if (document.selection && document.selection.empty) {  // IE?
			try {
			    document.selection.empty();
			} catch (ex) {
			    // ignore error to as a workaround for bug in IE8
			}
		}
	};

	// =============================================================================
	// CONTROL EVENT HANDLING
	// =============================================================================

	/**
	 * will be called by the vertical scrollbar. updates the visualized data by
	 * applying the first visible (scrollpos) row from the vertical scrollbar
	 * @private
	 */
	Table.prototype.onvscroll = function(oEvent) {
		// do not scroll in action mode!
		this._leaveActionMode();
		// set the first visible row
		this.setFirstVisibleRow(this._getScrollTop(), true);
	};

	/**
	 * sync the column header and content
	 * @private
	 */
	Table.prototype._syncHeaderAndContent = function() {
		if (!this._bSyncScrollLeft) {
			this._bSyncScrollLeft = true;
			// synchronize the scroll areas
			var $this = this.$();
			var iScrollLeft = this._oHSb.getNativeScrollPosition();
			$this.find(".sapUiTableCtrlScr").scrollLeft(iScrollLeft);
			if (!!sap.ui.Device.browser.webkit && this._bRtlMode) {
				var oScrollDomRef = $this.find(".sapUiTableColHdrScr").get(0);
				iScrollLeft = oScrollDomRef.scrollWidth - oScrollDomRef.clientWidth - this._oHSb.getScrollPosition();
			}
			$this.find(".sapUiTableColHdrScr").scrollLeft(iScrollLeft);
			this._bSyncScrollLeft = false;
		}

	};

	/**
	 * will be called when the horizontal scrollbar is used. since the table does
	 * not render/update the data of all columns (only the visible ones) in case
	 * of scrolling horizontally we need to update the content of the columns which
	 * became visible.
	 * @private
	 */
	Table.prototype.onhscroll = function(oEvent) {

		if (!this._bOnAfterRendering) {

			// sync the column header and the content area
			this._syncHeaderAndContent();

			// update the column headers (resize handles)
			this._updateColumnHeader(true);

			// update the bindings
			if (this.getBinding("rows")) {
				this.updateRows();
			}

		}

	};

	/**
	 * when navigating within the column header we need to synchronize the content
	 * area with the position (scrollLeft) of the column header.
	 * @private
	 */
	Table.prototype._oncolscroll = function(oEvent) {
		if (!this._bSyncScrollLeft) {
			var $cnt = this.$().find(".sapUiTableColHdrScr");
			if (!!sap.ui.Device.browser.webkit && this._bRtlMode) {
				var oScrollDomRef = this.$().find(".sapUiTableColHdrScr").get(0);
				this._oHSb.setScrollPosition(oScrollDomRef.scrollWidth - oScrollDomRef.clientWidth - $cnt.scrollLeft());
			} else {
				this._oHSb.setNativeScrollPosition($cnt.scrollLeft());
			}
		}
	};

	/**
	 * when navigating within the content area we need to synchronize the column
	 * header with the position (scrollLeft) of the content area.
	 * @private
	 */
	Table.prototype._oncntscroll = function(oEvent) {
		if (!this._bSyncScrollLeft) {
			var $cnt = this.$().find(".sapUiTableCtrlScr");
			this._oHSb.setNativeScrollPosition($cnt.scrollLeft());
		}
	};


	/**
	 * listens to the mousedown events for starting column drag & drop. therefore
	 * we wait 200ms to make sure it is no click on the column to open the menu.
	 * @private
	 */
	Table.prototype.onmousedown = function(oEvent) {

		// only move on left click!
		var bLeftButton = oEvent.button === (sap.ui.Device.browser.internet_explorer && sap.ui.Device.browser.version <= 8 ? 1 : 0);
		if (bLeftButton) {

			var $target = jQuery(oEvent.target);

			var $splitter = this.$("sb");
			if (oEvent.target == $splitter[0]) {

				// Fix for IE text selection while dragging
				jQuery(document.body).bind("selectstart",jQuery.proxy(this._splitterSelectStart,this));

				var offset = $splitter.offset();
				var height = $splitter.height();
				var width = $splitter.width();

				jQuery(document.body).append(
						"<div id=\"" + this.getId() + "-ghost\" class=\"sapUiHSBGhost\" style =\" height:" + height + "px; width:"
						+ width + "px; left:" + offset.left + "px; top:" + offset.top + "px\" ></div>");

				// append overlay over splitter to enable correct functionality of moving the splitter
				$splitter.append(
						"<div id=\"" + this.getId() + "-overlay\" style =\"left: 0px;" +
								" right: 0px; bottom: 0px; top: 0px; position:absolute\" ></div>");

				jQuery(document).bind("mouseup", jQuery.proxy(this._onGhostMouseRelease, this));
				jQuery(document).bind("mousemove", jQuery.proxy(this._onGhostMouseMove, this));
				return;
			}

			var $col = $target.closest(".sapUiTableCol");
			if ($col.length === 1) {

				this._bShowMenu = true;
				this._sDelayedMenuTimer = jQuery.sap.delayedCall(200, this, function() {
					this._bShowMenu = false;
				});

				if (this.getEnableColumnReordering()) {

					var iIndex = parseInt($col.attr("data-sap-ui-colindex"), 10);
					if (iIndex > this._iLastFixedColIndex) {

						var oColumn = this.getColumns()[iIndex];

						this._sDelayedActionTimer = jQuery.sap.delayedCall(200, this, function() {
							this._onColumnMoveStart(oColumn);
						});

					}

				}
			}

			// in case of FireFox and CTRL+CLICK it selects the target TD
			//   => prevent the default behavior only in this case (to still allow text selection)
			var bCtrl = !!(oEvent.metaKey || oEvent.ctrlKey);
			if (!!sap.ui.Device.browser.firefox && bCtrl) {
				oEvent.preventDefault();
			}

		}

	};

	/**
	 * controls the action mode when clicking into the table control
	 * @private
	 */
	Table.prototype.onmouseup = function(oEvent) {
		// clean up the timer
		jQuery.sap.clearDelayedCall(this._sDelayedActionTimer);

		if (this.$().find(".sapUiTableCtrl td :focus").length > 0) {
			// when clicking into a focusable control we enter the action mode!
			this._enterActionMode(this.$().find(".sapUiTableCtrl td :focus"));
		} else {
			// when clicking anywhere else in the table we leave the action mode!
			this._leaveActionMode(oEvent);
		}
	};

	/**
	 * handles the selection when clicking on the table
	 * @private
	 */
	Table.prototype.onclick = function(oEvent) {
		// clean up the timer
		jQuery.sap.clearDelayedCall(this._sDelayedActionTimer);
		// forward the event
		if (!this._findAndfireCellEvent(this.fireCellClick, oEvent)) {
			this._onSelect(oEvent);
		} else {
			oEvent.preventDefault();
		}
	};

	/**
	 * handles the cell contextmenu eventing of the table, open the menus for cell, group header and column header
	 * @private
	 */
	Table.prototype.oncontextmenu = function(oEvent) {
		var $Target = jQuery(oEvent.target);
		var $Header = $Target.closest('.sapUiTableCol');
		if ($Header.length > 0) {
			var oColumn = sap.ui.getCore().byId($Header.attr("data-sap-ui-colid"));
			if (oColumn) {
				oColumn._openMenu($Header[0]);
			}
			oEvent.preventDefault();
		} else {
			if (this._findAndfireCellEvent(this.fireCellContextmenu, oEvent, this._oncellcontextmenu)) {
				oEvent.preventDefault();
			}
		}
	};

	/**
	 * handles the default cell contextmenu
	 * @private
	 */
	Table.prototype._oncellcontextmenu = function(mParams) {

		if (this.getEnableCellFilter()) {

			// create the contextmenu instance the first time it is needed
			if (!this._oContextMenu) {

				jQuery.sap.require("sap.ui.unified.Menu");
				jQuery.sap.require("sap.ui.unified.MenuItem");

				this._oContextMenu = new sap.ui.unified.Menu(this.getId() + "-contextmenu");
				this.addDependent(this._oContextMenu);

			}

			// does the column support filtering?
			var oColumn = this._getVisibleColumns()[mParams.columnIndex];
			var sProperty = oColumn.getFilterProperty();
			if (sProperty && oColumn.getShowFilterMenuEntry()) {

				// destroy all items of the menu and recreate
				this._oContextMenu.destroyItems();
				this._oContextMenu.addItem(new sap.ui.unified.MenuItem({
					text: this._oResBundle.getText("TBL_FILTER"),
					select: [function() {
						var oContext = this.getContextByIndex(mParams.rowIndex);
						var sValue = oContext.getProperty(sProperty);
						this.filter(oColumn, sValue);
					}, this]
				}));

				// open the popup below the cell
				var eDock = sap.ui.core.Popup.Dock;
				this._oContextMenu.open(false, mParams.cellDomRef, eDock.BeginTop, eDock.BeginBottom, mParams.cellDomRef, "none none");
				return true;
			}
		}
	};

	/**
	 * helper method to bind different functions to a click if both a single and a double click can occur on an element
	 * @experimental Experimental
	 * @function
	 * @private
	 */
	Table.prototype._bindSimulatedDoubleclick = function(element, fnClick, fnDoubleclick){
		var eventBound = "click";
		var that = this;
		if (!!sap.ui.Device.support.touch){
			//event needs to be touchend due to timing issues on the ipad
			eventBound = "touchend";
		}
		jQuery(element).on(eventBound, function(oEvent){
			oEvent.preventDefault();
			oEvent.stopPropagation();
			that._clicksRegistered = that._clicksRegistered + 1;
			if (that._clicksRegistered < 2){
				that._singleClickTimer = jQuery.sap.delayedCall(that._doubleclickDelay, that, function(){
					that._clicksRegistered = 0;
					if (fnClick){
						fnClick.call(that, oEvent);
					}
				}, [oEvent]);
			} else {
				jQuery.sap.clearDelayedCall(that._singleClickTimer);
				that._clicksRegistered = 0;
				fnDoubleclick.call(that, oEvent);
			}
		});
	};

	/**
	 * finds the cell on which the click or contextmenu event is executed and
	 * notifies the listener which control has been clicked or the contextmenu
	 * should be openend.
	 * @param {function} fnFire function to fire the event
	 * @param {DOMEvent} oEvent event object
	 * @return {boolean} cancelled or not
	 * @private
	 */
	Table.prototype._findAndfireCellEvent = function(fnFire, oEvent, fnContextMenu) {
		var $target = jQuery(oEvent.target);
		// find out which cell has been clicked
		var $cell = $target.closest("td[role='gridcell']");
		var sId = $cell.attr("id");
		var aMatches = /.*-row(\d*)-col(\d*)/i.exec(sId);
		var bCancel = false;
		if (aMatches) {
			var iRow = aMatches[1];
			var iCol = aMatches[2];
			var oRow = this.getRows()[iRow];
			var oCell = oRow && oRow.getCells()[iCol];
			var iRealRowIndex = oRow && oRow.getIndex();
			var mParams = {
				rowIndex: iRealRowIndex,
				columnIndex: iCol,
				cellControl: oCell
			};
			bCancel = !fnFire.call(this, mParams);
			if (!bCancel && typeof fnContextMenu === "function") {
				mParams.cellDomRef = $cell[0];
				bCancel = fnContextMenu.call(this, mParams);
			}
		}
		return bCancel;
	};

	/**
	 * handles the focus in to reposition the focus or prevent default handling for
	 * column resizing
	 * @private
	 */
	Table.prototype.onfocusin = function(oEvent) {
		var $target = jQuery(oEvent.target);
		// KEYBOARD HANDLING (_bIgnoreFocusIn is set in onsaptabXXX)
		if (!this._bIgnoreFocusIn && ($target.hasClass("sapUiTableCtrlBefore") || $target.hasClass("sapUiTableCtrlAfter"))) {
			// reset the aria description of the table that the table is announced the
			// first time the table grabs the focus
			this.$("ariadesc").text(this._oResBundle.getText("TBL_TABLE"));
			// when entering the before or after helper DOM elements we put the
			// focus on the current focus element of the item navigation and we
			// leave the action mode!
			this._leaveActionMode();
			// set the focus on the last focused dom ref of the item navigation or
			// in case if not set yet (tab previous into item nav) then we set the
			// focus to the root domref
			if (jQuery.contains(this.$().find('.sapUiTableColHdrCnt')[0], oEvent.target)) {
				jQuery(this._oItemNavigation.getFocusedDomRef() || this._oItemNavigation.getRootDomRef()).focus();
			} else {
				if ($target.hasClass("sapUiTableCtrlBefore")) {
					this._oItemNavigation.focusItem(this._oItemNavigation.getFocusedIndex() % this._oItemNavigation.iColumns, oEvent);
				} else {
					this._oItemNavigation.focusItem((this._oItemNavigation.getFocusedIndex() % this._oItemNavigation.iColumns) + (this._oItemNavigation.iColumns * this._iLastSelectedDataRow), oEvent);
				}
			}
			oEvent.preventDefault();
		} else if (jQuery.sap.endsWith(oEvent.target.id, "-rsz")) {
			// prevent that the ItemNavigation grabs the focus!
			// only for the column resizing
			oEvent.preventDefault();
			oEvent.stopPropagation();
		}
	};


	// =============================================================================
	// SELECTION HANDLING
	// =============================================================================

	/**
	 * handles the row selection and the column header menu
	 * @private
	 */
	Table.prototype._onSelect = function(oEvent) {

		// trigger column menu
		var $target = jQuery(oEvent.target);

		// determine modifier keys
		var bShift = oEvent.shiftKey;
		var bCtrl = !!(oEvent.metaKey || oEvent.ctrlKey);

		// column header?
		var $col = $target.closest(".sapUiTableCol");
		if (this._bShowMenu && $col.length === 1) {
			var iIndex = parseInt($col.attr("data-sap-ui-colindex"), 10);
			var oColumn = this.getColumns()[iIndex];
			this._onColumnSelect(oColumn, $col[0]);
			return;
		}

		// row header?
		var $row = $target.closest(".sapUiTableRowHdr");
		if ($row.length === 1) {
			var iIndex = parseInt($row.attr("data-sap-ui-rowindex"), 10);
			this._onRowSelect(this.getFirstVisibleRow() + iIndex, bShift, bCtrl);
			return;
		}

		// table control? (only if the selection behavior is set to row)
		if (/*!this._bActionMode && */ (
		    this.getSelectionBehavior() === sap.ui.table.SelectionBehavior.Row ||
		    this.getSelectionBehavior() === sap.ui.table.SelectionBehavior.RowOnly)) {
			var $row = $target.closest(".sapUiTableCtrl > tbody > tr");
			if ($row.length === 1) {
				var iIndex = parseInt($row.attr("data-sap-ui-rowindex"), 10);
				this._onRowSelect(this.getFirstVisibleRow() + iIndex, bShift, bCtrl);
				return;
			}
		}

		// select all?
		if (jQuery.sap.containsOrEquals(this.getDomRef("selall"), oEvent.target)) {
			this._toggleSelectAll();
			return;
		}

	};


	// =============================================================================
	// ROW EVENT HANDLING
	// =============================================================================

	Table.prototype._isRowSelectable = function(iRowIndex) {
		return true;
	};

	/**
	 * handles the row selection (depending on the mode)
	 * @private
	 */
	Table.prototype._onRowSelect = function(iRowIndex, bShift, bCtrl) {

		// in case of IE and SHIFT we clear the text selection
		if (!!sap.ui.Device.browser.internet_explorer && bShift) {
			this._clearTextSelection();
		}

		// is the table bound?
		var oBinding = this.getBinding("rows");
		if (!oBinding) {
			return;
		}

		//var iRowIndex = Math.min(Math.max(0, iRowIndex), this.getBinding("rows").getLength() - 1);
		if (iRowIndex < 0 || iRowIndex >= (oBinding.getLength() || 0)) {
			return;
		}

		// Make sure that group headers, which represents a tree node in AnalyticalTable, are not selectable.
		if (!this._isRowSelectable(iRowIndex)) {
			return;
		}

		this._iSourceRowIndex = iRowIndex;

		var oSelMode = this.getSelectionMode();
		if (oSelMode !== sap.ui.table.SelectionMode.None) {
			if (oSelMode === sap.ui.table.SelectionMode.Single) {
				if (!this.isIndexSelected(iRowIndex)) {
					this.setSelectedIndex(iRowIndex);
				} else {
					this.clearSelection();
				}
			} else {
				// in case of multi toggle behavior a click on the row selection
				// header adds or removes the selected row and the previous seleciton
				// will not be removed
				if (oSelMode === sap.ui.table.SelectionMode.MultiToggle) {
					bCtrl = true;
				}
				if (bShift) {
					// If no row is selected getSelectedIndex returns -1 - then we simply
					// select the clicked row:
					var iSelectedIndex = this.getSelectedIndex();
					if (iSelectedIndex >= 0) {
						this.addSelectionInterval(iSelectedIndex, iRowIndex);
					} else {
						this.setSelectedIndex(iRowIndex);
					}
				} else {
					if (!this.isIndexSelected(iRowIndex)) {
						if (bCtrl) {
							this.addSelectionInterval(iRowIndex, iRowIndex);
						} else {
							this.setSelectedIndex(iRowIndex);
						}
					} else {
						if (bCtrl) {
							this.removeSelectionInterval(iRowIndex, iRowIndex);
						} else {
							if (this.getSelectedIndices().length === 1) {
								this.clearSelection();
							} else {
								this.setSelectedIndex(iRowIndex);
							}
						}
					}
				}
			}
		}

		this._iSourceRowIndex = undefined;

	};


	// =============================================================================
	// COLUMN EVENT HANDLING
	// =============================================================================

	/**
	 * column select event => opens the column menu
	 * @private
	 */
	Table.prototype._onColumnSelect = function(oColumn, oDomRef) {
		// forward the event
		var bExecuteDefault = this.fireColumnSelect({
			column: oColumn
		});

		// if the default behavior should be prevented we suppress to open
		// the column menu!
		if (bExecuteDefault) {
			oColumn._openMenu(oDomRef);
		}

	};

	/**
	 * start column moveing
	 * @private
	 */
	Table.prototype._onColumnMoveStart = function(oColumn) {
		this.$().addClass("sapUiTableDragDrop");
		
		this._disableTextSelection();

		var $col = oColumn.$();
		var iColIndex = parseInt($col.attr("data-sap-ui-colindex"), 10);

		if (iColIndex < this.getFixedColumnCount()) {
			return;
		}

		this._$colGhost = $col.clone().removeAttr("id");

		$col.css({
			"opacity": ".25"
		});

		this._$colGhost.addClass("sapUiTableColGhost").css({
			"left": -10000,
			"top": -10000,
			//Position is set to relative for columns later, if the moving is started a second time the position: relative overwrites
			//the absolut position set by the sapUiTableColGhost class, so we overrite the style attribute for position here to make
			//sure that the position is absolute
			"position": "absolute",
			"z-index": this.$().zIndex() + 10
		});

		// TODO: only for the visible columns!?
		this.$().find(".sapUiTableCol").each(function(iIndex, oElement) {

			var $col = jQuery(this);
			$col.css({position: "relative"});

			$col.data("pos", {
				left: $col.position().left,
				center: $col.position().left + $col.outerWidth() / 2,
				right:  $col.position().left + $col.outerWidth()
			});

		});

		this._$colGhost.appendTo(document.body);

		jQuery(document.body).
			mousemove(jQuery.proxy(this._onColumnMove, this)).
			mouseup(jQuery.proxy(this._onColumnMoved, this));


	};

	/**
	 * move the column position the ghost
	 * @private
	 */
	Table.prototype._onColumnMove = function(oEvent) {

		var $this = this.$();
		var bRtl = this._bRtlMode;
		var iRelX = oEvent.pageX - $this.offset().left;
		var iDnDColIndex = parseInt(this._$colGhost.attr("data-sap-ui-colindex"), 10);
		var $DnDCol = this.getColumns()[iDnDColIndex].$();

		// find out the new col position
		var iOldColPos = this._iNewColPos;
		this._iNewColPos = iDnDColIndex;
		var that = this;
		$this.find(".sapUiTableCol").each(function(iIndex, oCol) {

			var $col = jQuery(oCol);
			var iColIndex = parseInt($col.attr("data-sap-ui-colindex"), 10);
			var vHeaderSpans = sap.ui.getCore().byId($col.attr("data-sap-ui-colid")).getHeaderSpan();
			var iSpan;

			if (vHeaderSpans) {
				if (jQuery.isArray(vHeaderSpans)) {
					iSpan = vHeaderSpans[0];
				} else {
					iSpan = vHeaderSpans;
				}
			} else {
				iSpan = 1;
			}

			if ($col.get(0) !== $DnDCol.get(0)) {

				var oPos = $col.data("pos");

				var bBefore = iRelX >= oPos.left && iRelX <= oPos.center;
				var bAfter = iRelX >= oPos.center && iRelX <= oPos.right;

				if (!bRtl) {
					if (bBefore) {
						that._iNewColPos = iColIndex;
					} else if (bAfter) {
						that._iNewColPos = iColIndex + iSpan;
					} else {
						that._iNewColPos = that._iNewColPos;
					}
				} else {
					if (bAfter) {
						that._iNewColPos = iColIndex;
					} else if (bBefore) {
						that._iNewColPos = iColIndex + iSpan;
					} else {
						that._iNewColPos = that._iNewColPos;
					}
				}

				if ((bBefore || bAfter) && iColIndex > iDnDColIndex) {
					that._iNewColPos--;
				}

			}

		});

		// prevent the reordering of the fixed columns
		if (this._iNewColPos <= this._iLastFixedColIndex) {
			this._iNewColPos = iOldColPos;
		}
		if (this._iNewColPos < this.getFixedColumnCount()) {
			this._iNewColPos = iOldColPos;
		}

		// animate the column move
		this._animateColumnMove(iDnDColIndex, iOldColPos, this._iNewColPos);

		// update the ghost position
		this._$colGhost.css({
			"left": oEvent.pageX + 5,
			"top": oEvent.pageY + 5
		});

	};

	/**
	 * animates the column movement
	 */
	Table.prototype._animateColumnMove = function(iColIndex, iOldPos, iNewPos) {

		var bRtl = this._bRtlMode;
		var $DnDCol = this.getColumns()[iColIndex].$();

		// position has been changed => reorder
		if (iOldPos !== iNewPos) {

			for (var i = Math.min(iOldPos, iNewPos), l = Math.max(iOldPos, iNewPos); i <= l; i++) {
				var oCol = this.getColumns()[i];
				if (i !== iColIndex && oCol.getVisible()) {
					oCol.$().stop(true, true).animate({left: "0px"});
				}
			}

			var iOffsetLeft = 0;
			if (iNewPos < iColIndex) {
				for (var i = iNewPos; i < iColIndex; i++) {
					var oCol = this.getColumns()[i];
					if (oCol.getVisible()) {
						var $col = oCol.$();
						iOffsetLeft -= $col.outerWidth();
						$col.stop(true, true).animate({left: $DnDCol.outerWidth() * (bRtl ? -1 : 1) + "px"});
					}
				}
			} else {
				for (var i = iColIndex + 1, l = iNewPos + 1; i < l; i++) {
					var oCol = this.getColumns()[i];
					if (oCol.getVisible()) {
						var $col = oCol.$();
						iOffsetLeft += $col.outerWidth();
						$col.stop(true, true).animate({left: $DnDCol.outerWidth() * (bRtl ? 1 : -1) + "px"});
					}
				}
			}
			$DnDCol.stop(true, true).animate({left: iOffsetLeft * (bRtl ? -1 : 1) + "px"});

		}

	};

	/**
	 * columns is moved => update!
	 * @private
	 */
	Table.prototype._onColumnMoved = function(oEvent) {
		this.$().removeClass("sapUiTableDragDrop");

		var iDnDColIndex = parseInt(this._$colGhost.attr("data-sap-ui-colindex"), 10);
		var oDnDCol = this.getColumns()[iDnDColIndex];

		jQuery(document.body).
			unbind("mousemove", this._onColumnMove).
			unbind("mouseup", this._onColumnMoved);

		this._$colGhost.remove();
		this._$colGhost = undefined;

		this._enableTextSelection();

		// forward the event
		var bExecuteDefault = this.fireColumnMove({
			column: oDnDCol,
			newPos: this._iNewColPos
		});

		var bMoveRight = iDnDColIndex < this._iNewColPos;

		if (bExecuteDefault && this._iNewColPos !== undefined && this._iNewColPos !== iDnDColIndex) {
			this.removeColumn(oDnDCol);
			this.insertColumn(oDnDCol, this._iNewColPos);
			var vHeaderSpan = oDnDCol.getHeaderSpan(),
				iSpan;

			if (vHeaderSpan) {
				if (jQuery.isArray(vHeaderSpan)) {
					iSpan = vHeaderSpan[0];
				} else {
					iSpan = vHeaderSpan;
				}
			} else {
				iSpan = 1;
			}

			if (iSpan > 1) {
				if (!bMoveRight) {
					this._iNewColPos++;
				}
				for (var i = 1; i < iSpan; i++) {
					var oDependentCol = this.getColumns()[bMoveRight ? iDnDColIndex : iDnDColIndex + i];
					this.removeColumn(oDependentCol);
					this.insertColumn(oDependentCol, this._iNewColPos);
					this.fireColumnMove({
						column: oDependentCol,
						newPos: this._iNewColPos
					});
					if (!bMoveRight) {
						this._iNewColPos++;
					}
				}
			}
			this._oColHdrItemNav.setFocusedIndex(this._iNewColPos);
		} else {
			this._animateColumnMove(iDnDColIndex, this._iNewColPos, iDnDColIndex);
			oDnDCol.$().css({
				"backgroundColor": "",
				"backgroundImage": "",
				"opacity": ""
			});
		}

		// Re-apply focus
		setTimeout(function() {
			var iOldFocusedIndex = this._oItemNavigation.getFocusedIndex();
			this._oItemNavigation.focusItem(0, oEvent);
			this._oItemNavigation.focusItem(iOldFocusedIndex, oEvent);
		}.bind(this), 0);

		delete this._iNewColPos;
	};

	/**
	 * starts the automatic column resize after doubleclick
	 * @experimental Experimental, only works with a limited control set
	 * @private
	 */
	Table.prototype._onAutomaticColumnResize = function(oEvent) {
		var iColIndex, oCol, headerSpan, maxHeaderSpan, iColsToResize = 1, bResizeMultiple = false;
		jQuery.sap.log.debug("doubleclick fired");
		this._disableTextSelection();
		this._$colResize = jQuery(oEvent.target);
		this._$colResize.addClass("sapUiTableColRszActive");
		//get the id of the column which needs to be resized. it might be different from the resizers column id if a headerspan is used.
		var iParentColIndex = parseInt(this._$colResize.prevAll(".sapUiTableCol").first().attr("data-sap-ui-colindex"), 10);
		iColIndex = parseInt(this._$colResize.attr("data-sap-ui-colindex"), 10);
		if (iParentColIndex != iColIndex) {
			bResizeMultiple = true;
		}
		//try to find out if we are only resizing one column or all columns under a header span
		if (bResizeMultiple) {
			oCol = this.getColumns()[iParentColIndex];
			headerSpan = oCol.getHeaderSpan();
			if (headerSpan instanceof Array){
				maxHeaderSpan = Math.max.apply(Math, headerSpan);
			} else if (!!headerSpan) {
				maxHeaderSpan = headerSpan;
			}
			if (iColIndex + headerSpan - 1 != iParentColIndex){
				iColsToResize = maxHeaderSpan;
				iColIndex = iParentColIndex + maxHeaderSpan;
			}
		}
		if (iColsToResize > 1){
		//	for(var i = 0; i < iColsToResize; i--{
			while (iColIndex > iParentColIndex) {
				iColIndex--;
				this.autoResizeColumn(iColIndex);
			}
		} else {
			this.autoResizeColumn(iColIndex);
		}
		oEvent.preventDefault();
		oEvent.stopPropagation();
	};


	/**
	 * start the column resize
	 * @private
	 */
	Table.prototype._onColumnResizeStart = function(oEvent) {

		// only resize on left click!
		var bLeftButton = oEvent.button === (sap.ui.Device.browser.internet_explorer && sap.ui.Device.browser.version <= 8 ? 1 : 0);
		if (bLeftButton) {

			this._iColumnResizeStart = oEvent.pageX;

			this._disableTextSelection();
			this._$colResize = jQuery(oEvent.target);

			jQuery(document.body).
				mousemove(jQuery.proxy(this._onColumnResize, this)).
				mouseup(jQuery.proxy(this._onColumnResized, this));

		}

	};

	/**
	 * resize the column
	 * @private
	 */
	Table.prototype._onColumnResize = function(oEvent) {

		if (this._iColumnResizeStart && oEvent.pageX < this._iColumnResizeStart + 3 && oEvent.pageX > this._iColumnResizeStart - 3) {
			return;
		}

		this._$colResize.addClass("sapUiTableColRszActive");
		this._iColumnResizeStart = null;

		var $this = this.$();

		var bRtl = this._bRtlMode;
		var iColIndex = parseInt(this._$colResize.attr("data-sap-ui-colindex"), 10);
		var oColumn = this.getColumns()[iColIndex];
		var $col = $this.find(".sapUiTableCtrlFirstCol > th[data-sap-ui-headcolindex='" + iColIndex + "']");

		// get the left position of the column to calculate the new width
		// relative to the parent container (sapUiTableCnt)!
		var iColLeft = $col.position().left;

		var iWidth;
		if (!bRtl) {
			// refine width calculation in case of fixed columns
			if (this.getFixedColumnCount() > 0 && iColIndex >= this.getFixedColumnCount()) {
				var iFixedColumnsWidth = $this.find(".sapUiTableColHdrFixed").width();
				iColLeft = iColLeft + iFixedColumnsWidth;
				
				// Consider scroll offset of non fixed area.
				iColLeft = iColLeft - $this.find(".sapUiTableCtrlScr").scrollLeft();
			}

			// find the total left offset from the document (required for pageX info)
			var iOffsetLeft = $this.find(".sapUiTableCtrlFirstCol > th:first").offset().left;

			// relative left position within the table scroll container
			var iRelLeft = oEvent.pageX - iOffsetLeft;

			// calculate the new width
			iWidth = iRelLeft - iColLeft;
		} else {
			var $ScrollArea;
			if (this.getFixedColumnCount() > 0 && iColIndex < this.getFixedColumnCount()) {
				$ScrollArea = $this.find('.sapUiTableCtrlScrFixed');
			} else {
				$ScrollArea = $this.find('.sapUiTableCtrlScr');
			}
			var iScrollAreaScrollLeft = $ScrollArea.scrollLeft();

			if (sap.ui.Device.browser.internet_explorer) {
				// Assume ScrollWidth=100px, Scroll to the very left in RTL mode
				// IE has reverse scroll position (Chrome = 0, IE = 100, FF = -100)
				iScrollAreaScrollLeft = $ScrollArea[0].scrollWidth - iScrollAreaScrollLeft - $ScrollArea[0].clientWidth;
			} else if (sap.ui.Device.browser.firefox) {
				// FF has negative reverse scroll position (Chrome = 0, IE = 100, FF = -100)
				iScrollAreaScrollLeft = iScrollAreaScrollLeft + $ScrollArea[0].scrollWidth - $ScrollArea[0].clientWidth;
			}

			//get the difference between where mouse was released and left side of the table
			var iDiff = iColLeft - iScrollAreaScrollLeft - oEvent.pageX + $ScrollArea.offset().left;
			iWidth = $col.outerWidth() + iDiff;
		}

		iWidth = Math.max(iWidth, /* oColumn.getMinWidth() || */ this._iColMinWidth);
		//iWidth = Math.min(iWidth, oColumn.getMaxWidth() || iWidth);

		// calculate and set the position of the resize handle
		var iRszOffsetLeft = $this.find(".sapUiTableCnt").offset().left;
		var iRszLeft = oEvent.pageX - iRszOffsetLeft;
		iRszLeft -= this._$colResize.width() / 2;
		this._$colResize.css("left", iRszLeft);

		// store the width of the column to apply later
		oColumn._iNewWidth = iWidth;
	};

	/**
	 * column is resized => update!
	 * @private
	 */
	Table.prototype._onColumnResized = function(oEvent, iIndex) {
		var iColIndex;
		// ignore when no resize column is set
		if (!this._$colResize && (iIndex === null || iIndex === undefined)) {
			return;
		}
		// get the new width of the column
		if (iIndex === null || iIndex === undefined) {
			iColIndex = parseInt(this._$colResize.attr("data-sap-ui-colindex"), 10);
		} else {
			iColIndex = iIndex;
		}
		var oColumn = this.getColumns()[iColIndex];
		// if the resize has started and we have a new width for the column
		// we apply it to the column object
		var bResized = false;
		if (!this._iColumnResizeStart && oColumn._iNewWidth) {
			var sWidth;
			var iAvailableSpace = this.$().find(".sapUiTableCtrl").width();
			if (!this._checkPercentageColumnWidth()) {
				sWidth = oColumn._iNewWidth + "px";
			} else {
				var iColumnWidth = Math.round(100 / iAvailableSpace * oColumn._iNewWidth);
				sWidth = iColumnWidth + "%";
			}

			this._updateColumnWidth(oColumn, sWidth);
			this._resizeDependentColumns(oColumn, sWidth);

			delete oColumn._iNewWidth;

			bResized = true;
		}

		// unbind the event handlers
		jQuery(document.body).
			unbind("mousemove", this._onColumnResize).
			unbind("mouseup", this._onColumnResized);

		// focus the column
		oColumn.focus();

		// hide the text selection
		if (this._$colResize) {
			this._$colResize.removeClass("sapUiTableColRszActive");
			this._$colResize = undefined;
		}
		this._enableTextSelection();

		// rerender / ignore if nothing changed!
		if (bResized) {
			this.invalidate();
		}

	};

	Table.prototype._resizeDependentColumns = function(oColumn, sWidth) {

		//Adjust columns only if the columns have percentage values
		if (this._checkPercentageColumnWidth()) {
			var aVisibleColumns = this._getVisibleColumns();
			//var oLastVisibleColumn = aVisibleColumns[aVisibleColumns.length - 1]; // NOT USED!
			//var bAllFollowingColumnsFlexible = true; // NOT USED!

			var iColumnIndex;
			jQuery.each(aVisibleColumns, function(iIndex, oCurrentColumn) {
				if (oColumn === oCurrentColumn) {
					iColumnIndex = iIndex;
				//} else if (iColumnIndex !== undefined && !oCurrentColumn.getFlexible()) { // NOT REQUIRED?
					//bAllFollowingColumnsFlexible = false;
				}
			});

			var iOthersWidth = 0;
			var iLastIndex = aVisibleColumns.length - 1;
			var iTotalPercentage;
			if (iColumnIndex === undefined) {
				iTotalPercentage = 0;
			} else {
				iTotalPercentage = parseInt(sWidth,10);
			}
			var iPercentages = 0;
			var aOtherColumns = [];
			var that = this;

			jQuery.each(aVisibleColumns, function(iIndex, oCurrentColumn) {
				var iColumnPercentage = that._getColumnPercentageWidth(oCurrentColumn);
				if ((((iColumnIndex === iLastIndex && iIndex < iColumnIndex) || ((iColumnIndex !== iLastIndex) && iIndex > iColumnIndex)) && oCurrentColumn.getFlexible()) || iColumnIndex === undefined) {
					iOthersWidth += oCurrentColumn.$().outerWidth();
					iPercentages += iColumnPercentage;
					aOtherColumns.push(oCurrentColumn);
				} else if (iIndex !== iColumnIndex) {
					iTotalPercentage += iColumnPercentage;
				}
			});

			var iCalcPercentage = iTotalPercentage;
			jQuery.each(aOtherColumns, function(iIndex, oCurrentColumn){
				var iColumnPercentage = that._getColumnPercentageWidth(oCurrentColumn);
				var iNewWidth = Math.round((100 - iCalcPercentage) / iPercentages * iColumnPercentage);
				if (iIndex === aOtherColumns.length - 1) {
					iNewWidth = 100 - iTotalPercentage;
				} else {
					iTotalPercentage += iNewWidth;
				}
				that._updateColumnWidth(oCurrentColumn, iNewWidth + "%");
			});
		} else if (!this._hasOnlyFixColumnWidths()) {

			var aVisibleColumns = this._getVisibleColumns(),
				iAvailableSpace = this.$().find(".sapUiTableCtrl").width(),
				iColumnIndex,
				iRightColumns = 0,
				iLeftWidth = 0,
				iRightWidth = 0,
				iNonFixedColumns = 0;

			jQuery.each(aVisibleColumns, function(iIndex, oCurrentColumn) {
				//Check columns if they are fixed = they have a pixel width
				if (!jQuery.sap.endsWith(oCurrentColumn.getWidth(), "px")) {
					iNonFixedColumns++;
					return false;
				}
				//if iColumnIndex is defined we already found our column and all other columns are right of that one
				if (iColumnIndex != undefined) {
					iRightWidth += parseInt(oCurrentColumn.getWidth(),10);
					iRightColumns++;
				} else if (oColumn !== oCurrentColumn) {
					iLeftWidth += parseInt(oCurrentColumn.getWidth(),10);
				}
				if (oColumn === oCurrentColumn) {
					iColumnIndex = iIndex;
					//Use new width of column
					iLeftWidth += parseInt(sWidth,10);
				}
			});
			//If there are non fixed columns we don't do this
			if (iNonFixedColumns > 0 || (iLeftWidth + iRightWidth > iAvailableSpace)) {
				return;
			}
			//Available space is all space right of the modified columns
			iAvailableSpace -= iLeftWidth;
			for (var i = iColumnIndex + 1; i < aVisibleColumns.length; i++) {
				//Calculate new column width based on previous percentage width
				var oColumn = aVisibleColumns[i],
					iColWidth = parseInt(oColumn.getWidth(),10),
					iPercent = iColWidth / iRightWidth * 100,
					iNewWidth = iAvailableSpace / 100 * iPercent;
				this._updateColumnWidth(oColumn, Math.round(iNewWidth) + 'px');
			}
		}
	};

	Table.prototype._getColumnPercentageWidth = function(oColumn) {
		var sColumnWidth = oColumn.getWidth();
		var iColumnPercentage = parseInt(oColumn.getWidth(),10);
		var iTotalWidth = this.$().find(".sapUiTableCtrl").width();
		if (jQuery.sap.endsWith(sColumnWidth, "px")) {
			iColumnPercentage = Math.round(100 / iTotalWidth * iColumnPercentage);
		} else if (!jQuery.sap.endsWith(sColumnWidth, "%")) {
			iColumnPercentage = Math.round(100 / iTotalWidth * oColumn.$().width());
		}
		return iColumnPercentage;
	};

	Table.prototype._updateColumnWidth = function(oColumn, sWidth) {
		// forward the event
		var bExecuteDefault = this.fireColumnResize({
			column: oColumn,
			width: sWidth
		});

		// set the width of the column (when not cancelled)
		if (bExecuteDefault) {
			oColumn.setProperty("width", sWidth, true);
			this.$().find('th[aria-owns="' + oColumn.getId() + '"]').css('width', sWidth);
		}
	};

	/**
	 * Check if at least one column has a percentage value
	 */
	Table.prototype._checkPercentageColumnWidth = function() {
		var aColumns = this.getColumns();
		var bHasPercentageColumns = false;
		jQuery.each(aColumns, function(iIndex, oColumn) {
			if (jQuery.sap.endsWith(oColumn.getWidth(), "%")) {
				bHasPercentageColumns = true;
				return false;
			}
		});
		return bHasPercentageColumns;
	};

	/**
	 * Check if table has only non flexible columns with fixed widths and only then
	 * the table adds a dummy column to fill the rest of the width instead of resizing
	 * the columns to fit the complete table width
	 */
	Table.prototype._hasOnlyFixColumnWidths = function() {
		var bOnlyFixColumnWidths = true;
		jQuery.each(this.getColumns(), function(iIndex, oColumn) {
			var sWidth = oColumn.getWidth();
			if (oColumn.getFlexible() || !sWidth || sWidth.substr(-2) !== "px") {
				bOnlyFixColumnWidths = false;
				return false;
			}
		});
		return bOnlyFixColumnWidths;
	};


	// =============================================================================
	// SORTING & FILTERING
	// =============================================================================


	/**
	 * sorts the given column ascending or descending
	 *
	 * @param {sap.ui.table.Column} oColumn
	 *         column to be sorted
	 * @param {sap.ui.table.SortOrder} oSortOrder
	 *         sort order of the column (if undefined the default will be ascending)
	 * @type sap.ui.table.Table
	 * @public
	 * @ui5-metamodel This method also will be described in the UI5 (legacy) designtime metamodel
	 */
	Table.prototype.sort = function(oColumn, oSortOrder, bAdd) {
		if (jQuery.inArray(oColumn, this.getColumns()) >= 0) {
			oColumn.sort(oSortOrder === sap.ui.table.SortOrder.Descending, bAdd);
		}
	};


	/**
	 * filter the given column by the given value
	 *
	 * @param {sap.ui.table.Column} oColumn
	 *         column to be filtered
	 * @param {string} sValue
	 *         filter value as string (will be converted)
	 * @type sap.ui.table.Table
	 * @public
	 * @ui5-metamodel This method also will be described in the UI5 (legacy) designtime metamodel
	 */
	Table.prototype.filter = function(oColumn, sValue) {
		if (jQuery.inArray(oColumn, this.getColumns()) >= 0) {
			oColumn.filter(sValue);
		}
	};


	// =============================================================================
	// SELECTION HANDLING
	// =============================================================================

	/**
	 * updates the visual selection in the HTML markup
	 */
	Table.prototype._updateSelection = function() {
		if (this.getSelectionMode() === sap.ui.table.SelectionMode.None) {
			return;
		}
		var $this = this.$();
		var iFirstRow = this.getFirstVisibleRow();
		var that = this;
		var oResBundle = this._oResBundle;
		var bMultiSelection = this._oSelection.getSelectedIndices().length > 1;
		// Only show "click to select"-tooltip on cell if it actually can be selected that way
		var bSelectOnCell = this.getSelectionBehavior() !== sap.ui.table.SelectionBehavior.RowSelector;
		var sRowSelect           = oResBundle.getText("TBL_ROW_SELECT");
		var sRowSelectKey        = oResBundle.getText("TBL_ROW_SELECT_KEY");
		var sRowDeSelect         = oResBundle.getText("TBL_ROW_DESELECT");
		var sRowDeSelectKey      = oResBundle.getText("TBL_ROW_DESELECT_KEY");
		var sRowSelectMulti      = oResBundle.getText("TBL_ROW_SELECT_MULTI");
		var sRowSelectMultiKey   = oResBundle.getText("TBL_ROW_SELECT_MULTI_KEY");
		var sRowDeSelectMulti    = oResBundle.getText("TBL_ROW_DESELECT_MULTI");
		var sRowDeSelectMultiKey = oResBundle.getText("TBL_ROW_DESELECT_MULTI_KEY");


		$this.find(".sapUiTableRowHdr").each(function(iIndex, oElement) {
			var $jqTR1 = jQuery($this.find(".sapUiTableCtrlFixed > tbody > tr").get(iIndex));
			var $jqTR2 = jQuery($this.find(".sapUiTableCtrlScroll > tbody > tr").get(iIndex));
			var $jqTR = $jqTR1.add($jqTR2);
			var $jqDIV = jQuery(this);
			var $jqRow = $jqDIV.add($jqTR);
			if (that.isIndexSelected(iFirstRow + iIndex)) {
				if (!jQuery(this).hasClass("sapUiTableRowSel")) {
					jQuery(this).addClass("sapUiTableRowSel");
					$jqTR.addClass("sapUiTableRowSel");
					$jqRow.attr("aria-selected", "true");
					$jqTR.children("td").attr("aria-selected", "true");
				}
				if (bMultiSelection) {
					$jqTR.find(".sapUiTableAriaRowSel").text(sRowDeSelectMultiKey);
					if (bSelectOnCell) {
						$jqRow.attr("title", sRowDeSelectMulti).
							attr("aria-label", sRowDeSelectMultiKey);
						$jqTR.children("td").attr('aria-describedby', that.getId() + "-toggleedit " + that.getId() + "-deselectrowmulti");
					}
				} else {
					$jqTR.find(".sapUiTableAriaRowSel").text(sRowDeSelectKey);
					if (bSelectOnCell) {
						$jqRow.attr("title", sRowDeSelect).
							attr("aria-label", sRowDeSelectKey);
						$jqTR.children("td").attr('aria-describedby', that.getId() + "-toggleedit " + that.getId() + "-deselectrow");
					}
				}
			} else {
				if (jQuery(this).hasClass("sapUiTableRowSel")) {
					jQuery(this).removeClass("sapUiTableRowSel");
					$jqTR.removeClass("sapUiTableRowSel");
					if (that.getSelectionMode()  === sap.ui.table.SelectionMode.Multi ||
					    that.getSelectionMode()  === sap.ui.table.SelectionMode.MultiToggle) {
						$jqRow.attr("aria-selected", "false");
						$jqTR.children("td").attr("aria-selected", "false");
					} else {
						$jqRow.removeAttr("aria-selected");
						$jqTR.children("td").removeAttr("aria-selected");
					}
				}
				if ((that.getSelectionMode() === sap.ui.table.SelectionMode.Multi ||
				    that.getSelectionMode()  === sap.ui.table.SelectionMode.MultiToggle) && that._oSelection.getSelectedIndices().length > 0) {
					$jqTR.find(".sapUiTableAriaRowSel").text(sRowSelectMulti);
					if (bSelectOnCell) {
						$jqRow.attr("title", sRowSelectMulti).
							attr("aria-label", sRowSelectMultiKey);
						$jqTR.children("td").attr('aria-describedby', that.getId() + "-toggleedit " + that.getId() + "-selectrowmulti");
					}
				} else {
					$jqTR.find(".sapUiTableAriaRowSel").text(sRowSelectKey);
					if (bSelectOnCell) {
						$jqRow.attr("title", sRowSelect).
							attr("aria-label", sRowSelectKey);
						$jqTR.children("td").attr('aria-describedby', that.getId() + "-toggleedit " + that.getId() + "-selectrow");
					}
				}
			}
		});
		// update internal property to reflect the correct index
		this.setProperty("selectedIndex", this.getSelectedIndex(), true);
	};


	/**
	 * notifies the selection listeners about the changed rows
	 */
	Table.prototype._onSelectionChanged = function(oEvent) {
		var aRowIndices = oEvent.getParameter("rowIndices");
		var iRowIndex = this._iSourceRowIndex !== undefined ? this._iSourceRowIndex : this.getSelectedIndex();
		this._updateSelection();
		var oSelMode = this.getSelectionMode();
		if (oSelMode === "Multi" || oSelMode === "MultiToggle") {
			this.$("selall").attr('title',this._oResBundle.getText("TBL_SELECT_ALL")).addClass("sapUiTableSelAll");
		}
		this.fireRowSelectionChange({
			rowIndex: iRowIndex,
			rowContext: this.getContextByIndex(iRowIndex),
			rowIndices: aRowIndices
		});
	};


	/*
	 * @see JSDoc generated by SAPUI5 control API generator
	 */

	/**
	 * Returns the context of a row by its index.
	 *
	 * @param {int} iIndex
	 *         Index of the row to return the context from.
	 * @type object
	 * @public
	 * @ui5-metamodel This method also will be described in the UI5 (legacy) designtime metamodel
	 */
	Table.prototype.getContextByIndex = function(iIndex) {
		// TODO: ODataListBinding needs to make sure to prevent loading multiple times
		// index must not be smaller than 0! otherwise the ODataModel fails
		var oBinding = this.getBinding("rows");
		return iIndex >= 0 && oBinding ? oBinding.getContexts(iIndex, 1)[0] : null;
	};

	/*
	 * @see JSDoc generated by SAPUI5 control API generator
	 */
	Table.prototype.getSelectedIndex = function() {
		return this._oSelection.getLeadSelectedIndex();
	};

	/*
	 * @see JSDoc generated by SAPUI5 control API generator
	 */
	Table.prototype.setSelectedIndex = function(iIndex) {
		if (iIndex === -1) {
			//If Index eq -1 no item is selected, therefore clear selection is called
			//SelectionModel doesn't know that -1 means no selection
			this._oSelection.clearSelection();
		} else {
			this._oSelection.setSelectionInterval(iIndex, iIndex);
		}
		return this;
	};

	/*
	 * @see JSDoc generated by SAPUI5 control API generator
	 */

	/**
	 * Removes complete selection.
	 *
	 * @type sap.ui.table.Table
	 * @public
	 * @ui5-metamodel This method also will be described in the UI5 (legacy) designtime metamodel
	 */
	Table.prototype.clearSelection = function() {
		this._oSelection.clearSelection();
		return this;
	};

	/*
	 * @see JSDoc generated by SAPUI5 control API generator
	 */

	/**
	 * Add all rows to the selection.
	 *
	 * @type sap.ui.table.Table
	 * @public
	 * @ui5-metamodel This method also will be described in the UI5 (legacy) designtime metamodel
	 */
	Table.prototype.selectAll = function() {
		var oSelMode = this.getSelectionMode();
		if (!this.getEnableSelectAll() || (oSelMode != "Multi" && oSelMode != "MultiToggle")) {
			return this;
		}
		var oBinding = this.getBinding("rows");
		if (oBinding) {
			this._oSelection.setSelectionInterval(0, (oBinding.getLength() || 0) - 1);
			this.$("selall").attr('title',this._oResBundle.getText("TBL_DESELECT_ALL")).removeClass("sapUiTableSelAll");
		}
		return this;
	};

	/*
	 * @see JSDoc generated by SAPUI5 control API generator
	 */

	/**
	 * Zero-based indices of selected items, wrapped in an array. An empty array means "no selection".
	 *
	 * @type int[]
	 * @public
	 * @ui5-metamodel This method also will be described in the UI5 (legacy) designtime metamodel
	 */
	Table.prototype.getSelectedIndices = function() {
		return this._oSelection.getSelectedIndices();
	};

	/*
	 * @see JSDoc generated by SAPUI5 control API generator
	 */

	/**
	 * Adds the given selection interval to the selection. In case of single selection the "indexTo" value will be used for as selected index.
	 *
	 * @param {int} iIndexFrom
	 *         Index from which .
	 * @param {int} iIndexTo
	 *         Indices of the items that shall additionally be selected.
	 * @type sap.ui.table.Table
	 * @public
	 * @ui5-metamodel This method also will be described in the UI5 (legacy) designtime metamodel
	 */
	Table.prototype.addSelectionInterval = function(iIndexFrom, iIndexTo) {
		this._oSelection.addSelectionInterval(iIndexFrom, iIndexTo);
		return this;
	};

	/*
	 * @see JSDoc generated by SAPUI5 control API generator
	 */

	/**
	 * Sets the given selection interval as selection. In case of single selection the "indexTo" value will be used for as selected index.
	 *
	 * @param {int} iIndexFrom
	 *         Index from which .
	 * @param {int} iIndexTo
	 *         Indices of the items that shall additionally be selected.
	 * @type sap.ui.table.Table
	 * @public
	 * @ui5-metamodel This method also will be described in the UI5 (legacy) designtime metamodel
	 */
	Table.prototype.setSelectionInterval = function(iIndexFrom, iIndexTo) {
		this._oSelection.setSelectionInterval(iIndexFrom, iIndexTo);
		return this;
	};

	/*
	 * @see JSDoc generated by SAPUI5 control API generator
	 */

	/**
	 * Removes the given selection interval from the selection. In case of single selection this call removeSelectedIndex with the "indexTo" value.
	 *
	 * @param {int} iIndexFrom
	 *         Index from which .
	 * @param {int} iIndexTo
	 *         Indices of the items that shall additionally be selected.
	 * @type sap.ui.table.Table
	 * @public
	 * @ui5-metamodel This method also will be described in the UI5 (legacy) designtime metamodel
	 */
	Table.prototype.removeSelectionInterval = function(iIndexFrom, iIndexTo) {
		this._oSelection.removeSelectionInterval(iIndexFrom, iIndexTo);
		return this;
	};

	/*
	 * @see JSDoc generated by SAPUI5 control API generator
	 */

	/**
	 * Returns whether the given index is selected.
	 *
	 * @param {int} iIndex
	 *         Index which is checked for selection state.
	 * @type boolean
	 * @public
	 * @ui5-metamodel This method also will be described in the UI5 (legacy) designtime metamodel
	 */
	Table.prototype.isIndexSelected = function(iIndex) {
		return this._oSelection.isSelectedIndex(iIndex);
	};


	// =============================================================================
	// KEYBOARD HANDLING HELPERS
	// =============================================================================

	/**
	 * scrolls down a single row
	 * @private
	 */
	Table.prototype._scrollNext = function() {
		// we are at the end => scroll one down if possible
		if (this.getFirstVisibleRow() < this._getRowCount() - this.getVisibleRowCount()) {
			this.setFirstVisibleRow(Math.min(this.getFirstVisibleRow() + 1, this._getRowCount() - this.getVisibleRowCount()));
		}
	};

	/**
	 * scrolls up a single row
	 * @private
	 */
	Table.prototype._scrollPrevious = function() {
		// we are at the beginning => scroll one up if possible
		if (this.getFirstVisibleRow() > 0) {
			this.setFirstVisibleRow(Math.max(this.getFirstVisibleRow() - 1, 0));
		}
	};

	/**
	 * scrolls down a up page
	 * @private
	 */
	Table.prototype._scrollPageUp = function() {
		this.setFirstVisibleRow(Math.max(this.getFirstVisibleRow() - this.getVisibleRowCount(), 0));
	};

	/**
	 * scrolls down a complete page
	 * @private
	 */
	Table.prototype._scrollPageDown = function() {
		this.setFirstVisibleRow(Math.min(this.getFirstVisibleRow() + this.getVisibleRowCount(), this._getRowCount() - this.getVisibleRowCount()));
	};

	/**
	 * checks if the current target domref is in the first row of the table
	 * @private
	 */
	Table.prototype._isTopRow = function(oEvent) {
		var $target = jQuery(oEvent.target);
		var iRowIndex = parseInt($target.add($target.parent()).filter("[data-sap-ui-rowindex]").attr("data-sap-ui-rowindex"), 10);
		var iFixedRows = this.getFixedRowCount();
		if (iFixedRows > 0 && iRowIndex >= iFixedRows) {
			return iRowIndex === iFixedRows;
		}
		return iRowIndex === 0;
	};

	/**
	 * checks if the current target domref is in the last row of the table
	 * @private
	 */
	Table.prototype._isBottomRow = function(oEvent) {
		var $target = jQuery(oEvent.target);
		var iRowIndex = parseInt($target.add($target.parent()).filter("[data-sap-ui-rowindex]").attr("data-sap-ui-rowindex"), 10);
		var iFixedRows = this.getFixedBottomRowCount();
		if (iFixedRows > 0 && iRowIndex <= this.getVisibleRowCount() - 1 - iFixedRows) {
			return iRowIndex === this.getVisibleRowCount() - 1 - iFixedRows;
		}
		return iRowIndex === this.getVisibleRowCount() - 1;
	};

	/**
	 * enters the action mode. in the action mode the user can navigate through the
	 * interactive controls of the table by using the TAB & SHIFT-TAB. this table is
	 * aligned with the official WAI-ARIA 1.0.
	 * @private
	 */
	Table.prototype._enterActionMode = function($Focusable) {
		// only enter the action mode when not already in action mode and:
		if ($Focusable.length > 0 && !this._bActionMode) {

			//If cell has no tabbable element, we don't do anything
			if ($Focusable.filter(":sapTabbable").length == 0) {
				return;
			}

			// in the action mode we need no item navigation
			this._bActionMode = true;
			this.removeDelegate(this._oItemNavigation);

			// remove the tab index from the item navigation
			jQuery(this._oItemNavigation.getFocusedDomRef()).attr("tabindex", "-1");

			// set the focus to the active control
			$Focusable.filter(":sapTabbable").eq(0).focus();
		}
	};

	/**
	 * leaves the action mode and enters the navigation mode. in the navigation mode
	 * the user can navigate through the cells of the table by using the arrow keys,
	 * page up & down keys, home and end keys. this table is aligned with the
	 * official WAI-ARIA 1.0.
	 * @private
	 */
	Table.prototype._leaveActionMode = function(oEvent) {

	 // TODO: update ItemNavigation position otherwise the position is strange!
	 //        EDIT AN SCROLL!

		if (this._bActionMode) {

			// in the navigation mode we use the item navigation
			this._bActionMode = false;
			this.addDelegate(this._oItemNavigation);

			// reset the tabindex of the focused domref of the item navigation
			jQuery(this._oItemNavigation.getFocusedDomRef()).attr("tabindex", "0");

			// when we have an event which is responsible to leave the action mode
			// we search for the closest
			if (oEvent) {
				if (jQuery(oEvent.target).closest("td[tabindex='-1']").length > 0) {
					// triggered when clicking into a cell, then we focus the cell
					var iIndex = jQuery(this._oItemNavigation.aItemDomRefs).index(jQuery(oEvent.target).closest("td[tabindex='-1']").get(0));
					this._oItemNavigation.focusItem(iIndex, null);
				} else {
					// somewhere else means whe check if the click happend inside
					// the container, then we focus the last focused element
					// (DON'T KNOW IF THIS IS OK - but we don't know where the focus was!)
					if (jQuery.sap.containsOrEquals(this.$().find(".sapUiTableCCnt").get(0), oEvent.target)) {
						this._oItemNavigation.focusItem(this._oItemNavigation.getFocusedIndex(), null);
					}
				}
			} else {
				// when no event is given we just focus the last focused index
				this._oItemNavigation.focusItem(this._oItemNavigation.getFocusedIndex(), null);
			}

		}

	};

	/**
	 * Return the focused row index.
	 * @return {int} the currently focused row index.
	 * @private
	 */
	Table.prototype._getFocusedRowIndex = function() {
		var iFocusedIndex = this._oItemNavigation.iFocusedIndex;
		var iColumns = this._oItemNavigation.iColumns;
		var iSelectedCellInRow = iFocusedIndex % iColumns;
		var iSelectedRow = this.getFirstVisibleRow() + (iFocusedIndex - iSelectedCellInRow) / iColumns;

		if (!this.getColumnHeaderVisible()) {
			iSelectedRow++;
		}
		return iSelectedRow - 1;
	};

	/**
	 * Checks whether the row of the currently focused cell is selected or not.
	 * @return {boolean} true or false
	 * @private
	 */
	Table.prototype._isFocusedRowSelected = function() {
		var iSelectedRow = this._getFocusedRowIndex();
		var bIsFocusedRowSelected = this.isIndexSelected(iSelectedRow);

		var bIsCellRowHeader = (this._oItemNavigation.iFocusedIndex % this._oItemNavigation.iColumns == 0);
		if (bIsCellRowHeader) {
			return bIsFocusedRowSelected;
		} else {
			var bHasRowHeader = this.getSelectionMode() !== sap.ui.table.SelectionMode.None && this.getSelectionBehavior() !== sap.ui.table.SelectionBehavior.RowOnly;
			if (bHasRowHeader) {
				return null;
			} else {
				return bIsFocusedRowSelected;
			}
		}
	};

	// =============================================================================
	// KEYBOARD HANDLING EVENTS
	// =============================================================================

	// FYI: two more relevant things are handled in the onclick and onfocusin event

	/**
	 * handle the row selection via SPACE or ENTER key if key is pressed on a group header, the open state is toggled
	 * @private
	 */
	Table.prototype.onkeyup = function(oEvent) {
		if (!this._bEventSapSelect === true) {
			return;
		}
		this._bEventSapSelect = false;

		// this mimics the sapselect event but on keyup
		if (oEvent.keyCode !== jQuery.sap.KeyCodes.ENTER &&
			oEvent.keyCode !== jQuery.sap.KeyCodes.SPACE &&
			oEvent.keyCode !== jQuery.sap.KeyCodes.F4 ||
			oEvent.srcControl !== this &&
			jQuery.inArray(oEvent.srcControl,this.getRows()) === -1 &&
			jQuery.inArray(oEvent.srcControl,this.getColumns()) === -1) {
			return;
		}
		var $Parent = jQuery(oEvent.target).closest('.sapUiTableGroupHeader');
		if ($Parent.length > 0) {
			var iRowIndex = this.getFirstVisibleRow() + parseInt($Parent.attr("data-sap-ui-rowindex"), 10);
			var oBinding = this.getBinding("rows");
			if (oBinding) {
				if (oBinding.isExpanded(iRowIndex)) {
					oBinding.collapse(iRowIndex);
				} else {
					oBinding.expand(iRowIndex);
				}
			}
			oEvent.preventDefault();
			return;
		}
		this._bShowMenu = true;
		this._onSelect(oEvent);
		this._bShowMenu = false;
		oEvent.preventDefault();
	};

	Table.prototype.onsapselect = function() {
		this._bEventSapSelect = true;
	};

	/**
	 * handle the row selection via SPACE or ENTER key
	 * @private
	 */
	Table.prototype.onkeydown = function(oEvent) {
		var $this = this.$();
		if (!this._bActionMode &&
			oEvent.keyCode == jQuery.sap.KeyCodes.F2 ||
			oEvent.keyCode == jQuery.sap.KeyCodes.ENTER) {
			if ($this.find(".sapUiTableCtrl td:focus").length > 0) {
				this._enterActionMode($this.find(".sapUiTableCtrl td:focus").find(":sapFocusable"));
				oEvent.preventDefault();
				oEvent.stopPropagation();
			}
		} else if (this._bActionMode &&
			oEvent.keyCode == jQuery.sap.KeyCodes.F2) {
			this._leaveActionMode(oEvent);
		} else if (oEvent.keyCode == jQuery.sap.KeyCodes.TAB && this._bActionMode) {
			//Set tabindex to second table if fixed columns are used
			if (this.getFixedColumnCount() > 0) {
				var $cell = jQuery(oEvent.target);
				if ($cell.is("td[role=gridcell]") == false) {
					$cell = $cell.parents("td[role=gridcell]");
				}
				var $row = $cell.parent("tr[data-sap-ui-rowindex]");
				var $table = $row.closest(".sapUiTableCtrl");
				var iRowIndex = parseInt($row.attr("data-sap-ui-rowindex"),10);
				var $cells = $row.find("td[role=gridcell]");
				var iColIndex = $cells.index($cell);
				var iTableCols = $cells.length;
				if (iColIndex === (iTableCols - 1)) {
					var $otherTable;
					if ($table.hasClass("sapUiTableCtrlFixed")) {
						$otherTable = $this.find(".sapUiTableCtrl.sapUiTableCtrlScroll");
					} else {
						$otherTable = $this.find(".sapUiTableCtrl.sapUiTableCtrlFixed");
						iRowIndex++;
						if (iRowIndex == this.getVisibleRowCount()) {
							iRowIndex = 0;
						}
					}
					var $otherRow = $otherTable.find("tr[data-sap-ui-rowindex='" + iRowIndex + "']");
					var $nextFocus = $otherRow.find("td :sapFocusable[tabindex='0']").first();
					if ($nextFocus.length > 0) {
						$nextFocus.focus();
						oEvent.preventDefault();
					}
				}
			}
		} else if (oEvent.keyCode == jQuery.sap.KeyCodes.A && (oEvent.metaKey || oEvent.ctrlKey)) {
			// CTRL + A handling
			var oIN = this._oItemNavigation;
			var iFocusedIndex = oIN.getFocusedIndex();
			
			this._toggleSelectAll();

			oIN.focusItem(iFocusedIndex, oEvent);
			
			oEvent.preventDefault();
			oEvent.stopImmediatePropagation(true);
		} else if (oEvent.keyCode === jQuery.sap.KeyCodes.F10 && (oEvent.shiftKey)) {
			// SHIFT + 10 should open the context menu
			this.oncontextmenu(oEvent);
		}
	};

	/**
	 * handle the ESCAPE key to leave the action mode
	 * @private
	 */
	Table.prototype.onsapescape = function(oEvent) {
		this._leaveActionMode(oEvent);
	};

	/**
	 * handle the SHIFT-TAB key
	 * <ul>
	 *   <li>Navigation Mode:
	 *      <ul>
	 *          <li>If focus is on header: jump to the next focusable control before the table</li>
	 *          <li>If focus in on content: jump to header for the current column</li>
	 *      </ul>
	 *   <li>Action Mode: switch back to navigation mode</li>
	 * </ul>
	 * @private
	 */
	Table.prototype.onsaptabprevious = function(oEvent) {
		var $this = this.$();
		if (this._bActionMode) {
			this._leaveActionMode();
			oEvent.preventDefault();
		} else {
			var oIN = this._oItemNavigation;
			if (jQuery.contains($this.find('.sapUiTableCCnt')[0], oEvent.target) && this.getColumnHeaderVisible()) {
				var iColumn = oIN.getFocusedIndex() % oIN.iColumns;
				oIN.focusItem(iColumn, oEvent);
				oEvent.preventDefault();
			} else if (oIN.getFocusedDomRef() === oEvent.target && jQuery.sap.containsOrEquals($this.find(".sapUiTableCCnt").get(0), oEvent.target)) {
				// in case of having the focus in the row or column header we do not need to
				// place the focus to the div before the table control because there we do
				// not need to skip the table controls anymore.
				this._bIgnoreFocusIn = true;
				$this.find(".sapUiTableCtrlBefore").focus();
				this._bIgnoreFocusIn = false;
			}
		}
	};

	/**
	 * handle the TAB key:
	 * <ul>
	 *   <li>Navigation Mode:
	 *      <ul>
	 *          <li>If focus is on header: jump to the first data column of the focused column header</li>
	 *          <li>If focus in on content: jump to the next focusable control after the table</li>
	 *      </ul>
	 *   <li>Action Mode: switch back to navigation mode</li>
	 * </ul>
	 * @private
	 */
	Table.prototype.onsaptabnext = function(oEvent) {
		var $this = this.$();
		if (this._bActionMode) {
			this._leaveActionMode();
			oEvent.preventDefault();
		} else {
			var oIN = this._oItemNavigation;
			if (jQuery.contains($this.find('.sapUiTableColHdrCnt')[0], oEvent.target)) {
				oIN.focusItem(oIN.getFocusedIndex() + oIN.iColumns * this._iLastSelectedDataRow, oEvent);
				oEvent.preventDefault();
			} else if (oIN.getFocusedDomRef() === oEvent.target) {
				this._bIgnoreFocusIn = true;
				$this.find(".sapUiTableCtrlAfter").focus();
				this._bIgnoreFocusIn = false;
			}
		}
	};

	/**
	 * dynamic scrolling when reaching the bottom row with the ARROW DOWN key
	 * @private
	 */
	Table.prototype.onsapdown = function(oEvent) {
		if (!this._bActionMode && this._isBottomRow(oEvent)) {
			if (this.getFirstVisibleRow() != this._getRowCount() - this.getVisibleRowCount() - this.getFixedBottomRowCount()) {
				oEvent.stopImmediatePropagation(true);
				if (this.getNavigationMode() === sap.ui.table.NavigationMode.Scrollbar) {
					this._scrollNext();
				} else {
					this._scrollPageDown();
				}
			}
		}
		oEvent.preventDefault();
	};

	/**
	 * Implements selecting/deselecting rows when pressing SHIFT + DOWN
	 * @private
	 */
	Table.prototype.onsapdownmodifiers = function(oEvent) {
		if (oEvent.shiftKey) {
			var iFocusedRow = this._getFocusedRowIndex();
			var bIsFocusedRowSelected = this._isFocusedRowSelected();
			if (bIsFocusedRowSelected === true) {
				this.addSelectionInterval(iFocusedRow + 1, iFocusedRow + 1);
			} else if (bIsFocusedRowSelected === false) {
				this.removeSelectionInterval(iFocusedRow + 1, iFocusedRow + 1);
			}

			if (this._isBottomRow(oEvent)) {
				this._scrollNext();
			}
		} else if (oEvent.altKey) {
			// Toggle group header on ALT + DOWN.
			this._toggleGroupHeader(oEvent);
		}
	};

	/**
	 * Implements selecting/deselecting rows when pressing SHIFT + UP
	 *
	 * @private
	 */
	Table.prototype.onsapupmodifiers = function(oEvent) {
		if (oEvent.shiftKey) {
			var iFocusedRow = this._getFocusedRowIndex();
			var bIsFocusedRowSelected = this._isFocusedRowSelected();
			
			if (bIsFocusedRowSelected === true) {
				this.addSelectionInterval(iFocusedRow - 1, iFocusedRow - 1);
			} else if (bIsFocusedRowSelected === false) {
				this.removeSelectionInterval(iFocusedRow - 1, iFocusedRow - 1);
			}

			if (this._isTopRow(oEvent)) {
				// Prevent that focus jumps to header in this case.
				if (this.getFirstVisibleRow() != 0) {
					oEvent.stopImmediatePropagation(true);
				}
				this._scrollPrevious();
			}
		} else if (oEvent.altKey) {
			// Toggle group header on ALT + UP.
			this._toggleGroupHeader(oEvent);
		}
	};

	/**
	 * dynamic scrolling when reaching the top row with the ARROW UP key
	 *
	 * @private
	 */
	Table.prototype.onsapup = function(oEvent) {
		if (!this._bActionMode && this._isTopRow(oEvent)) {
			if (this.getFirstVisibleRow() != 0) {
				oEvent.stopImmediatePropagation(true);
			}
			if (this.getNavigationMode() === sap.ui.table.NavigationMode.Scrollbar) {
				this._scrollPrevious();
			} else {
				this._scrollPageUp();
			}
		}
		oEvent.preventDefault();
	};

	/**
	 * dynamic scrolling when reaching the bottom row with the PAGE DOWN key
	 * @private
	 */
	Table.prototype.onsappagedown = function(oEvent) {
		if (!this._bActionMode) {
			var $this = this.$();
			var oIN = this._oItemNavigation;

			var bRowHeader = (this.getSelectionBehavior() !== sap.ui.table.SelectionBehavior.RowOnly);
			var iHeaderRows = $this.find(".sapUiTableColHdrScr>.sapUiTableColHdr").length;

			// Check if focus is on header
			// Special Handling is required here:
			// - If not in the last header row, jump to the last header row in the same column
			// - If in the last header row, scroll table to first row and jump to first row, same column
			if (this.getColumnHeaderVisible() && oIN.iFocusedIndex < (oIN.iColumns * iHeaderRows)) {
				// focus is on header
				var iCol = oIN.iFocusedIndex % oIN.iColumns;
				if ((oIN.iFocusedIndex <= (oIN.iColumns * iHeaderRows) && oIN.iFocusedIndex >= (oIN.iColumns * iHeaderRows) - oIN.iColumns) ||
					(iCol === 0 && bRowHeader)) {
					// move focus to first data row, scroll table to top
					this.setFirstVisibleRow(0);
					oIN.focusItem(oIN.iColumns * iHeaderRows + iCol, oEvent);
				} else {
					// set focus to last header row, same column if possible
					oIN.focusItem(oIN.iColumns * iHeaderRows - oIN.iColumns + iCol, oEvent);
				}

				oEvent.stopImmediatePropagation(true);
			} else {
				if (this._isBottomRow(oEvent)) {
					this._scrollPageDown();
				}
			}
			oEvent.preventDefault();
		}
	};

	/**
	 * dynamic scrolling when reaching the top row with the PAGE DOWN key
	 * @private
	 */
	Table.prototype.onsappagedownmodifiers = function(oEvent) {
		if (!this._bActionMode && oEvent.altKey) {
			var oIN = this._oItemNavigation;
			var bRowHeader = (this.getSelectionBehavior() !== sap.ui.table.SelectionBehavior.RowOnly);

			var iCol = oIN.iFocusedIndex % oIN.iColumns;
			var iNewCol;
			if (iCol == 0 && bRowHeader) {
				iNewCol = 1;
			} else {
				var iVisibleColumns = this._aVisibleColumns.length;
				var iMaxIndex = this._getVisibleColumns().length;
				if (!bRowHeader) {
					iMaxIndex--;
				}
				if (iVisibleColumns === 0) {
					iNewCol = iMaxIndex;
				} else {
					iNewCol = Math.min(iMaxIndex, iCol + iVisibleColumns);
				}
			}
			oIN.focusItem(oIN.iFocusedIndex - (iCol - iNewCol), oEvent);
			oEvent.stopImmediatePropagation(true);
			oEvent.preventDefault();
		}
	};

	/**
	 * dynamic scrolling when reaching the top row with the PAGE UP key
	 * @private
	 */
	Table.prototype.onsappageup = function(oEvent) {
		if (!this._bActionMode) {
			var $this = this.$();
			var oIN = this._oItemNavigation;

			var bRowHeader = (this.getSelectionBehavior() !== sap.ui.table.SelectionBehavior.RowOnly);
			var iHeaderRows = $this.find(".sapUiTableColHdrScr>.sapUiTableColHdr").length;
			var iCol = oIN.iFocusedIndex % oIN.iColumns;

			if (this.getColumnHeaderVisible() && oIN.iFocusedIndex < (oIN.iColumns * iHeaderRows)) {
				// focus is on header
				if (oIN.iFocusedIndex > oIN.iColumns) {
					// focus is not on the first header row, move to first
					oIN.focusItem(iCol, oEvent);
				}
				oEvent.stopImmediatePropagation(true);
			} else {
				// focus is on content area
				if (this.getColumnHeaderVisible() && this.getFirstVisibleRow() == 0 && this._isTopRow(oEvent)) {
					// focus is on first row, move to last header row, same column
					if (bRowHeader && iCol === 0) {
						oIN.focusItem(iCol, oEvent);
					} else {
						oIN.focusItem(oIN.iColumns * iHeaderRows - oIN.iColumns + iCol, oEvent);
					}
					oEvent.stopImmediatePropagation(true);
				} else {
					var iIndex = this.getColumnHeaderVisible() ? oIN.iColumns * iHeaderRows : 0;
					oIN.focusItem(iIndex + iCol, oEvent);
					oEvent.stopImmediatePropagation(true);

					if (this._isTopRow(oEvent)) {
						this._scrollPageUp();
					}
				}
			}

			oEvent.preventDefault();
		}
	};

	/**
	 * dynamic scrolling when reaching the top row with the PAGE UP key
	 * @private
	 */
	Table.prototype.onsappageupmodifiers = function(oEvent) {
		if (!this._bActionMode && oEvent.altKey) {
			var oIN = this._oItemNavigation;
			var bRowHeader = (this.getSelectionBehavior() !== sap.ui.table.SelectionBehavior.RowOnly);

			var iCol = oIN.iFocusedIndex % oIN.iColumns;
			if (iCol > 0) {
				var iNewCol;
				if (iCol == 1 && bRowHeader) {
					iNewCol = 0;
				} else {
					var iVisibleColumns = this._aVisibleColumns.length;
					if (iVisibleColumns === 0) {
						if (bRowHeader) {
							iNewCol = 1;
						} else {
							iNewCol = 0;
						}
					} else {
						var iMin = 1;
						if (!bRowHeader) {
							iMin = 0;
						}
						iNewCol = Math.max(iMin, iCol - iVisibleColumns);
					}
				}
				oIN.focusItem(oIN.iFocusedIndex - (iCol - iNewCol), oEvent);
			}
			oEvent.stopImmediatePropagation(true);
			oEvent.preventDefault();
		}
	};

	/**
	 * Keyboard Handling regarding HOME key
	 *
	 * @private
	 */
	Table.prototype.onsaphome = function(oEvent) {
		var bIsRowOnly = (this.getSelectionBehavior() == sap.ui.table.SelectionBehavior.RowOnly);

		// If focus is on a group header, do nothing.
		var bIsGroupCell = jQuery(oEvent.target).parents(".sapUiTableGroupHeader").length > 0;
		if (bIsGroupCell) {
			oEvent.stopImmediatePropagation(true);
			return;
		}

		var iFocusedIndex = this._oItemNavigation.iFocusedIndex;
		var iColumns = this._oItemNavigation.iColumns;
		var iSelectedCellInRow = iFocusedIndex % iColumns;

		var offset = 0;
		if (!bIsRowOnly) {
			offset = 1;
		}

		if (iSelectedCellInRow > this.getFixedColumnCount() + offset) {
			// If there is a fixed column, stop right of it.
			oEvent.stopImmediatePropagation(true);
			this._oItemNavigation.focusItem(iFocusedIndex - iSelectedCellInRow + this.getFixedColumnCount() + offset, null);
		} else if (!bIsRowOnly) {
			if (iSelectedCellInRow > 1) {
				// if focus is anywhere in the row, move focus to the first column cell.
				oEvent.stopImmediatePropagation(true);
				this._oItemNavigation.focusItem(iFocusedIndex - iSelectedCellInRow + 1, null);
			} else if (iSelectedCellInRow == 1) {
				// if focus is on first cell, move focus to row header.
				oEvent.stopImmediatePropagation(true);
				this._oItemNavigation.focusItem(iFocusedIndex - 1, null);
			} else {
				// If focus is on selection cell, do nothing.
				oEvent.stopImmediatePropagation(true);
			}
		}
	};

	/**
	 * Keyboard Handling regarding END key
	 *
	 * @private
	 */
	Table.prototype.onsapend = function(oEvent) {
		// If focus is on a group header, do nothing.
		var bIsGroupCell = jQuery(oEvent.target).parents(".sapUiTableGroupHeader").length > 0;
		if (bIsGroupCell) {
			oEvent.stopImmediatePropagation(true);
			return;
		}

		// If focus is on a selection cell, move focus to the first cell of the same row.
		var iFocusedIndex = this._oItemNavigation.iFocusedIndex;
		var iColumns = this._oItemNavigation.iColumns;
		var iSelectedCellInRow = iFocusedIndex % iColumns;

		var bIsRowOnly = (this.getSelectionBehavior() !== sap.ui.table.SelectionBehavior.RowOnly);
		var offset = 0;
		if (!bIsRowOnly) {
			offset = 1;
		}

		if (iSelectedCellInRow === 0 && bIsRowOnly) {
			// If focus is in row header, select first cell in same row.
			oEvent.stopImmediatePropagation(true);
			this._oItemNavigation.focusItem(iFocusedIndex + 1, null);
		} else if (iSelectedCellInRow < this.getFixedColumnCount() - offset) {
			// if their is a fixed column, stop left of it.
			oEvent.stopImmediatePropagation(true);
			this._oItemNavigation.focusItem(iFocusedIndex - iSelectedCellInRow + this.getFixedColumnCount() - offset, null);
		}
	};

	/**
	 * dynamic scrolling when using CTRL + HOME key
	 *
	 * @private
	 */
	Table.prototype.onsaphomemodifiers = function(oEvent) {
		if (oEvent.metaKey || oEvent.ctrlKey) {
			var $this = this.$();

			// Is target a table header cell
			var oTableHeader = $this.find(".sapUiTableColHdrCnt")[0];
			var bIsTableHeaderCell = jQuery.contains(oTableHeader, oEvent.target);

			// If focus is on a group header, do nothing.
			if (bIsTableHeaderCell) {
				oEvent.stopImmediatePropagation(true);
				return;
			}

			var iFocusedIndex = this._oItemNavigation.iFocusedIndex;
			var iColumns = this._oItemNavigation.iColumns;
			var iSelectedRowInColumn = Math.ceil(iFocusedIndex / iColumns) - 1;
			var iSelectedCellInRow = iFocusedIndex % iColumns;

			if (this.getColumnHeaderVisible()) {
				if (iSelectedRowInColumn == 1) {
					// if focus is in first row, select corresponding header
					oEvent.stopImmediatePropagation(true);
					this._oItemNavigation.focusItem(iSelectedCellInRow, oEvent);
				} else if (iSelectedRowInColumn > 1) {
					oEvent.stopImmediatePropagation(true);

					// if focus is in any row, select first cell row
					this.setFirstVisibleRow(0);

					var iTargetIndex = iSelectedCellInRow + iColumns;
					this._oItemNavigation.focusItem(iTargetIndex, oEvent);
				}
			} else {
				oEvent.stopImmediatePropagation(true);

				// if focus is in any row, select first cell row
				this.setFirstVisibleRow(0);

				var iTargetIndex = iFocusedIndex - iSelectedRowInColumn * iColumns;
				this._oItemNavigation.focusItem(iTargetIndex, oEvent);
			}
		}
	};

	/**
	 * dynamic scrolling when using CTRL + END key
	 *
	 * @private
	 */
	Table.prototype.onsapendmodifiers = function(oEvent) {
		if (oEvent.metaKey || oEvent.ctrlKey) {
			var $this = this.$();

			// Is target a table header cell
			var oTableHeader = $this.find(".sapUiTableColHdrCnt")[0];
			var bIsTableHeaderCell = jQuery.contains(oTableHeader, oEvent.target);

			var iFocusedIndex = this._oItemNavigation.iFocusedIndex;
			var iColumns = this._oItemNavigation.iColumns;
			var iSelectedCellInRow = iFocusedIndex % iColumns;

			oEvent.stopImmediatePropagation(true);

			if (bIsTableHeaderCell) {
				// If focus is on a group header, select first cell row after header.
				this._oItemNavigation.focusItem(iFocusedIndex + iColumns, oEvent);
			} else {
				// if focus is on any cell row, select last cell row.
				this.setFirstVisibleRow(this._getRowCount() - this.getVisibleRowCount());
				var iTargetIndex = this._oItemNavigation.aItemDomRefs.length - (iColumns - iSelectedCellInRow);
				this._oItemNavigation.focusItem(iTargetIndex, oEvent);
			}
		}
	};

	/**
	 * Default handler for sapleft event.
	 * @private
	 */
	Table.prototype.onsapleft = function(oEvent) {
		this._collapseGroupHeader(oEvent);
	};

	/**
	 * Default handler for sapright event.
	 * @private
	 */
	Table.prototype.onsapright = function(oEvent) {
		this._expandGroupHeader(oEvent);
	};
	
	
	/**
	 * If focus is on group header, open/close the group header, depending on the expand state.
	 * @private
	 */
	Table.prototype._toggleGroupHeader = function(oEvent) {
		var $Parent = jQuery(oEvent.target).closest('.sapUiTableGroupHeader');
		if ($Parent.length > 0) {
			var iRowIndex = this.getFirstVisibleRow() + parseInt($Parent.attr("data-sap-ui-rowindex"), 10);
			var oBinding = this.getBinding("rows");
			if (oBinding && oBinding.isExpanded(iRowIndex)) {
				oBinding.collapse(iRowIndex);
			} else {
				oBinding.expand(iRowIndex);
			}
			oEvent.preventDefault();
			oEvent.stopImmediatePropagation();
		}
	};

	/**
	 * If focus is on group header, close the group header, else do the default behaviour of item navigation
	 * @private
	 */
	Table.prototype._collapseGroupHeader = function(oEvent) {
		var $Parent = jQuery(oEvent.target).closest('.sapUiTableGroupHeader');
		if ($Parent.length > 0) {
			var iRowIndex = this.getFirstVisibleRow() + parseInt($Parent.attr("data-sap-ui-rowindex"), 10);
			var oBinding = this.getBinding("rows");
			if (oBinding && oBinding.isExpanded(iRowIndex)) {
				oBinding.collapse(iRowIndex);
			}
			oEvent.preventDefault();
			oEvent.stopImmediatePropagation();
		}
	};

	/**
	 * If focus is on group header, open the group header, else do the default behaviour of item navigation
	 * @private
	 */
	Table.prototype._expandGroupHeader = function(oEvent) {
		var $Parent = jQuery(oEvent.target).closest('.sapUiTableGroupHeader');
		if ($Parent.length > 0) {
			var iRowIndex = this.getFirstVisibleRow() + parseInt($Parent.attr("data-sap-ui-rowindex"), 10);
			var oBinding = this.getBinding("rows");
			if (oBinding && !oBinding.isExpanded(iRowIndex)) {
				oBinding.expand(iRowIndex);
			}
			oEvent.preventDefault();
			oEvent.stopImmediatePropagation();
		}
	};

	/**
	 * On shift+left on column header decrease the width of a column
	 * @private
	 */
	Table.prototype.onsapleftmodifiers = function(oEvent) {
		var $Target = jQuery(oEvent.target);
		if ($Target.hasClass('sapUiTableCol')) {
			var iColIndex = parseInt($Target.attr('data-sap-ui-colindex'), 10),
				aVisibleColumns = this._getVisibleColumns(),
				oColumn = aVisibleColumns[this._aVisibleColumns.indexOf(iColIndex)];

			 if (oEvent.shiftKey) {
				 var iNewWidth = parseInt(oColumn.getWidth(), 10) - 16;
				oColumn.setWidth((iNewWidth > 20 ? iNewWidth : 20) + "px");
				oEvent.preventDefault();
				oEvent.stopImmediatePropagation();
			} else if (oEvent.ctrlKey || oEvent.metaKey) {
				if (iColIndex - 1 >= 0) {
					// check whether preceding column is part of column span
					var iNewIndex = 0;

					for (var iPointer = this._aVisibleColumns.indexOf(iColIndex) - 1; iPointer >= 0; iPointer--) {
						iNewIndex = this._aVisibleColumns[iPointer];
						if (aVisibleColumns[iPointer].$().css("display") !== "none") {
							break;
						}
					}
					this.removeColumn(oColumn);
					this.insertColumn(oColumn, iNewIndex);

					// also move spanned columns
					var iHeaderSpan = oColumn.getHeaderSpan();
					if (iHeaderSpan > 1) {
						for (var i = 1; i < iHeaderSpan; i++) {
							oColumn = aVisibleColumns[iColIndex + i];
							this.removeColumn(oColumn);
							this.insertColumn(oColumn, iNewIndex + i);
						}
					}
				}
				oEvent.preventDefault();
				oEvent.stopImmediatePropagation();
			}
		}
	};

	/**
	 * On shift+left on column header decrease the width of a column
	 * @private
	 */
	Table.prototype.onsaprightmodifiers = function(oEvent) {
		var $Target = jQuery(oEvent.target);
		if ($Target.hasClass('sapUiTableCol')) {
			var iColIndex = parseInt($Target.attr('data-sap-ui-colindex'), 10);
			var aVisibleColumns = this._getVisibleColumns();
			var iPointer = this._aVisibleColumns.indexOf(iColIndex);
			var oColumn = aVisibleColumns[iPointer];
			 if (oEvent.shiftKey) {
				oColumn.setWidth(parseInt(oColumn.getWidth(), 10) + 16 + "px");
				oEvent.preventDefault();
				oEvent.stopImmediatePropagation();
			} else if (oEvent.ctrlKey || oEvent.metaKey) {
				var iHeaderSpan = oColumn.getHeaderSpan();
				if (iPointer < aVisibleColumns.length - iHeaderSpan) {
					// Depending on the header span of the column to be moved, several
					// columns might need to be moved to the right
					var iNextHeaderSpan = aVisibleColumns[iPointer + 1].getHeaderSpan(),
						iNewIndex = this._aVisibleColumns[iPointer + iNextHeaderSpan];
					//iPointer = this._aVisibleColumns[iPointer];
					for (var i = iHeaderSpan - 1; i >= 0; i--) {
						oColumn = aVisibleColumns[iPointer + i];
						this.removeColumn(oColumn);
						this.insertColumn(oColumn, iNewIndex + i);
					}
				}
				oEvent.preventDefault();
				oEvent.stopImmediatePropagation();
			}
		}
	};

	// =============================================================================
	// GROUPING
	// =============================================================================

	/*
	 * overridden to hide the group by column when set
	 */
	Table.prototype.setGroupBy = function(vValue) {

		// determine the group by column
		var oGroupBy = vValue;
		if (typeof oGroupBy === "string") {
			oGroupBy = sap.ui.getCore().byId(oGroupBy);
		}

		// only for columns we do the full handling here - otherwise the method
		// setAssociation will fail below with a specific fwk error message
		var bReset = false;
		if (oGroupBy && oGroupBy instanceof sap.ui.table.Column) {

			// check for column being part of the columns aggregation
			if (jQuery.inArray(oGroupBy, this.getColumns()) === -1) {
				throw new Error("Column has to be part of the columns aggregation!");
			}

			// fire the event (to allow to cancel the event)
			var bExecuteDefault = this.fireGroup({column: oGroupBy, groupedColumns: [oGroupBy.getId()], type: sap.ui.table.GroupEventType.group});

			// first we reset the grouping indicator of the old column (will show the column)
			var oOldGroupBy = sap.ui.getCore().byId(this.getGroupBy());
			if (oOldGroupBy) {
				oOldGroupBy.setGrouped(false);
				bReset = true;
			}

			// then we set the grouping indicator of the new column (will hide the column)
			// ==> only if the default behavior is not prevented
			if (bExecuteDefault && oGroupBy instanceof sap.ui.table.Column) {
				oGroupBy.setGrouped(true);
			}

		}

		// reset the binding when no value is given or the binding needs to be reseted
		// TODO: think about a better handling to recreate the group binding
		if (!oGroupBy || bReset) {
			var oBindingInfo = this.getBindingInfo("rows");
			delete oBindingInfo.binding;
			this._bindAggregation("rows", oBindingInfo);
		}

		// set the new group by column (TODO: undefined doesn't work!)
		return this.setAssociation("groupBy", oGroupBy);
	};

	/*
	 * override the getBinding to inject the grouping information into the JSON model.
	 *
	 * !!EXPERIMENTAL FEATURE!!
	 *
	 * TODO:
	 *   - Grouping is not really possible for models based on OData:
	 *     - it works when loading data from the beginning because in this case the
	 *       model has the relevant information (distinct values) to determine the
	 *       count of rows and add them properly in the scrollbar as well as adding
	 *       the group information to the contexts array which is used by the
	 *       _modifyRow to display the group headers
	 *     - it doesn't work when not knowing how many groups are available before
	 *       and on which position the group header has to be added - e.g. when
	 *       displaying a snapshot in the middle of the model.
	 *   - For OData it might be a server-side feature?
	 */
	Table.prototype.getBinding = function(sName) {

		// default binding is the "rows" binding
		sName = sName || "rows";
		var oBinding = sap.ui.core.Element.prototype.getBinding.call(this, sName);

		// we do all the extended stuff only when grouping is enabled
		if (this.getEnableGrouping()) {

			// require the binding types (think about loading them only if required)
			jQuery.sap.require("sap.ui.model.ClientListBinding");

			// check for grouping being supported or not (only for client ListBindings!!)
			var oGroupBy = sap.ui.getCore().byId(this.getGroupBy());
			var bIsSupported = oGroupBy && oGroupBy.getGrouped() &&
			                   sName === "rows" && oBinding &&
			                   oBinding instanceof sap.ui.model.ClientListBinding;

			// only enhance the binding if it has not been done yet and supported!
			if (bIsSupported && !oBinding._modified) {

				// once the binding is modified we always return the modified binding
				// and don't wanna modifiy the binding once again
				oBinding._modified = true;

				// hook into the row modification and add the grouping specifics
				this._modifyRow = function(iRowIndex, $row) {

					// we add the style override to display the row header
					this.$().find(".sapUiTableRowHdrScr").css("display", "block");

					// modify the rows
					var $rowHdr = this.$().find("div[data-sap-ui-rowindex='" + $row.attr("data-sap-ui-rowindex") + "']");
					if (oBinding.isGroupHeader(iRowIndex)) {
						$row.addClass("sapUiTableGroupHeader sapUiTableRowHidden");
						var sClass = oBinding.isExpanded(iRowIndex) ? "sapUiTableGroupIconOpen" : "sapUiTableGroupIconClosed";
						$rowHdr.html("<div class=\"sapUiTableGroupIcon " + sClass + "\" tabindex=\"-1\">" + oBinding.getTitle(iRowIndex) + "</div>");
						$rowHdr.addClass("sapUiTableGroupHeader").removeAttr("title");
					} else {
						$row.removeClass("sapUiTableGroupHeader");
						$rowHdr.html("");
						$rowHdr.removeClass("sapUiTableGroupHeader");
					}

				};

				this.onclick = function(oEvent) {
					if (jQuery(oEvent.target).hasClass("sapUiTableGroupIcon")) {
						var $parent = jQuery(oEvent.target).parents("[data-sap-ui-rowindex]");
						if ($parent.length > 0) {
							var iRowIndex = this.getFirstVisibleRow() + parseInt($parent.attr("data-sap-ui-rowindex"), 10);
							var oBinding = this.getBinding("rows");
							if (oBinding.isExpanded(iRowIndex)) {
								oBinding.collapse(iRowIndex);
								jQuery(oEvent.target).removeClass("sapUiTableGroupIconOpen").addClass("sapUiTableGroupIconClosed");
							} else {
								oBinding.expand(iRowIndex);
								jQuery(oEvent.target).removeClass("sapUiTableGroupIconClosed").addClass("sapUiTableGroupIconOpen");
							}
						}
					} else {
						if (Table.prototype.onclick) {
							Table.prototype.onclick.apply(this, arguments);
						}
					}
				};

				// we use sorting finally to sort the values and afterwards group them
				var sPropertyName = oGroupBy.getSortProperty();
				oBinding.sort(new sap.ui.model.Sorter(sPropertyName));

				// fetch the contexts from the original binding
				var iLength = oBinding.getLength(),
					aContexts = oBinding.getContexts(0, iLength);

				// add the context information for the group headers which are later on
				// used for displaying the grouping information of each group
				var sKey;
				var iCounter = 0;
				for (var i = iLength - 1; i >= 0; i--) {
					var sNewKey = aContexts[i].getProperty(sPropertyName);
					if (!sKey) {
						sKey = sNewKey;
					}
					if (sKey !== sNewKey) {
						aContexts.splice(i + 1, 0, {
							oContext: aContexts[i + 1],
							name: sKey,
							count: iCounter,
							groupHeader: true,
							expanded: true
						});
						sKey = sNewKey;
						iCounter = 0;
					}
					iCounter++;
				}
				aContexts.splice(0, 0, {
					oContext: aContexts[0],
					name: sKey,
					count: iCounter,
					groupHeader: true,
					expanded: true
				});

				// extend the binding and hook into the relevant functions to provide
				// access to the grouping information for the _modifyRow function
				jQuery.extend(oBinding, {
					getLength: function() {
						return aContexts.length;
					},
					getContexts: function(iStartIndex, iLength) {
						return aContexts.slice(iStartIndex, iStartIndex + iLength);
					},
					isGroupHeader: function(iIndex) {
						var oContext = aContexts[iIndex];
						return oContext && !(oContext instanceof sap.ui.model.Context);
					},
					getTitle: function(iIndex) {
						var oContext = aContexts[iIndex];
						return oContext && !(oContext instanceof sap.ui.model.Context) && (oContext["name"] + " - " + oContext["count"]);
					},
					isExpanded: function(iIndex) {
						return this.isGroupHeader(iIndex) && aContexts[iIndex].expanded;
					},
					expand: function(iIndex) {
						if (this.isGroupHeader(iIndex) && !aContexts[iIndex].expanded) {
							for (var i = 0; i < aContexts[iIndex].childs.length; i++) {
								aContexts.splice(iIndex + 1 + i, 0, aContexts[iIndex].childs[i]);
							}
							delete aContexts[iIndex].childs;
							aContexts[iIndex].expanded = true;
							this._fireChange();
						}
					},
					collapse: function(iIndex) {
						if (this.isGroupHeader(iIndex) && aContexts[iIndex].expanded) {
							aContexts[iIndex].childs = aContexts.splice(iIndex + 1, aContexts[iIndex].count);
							aContexts[iIndex].expanded = false;
							this._fireChange();
						}
					}

				});

			}

		}

		return oBinding;

	};

	Table.prototype.resetGrouping = function() {

		// reset the group binding only when enhanced
		var oBinding = this.getBinding("rows");
		if (oBinding && oBinding._modified) {

			// we remove the style override to display the row header
			this.$().find(".sapUiTableRowHdrScr").css("display", "");

			// if the grouping is not supported we remove the hacks we did
			// and simply return the binding finally
			this.onclick = Table.prototype.onclick;
			this._modifyRow = undefined;

			// reset the binding
			var oBindingInfo = this.getBindingInfo("rows");
			this.unbindRows();
			this.bindRows(oBindingInfo);

		}

	};

	Table.prototype.setEnableGrouping = function(bEnableGrouping) {
		// set the property
		this.setProperty("enableGrouping", bEnableGrouping);
		// reset the grouping
		if (!bEnableGrouping) {
			this.resetGrouping();
		}
		// update the column headers
		this._invalidateColumnMenus();
		return this;
	};

	Table.prototype.setEnableCustomFilter = function(bEnableCustomFilter) {
		this.setProperty("enableCustomFilter", bEnableCustomFilter);
		// update the column headers
		this._invalidateColumnMenus();
		return this;
	};

	Table.prototype.setEnableColumnFreeze = function(bEnableColumnFreeze) {
		this.setProperty("enableColumnFreeze", bEnableColumnFreeze);
		this._invalidateColumnMenus();
		return this;
	};

	Table.prototype.setShowColumnVisibilityMenu = function(bShowColumnVisibilityMenu) {
		this.setProperty("showColumnVisibilityMenu", bShowColumnVisibilityMenu);
		this._invalidateColumnMenus();
		return this;
	};

	Table.prototype.setFixedColumnCount = function(iFixedColumnCount) {
		var aCols = this._getVisibleColumns();
		var vHeaderSpan = aCols[iFixedColumnCount - 1] && aCols[iFixedColumnCount - 1].getHeaderSpan();
		if (vHeaderSpan) {
			var iHeaderSpan;
			if (jQuery.isArray(vHeaderSpan)) {
				iHeaderSpan = parseInt(vHeaderSpan[0], 10);
			} else {
				iHeaderSpan = parseInt(vHeaderSpan, 10);
			}
			iFixedColumnCount += iHeaderSpan - 1;
		}
		//Set current width as fixed width for cols
		var $ths = this.$().find(".sapUiTableCtrlFirstCol > th");
		for (var i = 0; i < iFixedColumnCount; i++) {
			var oColumn = aCols[i];
			if (oColumn) {
				var iColumnIndex = jQuery.inArray(oColumn, this.getColumns());
				if (!oColumn.getWidth()) {
					oColumn.setWidth($ths.filter("[data-sap-ui-headcolindex='" + iColumnIndex + "']").width() + "px");
				}
			}
		}
		this.setProperty("fixedColumnCount", iFixedColumnCount);
		this._invalidateColumnMenus();
		return this;
	};

	Table.prototype._invalidateColumnMenus = function() {
		var aCols = this.getColumns();
		for (var i = 0, l = aCols.length; i < l; i++) {
			if (aCols[i].getMenu()) {
				aCols[i].getMenu()._bInvalidated = true;
			}
		}
	};

	/**
	 * The selectstart event triggered in IE to select the text.
	 * @private
	 * @param {event} oEvent The splitterselectstart event
	 * @return {boolean} false
	 */
	Table.prototype._splitterSelectStart = function(oEvent){
		oEvent.preventDefault();
		oEvent.stopPropagation();
		return false;
	};

	/**
	 * drops the splitter bar
	 */
	Table.prototype._onGhostMouseRelease = function(oEvent) {

		var splitterBarGhost = this.getDomRef("ghost");

		var iNewHeight = oEvent.pageY - this.$().offset().top;

	    this.setVisibleRowCount(this._calculateRowsToDisplay(iNewHeight));

		jQuery(splitterBarGhost).remove();
		this.$("overlay").remove();

		jQuery(document.body).unbind("selectstart", this._splitterSelectStart);
		jQuery(document).unbind("mouseup", this._onGhostMouseRelease);
		jQuery(document).unbind("mousemove", this._onGhostMouseMove);

	};

	Table.prototype._onGhostMouseMove = function(oEvent) {
		var splitterBarGhost = this.getDomRef("ghost");

		var min = this.$().offset().top;
		if (oEvent.pageY > min) {
			jQuery(splitterBarGhost).css("top", oEvent.pageY + "px");
		}
	};

	/**
	 * Calculates the maximum rows to display within the table.
	 */
	Table.prototype._calculateRowsToDisplay = function(iHeight) {
		var iMinRowCount = this.getMinAutoRowCount() || 5;

		// If no iHeight is passed, return minimum row count.
		if (!iHeight) {
			return iMinRowCount;
		}

		var $this = this.$();
		if (!$this.get(0)) {
			return;
		}

		// usage of getBoundingClientRect() for retrieving subpixel correct value of the height. Necessary for zooming/flickering bugs in Chrome
		var iControlHeight = $this.get(0).getBoundingClientRect().height;
		var iContentHeight = $this.find('.sapUiTableCCnt').outerHeight();

		// Determine default row height.
		var iRowHeight = $this.find("tr:not(.sapUiAnalyticalTableSum) > td").outerHeight();

		// No rows displayed when visible row count == 0, no row height can be determined, therefore we set standard row height
		if (!iRowHeight) {
			var sRowHeightParamName = "sap.ui.table.Table:sapUiTableRowHeight";
			if ($this.parents().hasClass('sapUiSizeCompact')) {
				sRowHeightParamName = "sap.ui.table.Table:sapUiTableCompactRowHeight";
			}
			iRowHeight = parseInt(Parameters.get(sRowHeightParamName), 10);
		}

		// Maximum height of the table is the height of the window minus two row height, reserved for header and footer.
		var iMaxHeight = window.innerHeight - 2 * iRowHeight;
		var iCalculatedSpace = iHeight - (iControlHeight - iContentHeight);

		// Make sure that table does not grow to infinity
		var iAvailableSpace = Math.min(iCalculatedSpace, iMaxHeight);
		
		// the last content row height is iRowHeight - 1, therefore + 1 in the formula below:
		return Math.max(iMinRowCount, Math.floor((iAvailableSpace + 1) / iRowHeight));
	};

	Table.prototype.setShowNoData = function(bShowNoData) {
		this.setProperty('showNoData', bShowNoData, true);
		bShowNoData = this.getProperty('showNoData');
		if (!bShowNoData) {
			this.$().removeClass("sapUiTableEmpty");
		} else {
			this._updateNoData();
		}
		return this;
	};

	Table.prototype.setNoDataText = function(sText) {
		this.setProperty("noDataText", sText, true);
		this.$().find('.sapUiTableCtrlEmptyMsg').text(sText);
	};

	/**
	 * Creates a new {@link sap.ui.core.util.Export} object and fills row/column information from the table if not provided. For the cell content, the column's "sortProperty" will be used (experimental!)
	 *
	 * <p><b>Please note: The return value was changed from jQuery Promises to standard ES6 Promises.
	 * jQuery specific Promise methods ('done', 'fail', 'always', 'pipe' and 'state') are still available but should not be used.
	 * Please use only the standard methods 'then' and 'catch'!</b></p>
	 *
	 * @param {object} [mSettings] settings for the new Export, see {@link sap.ui.core.util.Export} <code>constructor</code>
	 * @return {Promise} Promise object
	 *
	 * @experimental Experimental because the property for the column/cell definitions (sortProperty) could change in future.
	 * @public
	 */
	Table.prototype.exportData = function(mSettings) {
		jQuery.sap.require("sap.ui.core.util.Export");

		mSettings = mSettings || {};

		if (!mSettings.rows) {
			var oBinding = this.getBinding("rows"),
				oBindingInfo = this.getBindingInfo("rows");

			var aFilters = oBinding.aFilters.concat(oBinding.aApplicationFilters);

			mSettings.rows = {
				path: oBindingInfo.path,
				model: oBindingInfo.model,
				sorter: oBinding.aSorters,
				filters: aFilters,
				parameters: oBindingInfo.parameters
			};
		}

		// by default we choose the export type CSV
		if (!mSettings.exportType) {
			jQuery.sap.require("sap.ui.core.util.ExportTypeCSV");
			mSettings.exportType = new sap.ui.core.util.ExportTypeCSV();
		}

		var sModelName = mSettings.rows.model;
		if (!sModelName) {
			// if a model separator is found in the path, extract model name from there
			var sPath = mSettings.rows.path;
			var iSeparatorPos = sPath.indexOf(">");
			if (iSeparatorPos > 0) {
				sModelName = sPath.substr(0, iSeparatorPos);
			}
		}

		if (!mSettings.columns) {
			mSettings.columns = [];

			var aColumns = this.getColumns();
			for (var i = 0, l = aColumns.length; i < l; i++) {
				var oColumn = aColumns[i];
				if (oColumn.getSortProperty()) {
					mSettings.columns.push({
						name: oColumn.getLabel().getText(),
						template: {
							content: {
								path: oColumn.getSortProperty(),
								model: sModelName
							}
						}
					});
				}
			}
		}

		var oExport = new sap.ui.core.util.Export(mSettings);
		this.addDependent(oExport);

		return oExport;
	};

	/**
	 * internal function to calculate the widest content width of the column
	 * also takes the column header and potential icons into account
	 * @param {int} iColIndex index of the column which should be resized
	 * @return {int} minWidth minimum width the column needs to have
	 * @private
	 * @experimental Experimental, only works with a limited control set
	 * @function
	 */

	Table.prototype._calculateAutomaticColumnWidth = function(iColIndex) {

		var aTextBasedControls = [
			"sap.m.Text",
			"sap.m.Label",
			"sap.m.Link",
			"sap.ui.commons.TextView",
			"sap.ui.commons.Label",
			"sap.ui.commons.Link"
		];

		var $this = this.$();
		var iHeaderWidth = 0;

		var $cols = $this.find('td[headers=\"' + this.getId() + '_col' + iColIndex + '\"]').children("div");
		var oColumns = this.getColumns();
		var oCol = oColumns[iColIndex];
		if (!oCol) {
			return null;
		}
		var aHeaderSpan = oCol.getHeaderSpan();
		var oColLabel = oCol.getLabel();
		var that = this;

		var oColTemplate = oCol.getTemplate();
		var bIsTextBased = jQuery.inArray(oColTemplate.getMetadata().getName(), aTextBasedControls) != -1 ||
		                   sap.ui.commons && sap.ui.commons.TextField && oColTemplate instanceof sap.ui.commons.TextField ||
		                   sap.m && sap.m.Input && oColTemplate instanceof sap.m.Input;

		var hiddenSizeDetector = document.createElement("div");
		document.body.appendChild(hiddenSizeDetector);
		jQuery(hiddenSizeDetector).addClass("sapUiTableHiddenSizeDetector");

		var oColLabels = oCol.getMultiLabels();
		if (oColLabels.length == 0 && !!oColLabel){
			oColLabels = [oColLabel];
		}

		if (oColLabels.length > 0) {
			jQuery.each(oColLabels, function(iIdx, oLabel){
				var iHeaderSpan;
				if (!!oLabel.getText()){
					jQuery(hiddenSizeDetector).text(oLabel.getText());
					iHeaderWidth = hiddenSizeDetector.scrollWidth;
				} else {
					iHeaderWidth = oLabel.$().scrollWidth;
				}
				iHeaderWidth = iHeaderWidth + $this.find("#" + oCol.getId() + "-icons").first().width();

				$this.find(".sapUiTableColIcons#" + oCol.getId() + "_" + iIdx + "-icons").first().width();
				if (aHeaderSpan instanceof Array && aHeaderSpan[iIdx] > 1){
					iHeaderSpan = aHeaderSpan[iIdx];
				} else if (aHeaderSpan > 1){
					iHeaderSpan = aHeaderSpan;
				}
				if (!!iHeaderSpan){
					// we have a header span, so we need to distribute the width of this header label over more than one column
					//get the width of the other columns and subtract from the minwidth required from label side
					var i = iHeaderSpan - 1;
					while (i > iColIndex) {
						iHeaderWidth = iHeaderWidth - (that._oCalcColumnWidths[iColIndex + i] || 0);
						i -= 1;
					}
				}
			});
		}

		var minAddWidth = Math.max.apply(null, $cols.map(
			function(){
				var _$this = jQuery(this);
				return parseInt(_$this.css('padding-left'), 10) + parseInt(_$this.css('padding-right'), 10)
						+ parseInt(_$this.css('margin-left'), 10) + parseInt(_$this.css('margin-right'), 10);
			}).get());

		//get the max width of the currently displayed cells in this column
		var minWidth = Math.max.apply(null, $cols.children().map(
			function() {
				var width = 0,
				sWidth = 0;
				var _$this = jQuery(this);
				var sColText = _$this.text() || _$this.val();

				if (bIsTextBased){
					jQuery(hiddenSizeDetector).text(sColText);
					sWidth = hiddenSizeDetector.scrollWidth;
				} else {
					sWidth = this.scrollWidth;
				}
				if (iHeaderWidth > sWidth){
					sWidth = iHeaderWidth;
				}
				width = sWidth + parseInt(_$this.css('margin-left'), 10)
										+ parseInt(_$this.css('margin-right'), 10)
										+ minAddWidth
										+ 1; // ellipsis is still displayed if there is an equality of the div's width and the table column
				return width;
			}).get());

		jQuery(hiddenSizeDetector).remove();
		return (minWidth > this._iColMinWidth) ? minWidth : this._iColMinWidth;
	};

	Table.prototype._onPersoApplied = function() {

		// apply the sorter and filter again (right now only the first sorter is applied)
		var aColumns = this.getColumns();
		var aSorters = [];//, aFilters = [];
		for (var i = 0, l = aColumns.length; i < l; i++) {
			var oColumn = aColumns[i];
			if (oColumn.getSorted()) {
				aSorters.push(new sap.ui.model.Sorter(oColumn.getSortProperty(), oColumn.getSortOrder() === sap.ui.table.SortOrder.Descending));
			/*
			} else if (oColumn.getFiltered()) {
				aFilters.push(oColumn._getFilter());
			*/
			}
		}

		if (aSorters.length > 0 && this.getBinding("rows")) {
			this.getBinding("rows").sort(aSorters);
		}
		/*
		if (aFilters.length > 0 && this.getBinding("rows")) {
			this.getBinding("rows").filter(aFilters);
		}
		*/

		this.refreshRows();

	};

	/**
	 * Toggles the selection state of all cells.
	 * @private
	 */
	Table.prototype._toggleSelectAll = function() {
		
		if (!this.$("selall").hasClass("sapUiTableSelAll")) { //this._getSelectableRowCount() === this.getSelectedIndices().length) {
			this.clearSelection();
		} else {
			this.selectAll();
		}
		if (!!sap.ui.Device.browser.internet_explorer) {
			this.$("selall").focus();
		}
	};

	Table.prototype._restoreAppDefaultsColumnHeaderSortFilter = function () {
		var aColumns = this.getColumns();
		jQuery.each(aColumns, function(iIndex, oColumn){
			oColumn._restoreAppDefaults();
		});
	};

	Table.prototype._setBusy = function (mParameters) {
		var oBinding,
			i,
			bSetBusy;

		if (!this.getEnableBusyIndicator() || !this._bBusyIndicatorAllowed) {
			return;
		}

		oBinding = this.getBinding("rows");
		if (!oBinding) {
			return;
		}

		if (mParameters) {
			if (mParameters.contexts && mParameters.contexts.length !== undefined) {
				// TreeBinding and AnalyticalBinding always return a contexts array with the
				// requested length. Both put undefined in it for contexts which need to be loaded
				// Check for undefined in the contexts array.
				bSetBusy = false;
				for (i = 0; i < mParameters.contexts.length; i++) {
					if (mParameters.contexts[i] === undefined) {
						bSetBusy = true;
						break;
					}
				}
			}

			if (bSetBusy || oBinding.isInitial() || oBinding._bInitial ||
				(mParameters.requestedLength !== mParameters.receivedLength && oBinding.getLength() > 0 && mParameters.receivedLength !== oBinding.getLength())) {
				this.setBusy(true);
			}
		} else {
			this.setBusy(false);
		}
	};

	Table.prototype.setColumnHeaderVisible = function(bColumnHeaderVisible) {
		this.setProperty("columnHeaderVisible", bColumnHeaderVisible);
		// Adapt the item navigation. Since the HeaderRowCount changed, also the lastSelectedDataRow changes.
		this._iLastSelectedDataRow = this._getHeaderRowCount();

	};

	return Table;

}, /* bExport= */ true);

}; // end of sap/ui/table/Table.js
if ( !jQuery.sap.isDeclared('sap.ui.table.TreeTable') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides control sap.ui.table.TreeTable.
jQuery.sap.declare('sap.ui.table.TreeTable'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
jQuery.sap.require('sap.ui.model.odata.ODataTreeBindingAdapter'); // unlisted dependency retained
sap.ui.define("sap/ui/table/TreeTable",['jquery.sap.global', './Table', 'sap/ui/model/odata/ODataTreeBindingAdapter', './library'],
	function(jQuery, Table, ODataTreeBindingAdapter, library) {
	"use strict";



	/**
	 * Constructor for a new TreeTable.
	 *
	 * @param {string} [sId] id for the new control, generated automatically if no id is given
	 * @param {object} [mSettings] initial settings for the new control
	 *
	 * @class
	 * The TreeTable Control.
	 * @extends sap.ui.table.Table
	 * @version 1.28.10
	 *
	 * @constructor
	 * @public
	 * @alias sap.ui.table.TreeTable
	 * @ui5-metamodel This control/element also will be described in the UI5 (legacy) designtime metamodel
	 */
	var TreeTable = Table.extend("sap.ui.table.TreeTable", /** @lends sap.ui.table.TreeTable.prototype */ { metadata : {

		library : "sap.ui.table",
		properties : {

			/**
			 * Flag to enable or disable expanding of first level.
			 */
			expandFirstLevel : {type : "boolean", defaultValue : false},

			/**
			 * If group mode is enable nodes with subitems are rendered as if they were group headers.
			 * This can be used to do the grouping for an OData service on the backend and visualize this in a table.
			 * This mode only makes sense if the tree has a depth of exacly 1 (group headers and entries)
			 */
			useGroupMode : {type : "boolean", group : "Appearance", defaultValue : false},

			/**
			 * The property name of the rows data which will be displayed as a group header if the group mode is enabled
			 */
			groupHeaderProperty : {type : "string", group : "Data", defaultValue : null},
			
			/**
			 * Setting collapseRecursive to true means, that when collapsing a node all subsequent child nodes will also be collapsed.
			 * This property is only supported with sap.ui.model.odata.v2.ODataModel
			 */
			collapseRecursive : {type: "boolean", defaultValue: true},
			
			/**
			 * The root level is the level of the topmost tree nodes, which will be used as an entry point for OData services.
			 * This property is only supported when the TreeTable uses an underlying odata services with hierarchy annotations.
			 * This property is only supported with sap.ui.model.odata.v2.ODataModel
			 * The hierarchy annotations may also be provided locally as a parameter for the ODataTreeBinding.
			 */
			rootLevel : {type: "int", group: "Data", defaultValue: 0}
		},
		events : {

			/**
			 * fired when a node has been expanded or collapsed (only available in hierachical mode)
			 */
			toggleOpenState : {
				parameters : {

					/**
					 * index of the expanded/collapsed row
					 */
					rowIndex : {type : "int"},

					/**
					 * binding context of the selected row
					 */
					rowContext : {type : "object"},

					/**
					 * flag whether the node has been expanded or collapsed
					 */
					expanded : {type : "boolean"}
				}
			}
		}
	}});


	/**
	 * Initialization of the TreeTable control
	 * @private
	 */
	TreeTable.prototype.init = function() {
		Table.prototype.init.apply(this, arguments);
		this._iLastFixedColIndex = 0;

		// adopting properties and load icon fonts for bluecrystal
		if (sap.ui.getCore().getConfiguration().getTheme() === "sap_bluecrystal" ||
			sap.ui.getCore().getConfiguration().getTheme() === "sap_hcb") {

			// add the icon fonts
			jQuery.sap.require("sap.ui.core.IconPool");
			sap.ui.core.IconPool.insertFontFaceStyle();

			// defaulting the rowHeight
			// this.setRowHeight(32); --> is done via CSS

		}
	};

	TreeTable.prototype.bindRows = function(oBindingInfo, vTemplate, oSorter, aFilters) {
		var sPath,
			oTemplate,
			aSorters,
			aFilters;

		// Old API compatibility (sName, sPath, oTemplate, oSorter, aFilters)
		if (typeof oBindingInfo == "string") {
			sPath = arguments[0];
			oTemplate = arguments[1];
			aSorters = arguments[2];
			aFilters = arguments[3];
			oBindingInfo = {path: sPath, sorter: aSorters, filters: aFilters, template: oTemplate};
		}
		
		if (typeof oBindingInfo === "object") {
			oBindingInfo.parameters = oBindingInfo.parameters || {};
			oBindingInfo.parameters.rootLevel = this.getRootLevel();
			oBindingInfo.parameters.collapseRecursive = this.getCollapseRecursive();
			// number of expanded levels is taken from the binding parameters first,
			// if not found, we check if they are set on the table
			oBindingInfo.parameters.numberOfExpandedLevels = oBindingInfo.parameters.numberOfExpandedLevels || (this.getExpandFirstLevel() ? 1 : 0);
			oBindingInfo.parameters.rootNodeID = oBindingInfo.parameters.rootNodeID;
		}
		
		//Table.prototype.bindRows.call(this, oBindingInfo, vTemplate, oSorter, aFilters);
		return this.bindAggregation("rows", oBindingInfo);
	};
	
	/**
	 * refresh rows
	 * @private
	 */
	TreeTable.prototype.refreshRows = function(sReason) {
		this._bBusyIndicatorAllowed = true;
		var oBinding = this.getBinding("rows");
		if (oBinding && this.isTreeBinding("rows") && !oBinding.hasListeners("selectionChanged")) {
			oBinding.attachSelectionChanged(this._onSelectionChanged, this);
		}
		
		//needs to be called here to reset the firstVisible row so that the correct data is fetched
		this._bRefreshing = true;
		this._onBindingChange(sReason);
		this._updateBindingContexts(true);
		//this.getBinding()._init();
		this._bRefreshing = false;
	};
	
	/**
	 * Setter for property <code>fixedRowCount</code>.
	 *
	 * <b>This property is not supportd for the TreeTable and will be ignored!</b>
	 *
	 * Default value is <code>0</code>
	 *
	 * @param {int} iFixedRowCount  new value for property <code>fixedRowCount</code>
	 * @return {sap.ui.table.TreeTable} <code>this</code> to allow method chaining
	 * @public
	 */
	TreeTable.prototype.setFixedRowCount = function(iRowCount) {
		// this property makes no sense for the TreeTable
		jQuery.sap.log.warning("TreeTable: the property \"fixedRowCount\" is not supported and will be ignored!");
		return this;
	};


	/**
	 * Rerendering handling
	 * @private
	 */
	TreeTable.prototype.onAfterRendering = function() {
		Table.prototype.onAfterRendering.apply(this, arguments);
		this.$().find("[role=grid]").attr("role", "treegrid");
	};

	TreeTable.prototype.isTreeBinding = function(sName) {
		sName = sName || "rows";
		if (sName === "rows") {
			return true;
		}
		return sap.ui.core.Element.prototype.isTreeBinding.apply(this, arguments);
	};

	TreeTable.prototype.getBinding = function(sName) {
		sName = sName || "rows";
		var oBinding = sap.ui.core.Element.prototype.getBinding.call(this, sName);
		
		// the check for the tree binding is only relevant becuase of the DataTable migration
		//  --> once the DataTable is deleted after the deprecation period this check can be deleted
		if (oBinding && this.isTreeBinding(sName) && sName === "rows" && !oBinding.getLength) {
			
			if (oBinding instanceof sap.ui.model.ClientTreeBinding || oBinding.getModel() instanceof sap.ui.model.odata.ODataModel) {
				// Code necessary for ClientTreeBinding
				var that = this;
				jQuery.extend(oBinding, {
					_init: function(bExpandFirstLevel) {
						this._bExpandFirstLevel = bExpandFirstLevel;
						// load the root contexts and create the context info map
						this.mContextInfo = {};
						this._initContexts();
						// expand the first level if required
						if (bExpandFirstLevel && !this._bFirstLevelExpanded) {
							this._expandFirstLevel();
						}
					},
	
					_initContexts: function(bSkipFirstLevelLoad) {
						// load the root contexts and create the context info map entry (if missing)
						this.aContexts = this.getRootContexts();
						for (var i = 0, l = this.aContexts.length; i < l; i++) {
							var oldContextInfo = this._getContextInfo(this.aContexts[i]);
							this._setContextInfo({
								oContext: this.aContexts[i],
								iLevel: 0,
								bExpanded: oldContextInfo ? oldContextInfo.bExpanded : false
							});
						}
	
						if (this._bExpandFirstLevel && !this._bFirstLevelExpanded) {
							this._expandFirstLevel(bSkipFirstLevelLoad);
						}
					},
	
					_expandFirstLevel: function (bSkipFirstLevelLoad) {
						var that = this;
						if (this.aContexts && this.aContexts.length > 0) {
							jQuery.each(this.aContexts.slice(), function(iIndex, oContext) {
								if (!bSkipFirstLevelLoad) {
									that._loadChildContexts(oContext);
								}
								that._getContextInfo(oContext).bExpanded = true;
							});
	
							this._bFirstLevelExpanded = true;
						}
					},
	
					_fnFireFilter: oBinding._fireFilter,
					_fireFilter: function() {
						this._fnFireFilter.apply(this, arguments);
						this._initContexts(true);
						this._restoreContexts(this.aContexts);
					},
					_fnFireChange: oBinding._fireChange,
					_fireChange: function() {
						this._fnFireChange.apply(this, arguments);
						this._initContexts(true);
						this._restoreContexts(this.aContexts);
					},
					_restoreContexts: function(aContexts) {
						var that = this;
						var aNewChildContexts = [];
						jQuery.each(aContexts.slice(), function(iIndex, oContext) {
							var oContextInfo = that._getContextInfo(oContext);
							if (oContextInfo && oContextInfo.bExpanded) {
								aNewChildContexts.push.apply(aNewChildContexts, that._loadChildContexts(oContext));
							}
						});
						if (aNewChildContexts.length > 0) {
							this._restoreContexts(aNewChildContexts);
						}
					},
					_loadChildContexts: function(oContext) {
						var oContextInfo = this._getContextInfo(oContext);
						var iIndex = jQuery.inArray(oContext, this.aContexts);
						var aNodeContexts = this.getNodeContexts(oContext);
						for (var i = 0, l = aNodeContexts.length; i < l; i++) {
							this.aContexts.splice(iIndex + i + 1, 0, aNodeContexts[i]);
							var oldContextInfo = this._getContextInfo(aNodeContexts[i]);
							this._setContextInfo({
								oParentContext: oContext,
								oContext: aNodeContexts[i],
								iLevel: oContextInfo.iLevel + 1,
								bExpanded: oldContextInfo ? oldContextInfo.bExpanded : false
							});
						}
						return aNodeContexts;
					},
					_getContextInfo: function(oContext) {
						return oContext ? this.mContextInfo[oContext.getPath()] : undefined;
					},
					_setContextInfo: function(mData) {
						if (mData && mData.oContext) {
							this.mContextInfo[mData.oContext.getPath()] = mData;
						}
					},
					getLength: function() {
						return this.aContexts ? this.aContexts.length : 0;
					},
					getContexts: function(iStartIndex, iLength) {
						return this.aContexts.slice(iStartIndex, iStartIndex + iLength);
					},
					getContextByIndex: function (iRowIndex) {
						return this.aContexts[iRowIndex];
					},
					getLevel: function(oContext) {
						var oContextInfo = this._getContextInfo(oContext);
						return oContextInfo ? oContextInfo.iLevel : -1;
					},
					isExpanded: function(iRowIndex) {
						var oContext = this.getContextByIndex(iRowIndex); 
						var oContextInfo = this._getContextInfo(oContext);
						return oContextInfo ? oContextInfo.bExpanded : false;
					},
					expandContext: function(oContext) {
						var oContextInfo = this._getContextInfo(oContext);
						if (oContextInfo && !oContextInfo.bExpanded) {
							this.storeSelection();
							this._loadChildContexts(oContext);
							oContextInfo.bExpanded = true;
							this._fireChange();
							this.restoreSelection();
						}
					},
					expand: function (iRowIndex) {
						this.expandContext(this.getContextByIndex(iRowIndex));
					},
					collapseContext: function(oContext, bSupressChanges) {
						var oContextInfo = this._getContextInfo(oContext);
						if (oContextInfo && oContextInfo.bExpanded) {
							this.storeSelection();
							for (var i = this.aContexts.length - 1; i > 0; i--) {
								if (this._getContextInfo(this.aContexts[i]).oParentContext === oContext) {
									this.aContexts.splice(i, 1);
								}
							}
							oContextInfo.bExpanded = false;
							if (!bSupressChanges) {
								this._fireChange();
							}
							this.restoreSelection();
						}
					},
					collapse: function (iRowIndex) {
						this.collapseContext(this.getContextByIndex(iRowIndex));
					},
					collapseToLevel: function (iLevel) {
						if (!iLevel || iLevel < 0) {
							iLevel = 0;
						}
						
						var aContextsCopy = this.aContexts.slice();
						for (var i = aContextsCopy.length - 1; i >= 0; i--) {
							var iContextLevel = this.getLevel(aContextsCopy[i]);
							if (iContextLevel != -1 && iContextLevel >= iLevel) {
								this.collapseContext(aContextsCopy[i], true);
							}
						}
						
						this._fireChange();
					},
					toggleContext: function(oContext) {
						var oContextInfo = this._getContextInfo(oContext);
						if (oContextInfo) {
							if (oContextInfo.bExpanded) {
								this.collapseContext(oContext);
							} else {
								this.expandContext(oContext);
							}
						}
					},
					toggleIndex: function (iRowIndex) {
						this.toggleContext(this.getContextByIndex(iRowIndex));
					},
					storeSelection: function() {
						var aSelectedIndices = that.getSelectedIndices();
						var aSelectedContexts = [];
						jQuery.each(aSelectedIndices, function(iIndex, iValue) {
							aSelectedContexts.push(that.getContextByIndex(iValue));
						});
						this._aSelectedContexts = aSelectedContexts;
					},
					restoreSelection: function() {
						that.clearSelection();
						var _aSelectedContexts = this._aSelectedContexts;
						jQuery.each(this.aContexts, function(iIndex, oContext) {
							if (jQuery.inArray(oContext, _aSelectedContexts) >= 0) {
								that.addSelectionInterval(iIndex, iIndex);
							}
						});
						this._aSelectedContexts = undefined;
					},
					attachSelectionChanged: function() {
						// for compatibility reasons (OData Tree Binding)
						return undefined;
					},
					attachSort: function() {},
					detachSort: function() {}
				});
				// initialize the binding
				oBinding._init(this.getExpandFirstLevel());
			
			} else {
				//Use the ODataTreeBindingAdapter to enhance the TreeBinding with a ListBinding API
				ODataTreeBindingAdapter.apply(oBinding);
			}
		}
		
		return oBinding;
	};

	TreeTable.prototype._updateTableContent = function() {
		Table.prototype._updateTableContent.apply(this, arguments);

		if (!this.getUseGroupMode()) {
			return;
		}

		//If group mode is enabled nodes which have children are visualized as if they were group header
		var oBinding = this.getBinding("rows"),
			iFirstRow = this.getFirstVisibleRow(),
			iCount = this.getVisibleRowCount();

		for (var iRow = 0; iRow < iCount; iRow++) {
			var oContext = this.getContextByIndex(iFirstRow + iRow),
				$row = this.getRows()[iRow].$(),
				$rowHdr = this.$().find("div[data-sap-ui-rowindex='" + $row.attr("data-sap-ui-rowindex") + "']");

			if (oBinding.hasChildren && oBinding.hasChildren(oContext)) {
				// modify the rows
				$row.addClass("sapUiTableGroupHeader sapUiTableRowHidden");
				var sClass = oBinding.isExpanded(iFirstRow + iRow) ? "sapUiTableGroupIconOpen" : "sapUiTableGroupIconClosed";
				$rowHdr.html("<div class=\"sapUiTableGroupIcon " + sClass + "\" tabindex=\"-1\">" + this.getModel().getProperty(this.getGroupHeaderProperty(), oContext) + "</div>");
				$rowHdr.addClass("sapUiTableGroupHeader").removeAttr("title");
			} else {
				$row.removeClass("sapUiTableGroupHeader");
				if (oContext) {
					$row.removeClass("sapUiTableRowHidden");
				}
				$rowHdr.html("");
				$rowHdr.removeClass("sapUiTableGroupHeader");
			}
		}
	};

	TreeTable.prototype._updateTableCell = function(oCell, oContext, oTD, iAbsoluteRowIndex) {

		var oBinding = this.getBinding("rows");

		if (oBinding) {
			var iLevel = 0,
				bIsExpanded = false;
			
			if (oBinding.getLevel) {
				//used by the "mini-adapter" in the TreeTable ClientTreeBindings
				iLevel = oBinding.getLevel(oContext);
				bIsExpanded = oBinding.isExpanded(iAbsoluteRowIndex);
			} else if (oBinding.findNode) { // the ODataTreebinding(Adapter) provides the hasChildren method for Tree
				var oNode = oBinding.findNode(iAbsoluteRowIndex);
				iLevel = oNode ? oNode.level : 0;
				bIsExpanded = oNode && oNode.nodeState ? oNode.nodeState.expanded : false;
			}
			
			var $row;
			// in case of fixed columns we need to lookup the fixed table
			// otherwise the expand/collapse/margin will not be set!
			if (this.getFixedColumnCount() > 0) {
				$row = oCell.getParent().$("fixed");
			} else {
				$row = oCell.getParent().$();
			}
			var $TreeIcon = $row.find(".sapUiTableTreeIcon");
			var sTreeIconClass = "sapUiTableTreeIconLeaf";
			if (!this.getUseGroupMode()) {
				$TreeIcon.css("marginLeft", iLevel * 17);
			}
			if (oBinding.hasChildren && oBinding.hasChildren(oContext)) {
				sTreeIconClass = bIsExpanded ? "sapUiTableTreeIconNodeOpen" : "sapUiTableTreeIconNodeClosed";
				$row.attr('aria-expanded', bIsExpanded);
				var sNodeText = bIsExpanded ? this._oResBundle.getText("TBL_COLLAPSE") : this._oResBundle.getText("TBL_EXPAND");
				$TreeIcon.attr('title', sNodeText);
			} else {
				$row.attr('aria-expanded', false);
				$TreeIcon.attr('aria-label', this._oResBundle.getText("TBL_LEAF"));
			}
			$TreeIcon.removeClass("sapUiTableTreeIconLeaf sapUiTableTreeIconNodeOpen sapUiTableTreeIconNodeClosed").addClass(sTreeIconClass);
			$row.attr("data-sap-ui-level", iLevel);
			$row.attr('aria-level', iLevel + 1);
		}

	};

	TreeTable.prototype.onclick = function(oEvent) {
		if (jQuery(oEvent.target).hasClass("sapUiTableGroupIcon")) {
			this._onGroupSelect(oEvent);
		} else if (jQuery(oEvent.target).hasClass("sapUiTableTreeIcon")) {
			this._onNodeSelect(oEvent);
		} else {
			if (Table.prototype.onclick) {
				Table.prototype.onclick.apply(this, arguments);
			}
		}
	};

	TreeTable.prototype.onsapselect = function(oEvent) {
		if (jQuery(oEvent.target).hasClass("sapUiTableTreeIcon")) {
			this._onNodeSelect(oEvent);
		} else {
			if (Table.prototype.onsapselect) {
				Table.prototype.onsapselect.apply(this, arguments);
			}
		}
	};

	TreeTable.prototype.onkeydown = function(oEvent) {
		Table.prototype.onkeydown.apply(this, arguments);
		var $Target = jQuery(oEvent.target),
			$TargetTD = $Target.closest('td');
		if (oEvent.keyCode == jQuery.sap.KeyCodes.TAB && this._bActionMode && $TargetTD.find('.sapUiTableTreeIcon').length > 0) {
			//If node icon has focus set tab to control else set tab to node icon
			if ($Target.hasClass('sapUiTableTreeIcon')) {
				if (!$Target.hasClass("sapUiTableTreeIconLeaf")) {
					$TargetTD.find(':sapFocusable:not(.sapUiTableTreeIcon)').first().focus();
				}
			} else {
				$TargetTD.find('.sapUiTableTreeIcon:not(.sapUiTableTreeIconLeaf)').focus();
			}
			oEvent.preventDefault();
		}
	};

	TreeTable.prototype._onNodeSelect = function(oEvent) {

		var $parent = jQuery(oEvent.target).parents("tr");
		if ($parent.length > 0) {
			var iRowIndex = this.getFirstVisibleRow() + parseInt($parent.attr("data-sap-ui-rowindex"), 10);
			var oContext = this.getContextByIndex(iRowIndex);
			this.fireToggleOpenState({
				rowIndex: iRowIndex,
				rowContext: oContext,
				expanded: !this.getBinding().isExpanded(iRowIndex)
			});
			//this.getBinding("rows").toggleContext(oContext);
			this.getBinding("rows").toggleIndex(iRowIndex);
		}

		oEvent.preventDefault();
		oEvent.stopPropagation();

	};

	TreeTable.prototype._onGroupSelect = function(oEvent) {

		var $parent = jQuery(oEvent.target).parents("[data-sap-ui-rowindex]");
		if ($parent.length > 0) {
			var iRowIndex = this.getFirstVisibleRow() + parseInt($parent.attr("data-sap-ui-rowindex"), 10);
			var oContext = this.getContextByIndex(iRowIndex);
			if (this.getBinding().isExpanded(iRowIndex)) {
				jQuery(oEvent.target).removeClass("sapUiTableGroupIconOpen").addClass("sapUiTableGroupIconClosed");
			} else {
				jQuery(oEvent.target).removeClass("sapUiTableGroupIconClosed").addClass("sapUiTableGroupIconOpen");
			}
			this.fireToggleOpenState({
				rowIndex: iRowIndex,
				rowContext: oContext,
				expanded: !this.getBinding().isExpanded(iRowIndex)
			});
			//this.getBinding("rows").toggleContext(iRowIndex);
			this.getBinding("rows").toggleIndex(iRowIndex);
		}

		oEvent.preventDefault();
		oEvent.stopPropagation();

	};

	/**
	 * expands the row for the given row index
	 *
	 * @param {int} iRowIndex
	 *         index of the row to expand
	 * @return {sap.ui.table.TreeTable} a reference on the TreeTable control, can be used for chaining
	 * @public
	 * @ui5-metamodel This method also will be described in the UI5 (legacy) designtime metamodel
	 */
	TreeTable.prototype.expand = function(iRowIndex) {
		var oBinding = this.getBinding("rows");
		if (oBinding) {
			oBinding.expand(iRowIndex);
		}
		
		return this;
	};

	/**
	 * collapses the row for the given row index
	 *
	 * @param {int} iRowIndex
	 *         index of the row to collapse
	 * @return {sap.ui.table.TreeTable} a reference on the TreeTable control, can be used for chaining
	 * @public
	 * @ui5-metamodel This method also will be described in the UI5 (legacy) designtime metamodel
	 */
	TreeTable.prototype.collapse = function(iRowIndex) {
		var oBinding = this.getBinding("rows");
		if (oBinding) {
			oBinding.collapse(iRowIndex);
		}
		
		return this;
	};
	
	/**
	 * Collapses all nodes (and lower if collapseRecursive is activated)
	 * 
	 * @return {sap.ui.table.TreeTable} a reference on the TreeTable control, can be used for chaining
	 * @public
	 * @ui5-metamodel This method also will be described in the UI5 (legacy) designtime metamodel
	 */
	TreeTable.prototype.collapseAll = function () {
		var oBinding = this.getBinding("rows");
		if (oBinding) {
			oBinding.collapseToLevel(0);
			this.setFirstVisibleRow(0);
		}
		
		return this;
	};

	/**
	 * Collapses all nodes on level 'iLevel' (and lower if collapseRecursive is activated)
	 * If no parameter is given, all nodes will be collapsed to the topmost level.
	 * 
	 * Only supported with ODataModel v2.
	 * 
	 * @param {int} iLevel the level to which all nodes shall be collapsed
	 * @return {sap.ui.table.TreeTable} a reference on the TreeTable control, can be used for chaining
	 * @public
	 * @ui5-metamodel This method also will be described in the UI5 (legacy) designtime metamodel
	 */
	TreeTable.prototype.expandToLevel = function (iLevel) {
		var oBinding = this.getBinding("rows");
		
		jQuery.sap.assert(oBinding && oBinding.expandToLevel, "TreeTable.expandToLevel is not supported with your current Binding. Please check if you are running on an ODataModel V2.");
		
		if (oBinding && oBinding.expandToLevel) {
			oBinding.expandToLevel(iLevel);
		}
		
		return this;
	};
	
	/**
	 * Returns whether the row is expanded or collapsed.
	 *
	 * @param {int} iRowIndex index of the row to check
	 * @return {boolean} true if the node at "iRowIndex" is expanded, false otherwise (meaning it is collapsed)
	 * @public
	 * @ui5-metamodel This method also will be described in the UI5 (legacy) designtime metamodel
	 */
	TreeTable.prototype.isExpanded = function(iRowIndex) {
		var oBinding = this.getBinding("rows");
		if (oBinding) {
			return oBinding.isExpanded(iRowIndex);
		}
		return false;
	};

	/**
	 * Checks if the row at the given index is selected.
	 * 
	 * @param {int} iRowIndex The row index for which the selection state should be retrieved
	 * @return {boolean} true if the index is selected, false otherwise
	 * @public
	 * @ui5-metamodel This method also will be described in the UI5 (legacy) designtime metamodel
	 */
	TreeTable.prototype.isIndexSelected = function (iRowIndex) {
		var oBinding = this.getBinding("rows");
		//when using the treebindingadapter, check if the node is selected
		if (oBinding && oBinding.findNode) {
			var oNode = oBinding.findNode(iRowIndex);
			return oNode && oNode.nodeState && oNode.nodeState.selected;
		} else {
			return Table.prototype.isIndexSelected.call(this, iRowIndex);
		}
	};
	
	/**
	 * Overriden from Table.js base class.
	 * In a TreeTable you can only select indices, which correspond to the currently visualized tree.
	 * Invisible tree nodes (e.g. collapsed child nodes) can not be selected via Index, because they do not
	 * correspond to a TreeTable row.
	 * 
	 * @param {int} iRowIndex The row index which will be selected (if existing)
	 * @return {sap.ui.table.TreeTable} a reference on the TreeTable control, can be used for chaining
	 * @public
	 * @ui5-metamodel This method also will be described in the UI5 (legacy) designtime metamodel
	 */
	TreeTable.prototype.setSelectedIndex = function (iRowIndex) {
		if (iRowIndex === -1) {
			//If Index eq -1 no item is selected, therefore clear selection is called
			//SelectionModel doesn't know that -1 means no selection
			this.clearSelection();
		}
		
		//when using the treebindingadapter, check if the node is selected
		var oBinding = this.getBinding("rows");
		
		if (oBinding && oBinding.findNode && oBinding.setNodeSelection) {
			// set the found node as selected
			oBinding.setSelectedIndex(iRowIndex);
			//this.fireEvent("selectionChanged");
		} else {
			Table.prototype.setSelectedIndex.call(this, iRowIndex);
		}
		return this;
	};
	
	/**
	 * Returns an array containing the row indices of all selected tree nodes (ordered ascending).
	 * 
	 * Please be aware of the following:
	 * Due to performance/network traffic reasons, the getSelectedIndices function returns only all indices
	 * of actually selected rows/tree nodes. Unknown rows/nodes (as in "not yet loaded" to the client), will not be
	 * returned.
	 * 
	 * @return {int[]} an array containing all selected indices
	 * @public
	 * @ui5-metamodel This method also will be described in the UI5 (legacy) designtime metamodel
	 */
	TreeTable.prototype.getSelectedIndices = function () {
		//when using the treebindingadapter, check if the node is selected
		var oBinding = this.getBinding("rows");
		
		if (oBinding && oBinding.findNode && oBinding.getSelectedIndices) {
			/*jQuery.sap.log.warning("When using a TreeTable on a V2 ODataModel, you can also use 'getSelectedContexts' on the underlying TreeBinding," + 
					" for an optimised retrieval of the binding contexts of the all selected rows/nodes.");*/
			return oBinding.getSelectedIndices();
		} else {
			return Table.prototype.getSelectedIndices.call(this);
		}
	};
	
	/**
	 * Sets the selection of the TreeTable to the given range (including boundaries).
	 * Beware: The previous selection will be lost/overriden. If this is not wanted, please use "addSelectionInterval" and
	 * "removeSelectionIntervall".
	 * 
	 * @param {int} iFromIndex the start index of the selection range
	 * @param {int} iToIndex the end index of the selection range
	 * @return {sap.ui.table.TreeTable} a reference on the TreeTable control, can be used for chaining
	 * @public
	 * @ui5-metamodel This method also will be described in the UI5 (legacy) designtime metamodel
	 */
	TreeTable.prototype.setSelectionInterval = function (iFromIndex, iToIndex) {
		//when using the treebindingadapter, check if the node is selected
		var oBinding = this.getBinding("rows");
		
		if (oBinding && oBinding.findNode && oBinding.setSelectionInterval) {
			oBinding.setSelectionInterval(iFromIndex, iToIndex);
		} else {
			Table.prototype.setSelectionInterval.call(this, iFromIndex, iToIndex);
		}
		
		return this;
	};
	
	/**
	 * Marks a range of tree nodes as selected, starting with iFromIndex going to iToIndex.
	 * The TreeNodes are referenced via their absolute row index.
	 * Please be aware, that the absolute row index only applies to the the tree which is visualized by the TreeTable.
	 * Invisible nodes (collapsed child nodes) will not be regarded.
	 * 
	 * Please also take notice of the fact, that "addSelectionInterval" does not change any other selection.
	 * To override the current selection, please use "setSelctionInterval" or for a single entry use "setSelectedIndex".
	 * 
	 * @param {int} iFromIndex The starting index of the range which will be selected.
	 * @param {int} iToIndex The starting index of the range which will be selected.
	 * @return {sap.ui.table.TreeTable} a reference on the TreeTable control, can be used for chaining
	 * @public
	 * @ui5-metamodel This method also will be described in the UI5 (legacy) designtime metamodel
	 */
	TreeTable.prototype.addSelectionInterval = function (iFromIndex, iToIndex) {
		var oBinding = this.getBinding("rows");
		//TBA check
		if (oBinding && oBinding.findNode && oBinding.addSelectionInterval) {
			oBinding.addSelectionInterval(iFromIndex, iToIndex);
		} else {
			Table.prototype.addSelectionInterval.call(this, iFromIndex, iToIndex);
		}
		return this;
	};
	
	/**
	 * All rows/tree nodes inside the range (including boundaries) will be deselected.
	 * Tree nodes are referenced with theit absolute row index inside the tree- 
	 * Please be aware, that the absolute row index only applies to the the tree which is visualized by the TreeTable.
	 * Invisible nodes (collapsed child nodes) will not be regarded.
	 * 
	 * @param {int} iFromIndex The starting index of the range which will be deselected.
	 * @param {int} iToIndex The starting index of the range which will be deselected.
	 * @return {sap.ui.table.TreeTable} a reference on the TreeTable control, can be used for chaining
	 * @public
	 * @ui5-metamodel This method also will be described in the UI5 (legacy) designtime metamodel
	 */
	TreeTable.prototype.removeSelectionInterval = function (iFromIndex, iToIndex) {
		var oBinding = this.getBinding("rows");
		//TBA check
		if (oBinding && oBinding.findNode && oBinding.removeSelectionInterval) {
			oBinding.removeSelectionInterval(iFromIndex, iToIndex);
		} else {
			Table.prototype.removeSelectionInterval.call(this, iFromIndex, iToIndex);
		}
		return this;
	};
	
	/**
	 * Selects all available nodes/rows.
	 * 
	 * Explanation of the SelectAll function and what to expect from its behavior:
	 * All rows/tree nodes locally stored on the client are selected.
	 * In addition all subsequent rows/tree nodes, which will be paged into view are also immediatly selected.
	 * However, due to obvious performance/network traffic reasons, the SelectAll function will NOT retrieve any data from the backend.
	 * 
	 * @return {sap.ui.table.TreeTable} a reference on the TreeTable control, can be used for chaining
	 * @public
	 * @ui5-metamodel This method also will be described in the UI5 (legacy) designtime metamodel
	 */
	TreeTable.prototype.selectAll = function () {
		//select all is only allowed when SelectionMode is "Multi" or "MultiToggle"
		var oSelMode = this.getSelectionMode();
		if (!this.getEnableSelectAll() || (oSelMode != "Multi" && oSelMode != "MultiToggle")) {
			return this;
		}
		
		//The OData TBA exposes a selectAll function
		var oBinding = this.getBinding("rows");
		if (oBinding.selectAll) {
			oBinding.selectAll();
			this.$("selall").attr('title',this._oResBundle.getText("TBL_DESELECT_ALL")).removeClass("sapUiTableSelAll");
		} else {
			//otherwise fallback on the tables own function
			Table.prototype.selectAll.call(this);
		}

		return this;
	};
	
	/**
	 * Retrieves the lead selection index. The lead selection index is, among other things, used to determine the
	 * start/end of a selection range, when using Shift-Click to select multiple entries at once. 
	 * 
	 * @return {int[]} an array containing all selected indices (ascending ordered integers)
	 * @public
	 * @ui5-metamodel This method also will be described in the UI5 (legacy) designtime metamodel
	 */
	TreeTable.prototype.getSelectedIndex = function() {
		//when using the treebindingadapter, check if the node is selected
		var oBinding = this.getBinding("rows");
		
		if (oBinding && oBinding.findNode) {
			return oBinding.getSelectedIndex();
		} else {
			return Table.prototype.getSelectedIndex.call(this);
		}
	};
	
	/**
	 * Clears the complete selection (all tree table rows/nodes will lose their selection)
	 * 
	 * @return {sap.ui.table.TreeTable} a reference on the TreeTable control, can be used for chaining
	 * @public
	 * @ui5-metamodel This method also will be described in the UI5 (legacy) designtime metamodel
	 */
	TreeTable.prototype.clearSelection = function () {
		var oBinding = this.getBinding("rows");
		
		if (oBinding && oBinding.clearSelection) {
			oBinding.clearSelection();
		} else {
			Table.prototype.clearSelection.call(this);
		}
		
		return this;
	};
	
	TreeTable.prototype._enterActionMode = function($Tabbable) {
		var $domRef = $Tabbable.eq(0);

		Table.prototype._enterActionMode.apply(this, arguments);
		if ($Tabbable.length > 0 && $domRef.hasClass("sapUiTableTreeIcon") && !$domRef.hasClass("sapUiTableTreeIconLeaf")) {
			//Set tabindex to 0 to have make node icon accessible
			$domRef.attr("tabindex", 0).focus();
			//set action mode to true so that _leaveActionMode is called to remove the tabindex again
			this._bActionMode = true;
		}
	};

	TreeTable.prototype._leaveActionMode = function(oEvent) {
		Table.prototype._leaveActionMode.apply(this, arguments);
		this.$().find(".sapUiTableTreeIcon").attr("tabindex", -1);
	};

	TreeTable.prototype.getContextByIndex = function (iRowIndex) {
		var oBinding = this.getBinding("rows");
		if (oBinding) {
			return oBinding.getContextByIndex(iRowIndex);
		}
	};

	/**
	 * Set the rootLevel for the hierarchy
	 * The root level is the level of the topmost tree nodes, which will be used as an entry point for OData services.
	 * This setting has only effect when the binding is already initialized.
	 * @param {int} iRootLevel
	 * @returns {TreeTable}
	 */
	TreeTable.prototype.setRootLevel = function(iRootLevel) {
		this.setFirstVisibleRow(0);
		
		var oBinding = this.getBinding("rows");
		if (oBinding) {
			jQuery.sap.assert(oBinding.setRootLevel, "rootLevel is not supported by the used binding");
			if (oBinding.setRootLevel) {
				oBinding.setRootLevel(iRootLevel);
			}
		}
		this.setProperty("rootLevel", iRootLevel, true);
		
		return this;
	};

	/**
	 * Sets the node hierarchy to collapse recursive. When set to true, all child nodes will get collapsed as well.
	 * This setting has only effect when the binding is already initialized.
	 * @param {boolean} bCollapseRecursive
	 */
	TreeTable.prototype.setCollapseRecursive = function(bCollapseRecursive) {
		var oBinding = this.getBinding("rows");
		if (oBinding) {
			jQuery.sap.assert(oBinding.setCollapseRecursive, "Collapse Recursive is not supported by the used binding");
			if (oBinding.setCollapseRecursive) {
				oBinding.setCollapseRecursive(bCollapseRecursive);
			}
		}
		this.setProperty("collapseRecursive", !!bCollapseRecursive, true);
		return this;
	};

	return TreeTable;

}, /* bExport= */ true);

}; // end of sap/ui/table/TreeTable.js
if ( !jQuery.sap.isDeclared('sap.ui.table.AnalyticalColumn') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides control sap.ui.table.AnalyticalColumn.
jQuery.sap.declare('sap.ui.table.AnalyticalColumn'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
sap.ui.define("sap/ui/table/AnalyticalColumn",['jquery.sap.global', './Column', './library'],
	function(jQuery, Column, library) {
	"use strict";



	/**
	 * Constructor for a new AnalyticalColumn.
	 *
	 * @param {string} [sId] id for the new control, generated automatically if no id is given
	 * @param {object} [mSettings] initial settings for the new control
	 *
	 * @class
	 * This column addes additional properties to the tabl ecolumn which are needed for the analytical binding and table
	 * @extends sap.ui.table.Column
	 *
	 * @author SAP SE
	 * @version 1.28.10
	 *
	 * @constructor
	 * @public
	 * @experimental Since version 1.21.
	 * The AnalyticalColumn will be productized soon. Some attributes will be added to Column.
	 * @alias sap.ui.table.AnalyticalColumn
	 * @ui5-metamodel This control/element also will be described in the UI5 (legacy) designtime metamodel
	 */
	var AnalyticalColumn = Column.extend("sap.ui.table.AnalyticalColumn", /** @lends sap.ui.table.AnalyticalColumn.prototype */ { metadata : {

		library : "sap.ui.table",
		properties : {

			/**
			 * Defines the primary model property which is used inside the Column. In case of the analytical extension this means the property which is grouped by for dimensions or the property which is summed for measures.
			 */
			leadingProperty : {type : "string", group : "Misc", defaultValue : null},

			/**
			 * If defined a sum for this column is calculated
			 */
			summed : {type : "boolean", group : "Misc", defaultValue : false},

			/**
			 * Specifies that the dimension referred to by the column shall be included in the granularity of the data result. It allows a finer distinction between a visible/grouped/(included)inResult column.
			 */
			inResult : {type : "boolean", group : "Misc", defaultValue : false},

			/**
			 * Specifies whether the column is displayed within the table even if it is grouped or not. A grouped column has the same value for every rows within the group.
			 */
			showIfGrouped : {type : "boolean", group : "Appearance", defaultValue : false},

			/**
			 * If the column is grouped, this formatter is used to format the value in the group header
			 */
			groupHeaderFormatter : {type : "any", group : "Behavior", defaultValue : null}
		}
	}});

	AnalyticalColumn.prototype.init = function() {
		Column.prototype.init.apply(this, arguments);
		this._bSkipUpdateAI = false;
	};

	/**
	 * map of filtertypes for re-use in getFilterType
	 * @private
	 */
	AnalyticalColumn._DEFAULT_FILTERTYPES = {
		"Time": new sap.ui.model.type.Time({UTC: true}),
		"DateTime": new sap.ui.model.type.DateTime({UTC: true}),
		"Float": new sap.ui.model.type.Float(),
		"Integer": new sap.ui.model.type.Integer(),
		"Boolean": new sap.ui.model.type.Boolean()
	};

	/*
	 * Factory method. Creates the column menu.
	 *
	 * @return {sap.ui.table.AnalyticalColumnMenu} The created column menu.
	 */
	AnalyticalColumn.prototype._createMenu = function() {
		jQuery.sap.require("sap.ui.table.AnalyticalColumnMenu");
		return new sap.ui.table.AnalyticalColumnMenu(this.getId() + "-menu");
	};

	AnalyticalColumn.prototype.setGrouped = function(bGrouped) {
		var oParent = this.getParent();
		var that = this;
		if (oParent && oParent instanceof sap.ui.table.AnalyticalTable) {
			if (bGrouped) {
				oParent._addGroupedColumn(this.getId());
			} else {
				oParent._aGroupedColumns = jQuery.grep(oParent._aGroupedColumns, function(value) {
					return value != that.getId();
				});
			}
		}

		var bReturn = this.setProperty("grouped", bGrouped);
		this._updateTableColumnDetails();
		this._updateTableAnalyticalInfo(true);
		return bReturn;
	};

	AnalyticalColumn.prototype.setSummed = function(bSummed) {
		var bReturn = this.setProperty("summed", bSummed, true);
		this._updateTableAnalyticalInfo();
		return bReturn;
	};

	/*
	 * @see JSDoc generated by SAPUI5 control API generator
	 */
	AnalyticalColumn.prototype.setVisible = function(bVisible) {
		Column.prototype.setVisible.apply(this, arguments);
		this._updateTableColumnDetails();
		this._updateTableAnalyticalInfo();
		return this;
	};

	/*
	 * @see JSDoc generated by SAPUI5 control API generator
	 */
	AnalyticalColumn.prototype.getLabel = function() {
		var oLabel = this.getAggregation("label");
		if (!oLabel) {
			if (!this._oBindingLabel) {
				var oParent = this.getParent();
				if (oParent && oParent instanceof sap.ui.table.AnalyticalTable) {
					var oBinding = oParent.getBinding("rows");
					if (oBinding) {
						this._oBindingLabel = sap.ui.table.TableHelper.createLabel({text: oBinding.getPropertyLabel(this.getLeadingProperty())});
					}
				}
			}
			oLabel = this._oBindingLabel;
		}
		return oLabel;
	};

	/*
	 * @see JSDoc generated by SAPUI5 control API generator
	 */
	AnalyticalColumn.prototype.getFilterProperty = function() {
		var sProperty = this.getProperty("filterProperty");
		if (!sProperty) {
			var oParent = this.getParent();
			if (oParent && oParent instanceof sap.ui.table.AnalyticalTable) {
				var oBinding = oParent.getBinding("rows");
				var sLeadingProperty = this.getLeadingProperty();
				if (oBinding && jQuery.inArray(sLeadingProperty, oBinding.getFilterablePropertyNames()) > -1) {
					sProperty = sLeadingProperty;
				}
			}
		}
		return sProperty;
	};

	/*
	 * @see JSDoc generated by SAPUI5 control API generator
	 */
	AnalyticalColumn.prototype.getSortProperty = function() {
		var sProperty = this.getProperty("sortProperty");
		if (!sProperty) {
			var oParent = this.getParent();
			if (oParent && oParent instanceof sap.ui.table.AnalyticalTable) {
				var oBinding = oParent.getBinding("rows");
				var sLeadingProperty = this.getLeadingProperty();
				if (oBinding && jQuery.inArray(sLeadingProperty, oBinding.getSortablePropertyNames()) > -1) {
					sProperty = sLeadingProperty;
				}
			}
		}
		return sProperty;
	};

	/*
	 * @see JSDoc generated by SAPUI5 control API generator
	 */
	AnalyticalColumn.prototype.getFilterType = function() {
		var vFilterType = this.getProperty("filterType");
		if (!vFilterType) {
			var oParent = this.getParent();
			if (oParent && oParent instanceof sap.ui.table.AnalyticalTable) {
				var oBinding = oParent.getBinding("rows");
				var sLeadingProperty = this.getLeadingProperty(),
				    oProperty = oBinding && oBinding.getProperty(sLeadingProperty);
				if (oProperty) {
					switch (oProperty.type) {
						case "Edm.Time":
							vFilterType = AnalyticalColumn._DEFAULT_FILTERTYPES["Time"];
							break;
						case "Edm.DateTime":
						case "Edm.DateTimeOffset":
							vFilterType = AnalyticalColumn._DEFAULT_FILTERTYPES["DateTime"];
							break;
						case "Edm.Single":
						case "Edm.Double":
						case "Edm.Decimal":
							vFilterType = AnalyticalColumn._DEFAULT_FILTERTYPES["Float"];
							break;
						case "Edm.SByte":
						case "Edm.Int16":
						case "Edm.Int32":
						case "Edm.Int64":
							vFilterType = AnalyticalColumn._DEFAULT_FILTERTYPES["Integer"];
							break;
						case "Edm.Boolean":
							vFilterType = AnalyticalColumn._DEFAULT_FILTERTYPES["Boolean"];
							break;
					}
				}
			}
		}
		return vFilterType;
	};

	AnalyticalColumn.prototype._afterSort = function() {
		this._updateTableAnalyticalInfo();
	};

	AnalyticalColumn.prototype._updateTableAnalyticalInfo = function(bSupressRefresh) {
		if (this._bSkipUpdateAI) {
			return;
		}

		var oParent = this.getParent();
		if (oParent && oParent instanceof sap.ui.table.AnalyticalTable) {
			oParent.updateAnalyticalInfo(bSupressRefresh);
		}
	};

	AnalyticalColumn.prototype._updateTableColumnDetails = function() {
		if (this._bSkipUpdateAI) {
			return;
		}

		var oParent = this.getParent();
		if (oParent && oParent instanceof sap.ui.table.AnalyticalTable) {
			oParent._updateTableColumnDetails();
		}
	};

	AnalyticalColumn.prototype.shouldRender = function() {
		if (!this.getVisible()) {
			return false;
		}
		return (!this.getGrouped() || this._bLastGroupAndGrouped || this.getShowIfGrouped()) && (!this._bDependendGrouped || this._bLastGroupAndGrouped);
	};

	AnalyticalColumn.prototype.getTooltip_AsString = function() {
		var oParent = this.getParent();
		if (oParent && oParent instanceof sap.ui.table.AnalyticalTable) {
			var oBinding = oParent.getBinding("rows");
			if (oBinding && this.getLeadingProperty()) {
				return oBinding.getPropertyQuickInfo(this.getLeadingProperty());
			}
		}
		return sap.ui.core.Element.prototype.getTooltip_AsString.apply(this);
	};


	return AnalyticalColumn;

}, /* bExport= */ true);

}; // end of sap/ui/table/AnalyticalColumn.js
if ( !jQuery.sap.isDeclared('sap.ui.table.AnalyticalColumnMenu') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides control sap.ui.table.AnalyticalColumnMenu.
jQuery.sap.declare('sap.ui.table.AnalyticalColumnMenu'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
sap.ui.define("sap/ui/table/AnalyticalColumnMenu",['jquery.sap.global', './ColumnMenu', './library'],
	function(jQuery, ColumnMenu, library) {
	"use strict";



	/**
	 * Constructor for a new AnalyticalColumnMenu.
	 *
	 * @param {string} [sId] id for the new control, generated automatically if no id is given
	 * @param {object} [mSettings] initial settings for the new control
	 *
	 * @class
	 * A column menu which is used by the analytical column
	 * @extends sap.ui.table.ColumnMenu
	 *
	 * @author SAP SE
	 * @version 1.28.10
	 *
	 * @constructor
	 * @public
	 * @experimental Since version 1.21.
	 * The AnalyticalColumnMenu will be productized soon.
	 * @alias sap.ui.table.AnalyticalColumnMenu
	 * @ui5-metamodel This control/element also will be described in the UI5 (legacy) designtime metamodel
	 */
	var AnalyticalColumnMenu = ColumnMenu.extend("sap.ui.table.AnalyticalColumnMenu", /** @lends sap.ui.table.AnalyticalColumnMenu.prototype */ { metadata : {

		library : "sap.ui.table"
	}});

	AnalyticalColumnMenu.prototype.init = function() {
		ColumnMenu.prototype.init.apply(this);
	};

	/**
	 * Adds the menu items to the menu.
	 * @private
	 */
	AnalyticalColumnMenu.prototype._addMenuItems = function() {
		ColumnMenu.prototype._addMenuItems.apply(this);
		if (this._oColumn) {
			this._addSumMenuItem();
		}
	};

	/**
	 * Adds the group menu item to the menu.
	 * @private
	 */
	AnalyticalColumnMenu.prototype._addGroupMenuItem = function() {
		var oColumn = this._oColumn,
			oTable = this._oTable,
			oBinding = oTable.getBinding("rows"),
			oResultSet = oBinding && oBinding.getAnalyticalQueryResult();

		if (oTable && oResultSet && oResultSet.findDimensionByPropertyName(oColumn.getLeadingProperty())
				&& jQuery.inArray(oColumn.getLeadingProperty(), oBinding.getSortablePropertyNames()) > -1
				&& jQuery.inArray(oColumn.getLeadingProperty(), oBinding.getFilterablePropertyNames()) > -1) {
			this._oGroupIcon = this._createMenuItem(
				"group",
				"TBL_GROUP",
				oColumn.getGrouped() ? "accept" : null,
				jQuery.proxy(function(oEvent) {
					var oMenuItem = oEvent.getSource(),
						bGrouped = oColumn.getGrouped();

					oColumn.setGrouped(!bGrouped);
					oTable.fireGroup({column: oColumn, groupedColumns: oTable._aGroupedColumns, type: sap.ui.table.GroupEventType.group});
					oMenuItem.setIcon(!bGrouped ? "sap-icon://accept" : null);
				}, this)
			);
			this.addItem(this._oGroupIcon);
		}
	};

	/**
	 * Adds the group menu item to the menu.
	 * @private
	 */
	AnalyticalColumnMenu.prototype._addSumMenuItem = function() {
		var oColumn = this._oColumn,
			oTable = this._oTable,
			oBinding = oTable.getBinding("rows"),
			oResultSet = oBinding && oBinding.getAnalyticalQueryResult();

		if (oTable && oResultSet && oResultSet.findMeasureByPropertyName(oColumn.getLeadingProperty())) {
			this._oSumItem = this._createMenuItem(
				"total",
				"TBL_TOTAL",
				oColumn.getSummed() ? "accept" : null,
				jQuery.proxy(function(oEvent) {
					var oMenuItem = oEvent.getSource(),
						bSummed = oColumn.getSummed();

					oColumn.setSummed(!bSummed);
					oMenuItem.setIcon(!bSummed ? "sap-icon://accept" : null);
				}, this)
			);
			this.addItem(this._oSumItem);
		}
	};


	AnalyticalColumnMenu.prototype.open = function() {
		ColumnMenu.prototype.open.apply(this, arguments);

		var oColumn = this._oColumn;
		this._oSumItem && this._oSumItem.setIcon(oColumn.getSummed() ? "sap-icon://accept" : null);
		this._oGroupIcon && this._oGroupIcon.setIcon(oColumn.getGrouped() ? "sap-icon://accept" : null);
		this._oGroupIcon && this._oGroupIcon.setVisible(!oColumn._isLastGroupableLeft);
	};

	return AnalyticalColumnMenu;

}, /* bExport= */ true);

}; // end of sap/ui/table/AnalyticalColumnMenu.js
if ( !jQuery.sap.isDeclared('sap.ui.table.AnalyticalTable') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides control sap.ui.table.AnalyticalTable.
jQuery.sap.declare('sap.ui.table.AnalyticalTable'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
jQuery.sap.require('sap.ui.model.analytics.TreeBindingAdapter'); // unlisted dependency retained
sap.ui.define("sap/ui/table/AnalyticalTable",['jquery.sap.global', 'sap/ui/model/analytics/TreeBindingAdapter', './AnalyticalColumn', './Table', './library'],
	function(jQuery, TreeBindingAdapter, AnalyticalColumn, Table, library) {
	"use strict";



	/**
	 * Constructor for a new AnalyticalTable.
	 *
	 * @param {string} [sId] id for the new control, generated automatically if no id is given
	 * @param {object} [mSettings] initial settings for the new control
	 *
	 * @class
	 * Table which handles analytical OData backends
	 * @extends sap.ui.table.Table
	 * @version 1.28.10
	 *
	 * @constructor
	 * @public
	 * @experimental Since version 1.21.
	 * The AnalyticalTable will be productized soon.
	 * @alias sap.ui.table.AnalyticalTable
	 * @ui5-metamodel This control/element also will be described in the UI5 (legacy) designtime metamodel
	 */
	var AnalyticalTable = Table.extend("sap.ui.table.AnalyticalTable", /** @lends sap.ui.table.AnalyticalTable.prototype */ { metadata : {

		library : "sap.ui.table",
		properties : {

			/**
			 * Specifies if the total values should be displayed in the group headers or on bottom of the row. Does not affact the total sum.
			 */
			sumOnTop : {type : "boolean", group : "Appearance", defaultValue : false},

			/**
			 * Number of levels, which should be opened initially (on first load of data).
			 */
			numberOfExpandedLevels : {type : "int", group : "Misc", defaultValue : 0},

			/**
			 * Functions which is used to sort the column visibility menu entries e.g.: function(ColumnA, ColumnB) { return 0 = equals, <0 lower, >0 greater }; Other values than functions will be ignored.
			 */
			columnVisibilityMenuSorter : {type : "any", group : "Appearance", defaultValue : null},

			/**
			 * If dirty the content of the Table will be overlayed.
			 * @deprecated Since version 1.21.2.
			 * Please use setShowOverlay instead.
			 */
			dirty : {type : "boolean", group : "Appearance", defaultValue : null, deprecated: true}
		}
	}});


	// =====================================================================
	// WE START WITH A COPY OF THE TREETABLE AND REFACTOR THE CODING!
	// =====================================================================


	/**
	 * Initialization of the AnalyticalTable control
	 * @private
	 */
	AnalyticalTable.prototype.init = function() {
		Table.prototype.init.apply(this, arguments);

		this.addStyleClass("sapUiAnalyticalTable");

		this.attachBrowserEvent("contextmenu", this._onContextMenu);

		// defaulting properties
		this.setSelectionMode(sap.ui.table.SelectionMode.MultiToggle);
		this.setShowColumnVisibilityMenu(true);
		this.setEnableColumnFreeze(true);
		this.setEnableCellFilter(true);
		this._aGroupedColumns = [];

		// adopting properties and load icon fonts for bluecrystal
		if (sap.ui.getCore().getConfiguration().getTheme() === "sap_bluecrystal") {

			// add the icon fonts
			jQuery.sap.require("sap.ui.core.IconPool");
			sap.ui.core.IconPool.insertFontFaceStyle();

			// defaulting the rowHeight -> is set via CSS
		}

		this._bBindingAttachedListener = false;

	};

	AnalyticalTable.prototype.setFixedRowCount = function() {
		jQuery.sap.log.error("The property fixedRowCount is not supported by the AnalyticalTable and must not be set!");
		return this;
	};

	AnalyticalTable.prototype.setFixedBottomRowCount = function() {
		jQuery.sap.log.error("The property fixedBottomRowCount is managed by the AnalyticalTable and must not be set!");
		return this;
	};

	/**
	 * Rerendering handling
	 * @private
	 */
	AnalyticalTable.prototype.onAfterRendering = function() {
		Table.prototype.onAfterRendering.apply(this, arguments);
		this.$().find("[role=grid]").attr("role", "treegrid");
	};

	AnalyticalTable.prototype.setDirty = function(bDirty) {
		jQuery.sap.log.error("The property \"dirty\" is deprecated. Please use \"showOverlay\".");
		this.setProperty("dirty", bDirty, true);
		this.setShowOverlay(this.getDirty());
		return this;
	};

	AnalyticalTable.prototype.getModel = function(oModel, sName) {
		var oModel = Table.prototype.getModel.apply(this, arguments);
		if (oModel && sap.ui.model.odata && oModel instanceof sap.ui.model.odata.ODataModel) {
			jQuery.sap.require("sap.ui.model.analytics.ODataModelAdapter");
			sap.ui.model.analytics.ODataModelAdapter.apply(oModel);
		}
		return oModel;
	};

	AnalyticalTable.prototype._bindAggregation = function(sName, sPath, oTemplate, oSorter, aFilters) {
		if (sName === "rows") {
			// make sure to reset the first visible row (currently needed for the analytical binding)
			// TODO: think about a boundary check to reset the firstvisiblerow if out of bounds
			this.setProperty("firstVisibleRow", 0, true);
		}
		return Table.prototype._bindAggregation.apply(this, arguments);
	};

	/**
	 * handler for change events of the binding
	 * @param {sap.ui.base.Event} oEvent change event
	 * @private
	 */
	AnalyticalTable.prototype._onBindingChange = function(oEvent) {
		Table.prototype._onBindingChange.apply(this, arguments);
		// the column menus have to be invalidated when the amount
		// of data changes in the Table; this happens on normal changes
		// of the Table as well as when filtering
		var sReason = typeof (oEvent) === "object" ? oEvent.getParameter("reason") : oEvent;
		if (sReason !== "sort") {
			this._invalidateColumnMenus();
		}
	};

	AnalyticalTable.prototype.bindRows = function(oBindingInfo) {
		var sPath,
			oTemplate,
			aSorters,
			aFilters;

		// Old API compatibility (sName, sPath, oTemplate, oSorter, aFilters)
		if (typeof oBindingInfo == "string") {
			sPath = arguments[0];
			oTemplate = arguments[1];
			aSorters = arguments[2];
			aFilters = arguments[3];
			oBindingInfo = {path: sPath, sorter: aSorters, filters: aFilters};
			// allow either to pass the template or the factory function as 3rd parameter
			if (oTemplate instanceof sap.ui.base.ManagedObject) {
				oBindingInfo.template = oTemplate;
			} else if (typeof oTemplate === "function") {
				oBindingInfo.factory = oTemplate;
			}
		}

		// extract the sorters from the columns (TODO: reconsider this!)
		var aColumns = this.getColumns();
		for (var i = 0, l = aColumns.length; i < l; i++) {
			if (aColumns[i].getSorted()) {
				oBindingInfo.sorter = oBindingInfo.sorter || [];
				oBindingInfo.sorter.push(new sap.ui.model.Sorter(aColumns[i].getSortProperty() || aColumns[i].getLeadingProperty(), aColumns[i].getSortOrder() === sap.ui.table.SortOrder.Descending));
			}
		}

		oBindingInfo.parameters = oBindingInfo.parameters || {};
		oBindingInfo.parameters.analyticalInfo = this._getColumnInformation();
		oBindingInfo.parameters.sumOnTop = this.getSumOnTop();
		oBindingInfo.parameters.numberOfExpandedLevels = this.getNumberOfExpandedLevels();

		var vReturn = this.bindAggregation("rows", oBindingInfo);
		this._bSupressRefresh = true;
		this._updateColumns();
		this._bSupressRefresh = false;

		this._bBindingAttachedListener = false;

		return vReturn;
	};

		/**
		 * @param {Boolean} bSuppressRefresh Suppress Refresh
		 * @returns {sap.ui.table.AnalyticalTable} this
		 * @private
 		 */
	AnalyticalTable.prototype._setSuppressRefresh = function (bSuppressRefresh) {
		this._bSupressRefresh = bSuppressRefresh;
		return this;
	};

	AnalyticalTable.prototype.updateRows = function(sReason) {
		this._attachBindingListener();
		Table.prototype.updateRows.apply(this, arguments);
	};

	AnalyticalTable.prototype.refreshRows = function(sReason) {
		this._attachBindingListener();
		Table.prototype.refreshRows.apply(this, arguments);
	};

	AnalyticalTable.prototype._attachBindingListener = function() {
		if (!this._bBindingAttachedListener) {
			this._bBindingAttachedListener = true;

			var oBinding = this.getBinding("rows");
			var that = this;
			// The "contextChange" event is idiosyncratic for the TreeBindingAdapter.
			// Neither the TreeBinding, nor the AnalyticalBinding know this event.
			// Also make sure, the contextChange handler is only attached once, otherwise the selection is messed up.
			if (oBinding && !oBinding.hasListeners("contextChange")) {
				oBinding.attachContextChange(function(oEvent) {
					if (!that._oSelection) {
						return;
					}
					var oParameters = oEvent.getParameters(),
						sType = oParameters.type,
						iIndex = oParameters.index,
						iLength = oParameters.length;

					if (sType === "remove") {
						that._oSelection.sliceSelectionInterval(iIndex, Math.max(iIndex, iIndex + iLength - 1));
					} else {
						that._oSelection.moveSelectionInterval(iIndex, iLength);
					}
				});
			}
		}
	};

	AnalyticalTable.prototype._getColumnInformation = function() {
		var aColumns = [],
			aTableColumns = this.getColumns();

		for (var i = 0; i < this._aGroupedColumns.length; i++) {
			var oColumn = sap.ui.getCore().byId(this._aGroupedColumns[i]);

			if (!oColumn) {
				continue;
			}

			aColumns.push({
				name: oColumn.getLeadingProperty(),
				visible: oColumn.getVisible(),
				grouped: oColumn.getGrouped(),
				total: oColumn.getSummed(),
				sorted: oColumn.getSorted(),
				sortOrder: oColumn.getSortOrder(),
				inResult: oColumn.getInResult(),
				formatter: oColumn.getGroupHeaderFormatter()
			});
		}

		for (var i = 0; i < aTableColumns.length; i++) {
			var oColumn = aTableColumns[i];

			if (jQuery.inArray(oColumn.getId(), this._aGroupedColumns) > -1) {
				continue;
			}
			if (!oColumn instanceof AnalyticalColumn) {
				jQuery.sap.log.error("You have to use AnalyticalColumns for the Analytical table");
			}

			aColumns.push({
				name: oColumn.getLeadingProperty(),
				visible: oColumn.getVisible(),
				grouped: oColumn.getGrouped(),
				total: oColumn.getSummed(),
				sorted: oColumn.getSorted(),
				sortOrder: oColumn.getSortOrder(),
				inResult: oColumn.getInResult(),
				formatter: oColumn.getGroupHeaderFormatter()
			});
		}

		return aColumns;
	};

	AnalyticalTable.prototype._updateTableContent = function() {
		Table.prototype._updateTableContent.apply(this, arguments);

		var oBinding = this.getBinding("rows"),
			iFirstRow = this.getFirstVisibleRow(),
			iFixedBottomRowCount = this.getFixedBottomRowCount(),
			iCount = this.getVisibleRowCount(),
			aCols = this.getColumns();

		if (!oBinding) {
			return;
		}

		var iFirstMeasureColumnIndex = this._getFirstMeasureColumnIndex(),
			sMaxGroupHeaderWidth;
		if (iFirstMeasureColumnIndex > -1) {
			var bHasRowHeader = this.getSelectionMode() !== sap.ui.table.SelectionMode.None && this.getSelectionBehavior() !== sap.ui.table.SelectionBehavior.RowOnly;
			var $ths = this.$().find(".sapUiTableCtrlFirstCol > th");
			if (bHasRowHeader) {
				$ths = $ths.not(":nth-child(1)");
			}
			var iOffset = $ths.get(0).getBoundingClientRect().left;
			var $FirstMeasureColumn = $ths.get(this._getFirstMeasureColumnIndex());
			if ($FirstMeasureColumn) {
				var iMaxGroupHeaderWidth = 32 + $FirstMeasureColumn.getBoundingClientRect().left - iOffset;
				sMaxGroupHeaderWidth = iMaxGroupHeaderWidth + "px";
			} else {
				sMaxGroupHeaderWidth = "none";
			}
		} else {
			sMaxGroupHeaderWidth = "none";
		}

		var aRows = this.getRows();
		for (var iRow = 0, l = Math.min(iCount, aRows.length); iRow < l; iRow++) {
			var bIsFixedRow = iRow > (iCount - iFixedBottomRowCount - 1) && oBinding.getLength() > iCount,
				iRowIndex = bIsFixedRow ? (oBinding.getLength() - 1 - (iCount - 1 - iRow)) : iFirstRow + iRow,
				oContextInfo = this.getContextInfoByIndex(iRowIndex),
				oRow = aRows[iRow],
				$row = oRow.$(),
				$fixedRow = oRow.$("fixed"),
				$rowHdr = this.$().find("div[data-sap-ui-rowindex=" + $row.attr("data-sap-ui-rowindex") + "]"),
				iLevel = oContextInfo ? oContextInfo.level : 0;

			if (!oContextInfo || !oContextInfo.context) {
				$row.removeAttr("data-sap-ui-level");
				$row.removeAttr('aria-level');
				$row.removeAttr('aria-expanded');
				$row.removeClass("sapUiTableGroupHeader");
				$row.removeClass("sapUiAnalyticalTableSum");
				$row.removeClass("sapUiAnalyticalTableDummy");
				$fixedRow.removeAttr("data-sap-ui-level");
				$fixedRow.removeAttr('aria-level');
				$fixedRow.removeAttr('aria-expanded');
				$fixedRow.removeClass("sapUiTableGroupHeader");
				$rowHdr.removeClass("sapUiTableGroupHeader");
				$rowHdr.html("");
				$rowHdr.removeAttr("data-sap-ui-level");
				$rowHdr.removeClass("sapUiAnalyticalTableSum");
				$rowHdr.removeClass("sapUiAnalyticalTableDummy");
				if (oContextInfo && !oContextInfo.context) {
					$row.addClass("sapUiAnalyticalTableDummy");
					$rowHdr.addClass("sapUiAnalyticalTableDummy");
					$rowHdr.html('<div class="sapUiAnalyticalTableLoading">Loading...</div>');
				}
				continue;
			}

			if (oBinding.indexHasChildren && oBinding.indexHasChildren(iRowIndex)) {
				// modify the rows
				$row.addClass("sapUiTableGroupHeader");
				$fixedRow.addClass("sapUiTableGroupHeader");
				var sClass = oContextInfo.expanded ? "sapUiTableGroupIconOpen" : "sapUiTableGroupIconClosed";
				$row.attr('aria-expanded', oContextInfo.expanded);
				$fixedRow.attr('aria-expanded', oContextInfo.expanded);
				var sGroupHeaderText = oBinding.getGroupName(oContextInfo.context, oContextInfo.level);
				$rowHdr.html("<div class=\"sapUiTableGroupIcon " + sClass + "\" tabindex=\"-1\" title=\"" + sGroupHeaderText + "\" style=\"max-width:"  + sMaxGroupHeaderWidth + "\">" + sGroupHeaderText + "</div>");
				if (oContextInfo.expanded && !this.getSumOnTop()) {
					$row.addClass("sapUiTableRowHidden");
					$rowHdr.addClass("sapUiTableRowHidden");
				}
				$row.removeClass("sapUiAnalyticalTableSum");
				$rowHdr.removeClass("sapUiAnalyticalTableSum");
				$row.removeClass("sapUiAnalyticalTableDummy");
				$rowHdr.removeClass("sapUiAnalyticalTableDummy");
				$rowHdr.addClass("sapUiTableGroupHeader").removeAttr("title");
			} else {
				$row.attr('aria-expanded', false);
				$row.removeClass("sapUiTableGroupHeader");
				$row.removeClass("sapUiTableRowHidden");
				$row.removeClass("sapUiAnalyticalTableSum");
				$row.removeClass("sapUiAnalyticalTableDummy");

				$fixedRow.attr('aria-expanded', false);
				$fixedRow.removeClass("sapUiTableGroupHeader");

				$rowHdr.html("");
				$rowHdr.removeClass("sapUiTableGroupHeader");
				$rowHdr.removeClass("sapUiAnalyticalTableDummy");
				$rowHdr.removeClass("sapUiAnalyticalTableSum");

				if (oContextInfo.sum && oContextInfo.context && oContextInfo.context.getObject()) {
					$row.addClass("sapUiAnalyticalTableSum");
					$rowHdr.addClass("sapUiAnalyticalTableSum");
				}
			}
			$row.attr("data-sap-ui-level", iLevel);
			$fixedRow.attr("data-sap-ui-level", iLevel);
			$rowHdr.attr("data-sap-ui-level", iLevel);
			$row.attr('aria-level', iLevel + 1);
			$fixedRow.attr('aria-level', iLevel + 1);

			// show or hide the totals if not enabled - needs to be done by Table
			// control since the model could be reused and thus the values cannot
			// be cleared in the model - and the binding has no control over the
			// value mapping - this happens directly via the context!
			var aCells = oRow.getCells();
			for (var i = 0, lc = aCells.length; i < lc; i++) {
				var iCol = aCells[i].data("sap-ui-colindex");
				var oCol = aCols[iCol];
				var $td = jQuery(aCells[i].$().closest("td"));
				if (oBinding.isMeasure(oCol.getLeadingProperty())) {
					if (!oContextInfo.sum || oCol.getSummed()) {
						$td.removeClass("sapUiTableCellHidden");
					} else {
						$td.addClass("sapUiTableCellHidden");
					}
				}
			}

		}
	};

	AnalyticalTable.prototype.onclick = function(oEvent) {
		if (jQuery(oEvent.target).hasClass("sapUiTableGroupIcon")) {
			this._onNodeSelect(oEvent);
		} else if (jQuery(oEvent.target).hasClass("sapUiAnalyticalTableSum")) {
			//Summs connot be selected
			oEvent.preventDefault();
			return;
		} else {
			if (Table.prototype.onclick) {
				Table.prototype.onclick.apply(this, arguments);
			}
		}
	};

	AnalyticalTable.prototype.onsapselect = function(oEvent) {
		if (jQuery(oEvent.target).hasClass("sapUiTableGroupIcon")) {
			this._onNodeSelect(oEvent);
		} else if (jQuery(oEvent.target).hasClass("sapUiAnalyticalTableSum")) {
			//Summs connot be selected
			oEvent.preventDefault();
			return;
		} else {
			var $Target = jQuery(oEvent.target),
				$TargetDIV = $Target.closest('div.sapUiTableRowHdr');
			if ($TargetDIV.hasClass('sapUiTableGroupHeader') && $TargetDIV.hasClass('sapUiTableRowHdr')) {
				var iRowIndex = this.getFirstVisibleRow() + parseInt($TargetDIV.attr("data-sap-ui-rowindex"), 10);
				var oBinding = this.getBinding("rows");
				oBinding.toggleIndex(iRowIndex);
				return;
			}
			if (Table.prototype.onsapselect) {
				Table.prototype.onsapselect.apply(this, arguments);
			}
		}
	};

	AnalyticalTable.prototype._onNodeSelect = function(oEvent) {

		var $parent = jQuery(oEvent.target).parent();
		if ($parent.length > 0) {
			var iRowIndex = this.getFirstVisibleRow() + parseInt($parent.attr("data-sap-ui-rowindex"), 10);
			var oBinding = this.getBinding("rows");
			oBinding.toggleIndex(iRowIndex);
		}

		oEvent.preventDefault();
		oEvent.stopPropagation();

	};

	AnalyticalTable.prototype._onContextMenu = function(oEvent) {
		if (jQuery(oEvent.target).closest('tr').hasClass('sapUiTableGroupHeader') ||
				jQuery(oEvent.target).closest('.sapUiTableRowHdr.sapUiTableGroupHeader').length > 0) {
			this._iGroupedLevel = jQuery(oEvent.target).closest('[data-sap-ui-level]').data('sap-ui-level');
			var oMenu = this._getGroupHeaderMenu();
			var eDock = sap.ui.core.Popup.Dock;
			oMenu.open(false, oEvent.target, eDock.LeftTop, eDock.LeftTop, document, (oEvent.pageX - 2) + " " + (oEvent.pageY - 2));

			oEvent.preventDefault();
			oEvent.stopPropagation();
			return;
		}

		return true;
	};

	AnalyticalTable.prototype._getGroupHeaderMenu = function() {

		var that = this;
		function getGroupColumnInfo() {
			var iIndex = that._iGroupedLevel - 1;
			if (that._aGroupedColumns[iIndex]) {
				var oGroupedColumn = that.getColumns().filter(function(oColumn){
					if (that._aGroupedColumns[iIndex] == oColumn.getId()) {
						return true;
					}
				})[0];

				return {
					column: oGroupedColumn,
					index: iIndex
				};
			}else {
				return undefined;
			}
		}

		if (!this._oGroupHeaderMenu) {
			this._oGroupHeaderMenu = new sap.ui.unified.Menu();
			this._oGroupHeaderMenuVisibilityItem = new sap.ui.unified.MenuItem({
				text: this._oResBundle.getText("TBL_SHOW_COLUMN"),
				select: function() {
					var oGroupColumnInfo = getGroupColumnInfo();

					if (oGroupColumnInfo) {
						var oColumn = oGroupColumnInfo.column,
							bShowIfGrouped = oColumn.getShowIfGrouped();
						oColumn.setShowIfGrouped(!bShowIfGrouped);

						that.fireGroup({column: oColumn, groupedColumns: oColumn.getParent()._aGroupedColumns, type:( !bShowIfGrouped ? sap.ui.table.GroupEventType.showGroupedColumn : sap.ui.table.GroupEventType.hideGroupedColumn )});
					}
				}
			});
			this._oGroupHeaderMenu.addItem(this._oGroupHeaderMenuVisibilityItem);
			this._oGroupHeaderMenu.addItem(new sap.ui.unified.MenuItem({
				text: this._oResBundle.getText("TBL_UNGROUP"),
				select: function() {
					var aColumns = that.getColumns(),
						iFoundGroups = 0,
						iLastGroupedIndex = -1,
						iUngroudpedIndex = -1,
						oColumn;
					for (var i = 0; i < aColumns.length; i++) {
						oColumn = aColumns[i];
						if (oColumn.getGrouped()) {
							iFoundGroups++;
							if (iFoundGroups == that._iGroupedLevel) {
								oColumn._bSkipUpdateAI = true;

								// relaying the ungrouping to the AnalyticalBinding,
								// the numberOfExpandedLevels must be reset through the TreeBindingAdapter.
								var oBinding = that.getBinding("rows");
								oBinding.setNumberOfExpandedLevels(0);
								// setGrouped(false) leads to an invalidation of the Column -> rerender
								// and this will result in new requests from the AnalyticalBinding,
								//because the initial grouping is lost (can not be restored!)
								oColumn.setGrouped(false);

								oColumn._bSkipUpdateAI = false;
								iUngroudpedIndex = i;
								that.fireGroup({column: oColumn, groupedColumns: oColumn.getParent()._aGroupedColumns, type: sap.ui.table.GroupEventType.ungroup});
							} else {
								iLastGroupedIndex = i;
							}
						}
					}
					if (iLastGroupedIndex > -1 && iUngroudpedIndex > -1 && iUngroudpedIndex < iLastGroupedIndex) {
						var oUngroupedColumn = aColumns[iUngroudpedIndex];
						var iHeaderSpan = oUngroupedColumn.getHeaderSpan();
						if (jQuery.isArray(iHeaderSpan)) {
							iHeaderSpan = iHeaderSpan[0];
						}
						var aRemovedColumns = [];
						for (var i = iUngroudpedIndex; i < iUngroudpedIndex + iHeaderSpan; i++) {
							aRemovedColumns.push(aColumns[i]);
						}
						jQuery.each(aRemovedColumns, function(iIndex, oColumn) {
							that.removeColumn(oColumn);
							that.insertColumn(oColumn, iLastGroupedIndex);
						});
					}
					that._updateTableColumnDetails();
					that.updateAnalyticalInfo();
				}
			}));
			this._oGroupHeaderMenu.addItem(new sap.ui.unified.MenuItem({
				text: this._oResBundle.getText("TBL_UNGROUP_ALL"),
				select: function() {
					var aColumns = that.getColumns();
					for (var i = 0; i < aColumns.length; i++) {
						aColumns[i]._bSkipUpdateAI = true;

						// same as with single "ungrouping" (see above)
						var oBinding = that.getBinding("rows");
						oBinding.setNumberOfExpandedLevels(0);

						aColumns[i].setGrouped(false);
						aColumns[i]._bSkipUpdateAI = false;
					}
					that._bSupressRefresh = true;
					that._updateTableColumnDetails();
					that.updateAnalyticalInfo();
					that._bSupressRefresh = false;
					that.fireGroup({column: undefined, groupedColumns: [], type: sap.ui.table.GroupEventType.ungroupAll});
				}
			}));
			this._oGroupHeaderMoveUpItem = new sap.ui.unified.MenuItem({
				text: this._oResBundle.getText("TBL_MOVE_UP"),
				select: function() {
					var oGroupColumnInfo = getGroupColumnInfo();

					if (oGroupColumnInfo) {
						var oColumn = oGroupColumnInfo.column;
						var iIndex = jQuery.inArray(oColumn.getId(), that._aGroupedColumns);
						if (iIndex > 0) {
							that._aGroupedColumns[iIndex] = that._aGroupedColumns.splice(iIndex - 1, 1, that._aGroupedColumns[iIndex])[0];
							that.updateAnalyticalInfo();
							that.fireGroup({column: oColumn, groupedColumns: oColumn.getParent()._aGroupedColumns, type: sap.ui.table.GroupEventType.moveUp});
						}
					}
				},
				icon: "sap-icon://arrow-top"
			});
			this._oGroupHeaderMenu.addItem(this._oGroupHeaderMoveUpItem);
			this._oGroupHeaderMoveDownItem = new sap.ui.unified.MenuItem({
				text: this._oResBundle.getText("TBL_MOVE_DOWN"),
				select: function() {
					var oGroupColumnInfo = getGroupColumnInfo();

					if (oGroupColumnInfo) {
						var oColumn = oGroupColumnInfo.column;
						var iIndex = jQuery.inArray(oColumn.getId(), that._aGroupedColumns);
						if (iIndex < that._aGroupedColumns.length) {
							that._aGroupedColumns[iIndex] = that._aGroupedColumns.splice(iIndex + 1, 1, that._aGroupedColumns[iIndex])[0];
							that.updateAnalyticalInfo();
							that.fireGroup({column: oColumn, groupedColumns: oColumn.getParent()._aGroupedColumns, type: sap.ui.table.GroupEventType.moveDown});
						}
					}
				},
				icon: "sap-icon://arrow-bottom"
			});
			this._oGroupHeaderMenu.addItem(this._oGroupHeaderMoveDownItem);
			this._oGroupHeaderMenu.addItem(new sap.ui.unified.MenuItem({
				text: this._oResBundle.getText("TBL_SORT_ASC"),
				select: function() {
					var oGroupColumnInfo = getGroupColumnInfo();

					if (oGroupColumnInfo) {
						var oColumn = oGroupColumnInfo.column;

						oColumn.sort(false); //update Analytical Info triggered by aftersort in column
					}
				},
				icon: "sap-icon://up"
			}));
			this._oGroupHeaderMenu.addItem(new sap.ui.unified.MenuItem({
				text: this._oResBundle.getText("TBL_SORT_DESC"),
				select: function() {
					var oGroupColumnInfo = getGroupColumnInfo();

					if (oGroupColumnInfo) {
						var oColumn = oGroupColumnInfo.column;

						oColumn.sort(true); //update Analytical Info triggered by aftersort in column
					}
				},
				icon: "sap-icon://down"
			}));
			this._oGroupHeaderMenu.addItem(new sap.ui.unified.MenuItem({
				text: this._oResBundle.getText("TBL_COLLAPSE_LEVEL"),
				select: function() {
					that.getBinding("rows").collapseAll(that._iGroupedLevel);
					that._oSelection.clearSelection();
				}
			}));
			this._oGroupHeaderMenu.addItem(new sap.ui.unified.MenuItem({
				text: this._oResBundle.getText("TBL_COLLAPSE_ALL"),
				select: function() {
					that.getBinding("rows").collapseAll();
					that._oSelection.clearSelection();
				}
			}));
		}

		var oGroupColumnInfo = getGroupColumnInfo();
		if (oGroupColumnInfo) {
			var oColumn = oGroupColumnInfo.column;
			if (oColumn.getShowIfGrouped()) {
				this._oGroupHeaderMenuVisibilityItem.setText(this._oResBundle.getText("TBL_HIDE_COLUMN"));
			} else {
				this._oGroupHeaderMenuVisibilityItem.setText(this._oResBundle.getText("TBL_SHOW_COLUMN"));
			}
			this._oGroupHeaderMoveUpItem.setEnabled(oGroupColumnInfo.index > 0);
			this._oGroupHeaderMoveDownItem.setEnabled(oGroupColumnInfo.index < this._aGroupedColumns.length - 1);
		} else {
			this._oGroupHeaderMoveUpItem.setEnabled(true);
			this._oGroupHeaderMoveDownItem.setEnabled(true);
		}

		return this._oGroupHeaderMenu;

	};

	AnalyticalTable.prototype.expand = function(iRowIndex) {
		var oBinding = this.getBinding("rows");
		if (oBinding) {
			oBinding.expand(iRowIndex);
		}
	};

	AnalyticalTable.prototype.collapse = function(iRowIndex) {
		var oBinding = this.getBinding("rows");
		if (oBinding) {
			oBinding.collapse(iRowIndex);
		}
	};

	AnalyticalTable.prototype.isExpanded = function(iRowIndex) {
		var oBinding = this.getBinding("rows");
		if (oBinding) {
			return oBinding.isExpanded(iRowIndex);
		}
		return false;
	};

	AnalyticalTable.prototype.selectAll = function() {
		Table.prototype.selectAll.apply(this);
		var oSelMode = this.getSelectionMode();
		if (!this.getEnableSelectAll() || (oSelMode != "Multi" && oSelMode != "MultiToggle")) {
			return this;
		}
		var oBinding = this.getBinding("rows");
		if (oBinding) {
			var iLength = (oBinding.getLength() || 0);
			for (var i = 0; i < iLength; i++) {
				var oContextInfo = this.getContextInfoByIndex(i);
				if (oContextInfo.sum || oBinding.indexHasChildren(i)) {
					this._oSelection.removeSelectionInterval(i,i);
				}
			}
			this.$("selall").attr('title',this._oResBundle.getText("TBL_DESELECT_ALL")).removeClass("sapUiTableSelAll");
		}
		return this;
	};

	AnalyticalTable.prototype.getContextInfoByIndex = function(iIndex) {
		var oBinding = this.getBinding("rows");
		return iIndex >= 0 && oBinding ? oBinding.getContextInfo(iIndex) : null;
	};

	AnalyticalTable.prototype._onColumnMoved = function(oEvent) {
		Table.prototype._onColumnMoved.apply(this, arguments);
		this.updateAnalyticalInfo();
	};

	AnalyticalTable.prototype.addColumn = function(vColumn, bSuppressInvalidate) {
		var oColumn = this._getColumn(vColumn);
		if (oColumn.getGrouped()) {
			this._addGroupedColumn(oColumn.getId());
		}
		return Table.prototype.addColumn.call(this, oColumn, bSuppressInvalidate);
	};

	AnalyticalTable.prototype.insertColumn = function(vColumn, iIndex, bSuppressInvalidate) {
		var oColumn = this._getColumn(vColumn);
		if (oColumn.getGrouped()) {
			this._addGroupedColumn(oColumn.getId());
		}
		return Table.prototype.insertColumn.call(this, oColumn, iIndex, bSuppressInvalidate);
	};

	AnalyticalTable.prototype.removeColumn = function(vColumn, bSuppressInvalidate) {
		var oColumn = Table.prototype.removeColumn.apply(this, arguments);
		if (oColumn) {
			this._aGroupedColumns = jQuery.grep(this._aGroupedColumns, function(value) {
				return value != oColumn.getId();
			});
		}
		return oColumn;
	};

	AnalyticalTable.prototype.removeAllColumns = function(bSuppressInvalidate) {
		this._aGroupedColumns = [];
		return Table.prototype.removeColumn.apply(this, arguments);
	};

	AnalyticalTable.prototype._getColumn = function(vColumn) {
		if (typeof vColumn === "string") {
			var oColumn =  new AnalyticalColumn({
				leadingProperty: vColumn,
				template: vColumn,
				managed: true
			});
			return oColumn;
		} else if (vColumn instanceof AnalyticalColumn) {
			return vColumn;
		} else {
			throw new Error("Wrong column type. You need to define a string (property) or pass an AnalyticalColumnObject");
		}
	};

	AnalyticalTable.prototype._updateColumns = function() {
		this._updateTableColumnDetails();
		this.updateAnalyticalInfo();
	};

	AnalyticalTable.prototype.updateAnalyticalInfo = function(bSupressRefresh) {
		var oBinding = this.getBinding("rows");
		if (oBinding) {
			var aColumnInfo = this._getColumnInformation();
			oBinding.updateAnalyticalInfo(aColumnInfo);
			this._updateTotalRow(aColumnInfo, bSupressRefresh);
			if (bSupressRefresh || this._bSupressRefresh) {
				return;
			}
			this.refreshRows();
		}
	};

	AnalyticalTable.prototype._updateTotalRow = function(aColumnInfo, bSuppressInvalidate) {

		var bHasTotal = false;
		for (var i = 0, l = aColumnInfo ? aColumnInfo.length : 0; i < l; i++) {
			if (aColumnInfo[i].visible && aColumnInfo[i].total) {
				bHasTotal = true;
				break;
			}
		}

		var oBinding = this.getBinding("rows");
		if (oBinding && (!oBinding.providesGrandTotal() || !oBinding.hasTotaledMeasures())) {
			bHasTotal = false;
		}

		var iFixedBottomRowCount = this.getFixedBottomRowCount();
		if (bHasTotal) {
			if (iFixedBottomRowCount !== 1) {
				this.setProperty("fixedBottomRowCount", 1, bSuppressInvalidate);
			}
		} else {
			if (iFixedBottomRowCount !== 0) {
				this.setProperty("fixedBottomRowCount", 0, bSuppressInvalidate);
			}
		}

	};

	AnalyticalTable.prototype._updateTableColumnDetails = function() {
		var oBinding = this.getBinding("rows"),
			oResult = oBinding && oBinding.getAnalyticalQueryResult();

		if (oResult) {
			var aColumns = this.getColumns(),
				aGroupedDimensions = [],
				aUngroupedDimensions = [],
				aDimensions = [],
				oDimensionIndex = {},
				oColumn,
				oDimension;

			// calculate an index of all dimensions and their columns. Grouping is done per dimension.
			for (var i = 0; i < aColumns.length; i++) {
				oColumn = aColumns[i];
				oColumn._isLastGroupableLeft = false;
				oColumn._bLastGroupAndGrouped = false;
				oColumn._bDependendGrouped = false;

				// ignore invisible columns
				if (!oColumn.getVisible()) {
					continue;
				}

				var sLeadingProperty = oColumn.getLeadingProperty();
				oDimension = oResult.findDimensionByPropertyName(sLeadingProperty);

				if (oDimension) {
					var sDimensionName = oDimension.getName();
					if (!oDimensionIndex[sDimensionName]) {
						oDimensionIndex[sDimensionName] = {dimension: oDimension, columns: [oColumn]};
					} else {
						oDimensionIndex[sDimensionName].columns.push(oColumn);
					}

					// if one column of a dimension is grouped, the dimension is considered as grouped.
					// all columns which are not explicitly grouped will be flagged as dependendGrouped in the next step
					if (oColumn.getGrouped() && jQuery.inArray(sDimensionName, aGroupedDimensions) == -1) {
						aGroupedDimensions.push(sDimensionName);
					}

					if (jQuery.inArray(sDimensionName, aDimensions) == -1) {
						aDimensions.push(sDimensionName);
					}
				}
			}

			aUngroupedDimensions = jQuery.grep(aDimensions, function (s) {
				return (jQuery.inArray(s, aGroupedDimensions) == -1);
			});

			// for all grouped dimensions
			if (aGroupedDimensions.length > 0) {
				// calculate and flag the dependendly grouped columns of the dimension
				jQuery.each(aGroupedDimensions, function(i, s) {
					jQuery.each(oDimensionIndex[s].columns, function(j, o) {
						if (!o.getGrouped()) {
							o._bDependendGrouped = true;
						}
					});
				});

				// if there is only one dimension left, their columns must remain visible even though they are grouped.
				// this behavior is controlled by the flag _bLastGroupAndGrouped
				if (aGroupedDimensions.length == aDimensions.length) {
					oDimension = oResult.findDimensionByPropertyName(sap.ui.getCore().byId(this._aGroupedColumns[this._aGroupedColumns.length - 1]).getLeadingProperty());
					var aGroupedDimensionColumns = oDimensionIndex[oDimension.getName()].columns;
					jQuery.each(aGroupedDimensionColumns, function(i, o) {
						o._bLastGroupAndGrouped = true;
					});
				}
			}

			if (aUngroupedDimensions.length == 1) {
				jQuery.each(oDimensionIndex[aUngroupedDimensions[0]].columns, function(j, o) {
					o._isLastGroupableLeft = true;
				});
			}
		}
	};

	AnalyticalTable.prototype._getFirstMeasureColumnIndex = function() {
		var oBinding = this.getBinding("rows"),
			oResultSet = oBinding && oBinding.getAnalyticalQueryResult(),
			aColumns = this._getVisibleColumns();

		if (!oResultSet) {
			return -1;
		}

		for (var i = 0; i < aColumns.length; i++) {
			var oColumn = aColumns[i],
				sLeadingProperty = oColumn.getLeadingProperty();

			if (oResultSet.findMeasureByName(sLeadingProperty) || oResultSet.findMeasureByPropertyName(sLeadingProperty)) {
				return i;
			}
		}
	};

	/**
	 * Returns the total size of the data entries.
	 *
	 * @type int
	 * @public
	 * @ui5-metamodel This method also will be described in the UI5 (legacy) designtime metamodel
	 */
	AnalyticalTable.prototype.getTotalSize = function() {
		var oBinding = this.getBinding("rows");
		if (oBinding) {
			return oBinding.getTotalSize();
		}
		return 0;
	};

	AnalyticalTable.prototype._hasData = function() {
		var oBinding = this.getBinding("rows"),
			iLength = oBinding && (oBinding.getLength() || 0),
			bHasTotal = oBinding && (oBinding.providesGrandTotal() && oBinding.hasTotaledMeasures());

		if (!oBinding || (bHasTotal && iLength < 2) || (!bHasTotal && iLength === 0)) {
			return false;
		}
		return true;
	};

	AnalyticalTable.prototype._onPersoApplied = function() {
		Table.prototype._onPersoApplied.apply(this, arguments);
		this._aGroupedColumns = [];
		var aColumns = this.getColumns();
		for (var i = 0, l = aColumns.length; i < l; i++) {
			if (aColumns[i].getGrouped()) {
				this._addGroupedColumn(aColumns[i].getId());
			}
		}
		this._updateTableColumnDetails();
		this.updateAnalyticalInfo();
	};

	AnalyticalTable.prototype._addGroupedColumn = function(sColumn) {
		if (jQuery.inArray(sColumn, this._aGroupedColumns) < 0) {
			this._aGroupedColumns.push(sColumn);
		}
	};

    AnalyticalTable.prototype.getGroupedColumns = function () {
        return this._aGroupedColumns;
    };

	/**
	 * returns the count of rows which can ca selected when bound or 0
	 * @private
	 */
	AnalyticalTable.prototype._getSelectableRowCount = function() {
		var oBinding = this.getBinding("rows");

		if (oBinding) {
			var iCount = oBinding.getLength() || 0;

			for (var i = 0, l = iCount; i < l; i++) {
				var oContextInfo = this.getContextInfoByIndex(i);
				if (oContextInfo.sum || oBinding.indexHasChildren(i)) {
					iCount--;
				}
			}

			return iCount;
		} else {
			return 0;
		}
	};

	AnalyticalTable.prototype._isRowSelectable = function(iRowIndex) {
		return !this.getBinding("rows").indexHasChildren(iRowIndex);
	};

	return AnalyticalTable;

}, /* bExport= */ true);

}; // end of sap/ui/table/AnalyticalTable.js
if ( !jQuery.sap.isDeclared('sap.ui.table.DataTable') ) {
/*!
 * SAP UI development toolkit for HTML5 (SAPUI5/OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */

// Provides control sap.ui.table.DataTable.
jQuery.sap.declare('sap.ui.table.DataTable'); // unresolved dependency added by SAPUI5 'AllInOne' Builder
jQuery.sap.require('jquery.sap.global'); // unlisted dependency retained
sap.ui.define("sap/ui/table/DataTable",['jquery.sap.global', './TreeTable', './Table', './library'],
	function(jQuery, TreeTable, Table, library) {
	"use strict";


	
	/**
	 * Constructor for a new DataTable.
	 *
	 * @param {string} [sId] id for the new control, generated automatically if no id is given 
	 * @param {object} [mSettings] initial settings for the new control
	 *
	 * @class
	 * The DataTable control provides a set of sophisticated and comfort functions for table design. For example, you can make settings for the number of visible rows and a number for the displayed rows in the case the user expands the table. The first visible row can be explicitly set. For the selection of columns and rows, a Multi, a Single, a None, and an All mode are available. Setting the Editable property to true lets the user make changes on the table cell entries.
	 * @extends sap.ui.table.TreeTable
	 * @version 1.28.10
	 *
	 * @constructor
	 * @public
	 * @deprecated Since version 1.5.1. 
	 * The DataTable has been replaced via the Table/TreeTable control.
	 * @alias sap.ui.table.DataTable
	 * @ui5-metamodel This control/element also will be described in the UI5 (legacy) designtime metamodel
	 */
	var DataTable = TreeTable.extend("sap.ui.table.DataTable", /** @lends sap.ui.table.DataTable.prototype */ { metadata : {
	
		deprecated : true,
		library : "sap.ui.table",
		properties : {
	
			/**
			 * Count of visible rows when expanded
			 */
			expandedVisibleRowCount : {type : "int", defaultValue : null},
	
			/**
			 * Flag whether the Table is expanded or not
			 */
			expanded : {type : "boolean", defaultValue : false},
	
			/**
			 * Flag, whether the table displays its content hierarchical or not (**experimental**!!)
			 */
			hierarchical : {type : "boolean", defaultValue : false}
		},
		events : {
	
			/**
			 * fired when the row selection of the table has been changed
			 */
			rowSelect : {
				parameters : {
	
					/**
					 * row index which row has been selected or deselected
					 */
					rowIndex : {type : "int"}, 
	
					/**
					 * binding context of the row index which row has been selected or deselected
					 */
					rowContext : {type : "object"}, 
	
					/**
					 * array of row indices which selection has been changed (either selected or deselected)
					 */
					rowIndices : {type : "int[]"}
				}
			}
		}
	}});
	
	/**
	 * Initialization of the DataTable control
	 * @private
	 */
	DataTable.prototype.init = function() {
		
		TreeTable.prototype.init.apply(this, arguments);
		
		this._bInheritEditableToControls = true;
		
		// default values for DataTable
		this.setEditable(false);
		this.setSelectionBehavior(sap.ui.table.SelectionBehavior.Row);
		
		this.attachRowSelectionChange(function(oEvent) {
			this.fireRowSelect(oEvent.mParameters);
		});
		
		this._iLastFixedColIndex = -1;
	
	};
	
	DataTable.prototype.isTreeBinding = function(sName) {
		sName = sName || "rows";
		if (sName === "rows") {
			return this.getHierarchical();
		}
		return sap.ui.core.Element.prototype.isTreeBinding.apply(this, arguments);
	};
	
	DataTable.prototype.setHierarchical = function(bHierarchical) {
		this.setProperty("hierarchical", bHierarchical);
		this._iLastFixedColIndex = bHierarchical ? 0 : -1;
	};
	
	DataTable.prototype.setVisibleRowCount = function(iRowCount) {
		this._iVisibleRowCount = iRowCount;
		if (!this.getExpanded()) {
			sap.ui.table.Table.prototype.setVisibleRowCount.apply(this, arguments);
		}
	};
	
	DataTable.prototype.setExpandedVisibleRowCount = function(iRowCount) {
		this.setProperty("expandedVisibleRowCount", iRowCount, true);
		if (this.getExpanded()) {
			sap.ui.table.Table.prototype.setVisibleRowCount.apply(this, arguments);
		}
	};
	
	DataTable.prototype.setExpanded = function(bExpanded) {
		this.setProperty("expanded", bExpanded, true);
		if (this.getExpandedVisibleRowCount() > 0) {
			var iRowCount = bExpanded ? this.getExpandedVisibleRowCount() : this._iVisibleRowCount;
			sap.ui.table.Table.prototype.setVisibleRowCount.call(this, iRowCount);
		}
	};
	
	DataTable.prototype.getContextByIndex = function (iRowIndex) {
		return Table.prototype.getContextByIndex.call(this, iRowIndex);
	};

	return DataTable;

}, /* bExport= */ true);

}; // end of sap/ui/table/DataTable.js
