/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['jquery.sap.global','./library','sap/ui/core/TooltipBase'],function(q,l,T){"use strict";var C=T.extend("sap.ui.commons.CalloutBase",{metadata:{library:"sap.ui.commons",events:{open:{parameters:{parent:{type:"sap.ui.core.Control"}}},close:{},beforeOpen:{allowPreventDefault:true,parameters:{parent:{type:"sap.ui.core.Control"}}},opened:{}}}});C.prototype.init=function(){this.oPopup=new sap.ui.core.Popup();this.oPopup.setShadow(true);this.oRb=sap.ui.getCore().getLibraryResourceBundle("sap.ui.commons");this.setPosition(sap.ui.core.Popup.Dock.BeginBottom,sap.ui.core.Popup.Dock.BeginTop);this.fAnyEventHandlerProxy=q.proxy(this.onAnyEvent,this);var t=this;this.oPopup._applyPosition=function(p){sap.ui.core.Popup.prototype._applyPosition.call(this,p);t.setTip();};this.oPopup.setFollowOf(sap.ui.core.Popup.CLOSE_ON_SCROLL);};C.prototype.exit=function(){this.oPopup.close();this.oPopup.detachEvent("opened",this.handleOpened,this);this.oPopup.detachEvent("closed",this.handleClosed,this);this.oPopup.destroy();delete this.oPopup;delete this.oRb;q.sap.unbindAnyEvent(this.fAnyEventHandlerProxy);};C.prototype._getPopup=function(){return this.oPopup;};C.prototype.hasChild=function(d){return d&&!!(q(d).closest(this.getDomRef()).length);};C.prototype.isPopupElement=function(d){if(!d){return false;}if(this.hasChild(d)){return true;}var s=sap.ui.getCore().getStaticAreaRef();var t=parseInt(q(d).closest(q(s).children()).css("z-index"),10);var a=parseInt(this.$().css("z-index"),10);return t&&a&&t>=a;};C.prototype.setTip=function(){if(!this.oPopup||!this.oPopup.isOpen()){return;}var $=this._currentControl.$(),a=this.$(),b=this.$("arrow"),c=a.offset(),d=$.offset(),s=true,e={},t={l:c.left,r:c.left+a.outerWidth(),w:a.outerWidth(),t:c.top,b:c.top+a.outerHeight(),h:a.outerHeight()},p={l:d.left,r:d.left+$.outerWidth(),w:$.outerWidth(),t:d.top,b:d.top+$.outerHeight(),h:$.outerHeight()},f=(a.outerWidth()-a.innerWidth())/2,g=b.outerWidth()*1.4,h=b.outerWidth()/5,i=h-f-8,m=this.getMyPosition();if(t.r<p.l-i){e.x="right";}else if(t.l-i>p.r){e.x="left";}if(t.t>p.b-i){e.y="top";}else if(t.b<p.t+i){e.y="bottom";}if(e.x){var P=0;if(m.indexOf("top")>-1){P=20;}else if(m.indexOf("bottom")>-1){P=t.h-20-g;}else{P=(t.h-g)/2;}var j=t.t+P+g/2+f;if((j<p.t)||(j>p.b)||(p.t>t.t&&p.b<t.b)){P=(Math.max(t.t,p.t)+Math.min(t.b,p.b))/2-t.t-g/2;}if(!!sap.ui.Device.browser.internet_explorer&&sap.ui.Device.browser.version==8&&e.x=="left"){i=i-8;}b.css(e.x,i+"px");b.css("top",P);if(P<0||P>t.h-g){s=false;}}if(e.y){var r=sap.ui.getCore().getConfiguration().getRTL();if(r){m.replace("begin","right").replace("end","left");}var k=0;if((m.indexOf("begin")>-1)||(m.indexOf("left")>-1)){k=20;}else if((m.indexOf("right")>-1)||(m.indexOf("end")>-1)){k=t.w-20-g;}else{k=(t.w-g)/2;}var n=t.l+k+g/2+f;if((n<p.l)||(n>p.r)){k=(Math.max(t.l,p.l)+Math.min(t.r,p.r))/2-t.l-g/2;}if(!!sap.ui.Device.browser.internet_explorer&&sap.ui.Device.browser.version==8&&e.y=="top"){i=i-8;}b.css(e.y,i+"px");b.css("left",k+"px");if(k<0||k>t.w-g){s=false;}}if(e.x&&e.y||!e.x&&!e.y){s=false;}b.toggle(s);};C.prototype.adjustPosition=function(){function _(){if(this.oPopup){var p=this._currentControl.getDomRef();this.oPopup.setPosition(this.getMyPosition(),this.getAtPosition(),p,this.getOffset(),this.getCollision());}}setTimeout(q.proxy(_,this),0);};C.prototype.focus=function(){if(this.oPopup&&this.oPopup.isOpen()){var c=this.$("cont");q.sap.focus(c.firstFocusableDomRef()||c.get(0));}};C.prototype.openPopup=function(s){if(!this.oPopup||this.oPopup.isOpen()){return;}if(T.sOpenTimeout){q.sap.clearDelayedCall(T.sOpenTimeout);T.sOpenTimeout=undefined;}if(!this.fireEvent("beforeOpen",{parent:this._currentControl},true,false)){if(!this.sCloseNowTimeout){T.sOpenTimeout=q.sap.delayedCall(200,this,"openPopup",[this._currentControl]);}return;}this.oParentFocusInfo=s.getFocusInfo();this.oPopup.attachEvent("opened",this.handleOpened,this);T.prototype.openPopup.call(this,s);this.adjustPosition();this.fireOpen({parent:this._currentControl});};C.prototype.close=function(){if(this.oPopup&&this.oPopup.isOpen()&&!this.sCloseNowTimeout){if(T.sOpenTimeout){q.sap.clearDelayedCall(T.sOpenTimeout);T.sOpenTimeout=undefined;}this.closePopup();}};C.prototype.closePopup=function(){var w=this.oPopup!==undefined&&this.oPopup.isOpen();if(this.fAnyEventHandlerProxy){q.sap.unbindAnyEvent(this.onAnyEvent);}T.prototype.closePopup.call(this);if(w&&this._currentControl&&this.bFocused){this._currentControl.applyFocusInfo(this.oParentFocusInfo);this.bFocused=false;}this.fireClose();};C.prototype.handleClosed=function(){if(this.oPopup){this.oPopup.detachEvent("closed",this.handleClosed,this);this.fireClosed();}};C.prototype.onkeydown=function(e){var c=e.ctrlKey&&e.which==q.sap.KeyCodes.I;var E=e.which==q.sap.KeyCodes.ESCAPE;if(!c&&!E){if(q(e.target).control(0)===this._currentControl){this.close();}return;}if(c){if(this.oPopup&&this.oPopup.isOpen()){return;}this.bDoFocus=true;}T.prototype.onkeydown.call(this,e);};C.prototype.handleOpened=function(){this.oPopup.detachEvent("opened",this.handleOpened,this);if(this.bDoFocus){this.focus();this.bDoFocus=false;this.bFocused=true;}this.$().css("display:","");this.fireOpened();q.sap.bindAnyEvent(this.fAnyEventHandlerProxy);};C.prototype.onfocusin=function(e){this.bFocused=true;var s=e.target;if(s.id===this.getId()+"-fhfe"){q.sap.focus(this.$("cont").lastFocusableDomRef());}else if(s.id===this.getId()+"-fhee"){q.sap.focus(this.$("cont").firstFocusableDomRef());}};C.prototype.onfocusout=function(e){return;};C.prototype.onmouseover=function(e){if(this.oPopup&&(this.oPopup.isOpen()&&this.oPopup.getContent()==this)){if(this.sCloseNowTimeout){q.sap.clearDelayedCall(this.sCloseNowTimeout);this.sCloseNowTimeout=null;}return;}else{T.prototype.onmouseover.call(this,e);}};C.prototype.onmouseout=function(e){if(this.oPopup&&(this.oPopup.isOpen()&&this.isPopupElement(e.relatedTarget))){return;}T.prototype.onmouseout.call(this,e);};C.prototype.onmousedown=function(e){if(q(e.target).control(0)===this._currentControl){this.close();}};C.prototype.onAnyEvent=function(e){if((this.oPopup&&!this.oPopup.isOpen())||e.type!="mouseover"||this.hasChild(e.target)){return;}var d=this.isPopupElement(e.target)||q(e.target).control(0)===this._currentControl;if(!d&&!this.sCloseNowTimeout&&!T.sOpenTimeout){this.sCloseNowTimeout=q.sap.delayedCall(400,this,"closePopup");}if(d&&this.sCloseNowTimeout){q.sap.clearDelayedCall(this.sCloseNowTimeout);this.sCloseNowTimeout=null;}};C.prototype.setPosition=function(m,a){var b=m||sap.ui.core.Popup.Dock.BeginBottom;var c=a||sap.ui.core.Popup.Dock.BeginTop;var d=0,e=0,f=0,g=0,h=5;if((b.indexOf("begin")>-1)||(b.indexOf("left")>-1)){d=-1;}else if((b.indexOf("right")>-1)||(b.indexOf("end")>-1)){d=1;}if((c.indexOf("begin")>-1)||(c.indexOf("left")>-1)){f=-1;}else if((c.indexOf("right")>-1)||(c.indexOf("end")>-1)){f=1;}if(b.indexOf("top")>-1){e=-1;}else if(b.indexOf("bottom")>-1){e=1;}if(c.indexOf("top")>-1){g=-1;}else if(c.indexOf("bottom")>-1){g=1;}var o=((d-f)*d*f*h)+" "+((e-g)*e*g*h);this.setMyPosition(b);this.setAtPosition(c);this.setOffset(o);return this;};return C;},true);
