/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['sap/ui/dt/Plugin','sap/ui/dt/DOMUtil'],function(P,D){"use strict";var a=P.extend("sap.ui.dt.plugin.DragDrop",{metadata:{"abstract":true,library:"sap.ui.dt",properties:{},associations:{},events:{}}});a.prototype.init=function(){P.prototype.init.apply(this,arguments);this._oOverlayDelegate={"onAfterRendering":this._checkDraggable};};a.prototype.registerOverlay=function(o){o.addEventDelegate(this._oOverlayDelegate,this);o.attachEvent("draggableChange",this._onDraggableChange,this);if(o.isDraggable()){this._attachDragEvents(o);}o.attachBrowserEvent("dragover",this._onDragOver,this);o.attachBrowserEvent("dragenter",this._onDragEnter,this);};a.prototype.registerAggregationOverlay=function(A){A.attachDroppableChange(this._onAggregationDroppableChange,this);};a.prototype.deregisterOverlay=function(o){o.removeEventDelegate(this._oOverlayDelegate,this);o.detachEvent("draggableChange",this._onDraggableChange,this);this._detachDragEvents(o);o.detachBrowserEvent("dragover",this._onDragOver,this);o.detachBrowserEvent("dragenter",this._onDragEnter,this);};a.prototype.deregisterAggregationOverlay=function(A){A.detachDroppableChange(this._onAggregationDroppableChange,this);};a.prototype._attachDragEvents=function(o){o.attachBrowserEvent("dragstart",this._onDragStart,this);o.attachBrowserEvent("drag",this._onDrag,this);o.attachBrowserEvent("dragend",this._onDragEnd,this);};a.prototype._detachDragEvents=function(o){o.detachBrowserEvent("dragstart",this._onDragStart,this);o.detachBrowserEvent("dragend",this._onDragEnd,this);o.detachBrowserEvent("drag",this._onDrag,this);};a.prototype.onDraggableChange=function(e){};a.prototype.onDragStart=function(d,e){};a.prototype.onDragEnd=function(d,e){};a.prototype.onDrag=function(d,e){};a.prototype.onDragEnter=function(o,e){};a.prototype.onDragOver=function(o,e){};a.prototype.onAggregationDragEnter=function(A,e){};a.prototype.onAggregationDragOver=function(A,e){};a.prototype.onAggregationDragLeave=function(A,e){};a.prototype.onAggregationDrop=function(A,e){};a.prototype._checkDraggable=function(e){var o=e.srcControl;if(o.isDraggable()){D.setDraggable(o.$(),true);}};a.prototype._onDraggableChange=function(e){var o=e.getSource();if(o.isDraggable()){this._attachDragEvents(o);}else{this._detachDragEvents(o);}this.onDraggableChange(o,e);};a.prototype._onDragStart=function(e){var o=sap.ui.getCore().byId(e.currentTarget.id);this._oDraggedOverlay=o;e.stopPropagation();if(sap.ui.Device.browser.firefox&&e&&e.originalEvent&&e.originalEvent.dataTransfer&&e.originalEvent.dataTransfer.setData){e.originalEvent.dataTransfer.setData('text/plain','');}this.showGhost(o,e);this.onDragStart(o,e);};a.prototype.showGhost=function(o,e){var t=this;if(e&&e.originalEvent&&e.originalEvent.dataTransfer&&e.originalEvent.dataTransfer.setDragImage){this._$ghost=this.createGhost(o,e);this._$ghost.appendTo("body");setTimeout(function(){t._removeGhost();},0);e.originalEvent.dataTransfer.setDragImage(this._$ghost.get(0),e.originalEvent.pageX-this.getDraggedOverlay().$().offset().left,e.originalEvent.pageY-this.getDraggedOverlay().$().offset().top);}};a.prototype._removeGhost=function(){this.removeGhost();delete this._$ghost;};a.prototype.removeGhost=function(){var $=this.getGhost();if($){$.remove();}};a.prototype.createGhost=function(o){var g=o.getAssociatedDomRef();var $;if(!g){g=this._getAssociatedDomCopy(o);$=jQuery(g);}else{$=jQuery("<div></div>");D.cloneDOMAndStyles(g,$);}var b=jQuery("<div></div>").addClass("sapUiDtDragGhostWrapper");return b.append($.addClass("sapUiDtDragGhost"));};a.prototype._getAssociatedDomCopy=function(o){var t=this;var d=jQuery("<div></div>");o.getAggregationOverlays().forEach(function(A){A.getChildren().forEach(function(c){var C=c.getAssociatedDomRef();if(C){D.cloneDOMAndStyles(C,d);}else{D.cloneDOMAndStyles(t._getAssociatedDomCopy(c),d);}});});return d.get(0);};a.prototype.getGhost=function(){return this._$ghost;};a.prototype.getDraggedOverlay=function(){return this._oDraggedOverlay;};a.prototype._onDragEnd=function(e){var o=sap.ui.getCore().byId(e.currentTarget.id);this._removeGhost();this.onDragEnd(o,e);delete this._oDraggedOverlay;e.stopPropagation();};a.prototype._onDrag=function(e){var o=sap.ui.getCore().byId(e.currentTarget.id);this.onDrag(o,e);e.stopPropagation();};a.prototype._onDragEnter=function(e){var o=sap.ui.getCore().byId(e.currentTarget.id);var A=o.getParent();var i=A&&A.isDroppable&&A.isDroppable();if(i){if(!this.onDragEnter(o,e)){e.stopPropagation();}}e.preventDefault();};a.prototype._onDragOver=function(e){var o=sap.ui.getCore().byId(e.currentTarget.id);var A=o.getParent();var i=A&&A.isDroppable&&A.isDroppable();if(i){if(!this.onDragOver(o,e)){e.stopPropagation();}}e.preventDefault();};a.prototype._onAggregationDroppableChange=function(e){var A=e.getSource();var d=e.getParameter("droppable");if(d){this._attachAggregationOverlayEvents(A);}else{this._detachAggregationOverlayEvents(A);}};a.prototype._attachAggregationOverlayEvents=function(A){A.attachBrowserEvent("dragenter",this._onAggregationDragEnter,this);A.attachBrowserEvent("dragover",this._onAggregationDragOver,this);A.attachBrowserEvent("dragleave",this._onAggregationDragLeave,this);A.attachBrowserEvent("drop",this._onAggregationDrop,this);};a.prototype._detachAggregationOverlayEvents=function(A){A.detachBrowserEvent("dragenter",this._onAggregationDragEnter,this);A.detachBrowserEvent("dragover",this._onAggregationDragOver,this);A.detachBrowserEvent("dragleave",this._onAggregationDragLeave,this);A.detachBrowserEvent("drop",this._onAggregationDrop,this);};a.prototype._onAggregationDragEnter=function(e){var A=sap.ui.getCore().byId(e.currentTarget.id);this.onAggregationDragEnter(A,e);e.preventDefault();e.stopPropagation();};a.prototype._onAggregationDragOver=function(e){var A=sap.ui.getCore().byId(e.currentTarget.id);this.onAggregationDragOver(A,e);e.preventDefault();e.stopPropagation();};a.prototype._onAggregationDragLeave=function(e){var A=sap.ui.getCore().byId(e.currentTarget.id);this.onAggregationDragLeave(A,e);e.preventDefault();e.stopPropagation();};a.prototype._onAggregationDrop=function(e){var A=sap.ui.getCore().byId(e.currentTarget.id);this.onAggregationDrop(A,e);e.stopPropagation();};return a;},true);
