/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2015 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['jquery.sap.global','./AnalyticalColumn','./Table','./TreeTable','./library','sap/ui/model/analytics/ODataModelAdapter','sap/ui/core/IconPool'],function(q,A,T,a,b,O,I){"use strict";var c=T.extend("sap.ui.table.AnalyticalTable",{metadata:{library:"sap.ui.table",properties:{sumOnTop:{type:"boolean",group:"Appearance",defaultValue:false},numberOfExpandedLevels:{type:"int",group:"Misc",defaultValue:0},autoExpandMode:{type:"string",group:"Misc",defaultValue:"Bundled"},columnVisibilityMenuSorter:{type:"any",group:"Appearance",defaultValue:null},collapseRecursive:{type:"boolean",defaultValue:true},dirty:{type:"boolean",group:"Appearance",defaultValue:null,deprecated:true}}}});c.prototype._getFixedBottomRowContexts=function(B){return B.getGrandTotalContext();};c.prototype.init=function(){T.prototype.init.apply(this,arguments);this.addStyleClass("sapUiAnalyticalTable");this.attachBrowserEvent("contextmenu",this._onContextMenu);this.setSelectionMode(sap.ui.table.SelectionMode.MultiToggle);this.setShowColumnVisibilityMenu(true);this.setEnableColumnFreeze(true);this.setEnableCellFilter(true);this._aGroupedColumns=[];if(sap.ui.getCore().getConfiguration().getTheme()==="sap_bluecrystal"){q.sap.require("sap.ui.core.IconPool");sap.ui.core.IconPool.insertFontFaceStyle();}};c.prototype.setFixedRowCount=function(){q.sap.log.error("The property fixedRowCount is not supported by the AnalyticalTable and must not be set!");return this;};c.prototype.setFixedBottomRowCount=function(){q.sap.log.error("The property fixedBottomRowCount is managed by the AnalyticalTable and must not be set!");return this;};c.prototype.onAfterRendering=function(){T.prototype.onAfterRendering.apply(this,arguments);this.$().find("[role=grid]").attr("role","treegrid");};c.prototype.setDirty=function(d){q.sap.log.error("The property \"dirty\" is deprecated. Please use \"showOverlay\".");this.setProperty("dirty",d,true);this.setShowOverlay(this.getDirty());return this;};c.prototype.getModel=function(m,n){var m=T.prototype.getModel.apply(this,arguments);if(m){sap.ui.model.analytics.ODataModelAdapter.apply(m);}return m;};c.prototype._onBindingChange=function(e){T.prototype._onBindingChange.apply(this,arguments);var r=typeof(e)==="object"?e.getParameter("reason"):e;if(r!=="sort"){this._invalidateColumnMenus();}};c.prototype.bindRows=function(B){var o=this._sanitizeBindingInfo.apply(this,arguments);var r=this.bindAggregation("rows",o);this._bSupressRefresh=true;this._updateColumns();this._bSupressRefresh=false;return r;};c.prototype._bindAggregation=function(n,p,t,s,f){if(n==="rows"){this.setProperty("firstVisibleRow",0,true);this._sanitizeBindingInfo.call(this,p,t,s,f);}return T.prototype._bindAggregation.apply(this,arguments);};c.prototype._initSelectionModel=function(s){this._oSelection=new sap.ui.model.SelectionModel(s);return this;};c.prototype.setSelectionMode=function(s){if(s===sap.ui.table.SelectionMode.None){q.sap.log.fatal("SelectionMode 'None' is not supported by the AnalyticalTable.");return this;}var B=this.getBinding("rows");if(B&&B.clearSelection){B.clearSelection();}this.setProperty("selectionMode",s);return this;};c.prototype.setSelectionBehavior=function(B){if(B===sap.ui.table.SelectionBehavior.RowOnly){q.sap.log.fatal("SelectionBehavior 'RowOnly' is not supported by the AnalyticalTable.");return this;}else{return T.prototype.setSelectionBehavior.apply(this,arguments);}};c.prototype._sanitizeBindingInfo=function(B){var p,t,s,f;if(typeof B=="string"){p=arguments[0];t=arguments[1];s=arguments[2];f=arguments[3];B={path:p,sorter:s,filters:f};if(t instanceof sap.ui.base.ManagedObject){B.template=t;}else if(typeof t==="function"){B.factory=t;}}var C=this.getColumns();for(var i=0,l=C.length;i<l;i++){if(C[i].getSorted()){B.sorter=B.sorter||[];B.sorter.push(new sap.ui.model.Sorter(C[i].getSortProperty()||C[i].getLeadingProperty(),C[i].getSortOrder()===sap.ui.table.SortOrder.Descending));}}B.parameters=B.parameters||{};B.parameters.analyticalInfo=this._getColumnInformation();B.parameters.sumOnTop=this.getSumOnTop();B.parameters.numberOfExpandedLevels=this.getNumberOfExpandedLevels();B.parameters.autoExpandMode=this.getAutoExpandMode();var m=this.getModel(B.model);if(m){O.apply(m);}return B;};c.prototype._setSuppressRefresh=function(s){this._bSupressRefresh=s;return this;};c.prototype._attachBindingListener=function(){var B=this.getBinding("rows");if(B&&!B.hasListeners("selectionChanged")){B.attachSelectionChanged(this._onSelectionChanged,this);}T.prototype._attachDataRequestedListeners.apply(this);};c.prototype._getColumnInformation=function(){var C=[],t=this.getColumns();for(var i=0;i<this._aGroupedColumns.length;i++){var o=sap.ui.getCore().byId(this._aGroupedColumns[i]);if(!o){continue;}C.push({name:o.getLeadingProperty(),visible:o.getVisible(),grouped:o.getGrouped(),total:o.getSummed(),sorted:o.getSorted(),sortOrder:o.getSortOrder(),inResult:o.getInResult(),formatter:o.getGroupHeaderFormatter()});}for(var i=0;i<t.length;i++){var o=t[i];if(q.inArray(o.getId(),this._aGroupedColumns)>-1){continue;}if(!o instanceof A){q.sap.log.error("You have to use AnalyticalColumns for the Analytical table");}C.push({name:o.getLeadingProperty(),visible:o.getVisible(),grouped:o.getGrouped(),total:o.getSummed(),sorted:o.getSorted(),sortOrder:o.getSortOrder(),inResult:o.getInResult(),formatter:o.getGroupHeaderFormatter()});}return C;};c.prototype._updateTableContent=function(){T.prototype._updateTableContent.apply(this,arguments);var B=this.getBinding("rows"),f=this.getFirstVisibleRow(),F=this.getFixedBottomRowCount(),C=this.getVisibleRowCount(),d=this.getColumns();var r=function(o){var $=o.getDomRefs(true);$.row.removeAttr("data-sap-ui-level");$.row.removeData("sap-ui-level");$.row.removeAttr('aria-level');$.row.removeAttr('aria-expanded');$.row.removeClass("sapUiTableGroupHeader sapUiAnalyticalTableSum sapUiAnalyticalTableDummy");$.rowSelector.html("");};var R=this.getRows();if(!B){for(var i=0;i<R.length;i++){r(R[i]);}return;}for(var e=0,l=Math.min(C,R.length);e<l;e++){var g=e>(C-F-1)&&B.getLength()>C,h=g?(B.getLength()-1-(C-1-e)):f+e,o=R[e],$=o.$(),j=o.$("fixed"),m=this.$().find("div[data-sap-ui-rowindex="+$.attr("data-sap-ui-rowindex")+"]");var n;if(g&&B.bProvideGrandTotals){n=B.getGrandTotalContextInfo();}else{n=this.getContextInfoByIndex(h);}var L=n?n.level:0;if(!n||!n.context){r(o);if(n&&!n.context){$.addClass("sapUiAnalyticalTableDummy");m.addClass("sapUiAnalyticalTableDummy");m.html('<div class="sapUiAnalyticalTableLoading">'+this._oResBundle.getText("TBL_CELL_LOADING")+'</div>');}continue;}var p=[this.getId()+"-rownumberofrows"];var s="";if(B.nodeHasChildren&&B.nodeHasChildren(n)){$.addClass("sapUiTableGroupHeader");j.addClass("sapUiTableGroupHeader");m.attr("aria-haspopup",true);var G=B.getGroupName(n.context,n.level);var t=n.nodeState.expanded?"sapUiTableGroupIconOpen":"sapUiTableGroupIconClosed";if(n.nodeState.expanded&&!this.getSumOnTop()){$.addClass("sapUiTableRowHidden");j.addClass("sapUiTableRowHidden");m.addClass("sapUiTableRowHidden");}var u="";if('ontouchstart'in document){u="<div class='sapUiTableGroupMenuButton'></div>";}m.html("<div id=\""+o.getId()+"-groupHeader\" class=\"sapUiTableGroupIcon "+t+"\" tabindex=\"-1\" title=\""+G+"\">"+G+"</div>"+u);p.push(o.getId()+"-groupHeader");$.removeClass("sapUiAnalyticalTableSum sapUiAnalyticalTableDummy");j.removeClass("sapUiAnalyticalTableSum sapUiAnalyticalTableDummy");m.removeClass("sapUiAnalyticalTableSum sapUiAnalyticalTableDummy");m.addClass("sapUiTableGroupHeader").removeAttr("title").removeAttr("aria-label");$.attr('aria-expanded',n.nodeState.expanded);j.attr('aria-expanded',n.nodeState.expanded);m.attr('aria-expanded',n.nodeState.expanded);if(n.level>0){s=B.getGroupName(n.context,n.level);}else{s=this._oResBundle.getText("TBL_GRAND_TOTAL_ROW");}}else{$.removeAttr('aria-expanded');m.removeAttr('aria-expanded');j.removeAttr('aria-expanded');m.attr("aria-haspopup",false);m.removeAttr('aria-describedby');$.removeClass("sapUiTableGroupHeader sapUiTableRowHidden sapUiAnalyticalTableSum sapUiAnalyticalTableDummy");j.removeClass("sapUiTableGroupHeader sapUiTableRowHidden sapUiAnalyticalTableSum");m.html("");m.removeClass("sapUiTableGroupHeader sapUiAnalyticalTableDummy sapUiAnalyticalTableSum");if(!n.nodeState.sum){p.push(this.getId()+"-rows-row"+m.attr("data-sap-ui-rowindex")+"-rowselecttext");}if(n.nodeState.sum&&n.context&&n.context.getObject()){$.addClass("sapUiAnalyticalTableSum");j.addClass("sapUiAnalyticalTableSum");m.addClass("sapUiAnalyticalTableSum");s;if(n.level>0){s=this._oResBundle.getText("TBL_GROUP_TOTAL_ROW")+" "+B.getGroupName(n.context,n.level);}else{s=this._oResBundle.getText("TBL_GRAND_TOTAL_ROW");}}}$.attr("data-sap-ui-level",L);j.attr("data-sap-ui-level",L);m.attr("data-sap-ui-level",L);m.attr('aria-level',L+1);$.attr('aria-level',L+1);j.attr('aria-level',L+1);$.data("sap-ui-level",L);j.data("sap-ui-level",L);m.data("sap-ui-level",L);if('ontouchstart'in document){var S=0;if(this.$().hasClass("sapUiTableVScr")){S+=this.$().find('.sapUiTableVSb').width();}var v=m.find(".sapUiTableGroupMenuButton");if(this._bRtlMode){v.css("right",(this.$().width()-v.width()+m.position().left-S)+"px");}else{v.css("left",(this.$().width()-v.width()-m.position().left-S)+"px");}}var w=o.getCells();var M=[];for(var i=0,x=w.length;i<x;i++){var y=w[i].data("sap-ui-colindex");var z=d[y];var D=q(w[i].$().closest("td"));if(B.isMeasure(z.getLeadingProperty())){D.addClass("sapUiTableMeasureCell");if(!n.nodeState.sum||z.getSummed()){D.removeClass("sapUiTableCellHidden");M.push(z.getId());M.push(D[0].id);}else{D.addClass("sapUiTableCellHidden");}var E=D[0].id+"-ariaTextForSum";var H=q.sap.byId(E);if(H.length===0){D.append("<span id=\""+E+"\" class=\"sapUiHidden\"></span>");H=q.sap.byId(E);}if(n.nodeState.sum||$.hasClass("sapUiTableGroupHeader")){H.text(s);D.attr("aria-labelledby",E+" "+D.attr("aria-labelledby"));}else{H.text("");D.removeAriaLabelledBy(E);}}else{D.removeClass("sapUiTableMeasureCell");}}for(var k=0;k<M.length;k++){p.push(M[k]);}m.attr("aria-labelledby",p.join(" "));var J=this.getFixedColumnCount()>0?j:$;this._resizeGroupHeader(m,J,n.nodeState.expanded);}};c.prototype._resizeGroupHeader=function($,d,i){var e=$.find(".sapUiTableGroupIcon");if(e.length===0||i){return;}var m=d.find(".sapUiTableCell > *");var t=this.getDomRef().getBoundingClientRect();e.width('');var g=this._bRtlMode?e[0].getBoundingClientRect().left:e[0].getBoundingClientRect().right;var G=e.width();var f=this._bRtlMode;m.each(function(h){var j=q(this);if(j.text().length===0){return true;}var C=j[0].getBoundingClientRect();j.width('auto');var l=j.width();j.width('');var o=0;var D=false;var s=j.css('text-align');if(!f){if(s==="left"){o=g-C.left;D=(o>0&&C.left+l>t.left);}else if(s==="right"){o=g-C.right+l;D=(o>0&&C.right>t.left);}}else{if(s==="left"){o=C.left+l-g;D=(o>0&&C.left<t.right);}else if(s==="right"){o=C.right-g;D=(o>0&&C.right<t.right);}}if(D){e.width(G-o);return false;}});};c.prototype.onclick=function(e){var E=q(e.target);if(E.hasClass("sapUiTableGroupIcon")){this._onNodeSelect(e);}else if(E.hasClass("sapUiAnalyticalTableSum")){e.preventDefault();return;}else if(E.hasClass("sapUiTableGroupMenuButton")){this._onContextMenu(e);e.preventDefault();return;}else{if(T.prototype.onclick){T.prototype.onclick.apply(this,arguments);}}};c.prototype.onsapselect=function(e){if(q(e.target).hasClass("sapUiTableGroupIcon")){this._onNodeSelect(e);}else if(q(e.target).hasClass("sapUiAnalyticalTableSum")){e.preventDefault();return;}else{var t=q(e.target),$=t.closest('div.sapUiTableRowHdr');if($.hasClass('sapUiTableGroupHeader')&&$.hasClass('sapUiTableRowHdr')){var r=this.getFirstVisibleRow()+parseInt($.attr("data-sap-ui-rowindex"),10);var B=this.getBinding("rows");B.toggleIndex(r);return;}if(T.prototype.onsapselect){T.prototype.onsapselect.apply(this,arguments);}}};c.prototype._onNodeSelect=function(e){var $=q(e.target).parent();if($.length>0){var r=this.getFirstVisibleRow()+parseInt($.attr("data-sap-ui-rowindex"),10);var B=this.getBinding("rows");B.toggleIndex(r);}e.preventDefault();e.stopPropagation();};c.prototype._onContextMenu=function(e){if(q(e.target).closest('tr').hasClass('sapUiTableGroupHeader')||q(e.target).closest('.sapUiTableRowHdr.sapUiTableGroupHeader').length>0){this._iGroupedLevel=q(e.target).closest('[data-sap-ui-level]').data('sap-ui-level');var m=this._getGroupHeaderMenu();var d=sap.ui.core.Popup.Dock;var l=e.pageX||e.clientX;var L=e.pageY||e.clientY;m.open(false,e.target,d.LeftTop,d.LeftTop,document,(l-2)+" "+(L-2));e.preventDefault();e.stopPropagation();return;}return true;};c.prototype._getGroupHeaderMenu=function(){var t=this;function g(){var i=t._iGroupedLevel-1;if(t._aGroupedColumns[i]){var o=t.getColumns().filter(function(C){if(t._aGroupedColumns[i]==C.getId()){return true;}})[0];return{column:o,index:i};}else{return undefined;}}if(!this._oGroupHeaderMenu){this._oGroupHeaderMenu=new sap.ui.unified.Menu();this._oGroupHeaderMenuVisibilityItem=new sap.ui.unified.MenuItem({text:this._oResBundle.getText("TBL_SHOW_COLUMN"),select:function(){var G=g();if(G){var C=G.column,s=C.getShowIfGrouped();C.setShowIfGrouped(!s);t.fireGroup({column:C,groupedColumns:C.getParent()._aGroupedColumns,type:(!s?sap.ui.table.GroupEventType.showGroupedColumn:sap.ui.table.GroupEventType.hideGroupedColumn)});}}});this._oGroupHeaderMenu.addItem(this._oGroupHeaderMenuVisibilityItem);this._oGroupHeaderMenu.addItem(new sap.ui.unified.MenuItem({text:this._oResBundle.getText("TBL_UNGROUP"),select:function(){var d=t.getColumns(),f=0,l=-1,u=-1,C;for(var i=0;i<d.length;i++){C=d[i];if(C.getGrouped()){f++;if(f==t._iGroupedLevel){C._bSkipUpdateAI=true;var B=t.getBinding("rows");B.setNumberOfExpandedLevels(0);C.setGrouped(false);C._bSkipUpdateAI=false;u=i;t.fireGroup({column:C,groupedColumns:C.getParent()._aGroupedColumns,type:sap.ui.table.GroupEventType.ungroup});}else{l=i;}}}if(l>-1&&u>-1&&u<l){var U=d[u];var h=U.getHeaderSpan();if(q.isArray(h)){h=h[0];}var r=[];for(var i=u;i<u+h;i++){r.push(d[i]);}q.each(r,function(e,C){t.removeColumn(C);t.insertColumn(C,l);});}t._updateTableColumnDetails();t.updateAnalyticalInfo();}}));this._oGroupHeaderMenu.addItem(new sap.ui.unified.MenuItem({text:this._oResBundle.getText("TBL_UNGROUP_ALL"),select:function(){var d=t.getColumns();for(var i=0;i<d.length;i++){d[i]._bSkipUpdateAI=true;var B=t.getBinding("rows");B.setNumberOfExpandedLevels(0);d[i].setGrouped(false);d[i]._bSkipUpdateAI=false;}t._bSupressRefresh=true;t._updateTableColumnDetails();t.updateAnalyticalInfo();t._bSupressRefresh=false;t.fireGroup({column:undefined,groupedColumns:[],type:sap.ui.table.GroupEventType.ungroupAll});}}));this._oGroupHeaderMoveUpItem=new sap.ui.unified.MenuItem({text:this._oResBundle.getText("TBL_MOVE_UP"),select:function(){var G=g();if(G){var C=G.column;var i=q.inArray(C.getId(),t._aGroupedColumns);if(i>0){t._aGroupedColumns[i]=t._aGroupedColumns.splice(i-1,1,t._aGroupedColumns[i])[0];t.updateAnalyticalInfo();t.fireGroup({column:C,groupedColumns:C.getParent()._aGroupedColumns,type:sap.ui.table.GroupEventType.moveUp});}}},icon:"sap-icon://arrow-top"});this._oGroupHeaderMenu.addItem(this._oGroupHeaderMoveUpItem);this._oGroupHeaderMoveDownItem=new sap.ui.unified.MenuItem({text:this._oResBundle.getText("TBL_MOVE_DOWN"),select:function(){var G=g();if(G){var C=G.column;var i=q.inArray(C.getId(),t._aGroupedColumns);if(i<t._aGroupedColumns.length){t._aGroupedColumns[i]=t._aGroupedColumns.splice(i+1,1,t._aGroupedColumns[i])[0];t.updateAnalyticalInfo();t.fireGroup({column:C,groupedColumns:C.getParent()._aGroupedColumns,type:sap.ui.table.GroupEventType.moveDown});}}},icon:"sap-icon://arrow-bottom"});this._oGroupHeaderMenu.addItem(this._oGroupHeaderMoveDownItem);this._oGroupHeaderMenu.addItem(new sap.ui.unified.MenuItem({text:this._oResBundle.getText("TBL_SORT_ASC"),select:function(){var G=g();if(G){var C=G.column;C.sort(false);}},icon:"sap-icon://up"}));this._oGroupHeaderMenu.addItem(new sap.ui.unified.MenuItem({text:this._oResBundle.getText("TBL_SORT_DESC"),select:function(){var G=g();if(G){var C=G.column;C.sort(true);}},icon:"sap-icon://down"}));this._oGroupHeaderMenu.addItem(new sap.ui.unified.MenuItem({text:this._oResBundle.getText("TBL_COLLAPSE_LEVEL"),select:function(){t.getBinding("rows").collapseToLevel(t._iGroupedLevel-1);t.setFirstVisibleRow(0);t.clearSelection();}}));this._oGroupHeaderMenu.addItem(new sap.ui.unified.MenuItem({text:this._oResBundle.getText("TBL_COLLAPSE_ALL"),select:function(){t.getBinding("rows").collapseToLevel(0);t.setFirstVisibleRow(0);t.clearSelection();}}));}var G=g();if(G){var C=G.column;if(C.getShowIfGrouped()){this._oGroupHeaderMenuVisibilityItem.setText(this._oResBundle.getText("TBL_HIDE_COLUMN"));}else{this._oGroupHeaderMenuVisibilityItem.setText(this._oResBundle.getText("TBL_SHOW_COLUMN"));}this._oGroupHeaderMoveUpItem.setEnabled(G.index>0);this._oGroupHeaderMoveDownItem.setEnabled(G.index<this._aGroupedColumns.length-1);}else{this._oGroupHeaderMoveUpItem.setEnabled(true);this._oGroupHeaderMoveDownItem.setEnabled(true);}return this._oGroupHeaderMenu;};c.prototype.expand=function(r){var B=this.getBinding("rows");if(B){B.expand(r);}};c.prototype.collapse=function(r){var B=this.getBinding("rows");if(B){B.collapse(r);}};c.prototype.collapseAll=function(){var B=this.getBinding("rows");if(B){B.collapseToLevel(0);this.setFirstVisibleRow(0);}return this;};c.prototype.isExpanded=function(r){var B=this.getBinding("rows");if(B){return B.isExpanded(r);}return false;};c.prototype.getContextByIndex=function(i){var B=this.getBinding("rows");return i>=0&&B?B.getContextByIndex(i):null;};c.prototype.getContextInfoByIndex=function(i){var B=this.getBinding("rows");return i>=0&&B?B.getNodeByIndex(i):null;};c.prototype._onColumnMoved=function(e){T.prototype._onColumnMoved.apply(this,arguments);this.updateAnalyticalInfo();};c.prototype.addColumn=function(C,s){var o=this._getColumn(C);if(o.getGrouped()){this._addGroupedColumn(o.getId());}T.prototype.addColumn.call(this,o,s);this._updateTableColumnDetails();this.updateAnalyticalInfo(s);return this;};c.prototype.insertColumn=function(C,i,s){var o=this._getColumn(C);if(o.getGrouped()){this._addGroupedColumn(o.getId());}T.prototype.insertColumn.call(this,o,i,s);this._updateTableColumnDetails();this.updateAnalyticalInfo(s);return this;};c.prototype.removeColumn=function(C,s){var r=T.prototype.removeColumn.apply(this,arguments);if(!this._iNewColPos){this._aGroupedColumns=q.grep(this._aGroupedColumns,function(v){if(C.getId){return v!=C.getId();}else{return v==C;}});}this.updateAnalyticalInfo(s);return r;};c.prototype.removeAllColumns=function(s){this._aGroupedColumns=[];var r=T.prototype.removeAllColumns.apply(this,arguments);this._updateTableColumnDetails();this.updateAnalyticalInfo(s);return r;};c.prototype._getColumn=function(C){if(typeof C==="string"){var o=new A({leadingProperty:C,template:C,managed:true});return o;}else if(C instanceof A){return C;}else{throw new Error("Wrong column type. You need to define a string (property) or pass an AnalyticalColumnObject");}};c.prototype._updateColumns=function(){this._updateTableColumnDetails();this.updateAnalyticalInfo();};c.prototype.updateAnalyticalInfo=function(s){var B=this.getBinding("rows");if(B){var C=this._getColumnInformation();B.updateAnalyticalInfo(C);this._updateTotalRow(C,s);if(s||this._bSupressRefresh){return;}this.refreshRows();}};c.prototype._updateTotalRow=function(C,s){var B=this.getBinding("rows");var f=this.getFixedBottomRowCount();if(B&&(B.providesGrandTotal()&&B.hasTotaledMeasures())){if(f!==1){this.setProperty("fixedBottomRowCount",1,s);}}else{if(f!==0){this.setProperty("fixedBottomRowCount",0,s);}}};c.prototype._updateTableColumnDetails=function(){var B=this.getBinding("rows"),r=B&&B.getAnalyticalQueryResult();if(r){var C=this.getColumns(),g=[],u=[],d=[],D={},e,f;for(var i=0;i<C.length;i++){e=C[i];e._isLastGroupableLeft=false;e._bLastGroupAndGrouped=false;e._bDependendGrouped=false;if(!e.getVisible()){continue;}var l=e.getLeadingProperty();f=r.findDimensionByPropertyName(l);if(f){var h=f.getName();if(!D[h]){D[h]={dimension:f,columns:[e]};}else{D[h].columns.push(e);}if(e.getGrouped()&&q.inArray(h,g)==-1){g.push(h);}if(q.inArray(h,d)==-1){d.push(h);}}}u=q.grep(d,function(s){return(q.inArray(s,g)==-1);});if(g.length>0){q.each(g,function(i,s){q.each(D[s].columns,function(j,o){if(!o.getGrouped()){o._bDependendGrouped=true;}});});if(g.length==d.length){f=r.findDimensionByPropertyName(sap.ui.getCore().byId(this._aGroupedColumns[this._aGroupedColumns.length-1]).getLeadingProperty());var G=D[f.getName()].columns;q.each(G,function(i,o){o._bLastGroupAndGrouped=true;});}}if(u.length==1){q.each(D[u[0]].columns,function(j,o){o._isLastGroupableLeft=true;});}}};c.prototype._getFirstMeasureColumnIndex=function(){var B=this.getBinding("rows"),r=B&&B.getAnalyticalQueryResult(),C=this._getVisibleColumns();if(!r){return-1;}for(var i=0;i<C.length;i++){var o=C[i],l=o.getLeadingProperty();if(r.findMeasureByName(l)||r.findMeasureByPropertyName(l)){return i;}}};c.prototype.getTotalSize=function(){var B=this.getBinding("rows");if(B){return B.getTotalSize();}return 0;};c.prototype._hasData=function(){var B=this.getBinding("rows"),l=B&&(B.getLength()||0),h=B&&B.providesGrandTotal()&&B.hasTotaledMeasures();if(!B||(h&&l<2)||(!h&&l===0)){return false;}return true;};c.prototype._onPersoApplied=function(){T.prototype._onPersoApplied.apply(this,arguments);this._aGroupedColumns=[];var C=this.getColumns();for(var i=0,l=C.length;i<l;i++){if(C[i].getGrouped()){this._addGroupedColumn(C[i].getId());}}this._updateTableColumnDetails();this.updateAnalyticalInfo();};c.prototype._addGroupedColumn=function(C){if(q.inArray(C,this._aGroupedColumns)<0){this._aGroupedColumns.push(C);}};c.prototype.getGroupedColumns=function(){return this._aGroupedColumns;};c.prototype.setCollapseRecursive=function(C){var B=this.getBinding("rows");if(B){if(B.setCollapseRecursive){B.setCollapseRecursive(C);}}this.setProperty("collapseRecursive",!!C,true);return this;};c.prototype._getSelectableRowCount=function(){var B=this.getBinding("rows");if(B){var r=B.getGrandTotalContextInfo();return r?r.numberOfLeafs:0;}};c.prototype.isIndexSelected=function(r){return a.prototype.isIndexSelected.call(this,r);};c.prototype.setSelectedIndex=function(r){return a.prototype.setSelectedIndex.call(this,r);};c.prototype.getSelectedIndices=function(){return a.prototype.getSelectedIndices.call(this);};c.prototype.setSelectionInterval=function(f,t){return a.prototype.setSelectionInterval.call(this,f,t);};c.prototype.addSelectionInterval=function(f,t){return a.prototype.addSelectionInterval.call(this,f,t);};c.prototype.removeSelectionInterval=function(f,t){return a.prototype.removeSelectionInterval.call(this,f,t);};c.prototype.selectAll=function(){return a.prototype.selectAll.call(this);};c.prototype.getSelectedIndex=function(){return a.prototype.getSelectedIndex.call(this);};c.prototype.clearSelection=function(){return a.prototype.clearSelection.call(this);};c.prototype._isRowSelectable=function(r){var B=this.getBinding("rows");if(B){return B.isIndexSelectable(r);}else{return false;}};return c;},true);
